/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.request;

import java.util.Vector;
import org.snmp4j.agent.request.RequestStatusEvent;
import org.snmp4j.agent.request.RequestStatusListener;

public class RequestStatus {
    private int errorStatus = 0;
    private boolean phaseComplete = false;
    private boolean processed = false;
    private transient Vector<RequestStatusListener> requestStatusListeners;

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public void setErrorStatus(int errorStatus) {
        this.errorStatus = errorStatus;
        boolean error = errorStatus != 0;
        this.setPhaseComplete(error);
        this.fireRequestStatusChanged(new RequestStatusEvent(this, this));
    }

    public boolean isPhaseComplete() {
        return this.phaseComplete;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setPhaseComplete(boolean completionStatus) {
        this.phaseComplete = completionStatus;
        this.processed |= completionStatus;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public synchronized void addRequestStatusListener(RequestStatusListener l) {
        if (this.requestStatusListeners == null) {
            this.requestStatusListeners = new Vector(2);
        }
        this.requestStatusListeners.add(l);
    }

    public synchronized void removeRequestStatusListener(RequestStatusListener l) {
        if (this.requestStatusListeners != null) {
            this.requestStatusListeners.remove(l);
        }
    }

    protected void fireRequestStatusChanged(RequestStatusEvent event) {
        if (this.requestStatusListeners != null) {
            Vector<RequestStatusListener> listeners = this.requestStatusListeners;
            for (RequestStatusListener listener : listeners) {
                listener.requestStatusChanged(event);
            }
        }
    }

    public String toString() {
        return "RequestStatus{processed=" + this.processed + ", phaseComplete=" + this.phaseComplete + ", errorStatus=" + this.errorStatus + '}';
    }
}

