/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp4j;

import java.io.IOException;
import java.io.Serializable;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.util.OIDTranslation;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;

public class MOSubtreeProxy
implements ManagedObject {
    private static final LogAdapter logger = LogFactory.getLogger(MOSubtreeProxy.class);
    private Session session;
    private SnmpTargetMIB targetMIB;
    private OctetString proxyName;
    private OctetString contextName;
    private OctetString contextEngineID;
    private DefaultMOScope scope;
    private OctetString targetName;
    private MOAccess access = MOAccessImpl.ACCESS_READ_WRITE;
    private OIDTranslation translation;
    private boolean undoEnabled = true;
    private PDUFactory pduFactory;

    public MOSubtreeProxy(Session session, SnmpTargetMIB targetMIB, OctetString proxyName, OID subtreeOID, OctetString contextEngineID, OctetString contextName, OctetString targetName) {
        this.session = session;
        this.targetMIB = targetMIB;
        this.proxyName = proxyName;
        this.contextName = contextName;
        this.scope = new DefaultMOScope(subtreeOID, true, subtreeOID.nextPeer(), false);
        this.targetName = targetName;
        this.contextEngineID = contextEngineID;
        this.pduFactory = new DefaultPDUFactory(-95, contextEngineID, contextName);
    }

    @Override
    public MOScope getScope() {
        return this.scope;
    }

    @Override
    public OID find(MOScope range) {
        OID lowerBound;
        OID next;
        if (this.access.isAccessibleForRead() && this.scope.covers(next = OID.max((lowerBound = range.getLowerBound()) == null ? this.scope.getLowerBound() : lowerBound, this.scope.getLowerBound()))) {
            return next;
        }
        return null;
    }

    public void setTargetSubtree(OID remoteSubtree) {
        this.translation = new OIDTranslator(remoteSubtree);
    }

    private MOScope translate(MOScope range) {
        if (this.translation != null) {
            DefaultMOScope translated = new DefaultMOScope(this.translation.forwardTranslate(this.scope.getLowerBound()), this.scope.isLowerIncluded(), this.translation.forwardTranslate(this.scope.getUpperBound()), this.scope.isUpperIncluded());
            return translated;
        }
        return range;
    }

    @Override
    public void get(SubRequest request) {
        if (!this.access.isAccessibleForRead()) {
            request.setErrorStatus(6);
            return;
        }
        OID oid = request.getVariableBinding().getOid();
        if (this.translation != null) {
            oid = this.translation.forwardTranslate(oid);
        }
        VariableBinding vb = new VariableBinding(oid);
        Target target = this.targetMIB.getTarget(this.targetName, this.contextEngineID, this.contextName);
        PDU pdu = this.pduFactory.createPDU(target);
        pdu.setType(-96);
        pdu.add(vb);
        try {
            ResponseEvent resp = this.session.send(pdu, target);
            if (resp.getResponse() != null) {
                PDU rpdu = resp.getResponse();
                if (rpdu.getErrorStatus() != 0) {
                    request.setErrorStatus(rpdu.getErrorStatus());
                } else {
                    request.getVariableBinding().setVariable(resp.getResponse().getVariable(oid));
                }
            }
        }
        catch (IOException e) {
            logger.error("IOException in GET sub-request " + request + " to " + target, e);
        }
        request.completed();
    }

    @Override
    public boolean next(SubRequest request) {
        block7: {
            if (!this.access.isAccessibleForRead()) {
                return false;
            }
            OID oid = request.getVariableBinding().getOid();
            if (this.translation != null) {
                oid = this.translation.forwardTranslate(oid);
            }
            VariableBinding vb = new VariableBinding(oid);
            Target target = this.targetMIB.getTarget(this.targetName, this.contextEngineID, this.contextName);
            PDU pdu = this.pduFactory.createPDU(target);
            pdu.setType(-95);
            pdu.add(vb);
            try {
                ResponseEvent resp = this.session.send(pdu, target);
                if (resp.getResponse() == null) break block7;
                PDU rpdu = resp.getResponse();
                if (rpdu.getErrorStatus() != 0) {
                    request.setErrorStatus(rpdu.getErrorStatus());
                    break block7;
                }
                VariableBinding rvb = resp.getResponse().getVariableBindings().get(0);
                OID nextOID = rvb.getOid();
                if (this.translation != null) {
                    nextOID = this.translation.backwardTranslate(nextOID);
                    rvb.setOid(nextOID);
                }
                if (!this.scope.covers(nextOID)) {
                    return false;
                }
                request.getVariableBinding().setOid(rvb.getOid());
                request.getVariableBinding().setVariable(rvb.getVariable());
                request.completed();
                return true;
            }
            catch (IOException e) {
                logger.error("IOException in NEXT sub-request " + request + " to " + target, e);
            }
        }
        request.completed();
        return false;
    }

    @Override
    public void prepare(SubRequest request) {
        block7: {
            if (this.undoEnabled) {
                OID oid = request.getVariableBinding().getOid();
                if (this.translation != null) {
                    oid = this.translation.forwardTranslate(oid);
                }
                VariableBinding vb = new VariableBinding(oid);
                Target target = this.targetMIB.getTarget(this.targetName, this.contextEngineID, this.contextName);
                PDU pdu = this.pduFactory.createPDU(target);
                pdu.setType(-96);
                pdu.add(vb);
                try {
                    VariableBinding rvb;
                    ResponseEvent resp = this.session.send(pdu, target);
                    if (resp.getResponse() == null) break block7;
                    PDU rpdu = resp.getResponse();
                    if (rpdu.getErrorStatus() != 0) {
                        request.setErrorStatus(rpdu.getErrorStatus());
                    }
                    if ((rvb = rpdu.getVariableBindings().get(0)) == null || rvb.isException()) {
                        request.setErrorStatus(2);
                        break block7;
                    }
                    request.setUndoValue(rvb);
                }
                catch (IOException e) {
                    request.setErrorStatus(5);
                    logger.error("IOException in prepare SET sub-request " + request + " to " + target, e);
                }
            } else {
                request.setUndoValue(null);
            }
        }
        request.getStatus().setPhaseComplete(true);
    }

    @Override
    public void commit(SubRequest request) {
        OID oid = request.getVariableBinding().getOid();
        if (this.translation != null) {
            oid = this.translation.forwardTranslate(oid);
        }
        VariableBinding vb = new VariableBinding(oid, request.getVariableBinding().getVariable());
        Target target = this.targetMIB.getTarget(this.targetName, this.contextEngineID, this.contextName);
        PDU pdu = this.pduFactory.createPDU(target);
        pdu.setType(-93);
        pdu.add(vb);
        try {
            ResponseEvent resp = this.session.send(pdu, target);
            if (resp.getResponse() != null) {
                PDU rpdu = resp.getResponse();
                if (rpdu.getErrorStatus() != 0) {
                    request.setErrorStatus(rpdu.getErrorStatus());
                }
                request.getStatus().setPhaseComplete(true);
            } else {
                request.setErrorStatus(5);
            }
        }
        catch (IOException e) {
            request.setErrorStatus(5);
            logger.error("IOException in commit SET sub-request " + request + " to " + target, e);
        }
    }

    @Override
    public void undo(SubRequest request) {
        block7: {
            VariableBinding vb = (VariableBinding)request.getUndoValue();
            if (vb != null) {
                Target target = this.targetMIB.getTarget(this.targetName, this.contextEngineID, this.contextName);
                PDU pdu = this.pduFactory.createPDU(target);
                pdu.setType(-93);
                pdu.add(vb);
                try {
                    ResponseEvent resp = this.session.send(pdu, target);
                    if (resp.getResponse() != null) {
                        PDU rpdu = resp.getResponse();
                        if (rpdu.getErrorStatus() != 0) {
                            request.setErrorStatus(15);
                            logger.warn((Serializable)((Object)("Undo failed because target '" + target + "' returned error " + rpdu.getErrorStatusText())));
                        }
                        break block7;
                    }
                    request.setErrorStatus(5);
                }
                catch (IOException e) {
                    request.setErrorStatus(5);
                    logger.error("IOException in undo SET sub-request " + request + " to " + target, e);
                }
            } else if (this.undoEnabled) {
                request.setErrorStatus(15);
            }
        }
        request.getStatus().setPhaseComplete(true);
    }

    @Override
    public void cleanup(SubRequest request) {
        request.setUndoValue(null);
        request.getStatus().setPhaseComplete(true);
    }

    public boolean isUndoEnabled() {
        return this.undoEnabled;
    }

    public void setUndoEnabled(boolean undoEnabled) {
        this.undoEnabled = undoEnabled;
    }

    public OctetString getProxyName() {
        return this.proxyName;
    }

    public MOAccess getAccess() {
        return this.access;
    }

    public void setAccess(MOAccess access) {
        this.access = access;
    }

    public OIDTranslation getTranslation() {
        return this.translation;
    }

    public void setTranslation(OIDTranslation translation) {
        this.translation = translation;
    }

    public String toString() {
        return "MOSubtreeProxy[session=" + this.session + ", targetMIB=" + this.targetMIB + ", proxyName=" + this.proxyName + ", contextName=" + this.contextName + ", contextEngineID=" + this.contextEngineID + ", scope=" + this.scope + ", targetName=" + this.targetName + ", access=" + this.access + ", translation=" + this.translation + ", undoEnabled=" + this.undoEnabled + ", pduFactory=" + this.pduFactory + ']';
    }

    public class OIDTranslator
    implements OIDTranslation {
        private OID remoteOID;

        public OIDTranslator(OID remoteOID) {
            this.remoteOID = remoteOID;
        }

        @Override
        public OID forwardTranslate(OID oid) {
            if (oid != null) {
                OID translated;
                if (oid.size() >= MOSubtreeProxy.this.scope.getLowerBound().size() && oid.startsWith(MOSubtreeProxy.this.scope.getLowerBound())) {
                    OID remote = new OID(this.remoteOID);
                    int[] suffix = new int[oid.size() - MOSubtreeProxy.this.scope.getLowerBound().size()];
                    if (suffix.length > 0) {
                        System.arraycopy(oid.getValue(), MOSubtreeProxy.this.scope.getLowerBound().size(), suffix, 0, suffix.length);
                        remote.append(new OID(suffix));
                    }
                    translated = remote;
                } else {
                    translated = oid.compareTo(MOSubtreeProxy.this.scope.getLowerBound()) < 0 ? new OID(this.remoteOID) : this.remoteOID.nextPeer();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Forward OID translation '" + oid + "'->'" + translated)));
                }
                return translated;
            }
            return null;
        }

        @Override
        public OID backwardTranslate(OID oid) {
            if (oid != null) {
                OID translated;
                if (oid.size() >= this.remoteOID.size() && oid.startsWith(this.remoteOID)) {
                    OID local = new OID(MOSubtreeProxy.this.scope.getLowerBound());
                    int[] suffix = new int[oid.size() - this.remoteOID.size()];
                    if (suffix.length > 0) {
                        System.arraycopy(oid.getValue(), this.remoteOID.size(), suffix, 0, suffix.length);
                        local.append(new OID(suffix));
                    }
                    translated = local;
                } else {
                    translated = oid.compareTo(this.remoteOID) > 0 ? new OID(MOSubtreeProxy.this.scope.getUpperBound()) : new OID(MOSubtreeProxy.this.scope.getUpperBound());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Backward OID translation '" + oid + "'->'" + translated)));
                }
                return translated;
            }
            return null;
        }

        public String toString() {
            return "OIDTranslator{remoteOID=" + this.remoteOID + '}';
        }
    }
}

