/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opennms.mock.snmp.MockSnmpMOLoader;
import org.opennms.mock.snmp.Updatable;
import org.opennms.mock.snmp.responder.DynamicVariable;
import org.opennms.mock.snmp.responder.SnmpErrorStatusException;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class PropertiesBackedManagedObject
implements ManagedObject,
MockSnmpMOLoader,
Updatable,
MOAccess {
    private static final LogAdapter s_log = LogFactory.getLogger(PropertiesBackedManagedObject.class);
    private TreeMap<OID, Object> m_vars = null;
    private MOScope m_scope = null;
    private Object m_oldValue;
    Map<String, DynamicVariable> m_dynamicVariableCache = new HashMap<String, DynamicVariable>();

    @Override
    public List<ManagedObject> loadMOs(URL moFile) {
        Properties props = this.loadProperties(moFile);
        this.m_dynamicVariableCache.clear();
        if (props.isEmpty()) {
            this.m_scope = new DefaultMOScope(new OID(".1"), false, new OID(".1"), false);
            return Collections.singletonList(this);
        }
        this.m_vars = new TreeMap();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (!key.startsWith(".")) {
                s_log.debug((Serializable)((Object)String.format("key does not start with '.', probably a linewrap issue in snmpwalk: %s = %s", key, value)));
                continue;
            }
            try {
                this.m_vars.put(new OID(key), value);
            }
            catch (Throwable ex) {
                IllegalArgumentException nfe = new IllegalArgumentException("Could not load OID value: [" + key + "] [" + value + "]");
                nfe.initCause(ex);
                throw nfe;
            }
        }
        this.m_scope = new DefaultMOScope(this.m_vars.firstKey(), true, this.m_vars.lastKey(), true);
        return Collections.singletonList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL moFile) {
        Properties moProps = new Properties();
        InputStream inStream = null;
        try {
            inStream = moFile.openStream();
            moProps.load(inStream);
        }
        catch (Exception ex) {
            s_log.error("Unable to read property file " + moFile, ex);
            Properties properties = null;
            return properties;
        }
        finally {
            this.closeQuietly(inStream);
        }
        return moProps;
    }

    private void closeQuietly(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public OID find(MOScope range) {
        SortedMap<OID, Object> tail;
        if (!this.m_scope.isOverlapping(range)) {
            return null;
        }
        OID first = range.getLowerBound();
        if (range.isLowerIncluded()) {
            first = first.successor();
        }
        if ((tail = this.m_vars.tailMap(first)).isEmpty()) {
            return null;
        }
        return tail.firstKey();
    }

    public OID findNextOid(OID given) {
        OID next = given.successor();
        SortedMap<OID, Object> tail = this.m_vars.tailMap(next);
        if (tail.isEmpty()) {
            return null;
        }
        return tail.firstKey();
    }

    private Variable findValueForOID(OID oid) throws SnmpErrorStatusException {
        Object val = this.m_vars.get(oid);
        if (val == null) {
            return null;
        }
        if (val instanceof Variable) {
            return (Variable)val;
        }
        return this.getVariableFromValueString(oid.toString(), (String)val);
    }

    @Override
    public void get(SubRequest request) {
        this.getVariable(request, request.getVariableBinding().getOid());
    }

    private void getVariable(SubRequest request, OID oid) {
        try {
            Variable value = this.findValueForOID(oid);
            VariableBinding vb = request.getVariableBinding();
            vb.setOid(oid);
            vb.setVariable(value == null ? Null.noSuchObject : value);
            request.completed();
        }
        catch (SnmpErrorStatusException e) {
            request.setErrorStatus(e.getErrorStatus());
            request.completed();
        }
    }

    @Override
    public MOScope getScope() {
        return this.m_scope;
    }

    @Override
    public boolean next(SubRequest request) {
        OID nextOid = this.findNextOid(request.getVariableBinding().getOid());
        if (nextOid == null) {
            return false;
        }
        this.getVariable(request, nextOid);
        return true;
    }

    @Override
    public void prepare(SubRequest request) {
        VariableBinding vb = request.getVariableBinding();
        this.m_oldValue = this.m_vars.get(vb.getOid());
        RequestStatus status = request.getStatus();
        status.setErrorStatus(0);
        status.setPhaseComplete(true);
    }

    @Override
    public void commit(SubRequest request) {
        VariableBinding vb = request.getVariableBinding();
        Variable v = vb.getVariable();
        this.m_vars.put(vb.getOid(), v);
        RequestStatus status = request.getStatus();
        status.setPhaseComplete(true);
    }

    @Override
    public void cleanup(SubRequest request) {
        this.m_oldValue = null;
        RequestStatus status = request.getStatus();
        status.setPhaseComplete(true);
    }

    @Override
    public void undo(SubRequest request) {
        this.m_vars.put(request.getVariableBinding().getOid(), this.m_oldValue);
        this.m_oldValue = null;
        RequestStatus status = request.getStatus();
        status.setErrorStatus(0);
        status.setPhaseComplete(true);
    }

    @Override
    public void updateValue(OID oid, Variable value) {
        this.m_vars.put(oid, value);
    }

    @Override
    public boolean isAccessibleForCreate() {
        return false;
    }

    @Override
    public boolean isAccessibleForNotify() {
        return false;
    }

    @Override
    public boolean isAccessibleForRead() {
        return true;
    }

    @Override
    public boolean isAccessibleForWrite() {
        return false;
    }

    private Variable getVariableFromValueString(String oidStr, String valStr) throws SnmpErrorStatusException {
        Variable newVar;
        block18: {
            if (valStr.startsWith("Wrong Type")) {
                String newVal = valStr.replaceFirst("Wrong Type \\(should be .*\\): ", "");
                s_log.error((Serializable)((Object)("Bad Mib walk has value: '" + valStr + "' using '" + newVal + "'")));
                valStr = newVal;
            }
            if ("\"\"".equals(valStr)) {
                newVar = new Null();
            } else {
                String moTypeStr = valStr.substring(0, valStr.indexOf(58));
                String moValStr = valStr.substring(valStr.indexOf(58) + 2);
                try {
                    if (moTypeStr.equals("STRING")) {
                        if (moValStr.startsWith("\"") && moValStr.endsWith("\"")) {
                            moValStr = moValStr.substring(1, moValStr.length() - 1);
                        }
                        newVar = new OctetString(moValStr);
                        break block18;
                    }
                    if (moTypeStr.equals("Hex-STRING")) {
                        newVar = OctetString.fromHexString(moValStr.trim().replace(' ', ':'));
                        break block18;
                    }
                    if (moTypeStr.equals("INTEGER")) {
                        newVar = new Integer32(Integer.parseInt(moValStr));
                        break block18;
                    }
                    if (moTypeStr.equals("Gauge32")) {
                        newVar = new Gauge32(Long.parseLong(moValStr));
                        break block18;
                    }
                    if (moTypeStr.equals("Counter32")) {
                        newVar = new Counter32(Long.parseLong(moValStr));
                        break block18;
                    }
                    if (moTypeStr.equals("Counter64")) {
                        newVar = new Counter64(Long.parseLong(moValStr));
                        break block18;
                    }
                    if (moTypeStr.equals("Timeticks")) {
                        Integer ticksInt = Integer.parseInt(moValStr.substring(moValStr.indexOf(40) + 1, moValStr.indexOf(41)));
                        newVar = new TimeTicks((long)ticksInt.intValue());
                        break block18;
                    }
                    if (moTypeStr.equals("OID")) {
                        newVar = new OID(moValStr);
                        break block18;
                    }
                    if (moTypeStr.equals("IpAddress")) {
                        newVar = new IpAddress(moValStr.trim());
                        break block18;
                    }
                    if (moTypeStr.equals("Network Address")) {
                        newVar = OctetString.fromHexString(moValStr.trim());
                        break block18;
                    }
                    if (moTypeStr.equals("Responder")) {
                        newVar = this.handleDynamicVariable(oidStr, moValStr);
                        break block18;
                    }
                    throw new IllegalArgumentException("Unrecognized SNMP Type " + moTypeStr);
                }
                catch (SnmpErrorStatusException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new UndeclaredThrowableException(t, "Could not convert value '" + moValStr + "' of type '" + moTypeStr + "' to SNMP object for OID " + oidStr);
                }
            }
        }
        return newVar;
    }

    protected Variable handleDynamicVariable(String oidStr, String typeStr) throws SnmpErrorStatusException {
        DynamicVariable responder = this.m_dynamicVariableCache.get(oidStr);
        if (responder != null) {
            return responder.getVariableForOID(oidStr);
        }
        if (this.m_dynamicVariableCache.containsKey(oidStr)) {
            throw new IllegalArgumentException("Already failed to initialize the dynamic variable " + typeStr);
        }
        try {
            Class<DynamicVariable> dv = Class.forName(typeStr).asSubclass(DynamicVariable.class);
            if (!DynamicVariable.class.isAssignableFrom(dv)) {
                throw new IllegalArgumentException(typeStr + " must implement the DynamicVariable interface");
            }
            try {
                Method method = dv.getMethod("getInstance", new Class[0]);
                responder = (DynamicVariable)method.invoke(dv, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (responder == null) {
                responder = dv.newInstance();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to marshall " + typeStr);
        }
        finally {
            this.m_dynamicVariableCache.put(oidStr, responder);
        }
        return responder.getVariableForOID(oidStr);
    }
}

