/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp.responder;

import org.opennms.mock.snmp.responder.DynamicVariable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Variable;

public class Sleeper
implements DynamicVariable {
    private static Sleeper m_instance = null;
    private long m_millisToSleep;
    private Variable m_variable;

    private Sleeper() {
        this.resetWithVariable((Variable)new Integer32(0));
    }

    public static synchronized Sleeper getInstance() {
        if (m_instance == null) {
            m_instance = new Sleeper();
        }
        return m_instance;
    }

    public void resetWithVariable(Variable var) {
        this.m_millisToSleep = 0L;
        this.m_variable = var;
    }

    public long getSleepTime() {
        return this.m_millisToSleep;
    }

    public void setSleepTime(long millis) {
        this.m_millisToSleep = millis;
    }

    public Variable getVariable() {
        return this.m_variable;
    }

    public void setVariable(Variable var) {
        this.m_variable = var;
    }

    @Override
    public Variable getVariableForOID(String oidStr) {
        this.sleep(this.m_millisToSleep);
        return this.m_variable;
    }

    private void sleep(long millis) {
        if (millis == 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

