/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.ManagedObjectValueAccess;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.mo.MOChangeEvent;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MOScalar<V extends Variable>
implements ManagedObject,
MOScope,
SerializableManagedObject,
ManagedObjectValueAccess {
    private static LogAdapter logger = LogFactory.getLogger(MOScalar.class);
    protected OID oid;
    private volatile OID lowerBound;
    private volatile OID upperBound;
    private V value;
    protected MOAccess access;
    private boolean isVolatile;
    private transient Vector<MOValueValidationListener> moValueValidationListeners;
    private transient Vector<MOChangeListener> moChangeListeners;

    protected MOScalar() {
    }

    public MOScalar(OID id, MOAccess access, V value) {
        this.oid = id;
        this.access = access;
        this.value = value;
        this.isVolatile = MOScalar.isVolatileByDefault(value);
    }

    private static boolean isVolatileByDefault(Variable value) {
        if (value == null) {
            return true;
        }
        switch (value.getSyntax()) {
            case 65: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    @Override
    public MOScope getScope() {
        return this;
    }

    public MOScope getSingleInstanceScope() {
        return new DefaultMOScope(this.oid, true, this.oid, true);
    }

    @Override
    public OID find(MOScope range) {
        if (this.access.isAccessibleForRead() && range.isCovered(this.getSingleInstanceScope())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("MOScalar '" + this.oid + "' is in scope '" + range + "'")));
            }
            return this.oid;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("MOScalar '" + this.oid + "' is not in scope '" + range + "'")));
        }
        return null;
    }

    @Override
    public void get(SubRequest request) {
        RequestStatus status = request.getStatus();
        if (this.checkRequestScope(request)) {
            if (this.access.isAccessibleForRead()) {
                VariableBinding vb = request.getVariableBinding();
                vb.setOid(this.getOid());
                vb.setVariable((Variable)this.getValue().clone());
                request.completed();
            } else {
                status.setErrorStatus(6);
            }
        }
    }

    public MOAccess getAccess() {
        return this.access;
    }

    protected boolean checkRequestScope(SubRequest request) {
        if (!request.getVariableBinding().getOid().equals(this.oid)) {
            VariableBinding vb = request.getVariableBinding();
            vb.setOid(this.getOid());
            vb.setVariable(Null.noSuchInstance);
            request.completed();
            return false;
        }
        return true;
    }

    @Override
    public boolean next(SubRequest request) {
        if (this.access.isAccessibleForRead() && request.getScope().isCovered(this.getSingleInstanceScope())) {
            VariableBinding vb = request.getVariableBinding();
            vb.setOid(this.getOid());
            V variable = this.getValue();
            if (variable == null) {
                vb.setVariable(Null.noSuchObject);
            } else {
                vb.setVariable((Variable)variable.clone());
            }
            request.completed();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Processed GETNEXT/BULK request '" + request + "' by '" + this.getOid())));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Skipped '" + this.getOid() + "' for GETNEXT/BULK request '" + request + "'")));
        }
        return false;
    }

    public int isValueOK(SubRequest request) {
        if (this.moValueValidationListeners != null) {
            V oldValue = this.value;
            Variable newValue = request.getVariableBinding().getVariable();
            MOValueValidationEvent event = new MOValueValidationEvent(this, (Variable)oldValue, newValue);
            this.fireValidate(event);
            return event.getValidationStatus();
        }
        return 0;
    }

    @Override
    public void prepare(SubRequest request) {
        RequestStatus status = request.getStatus();
        if (this.oid.equals(request.getVariableBinding().getOid())) {
            if (this.access.isAccessibleForWrite()) {
                VariableBinding vb = request.getVariableBinding();
                if (vb.getVariable().getSyntax() != this.getValue().getSyntax()) {
                    status.setErrorStatus(7);
                    return;
                }
                if (this.moChangeListeners != null) {
                    MOChangeEvent event = new MOChangeEvent(this, this, request.getVariableBinding().getOid(), (Variable)this.getValue(), request.getVariableBinding().getVariable(), true);
                    this.fireBeforePrepareMOChange(event);
                    if (event.getDenyReason() != 0) {
                        status.setErrorStatus(event.getDenyReason());
                        status.setPhaseComplete(true);
                        return;
                    }
                }
                int valueOK = this.isValueOK(request);
                if (this.moChangeListeners != null && valueOK == 0) {
                    MOChangeEvent event = new MOChangeEvent(this, this, request.getVariableBinding().getOid(), (Variable)this.getValue(), request.getVariableBinding().getVariable(), true);
                    this.fireAfterPrepareMOChange(event);
                    valueOK = event.getDenyReason();
                }
                status.setErrorStatus(valueOK);
                status.setPhaseComplete(true);
            } else {
                status.setErrorStatus(17);
            }
        } else {
            status.setErrorStatus(11);
        }
    }

    @Override
    public void commit(SubRequest request) {
        MOChangeEvent event;
        RequestStatus status = request.getStatus();
        VariableBinding vb = request.getVariableBinding();
        if (this.moChangeListeners != null) {
            event = new MOChangeEvent(this, this, vb.getOid(), (Variable)this.getValue(), vb.getVariable(), false);
            this.fireBeforeMOChange(event);
        }
        request.setUndoValue(this.getValue());
        this.changeValue(vb.getVariable());
        status.setPhaseComplete(true);
        if (this.moChangeListeners != null) {
            event = new MOChangeEvent(this, this, request.getVariableBinding().getOid(), (Variable)request.getUndoValue(), vb.getVariable(), false);
            this.fireAfterMOChange(event);
        }
    }

    protected int changeValue(V value) {
        return this.setValue(value);
    }

    @Override
    public void undo(SubRequest request) {
        RequestStatus status = request.getStatus();
        if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
            int errorStatus = this.changeValue((Variable)request.getUndoValue());
            status.setErrorStatus(errorStatus);
            status.setPhaseComplete(true);
        } else {
            status.setErrorStatus(15);
        }
    }

    @Override
    public void cleanup(SubRequest request) {
        request.setUndoValue(null);
        request.getStatus().setPhaseComplete(true);
    }

    public OID getOid() {
        return this.oid;
    }

    @Override
    public OID getLowerBound() {
        if (this.lowerBound == null) {
            this.lowerBound = new OID(this.oid.getValue(), 0, this.oid.size() - 1);
        }
        return this.lowerBound;
    }

    @Override
    public OID getUpperBound() {
        if (this.upperBound == null) {
            this.upperBound = new OID(this.getLowerBound().nextPeer());
        }
        return this.upperBound;
    }

    @Override
    public boolean isCovered(MOScope other) {
        return !(!other.getLowerBound().startsWith(this.oid) || other.getLowerBound().size() <= this.oid.size() && !other.isLowerIncluded() || !other.getUpperBound().startsWith(this.oid) || other.getUpperBound().size() <= this.oid.size() && !other.isUpperIncluded());
    }

    @Override
    public boolean isLowerIncluded() {
        return true;
    }

    @Override
    public boolean isUpperIncluded() {
        return false;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int setValue(V value) {
        this.value = value;
        return 0;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    @Override
    public boolean isOverlapping(MOScope other) {
        return DefaultMOScope.overlaps(this, other);
    }

    public synchronized void addMOValueValidationListener(MOValueValidationListener l) {
        if (this.moValueValidationListeners == null) {
            this.moValueValidationListeners = new Vector(2);
        }
        this.moValueValidationListeners.add(l);
    }

    public synchronized void removeMOValueValidationListener(MOValueValidationListener l) {
        if (this.moValueValidationListeners != null) {
            this.moValueValidationListeners.remove(l);
        }
    }

    protected void fireValidate(MOValueValidationEvent validationEvent) {
        if (this.moValueValidationListeners != null) {
            Vector<MOValueValidationListener> listeners = this.moValueValidationListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).validate(validationEvent);
            }
        }
    }

    @Override
    public OID getID() {
        return this.getOid();
    }

    @Override
    public synchronized void load(MOInput input) throws IOException {
        Variable v = input.readVariable();
        this.setValue(v);
    }

    @Override
    public synchronized void save(MOOutput output) throws IOException {
        output.writeVariable((Variable)this.value);
    }

    @Override
    public boolean covers(OID oid) {
        return oid.startsWith(this.oid);
    }

    public String toString() {
        return this.getClass().getName() + "[oid=" + this.getOid() + ",access=" + this.access + ",value=" + this.getValue() + ",volatile=" + this.isVolatile() + this.toStringDetails() + "]";
    }

    protected String toStringDetails() {
        return "";
    }

    public synchronized void addMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners == null) {
            this.moChangeListeners = new Vector(2);
        }
        this.moChangeListeners.add(l);
    }

    public synchronized void removeMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners != null) {
            this.moChangeListeners.remove(l);
        }
    }

    protected void fireBeforePrepareMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            for (MOChangeListener listener : listeners) {
                listener.beforePrepareMOChange(changeEvent);
            }
        }
    }

    protected void fireAfterPrepareMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            for (MOChangeListener listener : listeners) {
                listener.afterPrepareMOChange(changeEvent);
            }
        }
    }

    protected void fireBeforeMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            for (MOChangeListener listener : listeners) {
                listener.beforeMOChange(changeEvent);
            }
        }
    }

    protected void fireAfterMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            for (MOChangeListener listener : listeners) {
                listener.afterMOChange(changeEvent);
            }
        }
    }

    @Override
    public Variable getValue(OID instanceOID) {
        if (this.getOid().equals(instanceOID)) {
            return this.getValue();
        }
        return null;
    }

    @Override
    public boolean setValue(VariableBinding newValueAndInstancceOID) {
        if (this.getOid().equals(newValueAndInstancceOID.getOid())) {
            return this.setValue(newValueAndInstancceOID.getVariable()) == 0;
        }
        return false;
    }
}

