/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.util.WorkerTask;

public class DummyTransport<A extends IpAddress>
extends AbstractTransportMapping<A> {
    private static final LogAdapter logger = LogFactory.getLogger(DummyTransport.class);
    private final Queue<OctetString> requests = new ConcurrentLinkedQueue<OctetString>();
    private final Queue<OctetString> responses = new ConcurrentLinkedQueue<OctetString>();
    private boolean listening;
    private A listenAddress;
    private A receiverAddress;
    private WorkerTask listenThread;
    private long sessionID = 0L;

    public DummyTransport() {
        this.listening = false;
    }

    public DummyTransport(A senderAddress) {
        this.listenAddress = senderAddress;
    }

    public DummyTransport(A senderAddress, A receiverAddress) {
        this.listenAddress = senderAddress;
        this.receiverAddress = receiverAddress;
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return IpAddress.class;
    }

    @Override
    public A getListenAddress() {
        return this.listenAddress;
    }

    public void setListenAddress(A listenAddress) {
        this.listenAddress = listenAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(A address, byte[] message, TransportStateReference tmStateReference) throws IOException {
        Queue<OctetString> queue = this.requests;
        synchronized (queue) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Send request message to '" + address + "': " + new OctetString(message).toHexString())));
            }
            this.requests.add(new OctetString(message));
        }
    }

    @Override
    public void close() throws IOException {
        this.listening = false;
        this.listenThread.terminate();
        try {
            this.listenThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.responses.clear();
    }

    @Override
    public void listen() throws IOException {
        this.listening = true;
        ++this.sessionID;
        QueueProcessor listener = new QueueProcessor(this.responses, this);
        this.listenThread = SNMP4JSettings.getThreadFactory().createWorkerThread("DummyTransportMapping_" + this.getListenAddress(), listener, true);
        this.listenThread.run();
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    public AbstractTransportMapping<A> getResponder(A receiverAddress) {
        this.receiverAddress = receiverAddress;
        return new DummyTransportResponder();
    }

    public String toString() {
        return "DummyTransport{requests=" + this.requests + ", responses=" + this.responses + ", listening=" + this.listening + ", listenAddress=" + this.listenAddress + ", receiverAddress=" + this.receiverAddress + ", listenThread=" + this.listenThread + ", sessionID=" + this.sessionID + '}';
    }

    public class DummyTransportResponder
    extends AbstractTransportMapping<A> {
        private boolean listening;
        private WorkerTask listenThread;

        @Override
        public Class<? extends Address> getSupportedAddressClass() {
            return DummyTransport.this.getSupportedAddressClass();
        }

        @Override
        public A getListenAddress() {
            return DummyTransport.this.receiverAddress;
        }

        @Override
        public void sendMessage(A address, byte[] message, TransportStateReference tmStateReference) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Send response message to '" + address + "': " + new OctetString(message).toHexString())));
            }
            DummyTransport.this.responses.add(new OctetString(message));
        }

        @Override
        public void close() throws IOException {
            this.listening = false;
            this.listenThread.terminate();
            try {
                this.listenThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DummyTransport.this.requests.clear();
        }

        @Override
        public void listen() throws IOException {
            this.listening = true;
            DummyTransport.this.sessionID++;
            QueueProcessor listener = new QueueProcessor(DummyTransport.this.requests, this);
            this.listenThread = SNMP4JSettings.getThreadFactory().createWorkerThread("DummyResponseTransportMapping_" + this.getListenAddress(), listener, true);
            this.listenThread.run();
        }

        @Override
        public boolean isListening() {
            return this.listening;
        }
    }

    private class QueueProcessor
    implements WorkerTask {
        private volatile boolean stop;
        private Queue<OctetString> queue;
        private AbstractTransportMapping tm;

        public QueueProcessor(Queue<OctetString> queue, AbstractTransportMapping tm) {
            this.queue = queue;
            this.tm = tm;
        }

        @Override
        public void run() {
            while (!this.stop) {
                OctetString nextMessage = null;
                nextMessage = this.queue.poll();
                if (nextMessage != null) {
                    TransportStateReference stateReference = new TransportStateReference(DummyTransport.this, DummyTransport.this.listenAddress, null, SecurityLevel.undefined, SecurityLevel.undefined, false, DummyTransport.this.sessionID);
                    this.tm.fireProcessMessage(DummyTransport.this.receiverAddress, ByteBuffer.wrap(nextMessage.getValue()), stateReference);
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    logger.warn((Serializable)((Object)("Interrupted QueueProcessor: " + e.getMessage())));
                }
            }
        }

        @Override
        public void terminate() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void join() throws InterruptedException {
            this.stop = true;
            QueueProcessor queueProcessor = this;
            synchronized (queueProcessor) {
            }
        }

        @Override
        public void interrupt() {
            this.stop = true;
        }
    }
}

