/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.LinkedMOFactory;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRelation;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.SNMPv2TC;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOFactory
implements MOFactory,
LinkedMOFactory {
    private Map<String, Map<String, TextualConvention>> textualConventions = new HashMap<String, Map<String, TextualConvention>>();
    private Map<OID, Object> links;
    private static MOFactory instance;

    protected DefaultMOFactory() {
    }

    public static MOFactory getInstance() {
        if (instance == null) {
            instance = new DefaultMOFactory();
            DefaultMOFactory.addSNMPv2TCs(instance);
        }
        return instance;
    }

    public static void setInstance(MOFactory factory) {
        instance = factory;
    }

    public static void addSNMPv2TCs(MOFactory factory) {
        Collection<TextualConvention> tcs = new SNMPv2TC().getTextualConventions();
        for (TextualConvention tc : tcs) {
            factory.addTextualConvention(tc);
        }
    }

    protected Map<? extends String, ? extends Map<String, TextualConvention>> getTextualConventions() {
        return this.textualConventions;
    }

    @Override
    public synchronized void addTextualConvention(TextualConvention tc) {
        Map<String, TextualConvention> tcMap = this.textualConventions.get(tc.getModuleName());
        if (tcMap == null) {
            tcMap = new HashMap<String, TextualConvention>(10);
            this.textualConventions.put(tc.getModuleName(), tcMap);
        }
        tcMap.put(tc.getName(), tc);
    }

    @Override
    public synchronized void removeTextualConvention(TextualConvention tc) {
        Map<String, TextualConvention> tcMap = this.textualConventions.get(tc.getModuleName());
        if (tcMap != null) {
            tcMap.remove(tc.getName());
            if (tcMap.isEmpty()) {
                this.textualConventions.remove(tc.getModuleName());
            }
        }
    }

    @Override
    public synchronized <V extends Variable> TextualConvention<V> getTextualConvention(String moduleName, String name) {
        Map<String, TextualConvention> tcMap = this.textualConventions.get(moduleName);
        if (tcMap != null) {
            return tcMap.get(name);
        }
        return null;
    }

    @Override
    public <V extends Variable> MOColumn<V> createColumn(int columnID, int syntax, MOAccess access) {
        return new MOMutableColumn(columnID, syntax, access);
    }

    @Override
    public <V extends Variable> MOColumn<V> createColumn(int columnID, int syntax, MOAccess access, V defaultValue, boolean mutableInService) {
        return new MOMutableColumn(columnID, syntax, access, defaultValue, mutableInService);
    }

    @Override
    public <BaseRow extends MOTableRow, DependentRow extends MOTableRow> MOTableRelation<BaseRow, DependentRow> createTableRelation(MOTable<BaseRow, ? extends MOColumn, ? extends MOTableModel<BaseRow>> baseTable, MOTable<DependentRow, ? extends MOColumn, ? extends MOTableModel<DependentRow>> dependentTable) {
        return new MOTableRelation<BaseRow, DependentRow>(baseTable, dependentTable);
    }

    public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
        return new DefaultMOMutableRow2PC(index, values);
    }

    @Override
    public <V extends Variable> MOScalar<V> createScalar(OID id, MOAccess access, V value) {
        return new MOScalar<V>(id, access, value);
    }

    @Override
    public <R extends MOTableRow, M extends MOTableModel<R>> MOTable<R, MOColumn, M> createTable(OID oid, MOTableIndex indexDef, MOColumn[] columns) {
        return this.createTable(oid, indexDef, columns, this.createTableModel(oid, indexDef, columns));
    }

    @Override
    public <R extends MOTableRow, M extends MOTableModel<R>> MOTable<R, MOColumn, M> createTable(OID oid, MOTableIndex indexDef, MOColumn[] columns, M model) {
        return new DefaultMOTable(oid, indexDef, columns, model);
    }

    @Override
    public <R extends MOTableRow, M extends MOTableModel<? extends R>> M createTableModel(OID tableOID, MOTableIndex indexDef, MOColumn[] columns) {
        return (M)new DefaultMOMutableTableModel();
    }

    public void freeRow(MOTableRow row) {
    }

    @Override
    public MOTableIndex createIndex(MOTableSubIndex[] subIndexes, boolean impliedLength) {
        return new MOTableIndex(subIndexes, impliedLength);
    }

    public MOTableSubIndex createSubIndex(int smiSyntax) {
        return new MOTableSubIndex(smiSyntax);
    }

    @Override
    public MOTableSubIndex createSubIndex(OID oid, int smiSyntax) {
        return new MOTableSubIndex(oid, smiSyntax);
    }

    public MOTableSubIndex createSubIndex(int smiSyntax, int minLength, int maxLength) {
        return new MOTableSubIndex(smiSyntax, minLength, maxLength);
    }

    @Override
    public MOTableSubIndex createSubIndex(OID oid, int smiSyntax, int minLength, int maxLength) {
        return new MOTableSubIndex(oid, smiSyntax, minLength, maxLength);
    }

    @Override
    public MOTableIndex createIndex(MOTableSubIndex[] subIndexes, boolean impliedLength, MOTableIndexValidator validator) {
        return new MOTableIndex(subIndexes, impliedLength, validator);
    }

    @Override
    public <V extends Variable> MOColumn<V> createColumn(int columnID, int syntax, MOAccess access, String tcModuleName, String textualConvention) {
        TextualConvention<Variable> tc = this.getTextualConvention(tcModuleName, textualConvention);
        if (tc != null) {
            return tc.createColumn(columnID, syntax, access, null, true);
        }
        return this.createColumn(columnID, syntax, access);
    }

    @Override
    public <V extends Variable> MOColumn<V> createColumn(int columnID, int syntax, MOAccess access, V defaultValue, boolean mutableInService, String tcModuleName, String textualConvention) {
        TextualConvention<V> tc = this.getTextualConvention(tcModuleName, textualConvention);
        if (tc != null) {
            return tc.createColumn(columnID, syntax, access, defaultValue, mutableInService);
        }
        return this.createColumn(columnID, syntax, access, defaultValue, mutableInService);
    }

    @Override
    public <V extends Variable> MOScalar<V> createScalar(OID id, MOAccess access, V value, String tcModuleName, String textualConvention) {
        TextualConvention<V> tc = this.getTextualConvention(tcModuleName, textualConvention);
        if (tc != null) {
            return tc.createScalar(id, access, value);
        }
        return this.createScalar(id, access, value);
    }

    @Override
    public MOAccess createAccess(int moAccess) {
        return MOAccessImpl.getInstance(moAccess);
    }

    @Override
    public void setLink(OID oid, Object instrumentationHelperObject) {
        if (this.links == null) {
            this.initLinkMap();
        }
        this.links.put(oid, instrumentationHelperObject);
    }

    @Override
    public Object getLink(OID oid) {
        if (this.links != null) {
            OID searchOID = new OID(oid);
            Object result = null;
            while (searchOID.size() > 0 && (result = this.links.get(searchOID)) == null) {
                searchOID.trim(1);
            }
            return result;
        }
        return null;
    }

    protected synchronized void initLinkMap() {
        if (this.links == null) {
            this.links = new HashMap<OID, Object>();
        }
    }
}

