/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.resource.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.opennms.core.resource.db.DbConnectionFactory;

public class SimpleDbConnectionFactory
implements DbConnectionFactory {
    private String url = null;
    private String username = null;
    private String password = null;

    @Override
    public void init(String dbUrl, String dbDriver, String username, String password) throws ClassNotFoundException {
        if (dbUrl == null || dbDriver == null || username == null || password == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Class.forName(dbDriver);
        this.url = dbUrl;
        this.username = username;
        this.password = password;
    }

    @Override
    public void destroy() {
        this.url = null;
        this.username = null;
        this.password = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.url == null) {
            throw new IllegalArgumentException("This database factory has not been initialized or has been destroyed.");
        }
        Connection connection = null;
        connection = this.username != null && this.password != null ? DriverManager.getConnection(this.url, this.username, this.password) : DriverManager.getConnection(this.url);
        return connection;
    }

    @Override
    public void releaseConnection(Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        connection.close();
    }
}

