/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterfallCallable
implements Runnable {
    private static Logger LOG = LoggerFactory.getLogger(WaterfallCallable.class);
    private final Executor m_service;
    private final Callable<Callable<?>> m_callable;

    public WaterfallCallable(Executor service, Callable<Callable<?>> callable) {
        this.m_service = service;
        this.m_callable = callable;
    }

    @Override
    public void run() {
        try {
            Callable<Callable<?>> next = this.m_callable.call();
            if (next != null) {
                this.m_service.execute(new WaterfallCallable(this.m_service, next));
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception while executing callable: " + e.getMessage(), e);
        }
    }
}

