/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentConfigManager;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOQueryWithSource;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.cfg.EngineBootsCounterFile;
import org.snmp4j.agent.example.Modules;
import org.snmp4j.agent.example.Snmp4jDemoMib;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.snmp.TimeStamp;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.ThreadPool;

public class SampleAgent
implements VariableProvider {
    private LogAdapter logger = LogFactory.getLogger(SampleAgent.class);
    protected AgentConfigManager agent;
    protected MOServer server;
    private String configFile;
    private File bootCounterFile;
    protected Modules modules;
    protected Properties tableSizeLimits;

    public SampleAgent(Map<String, List> args) {
        this.configFile = (String)args.get("c").get(0);
        this.bootCounterFile = new File((String)args.get("bc").get(0));
        String tlsVersions = (String)args.get("tls-version").get(0);
        if (tlsVersions != null) {
            System.setProperty("org.snmp4j.arg.tlsVersion", tlsVersions);
        }
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        InputStream configInputStream = SampleAgent.class.getResourceAsStream("SampleAgentConfig.properties");
        if (args.containsKey("cfg")) {
            String configFilename = (String)ArgumentParser.getValue(args, "cfg", 0);
            try {
                configInputStream = new FileInputStream(configFilename);
            }
            catch (FileNotFoundException ex1) {
                this.logger.error("Config file '" + configFilename + "' not found: " + ex1.getMessage(), ex1);
                throw new RuntimeException(ex1);
            }
        }
        final Properties props = new Properties();
        try {
            props.load(configInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MOInputFactory configurationFactory = new MOInputFactory(){

            @Override
            public MOInput createMOInput() {
                return new PropertyMOInput(props, SampleAgent.this);
            }
        };
        InputStream tableSizeLimitsInputStream = SampleAgent.class.getResourceAsStream("SampleAgentTableSizeLimits.properties");
        if (args.containsKey("ts")) {
            try {
                tableSizeLimitsInputStream = new FileInputStream((String)ArgumentParser.getValue(args, "ts", 0));
            }
            catch (FileNotFoundException ex1) {
                ex1.printStackTrace();
            }
        }
        this.tableSizeLimits = new Properties();
        try {
            this.tableSizeLimits.load(tableSizeLimitsInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        this.addListenAddresses(messageDispatcher, args.get("address"));
        this.agent = new AgentConfigManager(new OctetString(MPv3.createLocalEngineID()), messageDispatcher, null, moServers, ThreadPool.create("SampleAgent", 3), configurationFactory, new DefaultMOPersistenceProvider(moServers, this.configFile), new EngineBootsCounterFile(this.bootCounterFile));
    }

    protected void addListenAddresses(MessageDispatcher md, List<String> addresses) {
        for (String addressString : addresses) {
            Address address = GenericAddress.parse(addressString);
            if (address == null) {
                this.logger.fatal("Could not parse address string '" + addressString + "'");
                return;
            }
            TransportMapping tm = TransportMappings.getInstance().createTransportMapping(address);
            if (tm != null) {
                md.addTransportMapping(tm);
                continue;
            }
            this.logger.warn((Serializable)((Object)("No transport mapping available for address '" + address + "'.")));
        }
    }

    public void run() {
        this.agent.initialize();
        this.registerMIBs();
        this.agent.setupProxyForwarder();
        this.agent.setTableSizeLimits(this.tableSizeLimits);
        this.agent.run();
    }

    protected MOFactory getFactory() {
        return DefaultMOFactory.getInstance();
    }

    protected void registerMIBs() {
        if (this.modules == null) {
            this.modules = new Modules(this.getFactory());
            this.modules.getSnmp4jDemoMib().getSnmp4jDemoEntry().addMOTableRowListener(new DemoTableRowListener());
            ((TimeStamp)this.modules.getSnmp4jDemoMib().getSnmp4jDemoEntry().getColumn(3)).setSysUpTime(this.agent.getSysUpTime());
        }
        try {
            this.modules.registerMOs(this.server, null);
        }
        catch (DuplicateRegistrationException drex) {
            this.logger.error("Duplicate registration: " + drex.getMessage() + "." + " MIB object registration may be incomplete!", drex);
        }
    }

    @Override
    public Variable getVariable(String name) {
        OID oid;
        OctetString context = null;
        int pos = name.indexOf(58);
        if (pos >= 0) {
            context = new OctetString(name.substring(0, pos));
            oid = new OID(name.substring(pos + 1, name.length()));
        } else {
            oid = new OID(name);
        }
        final DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
        MOQueryWithSource query = new MOQueryWithSource(scope, false, this);
        ManagedObject mo = this.server.lookup(query);
        if (mo != null) {
            final VariableBinding vb = new VariableBinding(oid);
            final RequestStatus status = new RequestStatus();
            SubRequest req = new SubRequest(){
                private boolean completed;
                private MOQuery query;

                @Override
                public boolean hasError() {
                    return false;
                }

                @Override
                public void setErrorStatus(int errorStatus) {
                    status.setErrorStatus(errorStatus);
                }

                @Override
                public int getErrorStatus() {
                    return status.getErrorStatus();
                }

                @Override
                public RequestStatus getStatus() {
                    return status;
                }

                @Override
                public MOScope getScope() {
                    return scope;
                }

                @Override
                public VariableBinding getVariableBinding() {
                    return vb;
                }

                @Override
                public Request getRequest() {
                    return null;
                }

                @Override
                public Object getUndoValue() {
                    return null;
                }

                @Override
                public void setUndoValue(Object undoInformation) {
                }

                @Override
                public void completed() {
                    this.completed = true;
                }

                @Override
                public boolean isComplete() {
                    return this.completed;
                }

                @Override
                public void setTargetMO(ManagedObject managedObject) {
                }

                @Override
                public ManagedObject getTargetMO() {
                    return null;
                }

                @Override
                public int getIndex() {
                    return 0;
                }

                @Override
                public void setQuery(MOQuery query) {
                    this.query = query;
                }

                @Override
                public MOQuery getQuery() {
                    return this.query;
                }

                public SubRequestIterator<SubRequest> repetitions() {
                    return null;
                }

                @Override
                public void updateNextRepetition() {
                }

                @Override
                public Object getUserObject() {
                    return null;
                }

                @Override
                public void setUserObject(Object userObject) {
                }
            };
            mo.get(req);
            return vb.getVariable();
        }
        return null;
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser("-c[s{=SampleAgent.cfg}] -bc[s{=SampleAgent.bc}] +ts[s] +cfg[s] +tls-version[s{=TLSv1}<TLSv1[\\.1|\\.2]?[,TLSv1[\\.1|\\.2]?]*>] ", "#address[s<(udp|tcp|tls):.*[/[0-9]+]?>] ..");
        try {
            Map<String, List> commandLineParameters = parser.parse(args);
            SampleAgent sampleAgent = new SampleAgent(commandLineParameters);
            SecurityProtocols.getInstance().addDefaultProtocols();
            sampleAgent.run();
            for (int i = 1; i < 0; ++i) {
                sampleAgent.agent.getAgentNotificationOriginator().notify(new OctetString(), SnmpConstants.coldStart, new VariableBinding[]{new VariableBinding(new OID("1.3.6.1.4.0"), new Integer32(i)), new VariableBinding(new OID("1.3.6.1.4.0"), new Counter32(278070606L)), new VariableBinding(new OID("1.3.6.1.4.0"), new OctetString("Hello world!")), new VariableBinding(new OID("1.3.6.1.4.0"), new IpAddress("127.0.0.2")), new VariableBinding(new OID("1.3.6.1.4.0"), new Gauge32(867685L))});
            }
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
        }
    }

    static {
        LogFactory.setLogFactory(new Log4jLogFactory());
        BasicConfigurator.configure();
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
    }

    class DemoTableRowListener
    implements MOTableRowListener<Snmp4jDemoMib.Snmp4jDemoEntryRow> {
        DemoTableRowListener() {
        }

        @Override
        public void rowChanged(MOTableRowEvent event) {
            if (event.getType() == 1 || event.getType() == 4) {
                return;
            }
            Counter32 counter = (Counter32)event.getRow().getValue(2);
            if (counter == null) {
                counter = new Counter32(0L);
                ((MOMutableTableRow)event.getRow()).setValue(2, counter);
            }
            counter.increment();
            TimeStamp timestamp = (TimeStamp)event.getTable().getColumn(3);
            timestamp.update((MOMutableTableRow)event.getRow(), 3);
            Integer32 type = new Integer32(2);
            switch (event.getType()) {
                case 2: {
                    type.setValue(1);
                    break;
                }
                case 3: {
                    type.setValue(3);
                }
            }
            VariableBinding[] payload = new VariableBinding[2];
            OID table = event.getTable().getOID();
            OID updateCount = new OID(table);
            updateCount.append(5);
            updateCount.append(event.getRow().getIndex());
            OID modifyType = new OID(table);
            modifyType.append(9);
            modifyType.append(event.getRow().getIndex());
            payload[0] = new VariableBinding(updateCount, counter);
            payload[1] = new VariableBinding(modifyType, type);
            SampleAgent.this.modules.getSnmp4jDemoMib().snmp4jDemoEvent(SampleAgent.this.agent.getNotificationOriginator(), new OctetString(), payload);
        }
    }
}

