/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.opennms.core.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);
    public static final int DEFAULT_POST_BUFFER_SIZE = 1024;

    public static InputStream post(URL url, InputStream dataStream) throws IOException {
        return HttpUtils.post(url, dataStream, null, null, 1024);
    }

    public static InputStream post(URL url, InputStream dataStream, String username, String password) throws IOException {
        return HttpUtils.post(url, dataStream, username, password, 1024);
    }

    public static InputStream post(URL url, InputStream dataStream, String username, String password, int bufSize) throws IOException {
        if (url == null || dataStream == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (bufSize < 1) {
            throw new IllegalArgumentException("Cannot use zero or negative buffer size.");
        }
        if (!"http".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Cannot use non-HTTP URLs.");
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new IllegalStateException("Could not set a HttpURLConnection's method to POST.");
        }
        if (username != null && password != null) {
            byte[] authBytes = (username + ":" + password).getBytes();
            String authString = new String(Base64.encodeBase64(authBytes));
            conn.setRequestProperty("Authorization", "Basic " + authString);
        }
        OutputStream ostream = conn.getOutputStream();
        byte[] b = new byte[bufSize];
        int bytesRead = dataStream.read(b, 0, bufSize);
        while (bytesRead > 0) {
            ostream.write(b, 0, bytesRead);
            bytesRead = dataStream.read(b, 0, bufSize);
        }
        ostream.close();
        return conn.getInputStream();
    }

    public static InputStream post(URL url, Reader dataReader, String username, String password, int bufSize) throws IOException {
        if (url == null || dataReader == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (bufSize < 1) {
            throw new IllegalArgumentException("Cannot use zero or negative buffer size.");
        }
        if (!"http".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Cannot use non-HTTP URLs.");
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new IllegalStateException("Could not set a HttpURLConnection's method to POST.");
        }
        if (username != null && password != null) {
            byte[] authBytes = (username + ":" + password).getBytes();
            String authString = new String(Base64.encodeBase64(authBytes));
            conn.setRequestProperty("Authorization", "Basic " + authString);
        }
        conn.setRequestProperty("Content-type", "text/xml; charset=\"utf-8\"");
        OutputStreamWriter ostream = new OutputStreamWriter(conn.getOutputStream(), "US-ASCII");
        LOG.debug("HTTP Post: Current time: {}", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new GregorianCalendar().getTime()));
        LOG.debug("Data posted:");
        char[] b = new char[bufSize];
        int bytesRead = dataReader.read(b, 0, bufSize);
        if (bytesRead > 0 && LOG.isDebugEnabled()) {
            LOG.debug(new String(b, 0, bytesRead));
        }
        while (bytesRead > 0) {
            ostream.write(b, 0, bytesRead);
            bytesRead = dataReader.read(b, 0, bufSize);
            if (bytesRead <= 0 || !LOG.isDebugEnabled()) continue;
            LOG.debug(new String(b, 0, bytesRead));
        }
        ostream.close();
        return conn.getInputStream();
    }
}

