/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.AccessorFactoryWrapper;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.many.ArrayValue;
import org.eclipse.persistence.internal.jaxb.many.CollectionValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.jaxb.many.MultiDimensionalArrayValue;
import org.eclipse.persistence.internal.jaxb.many.MultiDimensionalCollectionValue;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.javamodel.AnnotationProxy;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessOrder;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMarshalNullRepresentation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNamedSubgraph;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethodsSchema;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLNameTransformer;
import org.eclipse.persistence.oxm.annotations.XmlAccessMethods;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;
import org.eclipse.persistence.oxm.annotations.XmlClassExtractor;
import org.eclipse.persistence.oxm.annotations.XmlContainerProperty;
import org.eclipse.persistence.oxm.annotations.XmlCustomizer;
import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode;
import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue;
import org.eclipse.persistence.oxm.annotations.XmlElementsJoinNodes;
import org.eclipse.persistence.oxm.annotations.XmlInverseReference;
import org.eclipse.persistence.oxm.annotations.XmlIsSetNullPolicy;
import org.eclipse.persistence.oxm.annotations.XmlJoinNode;
import org.eclipse.persistence.oxm.annotations.XmlJoinNodes;
import org.eclipse.persistence.oxm.annotations.XmlKey;
import org.eclipse.persistence.oxm.annotations.XmlLocation;
import org.eclipse.persistence.oxm.annotations.XmlNameTransformer;
import org.eclipse.persistence.oxm.annotations.XmlNamedAttributeNode;
import org.eclipse.persistence.oxm.annotations.XmlNamedObjectGraph;
import org.eclipse.persistence.oxm.annotations.XmlNamedObjectGraphs;
import org.eclipse.persistence.oxm.annotations.XmlNullPolicy;
import org.eclipse.persistence.oxm.annotations.XmlParameter;
import org.eclipse.persistence.oxm.annotations.XmlPath;
import org.eclipse.persistence.oxm.annotations.XmlPaths;
import org.eclipse.persistence.oxm.annotations.XmlProperties;
import org.eclipse.persistence.oxm.annotations.XmlProperty;
import org.eclipse.persistence.oxm.annotations.XmlReadOnly;
import org.eclipse.persistence.oxm.annotations.XmlReadTransformer;
import org.eclipse.persistence.oxm.annotations.XmlVariableNode;
import org.eclipse.persistence.oxm.annotations.XmlVirtualAccessMethods;
import org.eclipse.persistence.oxm.annotations.XmlWriteOnly;
import org.eclipse.persistence.oxm.annotations.XmlWriteTransformer;
import org.eclipse.persistence.oxm.annotations.XmlWriteTransformers;

public class AnnotationsProcessor {
    static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private static final String JAVAX_XML_BIND_JAXBELEMENT = "javax.xml.bind.JAXBElement";
    private static final String JAVAX_XML_BIND_ANNOTATION = "javax.xml.bind.annotation";
    private static final String OXM_ANNOTATIONS = "org.eclipse.persistence.oxm.annotations";
    private static final String TYPE_METHOD_NAME = "type";
    private static final String VALUE_METHOD_NAME = "value";
    private static final String ARRAY_PACKAGE_NAME = "jaxb.dev.java.net.array";
    private static final String ARRAY_NAMESPACE = "http://jaxb.dev.java.net/array";
    private static final String ARRAY_CLASS_NAME_SUFFIX = "Array";
    private static final String JAXB_DEV = "jaxb.dev.java.net";
    private static final String ORG_W3C_DOM = "org.w3c.dom";
    private static final String CREATE = "create";
    private static final String ELEMENT_DECL_GLOBAL = "javax.xml.bind.annotation.XmlElementDecl.GLOBAL";
    private static final String ELEMENT_DECL_DEFAULT = "\u0000";
    private static final String EMPTY_STRING = "";
    private static final String JAVA_UTIL_LIST = "java.util.List";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String SLASH = "/";
    private static final String SEMI_COLON = ";";
    private static final String L = "L";
    private static final String ITEM = "item";
    private static final String IS_STR = "is";
    private static final String GET_STR = "get";
    private static final String SET_STR = "set";
    private static final Character DOT_CHR = Character.valueOf('.');
    private static final Character DOLLAR_SIGN_CHR = Character.valueOf('$');
    private static final Character SLASH_CHR = Character.valueOf('/');
    private ArrayList<JavaClass> typeInfoClasses;
    private HashMap<String, PackageInfo> packageToPackageInfoMappings;
    private HashMap<String, MarshalCallback> marshalCallbacks;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private HashMap<String, TypeInfo> typeInfo;
    private ArrayList<QName> typeQNames;
    private HashMap<String, UnmarshalCallback> unmarshalCallbacks;
    private HashMap<String, HashMap<QName, ElementDeclaration>> elementDeclarations;
    private HashMap<String, ElementDeclaration> xmlRootElements;
    private List<ElementDeclaration> localElements;
    private HashMap<String, JavaMethod> factoryMethods;
    private Map<String, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry> xmlRegistries;
    private List<String> objectFactoryClassNames;
    private List<JavaClass> classesToProcessPropertyTypes;
    private Map<String, Class> arrayClassesToGeneratedClasses;
    private Map<Class, JavaClass> generatedClassesToArrayClasses;
    private Map<Type, Class> collectionClassesToGeneratedClasses;
    private Map<Class, Type> generatedClassesToCollectionClasses;
    private Map<JavaClass, List<TypeMappingInfo>> javaClassToTypeMappingInfos;
    private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClasses;
    private Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses;
    private Map<TypeMappingInfo, QName> typeMappingInfoToSchemaType;
    private Helper helper;
    private String defaultTargetNamespace;
    private JAXBMetadataLogger logger;
    private boolean isDefaultNamespaceAllowed;
    private boolean xmlAccessorFactorySupport;
    private boolean hasSwaRef;
    private List<String> referencedByTransformer;
    private boolean hasXmlBindings = false;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
        this.isDefaultNamespaceAllowed = true;
        this.hasSwaRef = false;
    }

    void postInitialize() {
        this.typeInfoClasses = null;
        this.packageToPackageInfoMappings = null;
        this.typeInfo = null;
        this.typeQNames = null;
        this.elementDeclarations = null;
        this.xmlRootElements = null;
        this.localElements = null;
        this.factoryMethods = null;
        this.xmlRegistries = null;
        this.objectFactoryClassNames = null;
        this.classesToProcessPropertyTypes = null;
        this.javaClassToTypeMappingInfos = null;
        this.typeMappingInfoToGeneratedClasses = null;
        this.typeMappingInfoToAdapterClasses = null;
        this.helper = null;
        this.logger = null;
        this.referencedByTransformer = null;
    }

    void processClassesAndProperties(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.init(classes, typeMappingInfos);
        this.preBuildTypeInfo(classes);
        classes = this.postBuildTypeInfo(classes);
        this.processPropertyTypes(this.typeInfoClasses.toArray(new JavaClass[this.typeInfoClasses.size()]));
        this.finalizeProperties();
        this.createElementsForTypeMappingInfo();
        this.processJavaClasses(null);
    }

    public void createElementsForTypeMappingInfo() {
        if (this.javaClassToTypeMappingInfos != null && !this.javaClassToTypeMappingInfos.isEmpty()) {
            Set<JavaClass> classes = this.javaClassToTypeMappingInfos.keySet();
            for (JavaClass nextClass : classes) {
                List<TypeMappingInfo> nextInfos = this.javaClassToTypeMappingInfos.get(nextClass);
                for (TypeMappingInfo nextInfo : nextInfos) {
                    Class generatedClass;
                    TypeInfo nextTypeInfo;
                    Class generatedClass2;
                    if (nextInfo == null) continue;
                    boolean xmlAttachmentRef = false;
                    String xmlMimeType = null;
                    Annotation[] annotations = this.getAnnotations(nextInfo);
                    Class adapterClass = this.typeMappingInfoToAdapterClasses.get(nextInfo);
                    Class declJavaType = null;
                    if (adapterClass != null) {
                        declJavaType = CompilerHelper.getTypeFromAdapterClass(adapterClass);
                    }
                    if (annotations != null) {
                        int j = 0;
                        while (j < annotations.length) {
                            Annotation nextAnnotation = annotations[j];
                            if (nextAnnotation != null) {
                                if (nextAnnotation instanceof XmlMimeType) {
                                    XmlMimeType javaAnnotation = (XmlMimeType)nextAnnotation;
                                    xmlMimeType = javaAnnotation.value();
                                } else if (nextAnnotation instanceof XmlAttachmentRef) {
                                    xmlAttachmentRef = true;
                                    if (!this.hasSwaRef) {
                                        this.hasSwaRef = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    QName qname = null;
                    String nextClassName = nextClass.getQualifiedName();
                    if (declJavaType != null) {
                        nextClassName = declJavaType.getCanonicalName();
                    }
                    if (this.typeMappingInfoToGeneratedClasses != null && (generatedClass2 = this.typeMappingInfoToGeneratedClasses.get(nextInfo)) != null) {
                        nextClassName = generatedClass2.getCanonicalName();
                    }
                    if ((nextTypeInfo = this.typeInfo.get(nextClassName)) != null) {
                        qname = new QName(nextTypeInfo.getClassNamespace(), nextTypeInfo.getSchemaTypeName());
                    } else {
                        qname = this.getUserDefinedSchemaTypes().get(nextClassName);
                        if (qname == null) {
                            if (nextClassName.equals(ClassConstants.APBYTE.getName()) || nextClassName.equals(Image.class.getName()) || nextClassName.equals(Source.class.getName()) || nextClassName.equals(JAVAX_ACTIVATION_DATAHANDLER)) {
                                qname = xmlAttachmentRef ? Constants.SWA_REF_QNAME : Constants.BASE_64_BINARY_QNAME;
                            } else if (nextClassName.equals(ClassConstants.OBJECT.getName())) {
                                qname = Constants.ANY_TYPE_QNAME;
                            } else if (nextClassName.equals(ClassConstants.XML_GREGORIAN_CALENDAR.getName())) {
                                qname = Constants.ANY_SIMPLE_TYPE_QNAME;
                            } else {
                                Class theClass = this.helper.getClassForJavaClass(nextClass);
                                qname = (QName)XMLConversionManager.getDefaultJavaTypes().get(theClass);
                            }
                        }
                    }
                    if (qname != null) {
                        this.typeMappingInfoToSchemaType.put(nextInfo, qname);
                    }
                    if (nextInfo.getXmlTagName() == null) continue;
                    ElementDeclaration element = new ElementDeclaration(nextInfo.getXmlTagName(), nextClass, nextClass.getQualifiedName(), false);
                    element.setTypeMappingInfo(nextInfo);
                    element.setXmlMimeType(xmlMimeType);
                    element.setXmlAttachmentRef(xmlAttachmentRef);
                    element.setNillable(nextInfo.isNillable());
                    if (declJavaType != null) {
                        element.setJavaType(this.helper.getJavaClass(declJavaType));
                    }
                    if ((generatedClass = this.typeMappingInfoToGeneratedClasses.get(nextInfo)) != null) {
                        element.setJavaType(this.helper.getJavaClass(generatedClass));
                    }
                    if (nextInfo.getElementScope() == TypeMappingInfo.ElementScope.Global) {
                        ElementDeclaration currentElement = this.getGlobalElements().get(element.getElementName());
                        if (currentElement == null) {
                            this.addGlobalElement(element.getElementName(), element);
                        } else {
                            this.localElements.add(element);
                        }
                    } else {
                        this.localElements.add(element);
                    }
                    String rootNamespace = element.getElementName().getNamespaceURI();
                    if (rootNamespace == null) {
                        rootNamespace = EMPTY_STRING;
                    }
                    if (!rootNamespace.equals(EMPTY_STRING)) continue;
                    this.isDefaultNamespaceAllowed = false;
                }
            }
        }
    }

    private Annotation[] getAnnotations(TypeMappingInfo tmInfo) {
        if (tmInfo.getXmlElement() != null) {
            ClassLoader loader = this.helper.getClassLoader();
            ConversionManager cMgr = new ConversionManager();
            cMgr.setLoader(loader);
            XmlElement xElt = CompilerHelper.getXmlElement(tmInfo.getXmlElement(), loader);
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            HashMap<String, Object> components = null;
            if (!xElt.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT")) {
                components = new HashMap<String, Object>();
                components.put(TYPE_METHOD_NAME, xElt.getType());
                annotations.add(AnnotationProxy.getProxy(components, javax.xml.bind.annotation.XmlElement.class, loader, cMgr));
            }
            if (xElt.isXmlList()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlList.class, loader, cMgr));
            }
            if (xElt.isXmlAttachmentRef()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlAttachmentRef.class, loader, cMgr));
            }
            if (xElt.getXmlMimeType() != null) {
                components = new HashMap();
                components.put(VALUE_METHOD_NAME, xElt.getXmlMimeType());
                annotations.add(AnnotationProxy.getProxy(components, XmlMimeType.class, loader, cMgr));
            }
            if (xElt.getXmlJavaTypeAdapter() != null) {
                components = new HashMap();
                components.put(TYPE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getType());
                components.put(VALUE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getValue());
                annotations.add(AnnotationProxy.getProxy(components, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class, loader, cMgr));
            }
            return annotations.toArray(new Annotation[annotations.size()]);
        }
        return tmInfo.getAnnotations();
    }

    void init(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.typeInfoClasses = new ArrayList();
        this.referencedByTransformer = new ArrayList<String>();
        this.typeInfo = new HashMap();
        this.typeQNames = new ArrayList();
        this.classesToProcessPropertyTypes = new ArrayList<JavaClass>();
        this.objectFactoryClassNames = new ArrayList<String>();
        this.userDefinedSchemaTypes = new HashMap();
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap();
        }
        this.factoryMethods = new HashMap();
        this.xmlRegistries = new HashMap<String, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry>();
        this.xmlRootElements = new HashMap();
        this.arrayClassesToGeneratedClasses = new HashMap<String, Class>();
        this.collectionClassesToGeneratedClasses = new HashMap<Type, Class>();
        this.generatedClassesToArrayClasses = new HashMap<Class, JavaClass>();
        this.generatedClassesToCollectionClasses = new HashMap<Class, Type>();
        this.typeMappingInfoToGeneratedClasses = new HashMap<TypeMappingInfo, Class>();
        this.typeMappingInfoToSchemaType = new HashMap<TypeMappingInfo, QName>();
        this.elementDeclarations = new HashMap();
        HashMap globalElements = new HashMap();
        this.elementDeclarations.put(XmlElementDecl.GLOBAL.class.getName(), globalElements);
        this.localElements = new ArrayList<ElementDeclaration>();
        this.javaClassToTypeMappingInfos = new HashMap<JavaClass, List<TypeMappingInfo>>();
        if (typeMappingInfos != null) {
            int i = 0;
            while (i < typeMappingInfos.length) {
                List<TypeMappingInfo> infos = this.javaClassToTypeMappingInfos.get(classes[i]);
                if (infos == null) {
                    infos = new ArrayList<TypeMappingInfo>();
                    this.javaClassToTypeMappingInfos.put(classes[i], infos);
                }
                infos.add(typeMappingInfos[i]);
                ++i;
            }
        }
        this.typeMappingInfoToAdapterClasses = new HashMap<TypeMappingInfo, Class>();
        if (typeMappingInfos != null) {
            TypeMappingInfo[] typeMappingInfoArray = typeMappingInfos;
            int n = typeMappingInfos.length;
            int n2 = 0;
            while (n2 < n) {
                TypeMappingInfo next = typeMappingInfoArray[n2];
                Annotation[] annotations = this.getAnnotations(next);
                if (annotations != null) {
                    Annotation[] annotationArray = annotations;
                    int n3 = annotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation nextAnnotation = annotationArray[n4];
                        if (nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter) {
                            this.typeMappingInfoToAdapterClasses.put(next, ((javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)nextAnnotation).value());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public Map<String, TypeInfo> preBuildTypeInfo(JavaClass[] javaClasses) {
        JavaClass[] javaClassArray = javaClasses;
        int n = javaClasses.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass javaClass = javaClassArray[n2];
            String qualifiedName = javaClass.getQualifiedName();
            TypeInfo info = this.typeInfo.get(qualifiedName);
            if (!(javaClass == null || javaClass.isArray() || info != null && info.isPreBuilt() || !this.shouldGenerateTypeInfo(javaClass) || this.isXmlRegistry(javaClass))) {
                Map<Object, Object> propertiesMap;
                info = javaClass.isEnum() ? new EnumTypeInfo(this.helper, javaClass) : new TypeInfo(this.helper, javaClass);
                info.setJavaClassName(qualifiedName);
                info.setPreBuilt(true);
                if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
                    info.setXmlTransient(true);
                }
                this.processXmlExtensible(javaClass, info);
                if (this.helper.isAnnotationPresent(javaClass, XmlInlineBinaryData.class)) {
                    info.setInlineBinaryData(true);
                }
                this.processNamedObjectGraphs(javaClass, info);
                this.processXmlRootElement(javaClass, info);
                this.processXmlSeeAlso(javaClass, info);
                PackageInfo packageInfo = this.getPackageInfoForPackage(javaClass);
                if (packageInfo != null && packageInfo.getPackageLevelAdaptersByClass().size() > 0) {
                    for (String adapterClass : packageInfo.getPackageLevelAdaptersByClass().keySet()) {
                        JavaClass boundType = packageInfo.getPackageLevelAdaptersByClass().get(adapterClass);
                        info.getPackageLevelAdaptersByClass().put(adapterClass, boundType);
                    }
                }
                NamespaceInfo namespaceInfo = packageInfo.getNamespaceInfo();
                this.preProcessXmlType(javaClass, info, namespaceInfo);
                this.preProcessXmlAccessorType(javaClass, info, namespaceInfo);
                this.preProcessXmlAccessorOrder(javaClass, info, namespaceInfo);
                this.processPackageLevelAdapters(javaClass, info);
                this.processAccessorFactory(javaClass, info);
                this.processClassLevelAdapters(javaClass, info);
                this.preProcessCustomizer(javaClass, info);
                this.processSchemaTypes(javaClass, info);
                if (this.helper.isAnnotationPresent(javaClass, XmlClassExtractor.class)) {
                    XmlClassExtractor classExtractor = (XmlClassExtractor)this.helper.getAnnotation(javaClass, XmlClassExtractor.class);
                    info.setClassExtractorName(classExtractor.value().getName());
                }
                if (this.helper.isAnnotationPresent(javaClass, XmlProperties.class)) {
                    XmlProperties xmlProperties = (XmlProperties)this.helper.getAnnotation(javaClass, XmlProperties.class);
                    propertiesMap = this.createUserPropertiesMap(xmlProperties.value());
                    info.setUserProperties(propertiesMap);
                } else if (this.helper.isAnnotationPresent(javaClass, XmlProperty.class)) {
                    XmlProperty xmlProperty = (XmlProperty)this.helper.getAnnotation(javaClass, XmlProperty.class);
                    propertiesMap = this.createUserPropertiesMap(new XmlProperty[]{xmlProperty});
                    info.setUserProperties(propertiesMap);
                }
                if (this.helper.isAnnotationPresent(javaClass, XmlDiscriminatorNode.class)) {
                    XmlDiscriminatorNode xmlDiscriminatorNode = (XmlDiscriminatorNode)this.helper.getAnnotation(javaClass, XmlDiscriminatorNode.class);
                    info.setXmlDiscriminatorNode(xmlDiscriminatorNode.value());
                }
                if (this.helper.isAnnotationPresent(javaClass, XmlDiscriminatorValue.class)) {
                    XmlDiscriminatorValue xmlDiscriminatorValue = (XmlDiscriminatorValue)this.helper.getAnnotation(javaClass, XmlDiscriminatorValue.class);
                    info.setXmlDiscriminatorValue(xmlDiscriminatorValue.value());
                }
                this.typeInfoClasses.add(javaClass);
                this.typeInfo.put(info.getJavaClassName(), info);
            }
            ++n2;
        }
        return this.typeInfo;
    }

    private void processNamedObjectGraphs(JavaClass javaClass, TypeInfo info) {
        ArrayList<XmlNamedObjectGraph> objectGraphs = new ArrayList<XmlNamedObjectGraph>();
        if (this.helper.isAnnotationPresent(javaClass, XmlNamedObjectGraphs.class)) {
            XmlNamedObjectGraphs graphs = (XmlNamedObjectGraphs)this.helper.getAnnotation(javaClass, XmlNamedObjectGraphs.class);
            XmlNamedObjectGraph[] xmlNamedObjectGraphArray = graphs.value();
            int n = xmlNamedObjectGraphArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlNamedObjectGraph next = xmlNamedObjectGraphArray[n2];
                objectGraphs.add(next);
                ++n2;
            }
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlNamedObjectGraph.class)) {
            objectGraphs.add((XmlNamedObjectGraph)this.helper.getAnnotation(javaClass, XmlNamedObjectGraph.class));
        }
        for (XmlNamedObjectGraph next : objectGraphs) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode namedNode;
            XmlNamedAttributeNode nextNode;
            int n;
            int n3;
            XmlNamedAttributeNode[] xmlNamedAttributeNodeArray;
            XmlNamedSubgraph namedSubGraph;
            org.eclipse.persistence.jaxb.xmlmodel.XmlNamedObjectGraph namedGraph = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedObjectGraph();
            namedGraph.setName(next.name());
            Annotation[] annotationArray = next.attributeNodes();
            int n4 = annotationArray.length;
            int n5 = 0;
            while (n5 < n4) {
                XmlNamedAttributeNode nextNode2 = annotationArray[n5];
                org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode namedNode2 = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode();
                namedNode2.setName(nextNode2.value());
                namedNode2.setSubgraph(nextNode2.subgraph());
                namedGraph.getXmlNamedAttributeNode().add(namedNode2);
                ++n5;
            }
            annotationArray = next.subgraphs();
            n4 = annotationArray.length;
            n5 = 0;
            while (n5 < n4) {
                Annotation nextSubgraph = annotationArray[n5];
                namedSubGraph = new XmlNamedSubgraph();
                namedSubGraph.setName(nextSubgraph.name());
                namedSubGraph.setType(nextSubgraph.type().getName());
                xmlNamedAttributeNodeArray = nextSubgraph.attributeNodes();
                n3 = xmlNamedAttributeNodeArray.length;
                n = 0;
                while (n < n3) {
                    nextNode = xmlNamedAttributeNodeArray[n];
                    namedNode = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode();
                    namedNode.setName(nextNode.value());
                    namedNode.setSubgraph(nextNode.subgraph());
                    namedSubGraph.getXmlNamedAttributeNode().add(namedNode);
                    ++n;
                }
                namedGraph.getXmlNamedSubgraph().add(namedSubGraph);
                ++n5;
            }
            annotationArray = next.subclassSubgraphs();
            n4 = annotationArray.length;
            n5 = 0;
            while (n5 < n4) {
                Annotation nextSubgraph = annotationArray[n5];
                namedSubGraph = new XmlNamedSubgraph();
                namedSubGraph.setName(nextSubgraph.name());
                namedSubGraph.setType(nextSubgraph.type().getName());
                xmlNamedAttributeNodeArray = nextSubgraph.attributeNodes();
                n3 = xmlNamedAttributeNodeArray.length;
                n = 0;
                while (n < n3) {
                    nextNode = xmlNamedAttributeNodeArray[n];
                    namedNode = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode();
                    namedNode.setName(nextNode.value());
                    namedNode.setSubgraph(nextNode.subgraph());
                    namedSubGraph.getXmlNamedAttributeNode().add(namedNode);
                    ++n;
                }
                namedGraph.getXmlNamedSubclassGraph().add(namedSubGraph);
                ++n5;
            }
            info.getObjectGraphs().add(namedGraph);
        }
    }

    private void processAccessorFactory(JavaClass javaClass, TypeInfo info) {
        PackageInfo pInfo;
        if (!this.xmlAccessorFactorySupport) {
            return;
        }
        Annotation xmlAccessorFactory = this.helper.getAnnotation(javaClass, CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS);
        Method valueMethod = null;
        if (xmlAccessorFactory != null) {
            valueMethod = CompilerHelper.ACCESSOR_FACTORY_VALUE_METHOD;
        } else {
            xmlAccessorFactory = this.helper.getAnnotation(javaClass, CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS);
            if (xmlAccessorFactory != null) {
                valueMethod = CompilerHelper.INTERNAL_ACCESSOR_FACTORY_VALUE_METHOD;
            }
        }
        if (xmlAccessorFactory != null) {
            Class xmlAccessorFactoryClass = null;
            try {
                xmlAccessorFactoryClass = (Class)PrivilegedAccessHelper.invokeMethod(valueMethod, xmlAccessorFactory, new Object[0]);
                info.setXmlAccessorFactory(new AccessorFactoryWrapper(PrivilegedAccessHelper.newInstanceFromClass(xmlAccessorFactoryClass)));
            }
            catch (Exception ex) {
                throw JAXBException.errorInstantiatingAccessorFactory(xmlAccessorFactoryClass, ex);
            }
        }
        if ((pInfo = this.getPackageInfoForPackage(javaClass)) != null) {
            info.setPackageLevelXmlAccessorFactory(pInfo.getAccessorFactory());
        }
    }

    public JavaClass[] postBuildTypeInfo(JavaClass[] javaClasses) {
        if (javaClasses.length == 0) {
            return javaClasses;
        }
        javaClasses = this.processAdditionalClasses(javaClasses);
        this.preBuildTypeInfo(javaClasses);
        this.buildTypeInfo(javaClasses);
        this.updateGlobalElements(javaClasses);
        return javaClasses;
    }

    private Map<String, TypeInfo> buildTypeInfo(JavaClass[] allClasses) {
        JavaClass[] javaClassArray = allClasses;
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo info;
            JavaClass javaClass = javaClassArray[n2];
            if (javaClass != null && (info = this.typeInfo.get(javaClass.getQualifiedName())) != null && !info.isPostBuilt()) {
                info.setPostBuilt(true);
                this.processFactoryMethods(javaClass, info);
                PackageInfo packageInfo = this.getPackageInfoForPackage(javaClass);
                XMLNameTransformer transformer = info.getXmlNameTransformer();
                if (transformer == TypeInfo.DEFAULT_NAME_TRANSFORMER) {
                    XMLNameTransformer nsInfoXmlNameTransformer = packageInfo.getXmlNameTransformer();
                    if (nsInfoXmlNameTransformer != null) {
                        info.setXmlNameTransformer(nsInfoXmlNameTransformer);
                    } else {
                        Class<? extends XMLNameTransformer> nameTransformerClass;
                        XmlNameTransformer nameTranformer;
                        if (this.helper.isAnnotationPresent(javaClass, XmlNameTransformer.class)) {
                            nameTranformer = (XmlNameTransformer)this.helper.getAnnotation(javaClass, XmlNameTransformer.class);
                            nameTransformerClass = nameTranformer.value();
                            try {
                                info.setXmlNameTransformer(nameTransformerClass.newInstance());
                            }
                            catch (InstantiationException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                        }
                        if (this.helper.isAnnotationPresent(javaClass.getPackage(), XmlNameTransformer.class)) {
                            nameTranformer = (XmlNameTransformer)this.helper.getAnnotation(javaClass.getPackage(), XmlNameTransformer.class);
                            nameTransformerClass = nameTranformer.value();
                            try {
                                info.setXmlNameTransformer(nameTransformerClass.newInstance());
                            }
                            catch (InstantiationException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                            }
                        }
                    }
                }
                this.postProcessXmlAccessorType(info, packageInfo);
                this.postProcessXmlType(javaClass, info, packageInfo);
                if (info.isEnumerationType()) {
                    this.addEnumTypeInfo(javaClass, (EnumTypeInfo)info);
                } else {
                    this.processTypeQName(javaClass, info, packageInfo.getNamespaceInfo());
                    JavaClass superClass = javaClass.getSuperclass();
                    this.processReferencedClass(superClass);
                    this.processPropertiesSuperClass(javaClass, info);
                    info.setProperties(this.getPropertiesForClass(javaClass, info));
                    this.processTypeInfoProperties(javaClass, info);
                    this.postProcessXmlAccessorOrder(info, packageInfo);
                    this.validatePropOrderForInfo(info);
                }
            }
            ++n2;
        }
        return this.typeInfo;
    }

    private TypeInfo processReferencedClass(JavaClass referencedClass) {
        if (this.shouldGenerateTypeInfo(referencedClass)) {
            PackageInfo pInfo;
            JavaClass adapterClass;
            TypeInfo existingInfo = this.typeInfo.get(referencedClass.getQualifiedName());
            if (existingInfo == null || !existingInfo.isPreBuilt()) {
                PackageInfo pInfo2 = this.getPackageInfoForPackage(referencedClass);
                JavaClass adapterClass2 = pInfo2.getPackageLevelAdaptersByClass().get(referencedClass);
                if (adapterClass2 == null) {
                    CompilerHelper.addClassToClassLoader(referencedClass, this.helper.getClassLoader());
                    JavaClass[] jClassArray = new JavaClass[]{referencedClass};
                    this.buildNewTypeInfo(jClassArray);
                }
                return this.typeInfo.get(referencedClass.getQualifiedName());
            }
            if (existingInfo != null && !existingInfo.isPostBuilt() && (adapterClass = (pInfo = this.getPackageInfoForPackage(referencedClass)).getPackageLevelAdaptersByClass().get(referencedClass)) == null) {
                CompilerHelper.addClassToClassLoader(referencedClass, this.helper.getClassLoader());
                JavaClass[] javaClasses = new JavaClass[]{referencedClass};
                JavaClass[] javaClassArray = javaClasses = this.postBuildTypeInfo(javaClasses);
                int n = javaClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    JavaClass next = javaClassArray[n2];
                    this.processPropertyTypes(next);
                    ++n2;
                }
            }
            return existingInfo;
        }
        return null;
    }

    public void processPropertiesSuperClass(JavaClass cls, TypeInfo info) {
        JavaClass superClass = cls.getSuperclass();
        if (superClass == null) {
            return;
        }
        TypeInfo superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
        if (superClassInfo != null) {
            this.processPropertiesSuperClass(superClass, superClassInfo);
            this.classesToProcessPropertyTypes.add(superClass);
            if (superClassInfo.getXmlVirtualAccessMethods() != null && info.getXmlVirtualAccessMethods() == null) {
                info.setXmlVirtualAccessMethods(superClassInfo.getXmlVirtualAccessMethods());
            }
            if (superClassInfo.isIDSet()) {
                info.setIDProperty(superClassInfo.getIDProperty());
            }
        }
    }

    public void finalizeProperties() {
        for (TypeInfo tInfo : this.getTypeInfo().values()) {
            JavaConstructor zeroArgConstructor;
            if (tInfo.isTransient()) continue;
            JavaClass jClass = tInfo.getJavaClass();
            String[] propOrder = tInfo.getPropOrder();
            boolean hasPropOrder = propOrder.length > 0 && (propOrder.length != 1 || !propOrder[0].equals(EMPTY_STRING));
            List<String> propOrderList = Arrays.asList(tInfo.getPropOrder());
            ArrayList<Property> propsList = tInfo.getPropertyList();
            int i = 0;
            while (i < propsList.size()) {
                Property p = propsList.get(i);
                if (p.isTransient() && propOrderList.contains(p.getPropertyName())) {
                    throw JAXBException.transientInProporder(p.getPropertyName());
                }
                if (!(!hasPropOrder || p.isAttribute() || p.isTransient() || p.isInverseReference() || propOrderList.contains(p.getPropertyName()))) {
                    throw JAXBException.missingPropertyInPropOrder(p.getPropertyName(), tInfo.getJavaClassName());
                }
                ++i;
            }
            if (!(jClass.isInterface() || tInfo.isEnumerationType() || jClass.isAbstract() || tInfo.getFactoryMethodName() != null || tInfo.getObjectFactoryClassName() != null || (zeroArgConstructor = jClass.getDeclaredConstructor(new JavaClass[0])) != null)) {
                if (tInfo.isSetXmlJavaTypeAdapter()) {
                    tInfo.setTransient(true);
                } else if (!this.referencedByTransformer.contains(jClass.getName())) {
                    throw JAXBException.factoryMethodOrConstructorRequired(jClass.getName());
                }
            }
            if (tInfo.getXmlValueProperty() != null) {
                this.validateXmlValueFieldOrProperty(jClass, tInfo.getXmlValueProperty());
            }
            ArrayList<Property> anyElementProperties = new ArrayList<Property>();
            for (Property property : tInfo.getPropertyList()) {
                TypeInfo targetInfo;
                if (property.isAttribute()) {
                    this.validateXmlAttributeFieldOrProperty(tInfo, property);
                }
                JavaClass typeClass = property.getActualType();
                if (property.isChoice()) {
                    Collection<Property> choiceProps = property.getChoiceProperties();
                    for (Property nextChoiceProp : choiceProps) {
                        JavaClass nextChoicePropTypeClass = nextChoiceProp.getActualType();
                        TypeInfo targetInfo2 = this.typeInfo.get(nextChoicePropTypeClass.getQualifiedName());
                        this.finalizeProperty(property, targetInfo2, nextChoicePropTypeClass, jClass);
                    }
                } else {
                    targetInfo = this.typeInfo.get(typeClass.getQualifiedName());
                    this.finalizeProperty(property, targetInfo, typeClass, jClass);
                }
                if (tInfo.isSetXmlValueProperty()) {
                    if (property.isXmlValue() && !tInfo.getXmlValueProperty().getPropertyName().equals(property.getPropertyName())) {
                        throw JAXBException.xmlValueAlreadySet(property.getPropertyName(), tInfo.getXmlValueProperty().getPropertyName(), jClass.getName());
                    }
                    if (!(property.isXmlValue() || property.isAttribute() || property.isInverseReference() || property.isTransient())) {
                        throw JAXBException.propertyOrFieldShouldBeAnAttribute(property.getPropertyName());
                    }
                }
                if (property.isReference()) {
                    this.processReferenceProperty(property, tInfo, jClass);
                }
                if (property.isSwaAttachmentRef() && !this.hasSwaRef) {
                    this.hasSwaRef = true;
                }
                if (property.isXmlId() && tInfo.getIDProperty() != null && !tInfo.getIDProperty().getPropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.idAlreadySet(property.getPropertyName(), tInfo.getIDProperty().getPropertyName(), jClass.getName());
                }
                if (property.isAnyAttribute() && tInfo.isSetAnyAttributePropertyName() && !tInfo.getAnyAttributePropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.multipleAnyAttributeMapping(jClass.getName());
                }
                if (property.isAny()) {
                    if (!anyElementProperties.isEmpty()) {
                        for (Property nextAny : anyElementProperties) {
                            if (!property.isSetXmlElementWrapper() && !nextAny.isSetXmlElementWrapper()) {
                                throw JAXBException.xmlAnyElementAlreadySet(property.getPropertyName(), nextAny.getPropertyName(), jClass.getName());
                            }
                            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper wrapper = property.getXmlElementWrapper();
                            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper targetWrapper = nextAny.getXmlElementWrapper();
                            if (wrapper == null || targetWrapper == null || !wrapper.getName().equals(targetWrapper.getName()) || !wrapper.getNamespace().equals(targetWrapper.getNamespace())) continue;
                            throw JAXBException.xmlAnyElementAlreadySet(property.getPropertyName(), nextAny.getPropertyName(), jClass.getName());
                        }
                    }
                    anyElementProperties.add(property);
                }
                if (property.isSwaAttachmentRef() && !this.areEquals(property.getActualType(), JAVAX_ACTIVATION_DATAHANDLER)) {
                    throw JAXBException.invalidAttributeRef(property.getPropertyName(), jClass.getQualifiedName());
                }
                if (!(property.getXmlElementWrapper() == null || this.helper.isCollectionType(property.getType()) || property.getType().isArray() || this.helper.isMapType(property.getType()))) {
                    throw JAXBException.invalidElementWrapper(property.getPropertyName());
                }
                if (property.isXmlTransformation()) {
                    this.processXmlTransformationProperty(property);
                }
                if (!property.isSetXmlJoinNodes()) continue;
                targetInfo = this.typeInfo.get(typeClass.getQualifiedName());
                if (targetInfo == null) {
                    throw JAXBException.invalidXmlJoinNodeReferencedClass(property.getPropertyName(), typeClass.getQualifiedName());
                }
                if (targetInfo.getIDProperty() != null || targetInfo.getXmlKeyProperties() != null) continue;
                throw JAXBException.noKeyOrIDPropertyOnJoinTarget(jClass.getQualifiedName(), property.getPropertyName(), typeClass.getQualifiedName());
            }
        }
    }

    private void finalizeProperty(Property property, TypeInfo targetInfo, JavaClass typeClass, JavaClass jClass) {
        if (targetInfo != null && targetInfo.isTransient() && property.getXmlElements() == null) {
            property.setTransientType(true);
        }
        if (property.isXmlIdRef()) {
            if (targetInfo == null && !typeClass.getQualifiedName().equals(JAVA_LANG_OBJECT)) {
                throw JAXBException.invalidIDREFClass(jClass.getQualifiedName(), property.getPropertyName(), typeClass.getQualifiedName());
            }
            if (targetInfo != null && targetInfo.getIDProperty() == null) {
                throw JAXBException.invalidIdRef(property.getPropertyName(), typeClass.getQualifiedName());
            }
        }
    }

    private void processTypeInfoProperties(JavaClass javaClass, TypeInfo info) {
        ArrayList<Property> properties = info.getPropertyList();
        for (Property property : properties) {
            this.processXmlID(property, javaClass, info);
            this.processXmlIDREF(property);
            if (!property.isMap()) continue;
            this.processReferencedClass(property.getKeyType());
            this.processReferencedClass(property.getValueType());
        }
    }

    void processPropertyTypes(JavaClass[] classes) {
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass next = javaClassArray[n2];
            this.processPropertyTypes(next);
            this.classesToProcessPropertyTypes.remove(next);
            ++n2;
        }
        int i = 0;
        while (i < this.classesToProcessPropertyTypes.size()) {
            JavaClass next = this.classesToProcessPropertyTypes.get(i);
            this.processPropertyTypes(next);
            ++i;
        }
    }

    private void processPropertyTypes(JavaClass next) {
        TypeInfo info = this.getTypeInfo().get(next.getQualifiedName());
        if (info != null) {
            for (Property property : info.getPropertyList()) {
                if (property.isXmlLocation()) {
                    info.setLocationAware(true);
                }
                if (property.isTransient()) continue;
                JavaClass type = property.getActualType();
                if (property.isReference()) {
                    this.processReferencePropertyTypes(property, info, next);
                }
                if (property.isChoice()) {
                    this.processChoiceProperty(property, info, next, type);
                    for (Property choiceProp : property.getChoiceProperties()) {
                        type = choiceProp.getActualType();
                        this.processReferencedClass(type);
                    }
                    continue;
                }
                this.processReferencedClass(type);
            }
        }
    }

    public void processJavaClasses(JavaClass[] classes) {
        this.checkForCallbackMethods();
    }

    private JavaClass[] processAdditionalClasses(JavaClass[] classes) {
        ArrayList<JavaClass> extraClasses = new ArrayList<JavaClass>();
        ArrayList<JavaClass> classesToProcess = new ArrayList<JavaClass>();
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass jClass = javaClassArray[n2];
            List<TypeMappingInfo> infos = this.javaClassToTypeMappingInfos.get(jClass);
            if (infos != null && infos.size() > 0) {
                for (TypeMappingInfo next : infos) {
                    this.processAdditionalClasses(jClass, next, extraClasses, classesToProcess);
                }
            } else {
                this.processAdditionalClasses(jClass, null, extraClasses, classesToProcess);
            }
            ++n2;
        }
        for (JavaClass javaClass : extraClasses) {
            this.processClass(javaClass, classesToProcess);
        }
        return classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
    }

    private void processAdditionalClasses(JavaClass cls, TypeMappingInfo tmi, ArrayList<JavaClass> extraClasses, ArrayList<JavaClass> classesToProcess) {
        Class xmlElementType = null;
        JavaClass javaClass = cls;
        if (tmi != null) {
            Annotation[] annotations;
            Class adapterClass = this.typeMappingInfoToAdapterClasses.get(tmi);
            if (adapterClass != null) {
                JavaClass adapterJavaClass = this.helper.getJavaClass(adapterClass);
                JavaClass newType = this.helper.getJavaClass(Object.class);
                for (Object nextMethod : adapterJavaClass.getDeclaredMethods()) {
                    JavaClass returnType;
                    JavaMethod method = (JavaMethod)nextMethod;
                    if (!method.getName().equals("marshal") || (returnType = method.getReturnType()).getQualifiedName().equals(newType.getQualifiedName())) continue;
                    newType = returnType;
                    break;
                }
                if (!this.helper.isBuiltInJavaType(javaClass)) {
                    extraClasses.add(javaClass);
                }
                javaClass = newType;
            }
            if ((annotations = this.getAnnotations(tmi)) != null) {
                int j = 0;
                while (j < annotations.length) {
                    javax.xml.bind.annotation.XmlElement javaAnnotation;
                    Annotation nextAnnotation = annotations[j];
                    if (nextAnnotation != null && nextAnnotation instanceof javax.xml.bind.annotation.XmlElement && (javaAnnotation = (javax.xml.bind.annotation.XmlElement)nextAnnotation).type() != XmlElement.DEFAULT.class) {
                        xmlElementType = javaAnnotation.type();
                    }
                    ++j;
                }
            }
        }
        if (this.areEquals(javaClass, byte[].class) || this.areEquals(javaClass, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(javaClass, Source.class) || this.areEquals(javaClass, Image.class) || this.areEquals(javaClass, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
            if (tmi == null || tmi.getXmlTagName() == null) {
                ElementDeclaration declaration = new ElementDeclaration(null, javaClass, javaClass.getQualifiedName(), false, XmlElementDecl.GLOBAL.class);
                declaration.setTypeMappingInfo(tmi);
                this.localElements.add(declaration);
            }
        } else if (javaClass.isArray()) {
            Class generatedClass;
            if (!this.helper.isBuiltInJavaType(javaClass.getComponentType())) {
                extraClasses.add(javaClass.getComponentType());
            }
            if ((generatedClass = tmi == null ? this.arrayClassesToGeneratedClasses.get(javaClass.getName()) : CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                generatedClass = this.generateWrapperForArrayClass(javaClass, tmi, xmlElementType, extraClasses);
                extraClasses.add(this.helper.getJavaClass(generatedClass));
                this.arrayClassesToGeneratedClasses.put(javaClass.getName(), generatedClass);
            }
            this.generatedClassesToArrayClasses.put(generatedClass, javaClass);
            this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
        } else if (this.helper.isCollectionType(javaClass)) {
            Class generatedClass;
            JavaClass componentClass;
            Collection args = javaClass.getActualTypeArguments();
            if (args.size() > 0) {
                componentClass = (JavaClass)args.iterator().next();
                if (!componentClass.isPrimitive()) {
                    extraClasses.add(componentClass);
                }
            } else {
                componentClass = this.helper.getJavaClass(Object.class);
            }
            if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                generatedClass = this.generateCollectionValue(javaClass, tmi, xmlElementType, extraClasses);
                extraClasses.add(this.helper.getJavaClass(generatedClass));
            }
            this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
        } else if (this.helper.isMapType(javaClass)) {
            Class generatedClass;
            JavaClass valueClass;
            JavaClass keyClass;
            Collection args = javaClass.getActualTypeArguments();
            Iterator argsIter = args.iterator();
            if (args.size() > 1) {
                keyClass = (JavaClass)argsIter.next();
                if (!this.helper.isBuiltInJavaType(keyClass)) {
                    extraClasses.add(keyClass);
                }
                if (!this.helper.isBuiltInJavaType(valueClass = (JavaClass)argsIter.next())) {
                    extraClasses.add(valueClass);
                }
            } else {
                keyClass = this.helper.getJavaClass(Object.class);
                valueClass = this.helper.getJavaClass(Object.class);
            }
            if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                generatedClass = this.generateWrapperForMapClass(javaClass, keyClass, valueClass, tmi);
                extraClasses.add(this.helper.getJavaClass(generatedClass));
            }
            this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
        } else {
            this.processClass(javaClass, classesToProcess);
        }
    }

    private void processClass(JavaClass javaClass, ArrayList<JavaClass> classesToProcess) {
        if (this.shouldGenerateTypeInfo(javaClass)) {
            if (this.isXmlRegistry(javaClass)) {
                this.processObjectFactory(javaClass, classesToProcess);
            } else {
                classesToProcess.add(javaClass);
                TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
                if (info != null && info.isSetXmlSeeAlso()) {
                    for (String jClassName : info.getXmlSeeAlso()) {
                        classesToProcess.add(this.helper.getJavaClass(jClassName));
                    }
                }
            }
        }
    }

    private void processXmlSeeAlso(JavaClass javaClass, TypeInfo info) {
        Class xmlSeeAlsoClass = null;
        Method valueMethod = null;
        try {
            xmlSeeAlsoClass = PrivilegedAccessHelper.getClassForName("javax.xml.bind.annotation.XmlSeeAlso", false, this.helper.getClassLoader());
            valueMethod = PrivilegedAccessHelper.getDeclaredMethod(xmlSeeAlsoClass, VALUE_METHOD_NAME, new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (xmlSeeAlsoClass != null && this.helper.isAnnotationPresent(javaClass, xmlSeeAlsoClass)) {
            Annotation seeAlso = this.helper.getAnnotation(javaClass, xmlSeeAlsoClass);
            Class[] values = null;
            try {
                values = (Class[])PrivilegedAccessHelper.invokeMethod(valueMethod, seeAlso, new Object[0]);
            }
            catch (Exception exception) {}
            if (values != null) {
                ArrayList<String> seeAlsoClassNames = new ArrayList<String>();
                Class[] classArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Class next = classArray[n2];
                    seeAlsoClassNames.add(next.getName());
                    ++n2;
                }
                info.setXmlSeeAlso(seeAlsoClassNames);
            }
        }
    }

    private void processFactoryMethods(JavaClass javaClass, TypeInfo info) {
        JavaMethod factoryMethod = this.factoryMethods.get(javaClass.getRawName());
        if (factoryMethod != null) {
            info.setFactoryMethodName(factoryMethod.getName());
            info.setObjectFactoryClassName(factoryMethod.getOwningClass().getQualifiedName());
            JavaClass[] paramTypes = factoryMethod.getParameterTypes();
            if (paramTypes != null && paramTypes.length > 0) {
                String[] paramTypeNames = new String[paramTypes.length];
                int i = 0;
                while (i < paramTypes.length) {
                    this.processReferencedClass(paramTypes[i]);
                    paramTypeNames[i] = paramTypes[i].getQualifiedName();
                    ++i;
                }
                info.setFactoryMethodParamTypes(paramTypeNames);
            }
        }
    }

    private void processPackageLevelAdapters(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlJavaTypeAdapters.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter[] adapterArray;
            XmlJavaTypeAdapters adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(pack, XmlJavaTypeAdapters.class);
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter[] xmlJavaTypeAdapterArray = adapterArray = adapters.value();
            int n = adapterArray.length;
            int n2 = 0;
            while (n2 < n) {
                javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter next = xmlJavaTypeAdapterArray[n2];
                this.processPackageLevelAdapter(next, info);
                ++n2;
            }
        }
        if (this.helper.isAnnotationPresent(pack, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(pack, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            this.processPackageLevelAdapter(adapter, info);
        }
    }

    private void processPackageLevelAdapter(javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter next, TypeInfo info) {
        JavaClass adapterClass = this.helper.getJavaClass(next.value());
        JavaClass boundType = this.helper.getJavaClass(next.type());
        if (boundType != null) {
            info.addPackageLevelAdapterClass(adapterClass, boundType);
        } else {
            this.getLogger().logWarning("jaxb_metadata_warning_invalid_bound_type", new Object[]{boundType, adapterClass});
        }
    }

    private void processClassLevelAdapters(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(javaClass, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            String boundType = adapter.type().getName();
            if (boundType == null || boundType.equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT")) {
                boundType = javaClass.getRawName();
            }
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(boundType);
            info.setXmlJavaTypeAdapter(xja);
        }
    }

    private void processSchemaTypes(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlSchemaTypes.class)) {
            XmlSchemaType[] typeArray;
            XmlSchemaTypes types = (XmlSchemaTypes)this.helper.getAnnotation(pack, XmlSchemaTypes.class);
            XmlSchemaType[] xmlSchemaTypeArray = typeArray = types.value();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlSchemaType next = xmlSchemaTypeArray[n2];
                this.processSchemaType(next);
                ++n2;
            }
        } else if (this.helper.isAnnotationPresent(pack, XmlSchemaType.class)) {
            this.processSchemaType((XmlSchemaType)this.helper.getAnnotation(pack, XmlSchemaType.class));
        }
    }

    private void processXmlRootElement(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = new org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement();
            xmlRE.setName(rootElemAnnotation.name());
            xmlRE.setNamespace(rootElemAnnotation.namespace());
            info.setXmlRootElement(xmlRE);
        }
    }

    private void processXmlExtensible(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlVirtualAccessMethods.class)) {
            XmlVirtualAccessMethods extAnnotation = (XmlVirtualAccessMethods)this.helper.getAnnotation(javaClass, XmlVirtualAccessMethods.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods xmlExt = new org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods();
            xmlExt.setGetMethod(extAnnotation.getMethod());
            xmlExt.setSetMethod(extAnnotation.setMethod());
            xmlExt.setSchema(XmlVirtualAccessMethodsSchema.valueOf(extAnnotation.schema().toString()));
            info.setXmlVirtualAccessMethods(xmlExt);
        }
    }

    private void preProcessXmlType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = new org.eclipse.persistence.jaxb.xmlmodel.XmlType();
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            xmlType.setName(typeAnnotation.name());
            xmlType.setNamespace(typeAnnotation.namespace());
            String[] propOrder = typeAnnotation.propOrder();
            if (propOrder != null) {
                xmlType.getPropOrder();
            }
            String[] stringArray = propOrder;
            int n = propOrder.length;
            int n2 = 0;
            while (n2 < n) {
                String prop = stringArray[n2];
                xmlType.getPropOrder().add(prop);
                ++n2;
            }
            Class factoryClass = typeAnnotation.factoryClass();
            if (factoryClass == XmlType.DEFAULT.class) {
                xmlType.setFactoryClass("javax.xml.bind.annotation.XmlType.DEFAULT");
            } else {
                xmlType.setFactoryClass(factoryClass.getCanonicalName());
            }
            xmlType.setFactoryMethod(typeAnnotation.factoryMethod());
        } else {
            xmlType.setNamespace(packageNamespace.getNamespace());
        }
        info.setXmlType(xmlType);
    }

    private void postProcessXmlType(JavaClass javaClass, TypeInfo info, PackageInfo packageNamespace) {
        String typeName;
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = info.getXmlType();
        String factoryClassName = xmlType.getFactoryClass();
        String factoryMethodName = xmlType.getFactoryMethod();
        if (factoryClassName.equals("javax.xml.bind.annotation.XmlType.DEFAULT")) {
            if (factoryMethodName != null && !factoryMethodName.equals(EMPTY_STRING)) {
                JavaMethod method = javaClass.getDeclaredMethod(factoryMethodName, new JavaClass[0]);
                if (method == null) {
                    throw JAXBException.factoryMethodNotDeclared(factoryMethodName, javaClass.getName());
                }
                info.setFactoryMethodName(factoryMethodName);
            }
        } else {
            if (factoryMethodName == null || factoryMethodName.equals(EMPTY_STRING)) {
                throw JAXBException.factoryClassWithoutFactoryMethod(javaClass.getName());
            }
            info.setObjectFactoryClassName(factoryClassName);
            info.setFactoryMethodName(factoryMethodName);
        }
        if ((typeName = xmlType.getName()).equals("##default")) {
            try {
                typeName = info.getXmlNameTransformer().transformTypeName(javaClass.getName());
            }
            catch (Exception ex) {
                throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
            }
        }
        info.setSchemaTypeName(typeName);
        if (xmlType.isSetPropOrder()) {
            List<String> props = xmlType.getPropOrder();
            if (props.size() == 0) {
                info.setPropOrder(new String[0]);
            } else if (props.get(0).equals(EMPTY_STRING)) {
                info.setPropOrder(new String[]{EMPTY_STRING});
            } else {
                info.setPropOrder(xmlType.getPropOrder().toArray(new String[xmlType.getPropOrder().size()]));
            }
        }
        if (xmlType.getNamespace().equals("##default")) {
            info.setClassNamespace(packageNamespace.getNamespace());
        } else {
            info.setClassNamespace(xmlType.getNamespace());
        }
    }

    private void preProcessXmlAccessorType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        if (javaClass.getDeclaredAnnotation(this.helper.getJavaClass(XmlAccessorType.class)) != null) {
            XmlAccessorType accessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            XmlAccessType xmlAccessType = XmlAccessType.fromValue(accessorType.value().name());
            info.setXmlAccessType(xmlAccessType);
        }
    }

    private void postProcessXmlAccessorType(TypeInfo info, PackageInfo packageNamespace) {
        if (!info.isSetXmlAccessType()) {
            JavaClass next = this.helper.getJavaClass(info.getJavaClassName()).getSuperclass();
            while (next != null && !next.getName().equals(JAVA_LANG_OBJECT)) {
                this.processReferencedClass(next);
                TypeInfo parentInfo = this.typeInfo.get(next.getName());
                if (parentInfo != null && parentInfo.isSetXmlAccessType()) {
                    info.setXmlAccessType(parentInfo.getXmlAccessType());
                    break;
                }
                next = next.getSuperclass();
            }
            if (!info.isSetXmlAccessType()) {
                info.setXmlAccessType(XmlAccessType.fromValue(packageNamespace.getAccessType().name()));
            }
        }
    }

    private void preProcessXmlAccessorOrder(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        XmlAccessorOrder order = null;
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            order = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(order.value().name()));
        }
    }

    private void postProcessXmlAccessorOrder(TypeInfo info, PackageInfo packageNamespace) {
        if (!info.isSetXmlAccessOrder()) {
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(packageNamespace.getAccessOrder().name()));
        }
        info.orderProperties();
    }

    private void processXmlElement(Property property, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), javax.xml.bind.annotation.XmlElement.class)) {
            javax.xml.bind.annotation.XmlElement element = (javax.xml.bind.annotation.XmlElement)this.helper.getAnnotation(property.getElement(), javax.xml.bind.annotation.XmlElement.class);
            property.setIsRequired(element.required());
            property.setNillable(element.nillable());
            if (element.type() != XmlElement.DEFAULT.class && !property.isSwaAttachmentRef()) {
                property.setOriginalType(property.getType());
                if (this.helper.isCollectionType(property.getType()) || property.getType().isArray()) {
                    property.setGenericType(this.helper.getJavaClass(element.type()));
                } else {
                    JavaClass originalType = property.getType();
                    JavaClass newType = this.helper.getJavaClass(element.type());
                    if (!originalType.getName().equals(newType.getName())) {
                        property.setTyped(true);
                        property.setSchemaType((QName)this.helper.getXMLToJavaTypeMap().get(newType.getName()));
                    }
                    property.setType(newType);
                }
                property.setHasXmlElementType(true);
            }
            if (!element.defaultValue().equals(ELEMENT_DECL_DEFAULT)) {
                property.setDefaultValue(element.defaultValue());
            }
        }
    }

    private void processXmlID(Property property, JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
            property.setIsXmlId(true);
            info.setIDProperty(property);
        }
    }

    private void processXmlIDREF(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
            property.setIsXmlIdRef(true);
        }
    }

    private void processXmlJavaTypeAdapter(Property property, TypeInfo info, JavaClass javaClass) {
        JavaClass adapterClass = null;
        JavaClass ptype = property.getActualType();
        if (this.helper.isAnnotationPresent(property.getElement(), javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(adapter.type().getName());
            property.setXmlJavaTypeAdapter(xja);
        } else {
            XmlJavaTypeAdapter xmlJavaTypeAdapter;
            TypeInfo ptypeInfo = this.typeInfo.get(ptype.getQualifiedName());
            if (ptypeInfo == null && this.shouldGenerateTypeInfo(ptype) && this.helper.isAnnotationPresent(ptype, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
                javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(ptype, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
                XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
                xja.setValue(adapter.value().getName());
                String boundType = adapter.type().getName();
                if (boundType == null || boundType.equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT")) {
                    boundType = ptype.getRawName();
                }
                xja.setType(adapter.type().getName());
                property.setXmlJavaTypeAdapter(xja);
            }
            if (ptypeInfo != null && (xmlJavaTypeAdapter = ptypeInfo.getXmlJavaTypeAdapter()) != null) {
                try {
                    property.setXmlJavaTypeAdapter(xmlJavaTypeAdapter);
                }
                catch (JAXBException jAXBException) {
                    throw JAXBException.invalidTypeAdapterClass(xmlJavaTypeAdapter.getValue(), javaClass.getName());
                }
            }
            if (info.hasPackageLevelAdaptersByClass() && info.getPackageLevelAdaptersByClass().get(ptype.getQualifiedName()) != null && !property.isSetXmlJavaTypeAdapter()) {
                adapterClass = info.getPackageLevelAdapterClass(ptype);
                XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
                xja.setValue(adapterClass.getQualifiedName());
                xja.setType(ptype.getQualifiedName());
                property.setXmlJavaTypeAdapter(xja);
            }
        }
    }

    private void processTypeQName(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        if (info.isTransient()) {
            return;
        }
        String typeName = info.getSchemaTypeName();
        if (typeName != null && !EMPTY_STRING.equals(typeName)) {
            QName typeQName = new QName(info.getClassNamespace(), typeName);
            boolean containsQName = this.typeQNames.contains(typeQName);
            if (containsQName) {
                throw JAXBException.nameCollision(typeQName.getNamespaceURI(), typeQName.getLocalPart());
            }
            this.typeQNames.add(typeQName);
        }
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        String javaClassName;
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || ORG_W3C_DOM.equals(javaClass.getPackageName())) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        if (javaClass.isArray() && !(javaClassName = javaClass.getName()).equals(CoreClassConstants.APBYTE.getName()) && !javaClassName.equals(CoreClassConstants.ABYTE.getName())) {
            return true;
        }
        if (this.helper.isBuiltInJavaType(javaClass)) {
            return false;
        }
        return !this.helper.isCollectionType(javaClass) && !this.helper.isMapType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass cls, TypeInfo info) {
        JavaClass superClass;
        ArrayList<Property> returnList = new ArrayList<Property>();
        if (!info.isTransient() && (superClass = cls.getSuperclass()) != null) {
            TypeInfo superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
            while (superClassInfo != null && superClassInfo.isTransient()) {
                ArrayList<Property> superClassProperties = info.getXmlAccessType() == XmlAccessType.FIELD ? this.getFieldPropertiesForClass(superClass, superClassInfo, false) : (info.getXmlAccessType() == XmlAccessType.PROPERTY ? this.getPropertyPropertiesForClass(superClass, superClassInfo, false) : (info.getXmlAccessType() == XmlAccessType.PUBLIC_MEMBER ? this.getPublicMemberPropertiesForClass(superClass, superClassInfo) : this.getNoAccessTypePropertiesForClass(superClass, superClassInfo)));
                superClass = superClass.getSuperclass();
                superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
                for (Property next : superClassProperties) {
                    next.setIsSuperClassProperty(true);
                }
                returnList.addAll(0, (Collection<Property>)superClassProperties);
            }
        }
        if (info.isTransient()) {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        } else if (info.getXmlAccessType() == XmlAccessType.FIELD) {
            returnList.addAll(this.getFieldPropertiesForClass(cls, info, false));
            returnList.addAll(this.getPropertyPropertiesForClass(cls, info, false, true));
        } else if (info.getXmlAccessType() == XmlAccessType.PROPERTY) {
            returnList.addAll(this.getFieldPropertiesForClass(cls, info, false, true));
            returnList.addAll(this.getPropertyPropertiesForClass(cls, info, false));
        } else if (info.getXmlAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            returnList.addAll(this.getPublicMemberPropertiesForClass(cls, info));
        } else {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        }
        return returnList;
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        return this.getFieldPropertiesForClass(cls, info, onlyPublic, false);
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic, boolean onlyExplicit) {
        properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        fieldIt = cls.getDeclaredFields().iterator();
        while (fieldIt.hasNext()) {
            block14: {
                property = null;
                nextField = (JavaField)fieldIt.next();
                modifiers = nextField.getModifiers();
                if (!Modifier.isTransient(modifiers) && (Modifier.isPublic(nextField.getModifiers()) && onlyPublic || !onlyPublic || this.hasJAXBAnnotations(nextField))) {
                    if (!Modifier.isStatic(modifiers)) {
                        if (onlyExplicit && this.hasJAXBAnnotations(nextField) || !onlyExplicit) {
                            try {
                                property = this.buildNewProperty(info, cls, nextField, nextField.getName(), nextField.getResolvedType());
                                properties.add(property);
                            }
                            catch (JAXBException ex) {
                                if (ex.getErrorCode() == 50089 && this.helper.isAnnotationPresent(nextField, XmlTransient.class)) ** GOTO lbl39
                                throw ex;
                            }
                        }
                    } else {
                        try {
                            property = this.buildNewProperty(info, cls, nextField, nextField.getName(), nextField.getResolvedType());
                            if (this.helper.isAnnotationPresent(nextField, XmlAttribute.class) && (value = ((JavaFieldImpl)nextField).get(null)) != null) {
                                stringValue = (String)XMLConversionManager.getDefaultXMLManager().convertObject(value, String.class, property.getSchemaType());
                                property.setFixedValue(stringValue);
                            }
                            property.setWriteOnly(true);
                            if (!this.hasJAXBAnnotations(nextField)) {
                                property.setTransient(true);
                            }
                            properties.add(property);
                        }
                        catch (ClassCastException v0) {
                        }
                        catch (IllegalAccessException v1) {
                        }
                        catch (JAXBException ex) {
                            if (ex.getErrorCode() == 50089 && this.helper.isAnnotationPresent(nextField, XmlTransient.class)) break block14;
                            throw ex;
                        }
                    }
                }
            }
            if (!this.helper.isAnnotationPresent(nextField, XmlTransient.class) || property == null) continue;
            property.setTransient(true);
        }
        return properties;
    }

    Property buildNewProperty(TypeInfo info, JavaClass cls, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        TypeInfo refClassInfo;
        XmlAnyElement anyElement;
        Property property = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElements.class)) {
            property = this.buildChoiceProperty(javaHasAnnotations);
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRef.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRefs.class)) {
            this.findAndProcessObjectFactory(cls);
            property = this.buildReferenceProperty(info, javaHasAnnotations, propertyName, ptype);
            if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class)) {
                anyElement = (XmlAnyElement)this.helper.getAnnotation(javaHasAnnotations, XmlAnyElement.class);
                property.setIsAny(true);
                if (anyElement.value() != null) {
                    property.setDomHandlerClassName(anyElement.value().getName());
                }
                property.setLax(anyElement.lax());
                info.setAnyElementPropertyName(propertyName);
            }
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class)) {
            this.findAndProcessObjectFactory(cls);
            anyElement = (XmlAnyElement)this.helper.getAnnotation(javaHasAnnotations, XmlAnyElement.class);
            property = new Property(this.helper);
            property.setIsAny(true);
            if (anyElement.value() != null) {
                property.setDomHandlerClassName(anyElement.value().getName());
            }
            property.setLax(anyElement.lax());
            info.setAnyElementPropertyName(propertyName);
        } else {
            property = this.helper.isAnnotationPresent(javaHasAnnotations, org.eclipse.persistence.oxm.annotations.XmlTransformation.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlReadTransformer.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformer.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformers.class) ? this.buildTransformationProperty(javaHasAnnotations, cls) : new Property(this.helper);
        }
        property.setPropertyName(propertyName);
        property.setElement(javaHasAnnotations);
        if (this.helper.isCollectionType(ptype)) {
            JavaClass componentType = this.helper.getJavaClass(Object.class);
            Collection typeArgs = ptype.getActualTypeArguments();
            if (typeArgs.size() > 0) {
                componentType = (JavaClass)typeArgs.iterator().next();
            }
            this.updatePropertyType(property, ptype, componentType);
        } else {
            this.updatePropertyType(property, ptype, ptype);
        }
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlVariableNode.class)) {
            XmlVariableNode variableNode = (XmlVariableNode)this.helper.getAnnotation(javaHasAnnotations, XmlVariableNode.class);
            if (variableNode.type() != XmlVariableNode.DEFAULT.class) {
                property.setVariableClassName(variableNode.type().getName());
                JavaClass componentType = this.helper.getJavaClass(variableNode.type());
                if (this.helper.isCollectionType(ptype)) {
                    property.setGenericType(componentType);
                } else {
                    property.setType(componentType);
                }
            }
            if (!variableNode.value().equals("##default")) {
                property.setVariableAttributeName(variableNode.value());
            }
            property.setVariableNodeAttribute(variableNode.attribute());
        }
        if (ptype.isArray() && !this.areEquals(ptype, byte[].class) || this.helper.isCollectionType(ptype) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlList.class)) {
            property.setNillable(true);
        }
        this.processPropertyAnnotations(info, cls, javaHasAnnotations, property);
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlPath.class)) {
            XmlPath xmlPath = (XmlPath)this.helper.getAnnotation(javaHasAnnotations, XmlPath.class);
            property.setXmlPath(xmlPath.value());
            XMLField tempField = new XMLField(xmlPath.value());
            boolean isAttribute = tempField.getLastXPathFragment().isAttribute();
            property.setIsAttribute(isAttribute);
            String schemaName = XMLProcessor.getNameFromXPath(xmlPath.value(), property.getPropertyName(), isAttribute);
            NamespaceInfo nsInfo = this.getPackageInfoForPackage(cls).getNamespaceInfo();
            QName qName = isAttribute ? (nsInfo.isAttributeFormQualified() ? new QName(nsInfo.getNamespace(), schemaName) : new QName(schemaName)) : (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), schemaName) : new QName(schemaName));
            property.setSchemaName(qName);
            XPathFragment fragment = tempField.getXPathFragment();
            String currentPath = EMPTY_STRING;
            while (fragment != null && !fragment.nameIsText() && !fragment.isAttribute()) {
                if (fragment.getPredicate() != null) {
                    String fragmentPath = fragment.getLocalName();
                    if (fragment.getPrefix() != null && !EMPTY_STRING.equals(fragment.getPrefix())) {
                        fragmentPath = String.valueOf(fragment.getPrefix()) + ":" + fragmentPath;
                    }
                    String predicatePath = currentPath = String.valueOf(currentPath) + fragmentPath;
                    TypeInfo targetInfo = info;
                    if (fragment.getNextFragment() == null) {
                        this.processReferencedClass(ptype);
                        TypeInfo predicateTypeInfo = this.typeInfo.get(ptype.getQualifiedName());
                        if (predicateTypeInfo != null) {
                            targetInfo = predicateTypeInfo;
                            predicatePath = EMPTY_STRING;
                        }
                    }
                    Property predicateProperty = new Property(this.helper);
                    predicateProperty.setType(this.helper.getJavaClass("java.lang.String"));
                    if (predicatePath.length() > 0) {
                        predicatePath = String.valueOf(predicatePath) + SLASH;
                    }
                    predicatePath = String.valueOf(predicatePath) + fragment.getPredicate().getXPathFragment().getXPath();
                    predicateProperty.setXmlPath(predicatePath);
                    predicateProperty.setIsAttribute(true);
                    String predschemaName = XMLProcessor.getNameFromXPath(predicatePath, property.getPropertyName(), true);
                    QName predQname = nsInfo.isAttributeFormQualified() ? new QName(nsInfo.getNamespace(), predschemaName) : new QName(predschemaName);
                    predicateProperty.setSchemaName(predQname);
                    if (!targetInfo.hasPredicateProperty(predicateProperty)) {
                        targetInfo.getPredicateProperties().add(predicateProperty);
                    }
                } else {
                    currentPath = String.valueOf(currentPath) + fragment.getXPath();
                }
                currentPath = String.valueOf(currentPath) + SLASH;
                fragment = fragment.getNextFragment();
            }
        } else {
            property.setSchemaName(this.getQNameForProperty(property, propertyName, javaHasAnnotations, this.getPackageInfoForPackage(cls).getNamespaceInfo(), info));
        }
        if ((ptype = property.getActualType()).isPrimitive()) {
            if (property.getType().isArray() && this.helper.isAnnotationPresent(javaHasAnnotations, javax.xml.bind.annotation.XmlElement.class)) {
                javax.xml.bind.annotation.XmlElement elemAnno = (javax.xml.bind.annotation.XmlElement)this.helper.getAnnotation(javaHasAnnotations, javax.xml.bind.annotation.XmlElement.class);
                property.setIsRequired(elemAnno.required());
            } else {
                property.setIsRequired(true);
            }
        }
        if (!property.isSetXmlJavaTypeAdapter() && (refClassInfo = this.getTypeInfo().get(ptype.getQualifiedName())) != null && refClassInfo.isSetXmlJavaTypeAdapter()) {
            XmlJavaTypeAdapter xmlJavaTypeAdapter = null;
            try {
                xmlJavaTypeAdapter = refClassInfo.getXmlJavaTypeAdapter();
                property.setXmlJavaTypeAdapter(refClassInfo.getXmlJavaTypeAdapter());
            }
            catch (JAXBException jAXBException) {
                throw JAXBException.invalidTypeAdapterClass(xmlJavaTypeAdapter.getValue(), cls.getName());
            }
        }
        if (property.isXmlTransformation()) {
            this.referencedByTransformer.add(property.getType().getName());
        }
        return property;
    }

    private void updatePropertyType(Property property, JavaClass ptype, JavaClass componentType) {
        TypeInfo componentTypeInfo = this.typeInfo.get(componentType);
        if (componentTypeInfo != null && !componentTypeInfo.isTransient() || !this.helper.isAnnotationPresent(componentType, XmlTransient.class)) {
            property.setType(ptype);
        } else {
            JavaClass parent = componentType.getSuperclass();
            while (parent != null) {
                if (parent.getName().equals(JAVA_LANG_OBJECT)) {
                    property.setTransientType(true);
                    property.setType(ptype);
                    break;
                }
                TypeInfo parentTypeInfo = this.typeInfo.get(parent.getQualifiedName());
                if (parentTypeInfo != null && !parentTypeInfo.isTransient() || !this.helper.isAnnotationPresent(parent, XmlTransient.class)) {
                    property.setType(parent);
                    break;
                }
                parent = parent.getSuperclass();
            }
        }
    }

    private Property buildChoiceProperty(JavaHasAnnotations javaHasAnnotations) {
        Property choiceProperty = new Property(this.helper);
        choiceProperty.setChoice(true);
        boolean isIdRef = this.helper.isAnnotationPresent(javaHasAnnotations, XmlIDREF.class);
        choiceProperty.setIsXmlIdRef(isIdRef);
        org.eclipse.persistence.jaxb.xmlmodel.XmlElements xmlElements = new org.eclipse.persistence.jaxb.xmlmodel.XmlElements();
        javax.xml.bind.annotation.XmlElement[] elements = ((XmlElements)this.helper.getAnnotation(javaHasAnnotations, XmlElements.class)).value();
        int i = 0;
        while (i < elements.length) {
            javax.xml.bind.annotation.XmlElement next = elements[i];
            XmlElement xmlElement = new XmlElement();
            xmlElement.setDefaultValue(next.defaultValue());
            xmlElement.setName(next.name());
            xmlElement.setNamespace(next.namespace());
            xmlElement.setNillable(next.nillable());
            xmlElement.setRequired(next.required());
            xmlElement.setType(next.type().getName());
            xmlElements.getXmlElement().add(xmlElement);
            ++i;
        }
        choiceProperty.setXmlElements(xmlElements);
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementsJoinNodes.class)) {
            ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes> xmlJoinNodesList = new ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes>();
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = null;
            XmlJoinNodes[] xmlJoinNodesArray = ((XmlElementsJoinNodes)this.helper.getAnnotation(javaHasAnnotations, XmlElementsJoinNodes.class)).value();
            int n = xmlJoinNodesArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlJoinNodes xmlJNs = xmlJoinNodesArray[n2];
                xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
                XmlJoinNode[] xmlJoinNodeArray = xmlJNs.value();
                int n3 = xmlJoinNodeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    XmlJoinNode xmlJN = xmlJoinNodeArray[n4];
                    XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
                    xmlJoinNode.setXmlPath(xmlJN.xmlPath());
                    xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
                    xmlJoinNodeList.add(xmlJoinNode);
                    ++n4;
                }
                if (xmlJoinNodeList.size() > 0) {
                    org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
                    xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
                    xmlJoinNodesList.add(xmlJoinNodes);
                }
                ++n2;
            }
            choiceProperty.setXmlJoinNodesList(xmlJoinNodesList);
        }
        return choiceProperty;
    }

    private Property buildTransformationProperty(JavaHasAnnotations javaHasAnnotations, JavaClass cls) {
        XmlReadTransformer readTransformer;
        Property property = new Property(this.helper);
        org.eclipse.persistence.oxm.annotations.XmlTransformation transformationAnnotation = (org.eclipse.persistence.oxm.annotations.XmlTransformation)this.helper.getAnnotation(javaHasAnnotations, org.eclipse.persistence.oxm.annotations.XmlTransformation.class);
        XmlTransformation transformation = new XmlTransformation();
        if (transformationAnnotation != null) {
            transformation.setOptional(transformationAnnotation.optional());
        }
        if ((readTransformer = (XmlReadTransformer)this.helper.getAnnotation(javaHasAnnotations, XmlReadTransformer.class)) != null) {
            XmlTransformation.XmlReadTransformer xmlReadTransformer = new XmlTransformation.XmlReadTransformer();
            if (readTransformer.transformerClass() != AttributeTransformer.class) {
                xmlReadTransformer.setTransformerClass(readTransformer.transformerClass().getName());
            } else if (!readTransformer.method().equals(EMPTY_STRING)) {
                xmlReadTransformer.setMethod(readTransformer.method());
            }
            transformation.setXmlReadTransformer(xmlReadTransformer);
        }
        XmlWriteTransformer[] transformers = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformer.class)) {
            XmlWriteTransformer writeTransformer = (XmlWriteTransformer)this.helper.getAnnotation(javaHasAnnotations, XmlWriteTransformer.class);
            transformers = new XmlWriteTransformer[]{writeTransformer};
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformers.class)) {
            XmlWriteTransformers writeTransformers = (XmlWriteTransformers)this.helper.getAnnotation(javaHasAnnotations, XmlWriteTransformers.class);
            transformers = writeTransformers.value();
        }
        if (transformers != null) {
            XmlWriteTransformer[] xmlWriteTransformerArray = transformers;
            int n = transformers.length;
            int n2 = 0;
            while (n2 < n) {
                XmlWriteTransformer next = xmlWriteTransformerArray[n2];
                XmlTransformation.XmlWriteTransformer xmlWriteTransformer = new XmlTransformation.XmlWriteTransformer();
                if (next.transformerClass() != FieldTransformer.class) {
                    xmlWriteTransformer.setTransformerClass(next.transformerClass().getName());
                } else if (!next.method().equals(EMPTY_STRING)) {
                    xmlWriteTransformer.setMethod(next.method());
                }
                xmlWriteTransformer.setXmlPath(next.xmlPath());
                transformation.getXmlWriteTransformer().add(xmlWriteTransformer);
                ++n2;
            }
        }
        property.setXmlTransformation(transformation);
        property.setIsXmlTransformation(true);
        return property;
    }

    private void processChoiceProperty(Property choiceProperty, TypeInfo info, JavaClass cls, JavaClass propertyType) {
        String propertyName = choiceProperty.getPropertyName();
        if (choiceProperty.isSetXmlJoinNodesList() && choiceProperty.getXmlElements().getXmlElement().size() != choiceProperty.getXmlJoinNodesList().size()) {
            throw JAXBException.incorrectNumberOfXmlJoinNodesOnXmlElements(propertyName, cls.getQualifiedName());
        }
        XmlPath[] paths = null;
        if (this.helper.isAnnotationPresent(choiceProperty.getElement(), XmlPaths.class)) {
            XmlPaths pathAnnotation = (XmlPaths)this.helper.getAnnotation(choiceProperty.getElement(), XmlPaths.class);
            paths = pathAnnotation.value();
        }
        ArrayList<Property> choiceProperties = new ArrayList<Property>();
        int i = 0;
        while (i < choiceProperty.getXmlElements().getXmlElement().size()) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes;
            NamespaceInfo namespaceInfo;
            String namespace;
            String name;
            XmlElement next = choiceProperty.getXmlElements().getXmlElement().get(i);
            Property choiceProp = new Property(this.helper);
            choiceProp.setNillable(next.isNillable());
            choiceProp.setIsRequired(next.isRequired());
            if (paths != null && next.getXmlPath() == null) {
                XmlPath nextPath = paths[i];
                next.setXmlPath(nextPath.value());
            }
            if (next.getXmlPath() != null) {
                choiceProp.setXmlPath(next.getXmlPath());
                boolean isAttribute = new XMLField(next.getXmlPath()).getLastXPathFragment().isAttribute();
                if (isAttribute && !next.getXmlPath().contains(SLASH)) {
                    throw JAXBException.invalidXmlPathWithAttribute(propertyName, cls.getQualifiedName(), next.getXmlPath());
                }
                choiceProp.setIsAttribute(isAttribute);
                name = XMLProcessor.getNameFromXPath(next.getXmlPath(), propertyName, isAttribute);
                namespace = "##default";
            } else {
                name = next.getName();
                namespace = next.getNamespace();
            }
            if (name == null || name.equals("##default")) {
                name = next.getJavaAttribute() != null ? next.getJavaAttribute() : propertyName;
            }
            if (choiceProperty.isXmlIdRef()) {
                JavaClass nextCls = this.helper.getJavaClass(next.getType());
                this.processReferencedClass(nextCls);
                TypeInfo tInfo = this.typeInfo.get(next.getType());
                if (tInfo == null || !tInfo.isIDSet()) {
                    throw JAXBException.invalidXmlElementInXmlElementsList(propertyName, name);
                }
            }
            QName qName = null;
            qName = !namespace.equals("##default") ? new QName(namespace, name) : ((namespaceInfo = this.getPackageInfoForPackage(cls).getNamespaceInfo()).isElementFormQualified() ? new QName(namespaceInfo.getNamespace(), name) : new QName(name));
            choiceProp.setPropertyName(name);
            if (next.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT") || next.getType().equals("javax.xml.bind.annotation.XmlElement$DEFAULT")) {
                choiceProp.setType(propertyType);
            } else {
                choiceProp.setType(this.helper.getJavaClass(next.getType()));
            }
            if (choiceProperty.isSetXmlJoinNodesList() && (xmlJoinNodes = choiceProperty.getXmlJoinNodesList().get(i)) != null) {
                choiceProp.setXmlJoinNodes(xmlJoinNodes);
                if (!xmlJoinNodes.getType().equals("##default")) {
                    JavaClass pType = this.helper.getJavaClass(xmlJoinNodes.getType());
                    if (this.helper.isCollectionType(choiceProp.getType())) {
                        choiceProp.setGenericType(pType);
                    } else {
                        choiceProp.setType(pType);
                    }
                }
            }
            choiceProp.setSchemaName(qName);
            choiceProp.setSchemaType(this.getSchemaTypeFor(choiceProp.getType()));
            choiceProp.setIsXmlIdRef(choiceProperty.isXmlIdRef());
            choiceProp.setXmlElementWrapper(choiceProperty.getXmlElementWrapper());
            choiceProperties.add(choiceProp);
            this.processReferencedClass(choiceProp.getType());
            TypeInfo newInfo = this.typeInfo.get(choiceProp.getType().getQualifiedName());
            if (newInfo != null && newInfo.isTransient()) {
                throw JAXBException.invalidReferenceToTransientClass(info.getJavaClassName(), choiceProperty.getPropertyName(), newInfo.getJavaClassName());
            }
            ++i;
        }
        choiceProperty.setChoiceProperties(choiceProperties);
    }

    private Property buildReferenceProperty(TypeInfo info, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        XmlElementRef[] elementRefs;
        Property property = new Property(this.helper);
        property.setType(ptype);
        XmlElementRef ref = (XmlElementRef)this.helper.getAnnotation(javaHasAnnotations, XmlElementRef.class);
        if (ref != null) {
            elementRefs = new XmlElementRef[]{ref};
        } else {
            XmlElementRefs refs = (XmlElementRefs)this.helper.getAnnotation(javaHasAnnotations, XmlElementRefs.class);
            elementRefs = refs.value();
            info.setElementRefsPropertyName(propertyName);
        }
        ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef> eltRefs = new ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef>();
        XmlElementRef[] xmlElementRefArray = elementRefs;
        int n = elementRefs.length;
        int n2 = 0;
        while (n2 < n) {
            XmlElementRef nextRef = xmlElementRefArray[n2];
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef eltRef = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef();
            eltRef.setName(nextRef.name());
            eltRef.setNamespace(nextRef.namespace());
            eltRef.setType(nextRef.type().getName());
            property.setIsRequired(true);
            try {
                Method requireMethod = PrivilegedAccessHelper.getMethod(XmlElementRef.class, "required", new Class[0], true);
                if (requireMethod != null) {
                    Boolean val = (Boolean)PrivilegedAccessHelper.invokeMethod(requireMethod, nextRef);
                    property.setIsRequired(val);
                }
            }
            catch (Exception exception) {}
            eltRefs.add(eltRef);
            ++n2;
        }
        property.setIsReference(true);
        property.setXmlElementRefs(eltRefs);
        return property;
    }

    private Property processReferenceProperty(Property property, TypeInfo info, JavaClass cls) {
        for (org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef nextRef : property.getXmlElementRefs()) {
            JavaClass type = property.getType();
            String typeName = type.getQualifiedName();
            if (this.helper.isCollectionType(property.getType()) && type.hasActualTypeArguments()) {
                type = property.getGenericType();
                typeName = type.getQualifiedName();
            }
            if (!nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef.DEFAULT") && !nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef$DEFAULT")) {
                typeName = nextRef.getType();
                type = this.helper.getJavaClass(typeName);
            }
            boolean missingReference = true;
            for (Map.Entry<String, ElementDeclaration> entry : this.xmlRootElements.entrySet()) {
                ElementDeclaration entryValue = entry.getValue();
                if (this.areEquals(type, Object.class) || !type.isAssignableFrom(entryValue.getJavaType())) continue;
                this.addReferencedElement(property, entryValue);
                missingReference = false;
            }
            if (!missingReference) continue;
            String name = nextRef.getName();
            String namespace = nextRef.getNamespace();
            if (namespace.equals("##default")) {
                namespace = EMPTY_STRING;
            }
            QName qname = new QName(namespace, name);
            JavaClass scopeClass = cls;
            ElementDeclaration referencedElement = null;
            while (!scopeClass.getName().equals(JAVA_LANG_OBJECT)) {
                HashMap<QName, ElementDeclaration> elements = this.getElementDeclarationsForScope(scopeClass.getName());
                if (elements != null) {
                    referencedElement = elements.get(qname);
                }
                if (referencedElement != null) break;
                scopeClass = scopeClass.getSuperclass();
            }
            if (referencedElement == null) {
                referencedElement = this.getGlobalElements().get(qname);
            }
            if (referencedElement != null) {
                this.addReferencedElement(property, referencedElement);
                continue;
            }
            throw JAXBException.invalidElementRef(property.getPropertyName(), cls.getName());
        }
        return property;
    }

    private void processReferencePropertyTypes(Property property, TypeInfo info, JavaClass theClass) {
        for (org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef nextRef : property.getXmlElementRefs()) {
            Collection args;
            JavaClass type = property.getType();
            String typeName = type.getQualifiedName();
            if (this.helper.isCollectionType(property.getType()) && type.hasActualTypeArguments()) {
                type = property.getGenericType();
                typeName = type.getQualifiedName();
            }
            if (JAVAX_XML_BIND_JAXBELEMENT.equals(typeName) && (args = type.getActualTypeArguments()).size() > 0) {
                JavaClass theType = (JavaClass)args.iterator().next();
                this.processReferencedClass(theType);
            }
            if (!nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef.DEFAULT") && !nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef$DEFAULT")) {
                typeName = nextRef.getType();
                type = this.helper.getJavaClass(typeName);
            }
            this.processReferencedClass(type);
        }
    }

    private void processPropertyAnnotations(TypeInfo info, JavaClass cls, JavaHasAnnotations javaHasAnnotations, Property property) {
        Map<Object, Object> propertiesMap;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlMixed.class)) {
            info.setMixed(true);
            property.setMixedContent(true);
            this.findAndProcessObjectFactory(cls);
        }
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlContainerProperty.class)) {
            XmlContainerProperty container = (XmlContainerProperty)this.helper.getAnnotation(javaHasAnnotations, XmlContainerProperty.class);
            property.setInverseReferencePropertyName(container.value());
            property.setInverseReferencePropertyGetMethodName(container.getMethodName());
            property.setInverseReferencePropertySetMethodName(container.setMethodName());
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlInverseReference.class)) {
            XmlInverseReference inverseReference = (XmlInverseReference)this.helper.getAnnotation(javaHasAnnotations, XmlInverseReference.class);
            property.setInverseReferencePropertyName(inverseReference.mappedBy());
            TypeInfo targetInfo = this.getTypeInfo().get(property.getActualType().getName());
            if (targetInfo != null && targetInfo.getXmlAccessType() == XmlAccessType.PROPERTY) {
                String propName = property.getPropertyName();
                propName = String.valueOf(Character.toUpperCase(propName.charAt(0))) + propName.substring(1);
                property.setInverseReferencePropertyGetMethodName(GET_STR + propName);
                property.setInverseReferencePropertySetMethodName(SET_STR + propName);
            }
            property.setInverseReference(true, this.helper.isAnnotationPresent(javaHasAnnotations, javax.xml.bind.annotation.XmlElement.class));
        }
        this.processXmlJavaTypeAdapter(property, info, cls);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(property.getActualType(), JAVAX_ACTIVATION_DATAHANDLER)) {
            property.setIsSwaAttachmentRef(true);
            property.setSchemaType(Constants.SWA_REF_QNAME);
        }
        this.processXmlElement(property, info);
        if (!property.isSwaAttachmentRef() && this.isMtomAttachment(property)) {
            property.setIsMtomAttachment(true);
            property.setSchemaType(Constants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
            property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class) || info.isBinaryDataToBeInlined()) {
            property.setisInlineBinaryData(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
            XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
            QName schemaTypeQname = new QName(schemaType.namespace(), schemaType.name());
            property.setSchemaType(schemaTypeQname);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
            property.setIsAttribute(true);
            property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
            if (info.isSetAnyAttributePropertyName() && !info.getAnyAttributePropertyName().equals(property.getPropertyName())) {
                throw JAXBException.multipleAnyAttributeMapping(cls.getName());
            }
            if (!this.helper.isMapType(property.getType())) {
                throw JAXBException.anyAttributeOnNonMap(property.getPropertyName());
            }
            property.setIsAnyAttribute(true);
            info.setAnyAttributePropertyName(property.getPropertyName());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
            XmlElementWrapper wrapper = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper xmlEltWrapper = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper();
            String wrapperName = wrapper.name();
            if (wrapperName.equals("##default")) {
                wrapperName = info.getXmlNameTransformer().transformElementName(property.getPropertyName());
            }
            xmlEltWrapper.setName(wrapperName);
            xmlEltWrapper.setNamespace(wrapper.namespace());
            xmlEltWrapper.setNillable(wrapper.nillable());
            xmlEltWrapper.setRequired(wrapper.required());
            property.setXmlElementWrapper(xmlEltWrapper);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            if (!this.helper.isCollectionType(property.getType()) && !property.getType().isArray()) {
                throw JAXBException.invalidList(property.getPropertyName());
            }
            property.setIsXmlList(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            property.setIsXmlValue(true);
            info.setXmlValueProperty(property);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlReadOnly.class)) {
            property.setReadOnly(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlWriteOnly.class)) {
            property.setWriteOnly(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlCDATA.class)) {
            property.setCdata(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAccessMethods.class)) {
            XmlAccessMethods accessMethods = (XmlAccessMethods)this.helper.getAnnotation(property.getElement(), XmlAccessMethods.class);
            if (!accessMethods.getMethodName().equals(EMPTY_STRING)) {
                property.setGetMethodName(accessMethods.getMethodName());
            }
            if (!accessMethods.setMethodName().equals(EMPTY_STRING)) {
                property.setSetMethodName(accessMethods.setMethodName());
            }
            if (!property.isMethodProperty()) {
                property.setMethodProperty(true);
            }
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlProperties.class)) {
            XmlProperties xmlProperties = (XmlProperties)this.helper.getAnnotation(property.getElement(), XmlProperties.class);
            propertiesMap = this.createUserPropertiesMap(xmlProperties.value());
            property.setUserProperties(propertiesMap);
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlProperty.class)) {
            XmlProperty xmlProperty = (XmlProperty)this.helper.getAnnotation(property.getElement(), XmlProperty.class);
            propertiesMap = this.createUserPropertiesMap(new XmlProperty[]{xmlProperty});
            property.setUserProperties(propertiesMap);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlKey.class)) {
            info.addXmlKeyProperty(property);
        }
        this.processXmlJoinNodes(property);
        this.processXmlNullPolicy(property);
        JavaHasAnnotations elem = property.getElement();
        if (this.helper.isAnnotationPresent(elem, XmlLocation.class) || this.helper.isAnnotationPresent(elem, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(elem, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS)) {
            if (!this.helper.getJavaClass(Constants.LOCATOR_CLASS).isAssignableFrom(property.getType())) {
                throw JAXBException.invalidXmlLocation(property.getPropertyName(), property.getType().getName());
            }
            property.setXmlLocation(true);
        }
    }

    private void processXmlJoinNodes(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlJoinNodes.class)) {
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
            XmlJoinNode[] xmlJoinNodeArray = ((XmlJoinNodes)this.helper.getAnnotation(property.getElement(), XmlJoinNodes.class)).value();
            int n = xmlJoinNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlJoinNode xmlJN = xmlJoinNodeArray[n2];
                XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
                xmlJoinNode.setXmlPath(xmlJN.xmlPath());
                xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
                xmlJoinNodeList.add(xmlJoinNode);
                ++n2;
            }
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
            xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
            property.setXmlJoinNodes(xmlJoinNodes);
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlJoinNode.class)) {
            XmlJoinNode xmlJN = (XmlJoinNode)this.helper.getAnnotation(property.getElement(), XmlJoinNode.class);
            XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
            xmlJoinNode.setXmlPath(xmlJN.xmlPath());
            xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
            xmlJoinNodeList.add(xmlJoinNode);
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
            xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
            property.setXmlJoinNodes(xmlJoinNodes);
        }
    }

    private void processXmlTransformationProperty(Property property) {
        if (property.isSetXmlTransformation()) {
            XmlTransformation xmlTransformation = property.getXmlTransformation();
            if (xmlTransformation.isSetXmlReadTransformer()) {
                XmlTransformation.XmlReadTransformer readTransformer = xmlTransformation.getXmlReadTransformer();
                if (readTransformer.isSetTransformerClass()) {
                    if (readTransformer.isSetMethod()) {
                        throw JAXBException.readTransformerHasBothClassAndMethod(property.getPropertyName());
                    }
                } else if (!readTransformer.isSetMethod()) {
                    throw JAXBException.readTransformerHasNeitherClassNorMethod(property.getPropertyName());
                }
            }
            if (xmlTransformation.isSetXmlWriteTransformers()) {
                for (XmlTransformation.XmlWriteTransformer writeTransformer : xmlTransformation.getXmlWriteTransformer()) {
                    if (!writeTransformer.isSetXmlPath()) {
                        throw JAXBException.writeTransformerHasNoXmlPath(property.getPropertyName());
                    }
                    if (writeTransformer.isSetTransformerClass()) {
                        if (!writeTransformer.isSetMethod()) continue;
                        throw JAXBException.writeTransformerHasBothClassAndMethod(property.getPropertyName(), writeTransformer.getXmlPath());
                    }
                    if (writeTransformer.isSetMethod()) continue;
                    throw JAXBException.writeTransformerHasNeitherClassNorMethod(property.getPropertyName(), writeTransformer.getXmlPath());
                }
            }
        }
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    private void processXmlNullPolicy(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlNullPolicy.class)) {
            XmlNullPolicy nullPolicy = (XmlNullPolicy)this.helper.getAnnotation(property.getElement(), XmlNullPolicy.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy policy = new org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy();
            policy.setEmptyNodeRepresentsNull(nullPolicy.emptyNodeRepresentsNull());
            policy.setIsSetPerformedForAbsentNode(nullPolicy.isSetPerformedForAbsentNode());
            policy.setXsiNilRepresentsNull(nullPolicy.xsiNilRepresentsNull());
            policy.setNullRepresentationForXml(XmlMarshalNullRepresentation.valueOf(nullPolicy.nullRepresentationForXml().toString()));
            property.setNullPolicy(policy);
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIsSetNullPolicy.class)) {
            XmlIsSetNullPolicy nullPolicy = (XmlIsSetNullPolicy)this.helper.getAnnotation(property.getElement(), XmlIsSetNullPolicy.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy policy = new org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy();
            policy.setEmptyNodeRepresentsNull(nullPolicy.emptyNodeRepresentsNull());
            policy.setXsiNilRepresentsNull(nullPolicy.xsiNilRepresentsNull());
            policy.setNullRepresentationForXml(XmlMarshalNullRepresentation.valueOf(nullPolicy.nullRepresentationForXml().toString()));
            policy.setIsSetMethodName(nullPolicy.isSetMethodName());
            XmlParameter[] xmlParameterArray = nullPolicy.isSetParameters();
            int n = xmlParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlParameter next = xmlParameterArray[n2];
                XmlIsSetNullPolicy.IsSetParameter param = new XmlIsSetNullPolicy.IsSetParameter();
                param.setValue(next.value());
                param.setType(next.type().getName());
                policy.getIsSetParameter().add(param);
                ++n2;
            }
            property.setNullPolicy(policy);
        }
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        return this.getPropertyPropertiesForClass(cls, info, onlyPublic, false);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic, boolean onlyExplicit) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        ArrayList<JavaMethod> propertyMethods = new ArrayList<JavaMethod>();
        for (JavaMethod next : new ArrayList(cls.getDeclaredMethods())) {
            int modifiers;
            if (next.isSynthetic()) continue;
            if ((next.getName().startsWith(GET_STR) && next.getName().length() > 3 || next.getName().startsWith(IS_STR) && next.getName().length() > 2) && next.getParameterTypes().length == 0 && next.getReturnType() != this.helper.getJavaClass(Void.class)) {
                modifiers = next.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic && !this.hasJAXBAnnotations(next)) continue;
                propertyMethods.add(next);
                continue;
            }
            if (!next.getName().startsWith(SET_STR) || next.getName().length() <= 3 || next.getParameterTypes().length != 1 || Modifier.isStatic(modifiers = next.getModifiers()) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic && !this.hasJAXBAnnotations(next)) continue;
            propertyMethods.add(next);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        int i = 0;
        while (i < propertyMethods.size()) {
            block31: {
                JavaMethod setMethod;
                JavaMethod getMethod;
                JavaMethod propertyMethod;
                String propertyName;
                boolean isPropertyTransient;
                block34: {
                    block37: {
                        block38: {
                            boolean isLocation;
                            block36: {
                                JavaMethod nextMethod;
                                block32: {
                                    block35: {
                                        boolean isLocation2;
                                        boolean isTransient;
                                        block33: {
                                            isPropertyTransient = false;
                                            nextMethod = (JavaMethod)propertyMethods.get(i);
                                            propertyName = EMPTY_STRING;
                                            propertyMethod = null;
                                            if (nextMethod.getName().startsWith(SET_STR)) break block32;
                                            if (nextMethod.getName().startsWith(GET_STR)) {
                                                propertyName = nextMethod.getName().substring(3);
                                            } else if (nextMethod.getName().startsWith(IS_STR)) {
                                                propertyName = nextMethod.getName().substring(2);
                                            }
                                            getMethod = nextMethod;
                                            String setMethodName = SET_STR + propertyName;
                                            propertyName = Introspector.decapitalize(propertyName);
                                            JavaClass[] paramTypes = new JavaClass[]{getMethod.getReturnType()};
                                            setMethod = cls.getDeclaredMethod(setMethodName, paramTypes);
                                            if (setMethod == null) {
                                                setMethod = cls.getMethod(setMethodName, paramTypes);
                                            }
                                            if (setMethod == null && !this.hasJAXBAnnotations(getMethod)) {
                                                isPropertyTransient = true;
                                            }
                                            if (setMethod == null || !this.hasJAXBAnnotations(setMethod)) break block33;
                                            isTransient = this.helper.isAnnotationPresent(setMethod, XmlTransient.class);
                                            isLocation2 = this.helper.isAnnotationPresent(setMethod, XmlLocation.class) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                                            propertyMethod = setMethod;
                                            if (isTransient) {
                                                isPropertyTransient = true;
                                                if (isLocation2) {
                                                    propertyMethod = setMethod;
                                                    info.setLocationAware(true);
                                                }
                                            }
                                            break block34;
                                        }
                                        if ((!onlyExplicit || !this.hasJAXBAnnotations(getMethod)) && onlyExplicit) break block35;
                                        isTransient = this.helper.isAnnotationPresent(getMethod, XmlTransient.class);
                                        isLocation2 = this.helper.isAnnotationPresent(getMethod, XmlLocation.class) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                                        propertyMethod = getMethod;
                                        if (isTransient) {
                                            isPropertyTransient = true;
                                            if (isLocation2) {
                                                propertyMethod = getMethod;
                                                info.setLocationAware(true);
                                            }
                                        }
                                        break block34;
                                    }
                                    if (!onlyExplicit) break block34;
                                    break block31;
                                }
                                propertyName = nextMethod.getName().substring(3);
                                setMethod = nextMethod;
                                String getMethodName = GET_STR + propertyName;
                                getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                                if (getMethod == null) {
                                    getMethodName = IS_STR + propertyName;
                                    getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                                }
                                if (getMethod == null && (getMethod = cls.getMethod(GET_STR + propertyName, new JavaClass[0])) == null) {
                                    getMethod = cls.getMethod(IS_STR + propertyName, new JavaClass[0]);
                                }
                                if (getMethod == null && !this.hasJAXBAnnotations(setMethod)) {
                                    isPropertyTransient = true;
                                }
                                if (getMethod == null || !this.hasJAXBAnnotations(getMethod)) break block36;
                                boolean isTransient = this.helper.isAnnotationPresent(getMethod, XmlTransient.class);
                                boolean bl = isLocation = this.helper.isAnnotationPresent(getMethod, XmlLocation.class) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                                if (!isTransient) {
                                    propertyMethod = getMethod;
                                } else {
                                    isPropertyTransient = true;
                                    if (isLocation) {
                                        propertyMethod = getMethod;
                                        info.setLocationAware(true);
                                    }
                                }
                                break block37;
                            }
                            if ((!onlyExplicit || !this.hasJAXBAnnotations(setMethod)) && onlyExplicit) break block38;
                            boolean isTransient = this.helper.isAnnotationPresent(setMethod, XmlTransient.class);
                            boolean bl = isLocation = this.helper.isAnnotationPresent(setMethod, XmlLocation.class) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                            if (!isTransient) {
                                propertyMethod = setMethod;
                            } else {
                                isPropertyTransient = true;
                                if (isLocation) {
                                    propertyMethod = setMethod;
                                    info.setLocationAware(true);
                                }
                            }
                            break block37;
                        }
                        if (onlyExplicit) break block31;
                    }
                    propertyName = Introspector.decapitalize(propertyName);
                }
                JavaClass ptype = null;
                ptype = getMethod != null ? getMethod.getReturnType() : setMethod.getParameterTypes()[0];
                if (!propertyNames.contains(propertyName)) {
                    try {
                        Property property = this.buildNewProperty(info, cls, propertyMethod, propertyName, ptype);
                        propertyNames.add(propertyName);
                        property.setTransient(isPropertyTransient);
                        if (getMethod != null) {
                            property.setOriginalGetMethodName(getMethod.getName());
                            if (property.getGetMethodName() == null) {
                                property.setGetMethodName(getMethod.getName());
                            }
                        }
                        if (setMethod != null) {
                            property.setOriginalSetMethodName(setMethod.getName());
                            if (property.getSetMethodName() == null) {
                                property.setSetMethodName(setMethod.getName());
                            }
                        }
                        property.setMethodProperty(true);
                        properties.add(property);
                    }
                    catch (JAXBException ex) {
                        if (ex.getErrorCode() == 50089 && isPropertyTransient) break block31;
                        throw ex;
                    }
                }
            }
            ++i;
        }
        properties = this.removeSuperclassProperties(cls, properties);
        Collections.sort(properties, new PropertyComparitor());
        return properties;
    }

    private ArrayList<Property> removeSuperclassProperties(JavaClass cls, ArrayList<Property> properties) {
        TypeInfo superClassInfo;
        ArrayList<Property> revisedProperties = new ArrayList<Property>();
        revisedProperties.addAll(properties);
        JavaClass superClass = cls.getSuperclass();
        if (superClass != null && (superClassInfo = this.typeInfo.get(superClass.getQualifiedName())) != null && !superClassInfo.isTransient()) {
            for (Property prop : properties) {
                for (Property superProp : superClassInfo.getProperties().values()) {
                    if (superProp.getGetMethodName() == null || !superProp.getGetMethodName().equals(prop.getGetMethodName()) || superProp.isTransient()) continue;
                    revisedProperties.remove(prop);
                }
            }
        }
        return revisedProperties;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, !this.hasXmlBindings());
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, !this.hasXmlBindings());
        ArrayList<Property> publicFieldProperties = new ArrayList<Property>();
        ArrayList<Property> publicMethodProperties = new ArrayList<Property>();
        for (Property next : fieldProperties) {
            if (Modifier.isPublic(((JavaField)next.getElement()).getModifiers())) {
                publicFieldProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicFieldProperties.add(next);
        }
        for (Property next : methodProperties) {
            if (next.getElement() == null) continue;
            if (Modifier.isPublic(((JavaMethod)next.getElement()).getModifiers())) {
                publicMethodProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicMethodProperties.add(next);
        }
        if (publicFieldProperties.size() >= 0 && publicMethodProperties.size() == 0) {
            return publicFieldProperties;
        }
        if (publicMethodProperties.size() > 0 && publicFieldProperties.size() == 0) {
            return publicMethodProperties;
        }
        HashMap<String, Property> fieldPropertyMap = this.getPropertyMapFromArrayList(publicFieldProperties);
        int i = 0;
        while (i < publicMethodProperties.size()) {
            Property next = (Property)publicMethodProperties.get(i);
            Property fieldProp = fieldPropertyMap.get(next.getPropertyName());
            if (fieldProp == null) {
                publicFieldProperties.add(next);
            } else if (fieldProp.isTransient()) {
                publicFieldProperties.remove(fieldProp);
                publicFieldProperties.add(next);
            }
            ++i;
        }
        return publicFieldProperties;
    }

    public HashMap<String, Property> getPropertyMapFromArrayList(ArrayList<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>(props.size());
        for (Property next : props) {
            propMap.put(next.getPropertyName(), next);
        }
        return propMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (cls == null) {
            return list;
        }
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        HashMap<String, Property> fields = new HashMap<String, Property>(fieldProperties.size());
        for (Property next : fieldProperties) {
            JavaHasAnnotations elem = next.getElement();
            if (!this.hasJAXBAnnotations(elem)) {
                next.setTransient(true);
            }
            list.add(next);
            fields.put(next.getPropertyName(), next);
        }
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        for (Property next : methodProperties) {
            JavaHasAnnotations elem = next.getElement();
            if (this.hasJAXBAnnotations(elem)) {
                Property fieldProperty = (Property)fields.get(next.getPropertyName());
                list.remove(fieldProperty);
                list.add(next);
                continue;
            }
            next.setTransient(true);
            if (fields.get(next.getPropertyName()) != null) continue;
            list.add(next);
        }
        return list;
    }

    public void processSchemaType(String name, String namespace, String jClassQualifiedName) {
        this.userDefinedSchemaTypes.put(jClassQualifiedName, new QName(namespace, name));
    }

    public void processSchemaType(XmlSchemaType type) {
        JavaClass jClass = this.helper.getJavaClass(type.type());
        if (jClass == null) {
            return;
        }
        this.processSchemaType(type.name(), type.namespace(), jClass.getQualifiedName());
    }

    /*
     * Unable to fully structure code
     */
    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo info) {
        block14: {
            block15: {
                if (javaClass == null) {
                    return;
                }
                info.setClassName(javaClass.getQualifiedName());
                restrictionClass = String.class;
                restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
                if (!this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) break block14;
                xmlEnum = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
                restrictionClass = xmlEnum.value();
                restrictionJavaClass = this.helper.getJavaClass(restrictionClass);
                restrictionIsEnum = this.helper.isAnnotationPresent(restrictionJavaClass, XmlEnum.class);
                if (restrictionIsEnum) ** GOTO lbl37
                if (!this.helper.isBuiltInJavaType(restrictionJavaClass)) break block15;
                restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
                break block14;
            }
            restrictionInfo = this.typeInfo.get(restrictionJavaClass.getQualifiedName());
            if (restrictionInfo == null) {
                jClasses = new JavaClass[]{restrictionJavaClass};
                this.buildNewTypeInfo(jClasses);
                restrictionInfo = this.typeInfo.get(restrictionJavaClass.getQualifiedName());
            } else if (restrictionInfo != null && !restrictionInfo.isPostBuilt()) {
                this.postBuildTypeInfo(new JavaClass[]{restrictionJavaClass});
            }
            xmlValueProp = restrictionInfo.getXmlValueProperty();
            if (xmlValueProp == null) break block14;
            restrictionJavaClass = xmlValueProp.getActualType();
            restrictionBase = this.getSchemaTypeFor(restrictionJavaClass);
            restrictionClass = this.helper.getClassForJavaClass(restrictionJavaClass);
            break block14;
lbl-1000:
            // 1 sources

            {
                restrictionTypeInfo = this.processReferencedClass(restrictionJavaClass);
                restrictionBase = new QName(restrictionTypeInfo.getClassNamespace(), restrictionTypeInfo.getSchemaTypeName());
                xmlEnum = (XmlEnum)this.helper.getAnnotation(restrictionJavaClass, XmlEnum.class);
                restrictionClass = xmlEnum.value();
                restrictionJavaClass = this.helper.getJavaClass(restrictionClass);
                restrictionIsEnum = this.helper.isAnnotationPresent(restrictionJavaClass, XmlEnum.class);
lbl37:
                // 2 sources

                ** while (restrictionIsEnum)
            }
        }
        info.setRestrictionBase(restrictionBase);
        for (JavaField field : javaClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            enumValue = field.getName();
            if (this.helper.isAnnotationPresent(field, XmlEnumValue.class)) {
                enumValue = ((XmlEnumValue)this.helper.getAnnotation(field, XmlEnumValue.class)).value();
            }
            if (restrictionClass != null) {
                try {
                    enumValue = XMLConversionManager.getDefaultXMLManager().convertObject(enumValue, restrictionClass);
                }
                catch (ConversionException e) {
                    throw JAXBException.invalidEnumValue(enumValue, restrictionClass.getName(), e);
                }
            }
            info.addJavaFieldToXmlEnumValuePair(field.getName(), enumValue);
        }
        if (info.getXmlRootElement() == null) {
            elem = new ElementDeclaration(null, javaClass, javaClass.getQualifiedName(), false);
            this.getLocalElements().add(elem);
        }
    }

    public QName getSchemaTypeOrNullFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        return schemaType;
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName schemaType = this.getSchemaTypeOrNullFor(javaClass);
        if (schemaType == null) {
            return Constants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo info = new NamespaceInfo();
        info.setNamespaceResolver(new NamespaceResolver());
        String packageNamespace = null;
        if (xmlSchema != null) {
            String namespaceMapping = xmlSchema.namespace();
            if (!namespaceMapping.equals(EMPTY_STRING) && !namespaceMapping.equals("##default")) {
                packageNamespace = namespaceMapping;
            } else if (namespaceMapping.equals("##default")) {
                packageNamespace = this.defaultTargetNamespace;
            }
            info.setNamespace(packageNamespace);
            XmlNs[] xmlns = xmlSchema.xmlns();
            int i = 0;
            while (i < xmlns.length) {
                XmlNs next = xmlns[i];
                info.getNamespaceResolver().put(next.prefix(), next.namespaceURI());
                ++i;
            }
            info.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            info.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
            try {
                Method locationMethod = PrivilegedAccessHelper.getDeclaredMethod(XmlSchema.class, "location", new Class[0]);
                String location = (String)PrivilegedAccessHelper.invokeMethod(locationMethod, xmlSchema, new Object[0]);
                if (location != null) {
                    if (location.equals("##generate")) {
                        location = null;
                    } else if (location.equals(EMPTY_STRING)) {
                        location = null;
                    }
                }
                info.setLocation(location);
            }
            catch (Exception exception) {}
        } else {
            info.setNamespace(this.defaultTargetNamespace);
        }
        if (!info.isElementFormQualified()) {
            this.isDefaultNamespaceAllowed = false;
        }
        return info;
    }

    public HashMap<String, TypeInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public ArrayList<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public HashMap<String, QName> getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public QName getQNameForProperty(Property property, String defaultName, JavaHasAnnotations element, NamespaceInfo namespaceInfo, TypeInfo info) {
        String uri = info.getClassNamespace();
        String name = "##default";
        String namespace = "##default";
        QName qName = null;
        if (property.isMap()) {
            this.isDefaultNamespaceAllowed = false;
        }
        if (this.helper.isAnnotationPresent(element, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.helper.getAnnotation(element, XmlAttribute.class);
            name = xmlAttribute.name();
            namespace = xmlAttribute.namespace();
            if (name.equals("##default")) {
                name = defaultName;
                try {
                    name = info.getXmlNameTransformer().transformAttributeName(name);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(name, info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                this.isDefaultNamespaceAllowed = false;
            } else if (namespaceInfo.isAttributeFormQualified()) {
                qName = new QName(uri, name);
                this.isDefaultNamespaceAllowed = false;
            } else {
                qName = new QName(name);
            }
        } else {
            if (this.helper.isAnnotationPresent(element, javax.xml.bind.annotation.XmlElement.class)) {
                javax.xml.bind.annotation.XmlElement xmlElement = (javax.xml.bind.annotation.XmlElement)this.helper.getAnnotation(element, javax.xml.bind.annotation.XmlElement.class);
                name = xmlElement.name();
                namespace = xmlElement.namespace();
            }
            if (property.isMap() && this.helper.isAnnotationPresent(element, XmlElementWrapper.class)) {
                XmlElementWrapper xmlElementWrapper = (XmlElementWrapper)this.helper.getAnnotation(element, XmlElementWrapper.class);
                name = xmlElementWrapper.name();
                namespace = xmlElementWrapper.namespace();
            }
            if (name.equals("##default")) {
                name = defaultName;
                try {
                    name = info.getXmlNameTransformer().transformElementName(name);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(name, info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                if (namespace.equals(EMPTY_STRING)) {
                    this.isDefaultNamespaceAllowed = false;
                }
            } else {
                qName = namespaceInfo.isElementFormQualified() ? new QName(uri, name) : new QName(name);
            }
        }
        return qName;
    }

    public HashMap<String, PackageInfo> getPackageToPackageInfoMappings() {
        return this.packageToPackageInfoMappings;
    }

    public void addPackageToNamespaceMapping(String packageName, NamespaceInfo nsInfo) {
        PackageInfo info;
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap();
        }
        if ((info = this.packageToPackageInfoMappings.get(packageName)) == null) {
            info = new PackageInfo();
            this.packageToPackageInfoMappings.put(packageName, info);
        }
        info.setNamespaceInfo(nsInfo);
    }

    public void addPackageToPackageInfoMapping(String packageName, PackageInfo packageInfo) {
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap();
        }
        this.packageToPackageInfoMappings.put(packageName, packageInfo);
    }

    public PackageInfo getPackageInfoForPackage(JavaClass javaClass) {
        String packageName = javaClass.getPackageName();
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        if (packageInfo == null) {
            packageInfo = this.getPackageInfoForPackage(javaClass.getPackage(), packageName);
        }
        return packageInfo;
    }

    public PackageInfo getPackageInfoForPackage(JavaPackage pack, String packageName) {
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        if (packageInfo == null) {
            Annotation xmlAccessorFactory;
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(pack, XmlSchema.class);
            packageInfo = new PackageInfo();
            NamespaceInfo namespaceInfo = null;
            if (xmlSchema != null) {
                namespaceInfo = this.findInfoForNamespace(xmlSchema.namespace());
            }
            if (namespaceInfo == null) {
                namespaceInfo = this.processNamespaceInformation(xmlSchema);
            }
            packageInfo.setNamespaceInfo(namespaceInfo);
            if (namespaceInfo.getNamespace() == null) {
                namespaceInfo.setNamespace(EMPTY_STRING);
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(pack, XmlAccessorType.class);
                packageInfo.setAccessType(XmlAccessType.fromValue(xmlAccessorType.value().name()));
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorOrder.class)) {
                XmlAccessorOrder xmlAccessorOrder = (XmlAccessorOrder)this.helper.getAnnotation(pack, XmlAccessorOrder.class);
                packageInfo.setAccessOrder(XmlAccessOrder.fromValue(xmlAccessorOrder.value().name()));
            }
            if (CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS != null && this.helper.isAnnotationPresent(pack, CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS)) {
                xmlAccessorFactory = this.helper.getAnnotation(pack, CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS);
                Class xmlAccessorFactoryClass = null;
                try {
                    xmlAccessorFactoryClass = (Class)PrivilegedAccessHelper.invokeMethod(CompilerHelper.ACCESSOR_FACTORY_VALUE_METHOD, xmlAccessorFactory, new Object[0]);
                    packageInfo.setAccessorFactory(new AccessorFactoryWrapper(PrivilegedAccessHelper.newInstanceFromClass(xmlAccessorFactoryClass)));
                }
                catch (Exception ex) {
                    throw JAXBException.errorInstantiatingAccessorFactory(xmlAccessorFactoryClass, ex);
                }
            }
            if (CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS != null && this.helper.isAnnotationPresent(pack, CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS)) {
                xmlAccessorFactory = this.helper.getAnnotation(pack, CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS);
                Class xmlAccessorFactoryClass = null;
                try {
                    xmlAccessorFactoryClass = (Class)PrivilegedAccessHelper.invokeMethod(CompilerHelper.INTERNAL_ACCESSOR_FACTORY_VALUE_METHOD, xmlAccessorFactory, new Object[0]);
                    packageInfo.setAccessorFactory(new AccessorFactoryWrapper(PrivilegedAccessHelper.newInstanceFromClass(xmlAccessorFactoryClass)));
                }
                catch (Exception ex) {
                    throw JAXBException.errorInstantiatingAccessorFactory(xmlAccessorFactoryClass, ex);
                }
            }
            this.packageToPackageInfoMappings.put(packageName, packageInfo);
        }
        return packageInfo;
    }

    public NamespaceInfo findInfoForNamespace(String namespace) {
        for (PackageInfo next : this.packageToPackageInfoMappings.values()) {
            String nextUri = next.getNamespace();
            if (nextUri == null) {
                nextUri = EMPTY_STRING;
            }
            if (namespace == null) {
                namespace = EMPTY_STRING;
            }
            if (!nextUri.equals(namespace)) continue;
            return next.getNamespaceInfo();
        }
        return null;
    }

    private void checkForCallbackMethods() {
        JavaClass unmarshallerCls = this.helper.getJavaClass(Unmarshaller.class);
        JavaClass marshallerCls = this.helper.getJavaClass(Marshaller.class);
        JavaClass objectCls = this.helper.getJavaClass(Object.class);
        JavaClass[] unmarshalParams = new JavaClass[]{unmarshallerCls, objectCls};
        JavaClass[] marshalParams = new JavaClass[]{marshallerCls};
        for (JavaClass next : this.typeInfoClasses) {
            if (next == null) continue;
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (next.getMethod("beforeUnmarshal", unmarshalParams) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(next.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (next.getMethod("afterUnmarshal", unmarshalParams) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(next.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap();
                }
                this.unmarshalCallbacks.put(next.getQualifiedName(), unmarshalCallback);
            }
            if (next.getMethod("beforeMarshal", marshalParams) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(next.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (next.getMethod("afterMarshal", marshalParams) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(next.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap();
            }
            this.marshalCallbacks.put(next.getQualifiedName(), marshalCallback);
        }
    }

    public HashMap<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public HashMap<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }

    private void findAndProcessObjectFactory(JavaClass cls) {
        try {
            String className = String.valueOf(cls.getPackageName()) + ".ObjectFactory";
            this.findAndProcessObjectFactory(className);
        }
        catch (JAXBException jAXBException) {}
    }

    void findAndProcessObjectFactory(String objectFactoryClassName) {
        try {
            if (this.objectFactoryClassNames.contains(objectFactoryClassName)) {
                return;
            }
            JavaClass javaClass = this.helper.getJavaClass(objectFactoryClassName);
            if (this.isXmlRegistry(javaClass)) {
                JavaClass[] processed = this.processObjectFactory(javaClass, new ArrayList<JavaClass>());
                this.preBuildTypeInfo(processed);
                this.buildTypeInfo(processed);
                this.updateGlobalElements(processed);
            }
        }
        catch (JAXBException jAXBException) {}
    }

    public JavaClass[] processObjectFactory(JavaClass objectFactoryClass, ArrayList<JavaClass> classes) {
        String className = objectFactoryClass.getName();
        if (this.objectFactoryClassNames.contains(className)) {
            return new JavaClass[0];
        }
        this.objectFactoryClassNames.add(className);
        HashMap<String, XmlRegistry.XmlElementDecl> elemDecls = new HashMap<String, XmlRegistry.XmlElementDecl>();
        org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry xmlReg = this.xmlRegistries.get(objectFactoryClass.getQualifiedName());
        if (xmlReg != null) {
            for (XmlRegistry.XmlElementDecl xmlElementDecl : xmlReg.getXmlElementDecl()) {
                elemDecls.put(xmlElementDecl.getJavaMethod(), xmlElementDecl);
            }
        }
        Collection methods = objectFactoryClass.getDeclaredMethods();
        Iterator methodsIter = methods.iterator();
        PackageInfo packageInfo = this.getPackageInfoForPackage(objectFactoryClass);
        while (methodsIter.hasNext()) {
            JavaMethod next = (JavaMethod)methodsIter.next();
            if (!next.getName().startsWith(CREATE)) continue;
            JavaClass type = next.getReturnType();
            if (JAVAX_XML_BIND_JAXBELEMENT.equals(type.getName())) {
                Object[] actualTypeArguments = type.getActualTypeArguments().toArray();
                type = actualTypeArguments.length == 0 ? Helper.OBJECT_CLASS : (JavaClass)actualTypeArguments[0];
                type = this.processXmlElementDecl(type, next, packageInfo, elemDecls);
            } else if (Helper.JAXBELEMENT_CLASS.isAssignableFrom(type)) {
                this.factoryMethods.put(type.getRawName(), next);
                type = this.processXmlElementDecl(type, next, packageInfo, elemDecls);
            } else {
                this.factoryMethods.put(type.getRawName(), next);
            }
            if (this.helper.isBuiltInJavaType(type) || this.helper.classExistsInArray(type, classes)) continue;
            classes.add(type);
        }
        if (classes.size() > 0) {
            this.classesToProcessPropertyTypes.addAll(classes);
            return classes.toArray(new JavaClass[classes.size()]);
        }
        return new JavaClass[0];
    }

    private JavaClass processXmlElementDecl(JavaClass type, JavaMethod next, PackageInfo packageInfo, Map<String, XmlRegistry.XmlElementDecl> elemDecls) {
        JavaClass returnType = type;
        XmlRegistry.XmlElementDecl xmlEltDecl = elemDecls.get(next.getName());
        if (xmlEltDecl != null || this.helper.isAnnotationPresent(next, XmlElementDecl.class)) {
            HashMap<QName, ElementDeclaration> elements;
            QName qname;
            String subHeadNamespace;
            String subHeadLocal;
            String localName;
            String url;
            QName substitutionHead = null;
            String defaultValue = null;
            Class<XmlElementDecl.GLOBAL> scopeClass = XmlElementDecl.GLOBAL.class;
            if (xmlEltDecl != null) {
                JavaClass jScopeClass;
                url = xmlEltDecl.getNamespace();
                localName = xmlEltDecl.getName();
                String scopeClassName = xmlEltDecl.getScope();
                if (!scopeClassName.equals(ELEMENT_DECL_GLOBAL) && (jScopeClass = this.helper.getJavaClass(scopeClassName)) != null && (scopeClass = this.helper.getClassForJavaClass(jScopeClass)) == null) {
                    scopeClass = XmlElementDecl.GLOBAL.class;
                }
                if (!xmlEltDecl.getSubstitutionHeadName().equals(EMPTY_STRING)) {
                    subHeadLocal = xmlEltDecl.getSubstitutionHeadName();
                    subHeadNamespace = xmlEltDecl.getSubstitutionHeadNamespace();
                    if (subHeadNamespace.equals("##default")) {
                        subHeadNamespace = packageInfo.getNamespace();
                    }
                    substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                }
                if (xmlEltDecl.getDefaultValue().length() != 1 || !xmlEltDecl.getDefaultValue().startsWith(ELEMENT_DECL_DEFAULT)) {
                    defaultValue = xmlEltDecl.getDefaultValue();
                }
            } else {
                XmlElementDecl elementDecl = (XmlElementDecl)this.helper.getAnnotation(next, XmlElementDecl.class);
                url = elementDecl.namespace();
                localName = elementDecl.name();
                scopeClass = elementDecl.scope();
                if (!elementDecl.substitutionHeadName().equals(EMPTY_STRING)) {
                    subHeadLocal = elementDecl.substitutionHeadName();
                    subHeadNamespace = elementDecl.substitutionHeadNamespace();
                    if (subHeadNamespace.equals("##default")) {
                        subHeadNamespace = packageInfo.getNamespace();
                    }
                    substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                }
                if (elementDecl.defaultValue().length() != 1 || !elementDecl.defaultValue().startsWith(ELEMENT_DECL_DEFAULT)) {
                    defaultValue = elementDecl.defaultValue();
                }
            }
            if ("##default".equals(url)) {
                url = packageInfo.getNamespace();
            }
            if (EMPTY_STRING.equals(url)) {
                this.isDefaultNamespaceAllowed = false;
                qname = new QName(localName);
            } else {
                qname = new QName(url, localName);
            }
            boolean isList = false;
            if (JAVA_UTIL_LIST.equals(type.getName())) {
                isList = true;
                Collection args = type.getActualTypeArguments();
                if (args.size() > 0) {
                    type = (JavaClass)args.iterator().next();
                }
            }
            ElementDeclaration declaration = new ElementDeclaration(qname, type, type.getQualifiedName(), isList, scopeClass);
            if (substitutionHead != null) {
                declaration.setSubstitutionHead(substitutionHead);
            }
            if (defaultValue != null) {
                declaration.setDefaultValue(defaultValue);
            }
            if (this.helper.isAnnotationPresent(next, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
                javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter typeAdapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(next, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
                Class<? extends XmlAdapter> typeAdapterClass = typeAdapter.value();
                declaration.setJavaTypeAdapterClass(typeAdapterClass);
                Class declJavaType = CompilerHelper.getTypeFromAdapterClass(typeAdapterClass);
                JavaClass adaptedType = this.helper.getJavaClass(declJavaType);
                declaration.setJavaType(adaptedType);
                declaration.setAdaptedJavaType(type);
                returnType = adaptedType;
            }
            if (this.helper.isAnnotationPresent(next, XmlMimeType.class)) {
                XmlMimeType mimeType = (XmlMimeType)this.helper.getAnnotation(next, XmlMimeType.class);
                declaration.setXmlMimeType(mimeType.value());
            }
            if (this.helper.isAnnotationPresent(next, XmlAttachmentRef.class)) {
                declaration.setXmlAttachmentRef(true);
            }
            if ((elements = this.getElementDeclarationsForScope(scopeClass.getName())) == null) {
                elements = new HashMap();
                this.elementDeclarations.put(scopeClass.getName(), elements);
            }
            if (elements.containsKey(qname)) {
                throw JAXBException.duplicateElementName(qname);
            }
            elements.put(qname, declaration);
        }
        return returnType;
    }

    public HashMap<QName, ElementDeclaration> getGlobalElements() {
        return this.elementDeclarations.get(XmlElementDecl.GLOBAL.class.getName());
    }

    public void updateGlobalElements(JavaClass[] classesToProcess) {
        JavaClass[] javaClassArray = classesToProcess;
        int n = classesToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass javaClass = javaClassArray[n2];
            TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
            if (info != null && !info.isTransient() && info.isSetXmlRootElement()) {
                org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = info.getXmlRootElement();
                NamespaceInfo namespaceInfo = this.getPackageInfoForPackage(javaClass).getNamespaceInfo();
                String elementName = xmlRE.getName();
                if (elementName.equals("##default") || elementName.equals(EMPTY_STRING)) {
                    XMLNameTransformer transformer = info.getXmlNameTransformer();
                    try {
                        elementName = transformer.transformRootElementName(javaClass.getName());
                    }
                    catch (Exception ex) {
                        throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
                    }
                }
                String rootNamespace = xmlRE.getNamespace();
                QName rootElemName = null;
                if (rootNamespace.equals("##default")) {
                    if (namespaceInfo == null) {
                        rootElemName = new QName(elementName);
                    } else {
                        String rootNS = namespaceInfo.getNamespace();
                        rootElemName = new QName(rootNS, elementName);
                        if (rootNS.equals(EMPTY_STRING)) {
                            this.isDefaultNamespaceAllowed = false;
                        }
                    }
                } else {
                    rootElemName = new QName(rootNamespace, elementName);
                    if (rootNamespace.equals(EMPTY_STRING)) {
                        this.isDefaultNamespaceAllowed = false;
                    }
                }
                ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getQualifiedName(), false);
                declaration.setIsXmlRootElement(true);
                this.addGlobalElement(rootElemName, declaration);
                this.xmlRootElements.put(javaClass.getQualifiedName(), declaration);
            }
            ++n2;
        }
        for (QName next : this.getGlobalElements().keySet()) {
            ElementDeclaration nextDeclaration = this.getGlobalElements().get(next);
            QName substitutionHead = nextDeclaration.getSubstitutionHead();
            while (substitutionHead != null) {
                ElementDeclaration rootDeclaration = this.getGlobalElements().get(substitutionHead);
                rootDeclaration.addSubstitutableElement(nextDeclaration);
                substitutionHead = rootDeclaration.getSubstitutionHead() != null && rootDeclaration.getSubstitutionHead().equals(substitutionHead) ? null : rootDeclaration.getSubstitutionHead();
            }
        }
    }

    private void addReferencedElement(Property property, ElementDeclaration referencedElement) {
        property.addReferencedElement(referencedElement);
        if (referencedElement.getSubstitutableElements() != null && referencedElement.getSubstitutableElements().size() > 0) {
            for (ElementDeclaration substitutable : referencedElement.getSubstitutableElements()) {
                if (substitutable == referencedElement) continue;
                this.addReferencedElement(property, substitutable);
            }
        }
    }

    private boolean hasJAXBAnnotations(JavaHasAnnotations elem) {
        if (elem == null) {
            return false;
        }
        Collection annotations = elem.getAnnotations();
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        Iterator annotationsIter = annotations.iterator();
        while (annotationsIter.hasNext()) {
            String nextName = ((JavaAnnotation)annotationsIter.next()).getName();
            if (!nextName.startsWith(JAVAX_XML_BIND_ANNOTATION) && !nextName.startsWith(OXM_ANNOTATIONS) && !nextName.equals("com.sun.xml.bind.annotation.XmlLocation") && !nextName.equals("com.sun.xml.internal.bind.annotation.XmlLocation")) continue;
            return true;
        }
        return false;
    }

    private void validatePropOrderForInfo(TypeInfo info) {
        if (info.isTransient()) {
            return;
        }
        if (info.getXmlVirtualAccessMethods() != null) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        int propOrderLength = propOrder.length;
        if (propOrderLength > 0) {
            int i = 1;
            while (i < propOrderLength) {
                String nextPropName = propOrder[i];
                if (!nextPropName.equals(EMPTY_STRING) && !info.getPropertyNames().contains(nextPropName)) {
                    throw JAXBException.nonExistentPropertyInPropOrder(nextPropName);
                }
                ++i;
            }
        }
    }

    private void validateXmlValueFieldOrProperty(JavaClass cls, Property property) {
        TypeInfo refInfo;
        JavaClass ptype = property.getActualType();
        String propName = property.getPropertyName();
        JavaClass parent = cls.getSuperclass();
        while (parent != null && !parent.getQualifiedName().equals(JAVA_LANG_OBJECT)) {
            TypeInfo parentTypeInfo = this.typeInfo.get(parent.getQualifiedName());
            if (this.hasElementMappedProperties(parentTypeInfo)) {
                throw JAXBException.propertyOrFieldCannotBeXmlValue(propName);
            }
            parent = parent.getSuperclass();
        }
        QName schemaQName = this.getSchemaTypeOrNullFor(ptype);
        if (schemaQName == null && (refInfo = this.processReferencedClass(ptype)) != null && !refInfo.isEnumerationType() && refInfo.getXmlValueProperty() == null) {
            throw JAXBException.invalidTypeForXmlValueField(propName);
        }
    }

    private boolean hasElementMappedProperties(TypeInfo typeInfo) {
        for (Property property : typeInfo.getPropertyList()) {
            if (property.isTransient() || property.isAttribute() || property.isAnyAttribute()) continue;
            return true;
        }
        return false;
    }

    private void validateXmlAttributeFieldOrProperty(TypeInfo tInfo, Property property) {
        JavaClass ptype = property.getActualType();
        TypeInfo refInfo = this.typeInfo.get(ptype.getQualifiedName());
        if (refInfo != null) {
            if (!refInfo.isPostBuilt()) {
                this.postBuildTypeInfo(new JavaClass[]{ptype});
            }
            if (!refInfo.isEnumerationType()) {
                JavaClass parent = ptype.getSuperclass();
                boolean hasMapped = false;
                while (parent != null) {
                    hasMapped = this.hasTextMapping(refInfo);
                    if (hasMapped || parent.getQualifiedName().equals(JAVA_LANG_OBJECT)) break;
                    refInfo = this.typeInfo.get(parent.getQualifiedName());
                    parent = parent.getSuperclass();
                }
                if (!hasMapped) {
                    String propName = property.getPropertyName();
                    String typeName = tInfo.getJavaClassName();
                    String refTypeName = refInfo.getJavaClassName();
                    throw JAXBException.mustMapToText(propName, typeName, refTypeName);
                }
            }
        }
    }

    private boolean hasTextMapping(TypeInfo tInfo) {
        boolean hasXmlValue;
        Collection<Property> props = tInfo.getProperties().values();
        for (Property property : props) {
            JavaClass ptype;
            TypeInfo refInfo;
            if (!property.isAttribute() || (refInfo = this.typeInfo.get((ptype = property.getActualType()).getQualifiedName())) == null) continue;
            return this.hasTextMapping(refInfo);
        }
        boolean hasXmlId = tInfo.getIDProperty() != null && !tInfo.getIDProperty().isTransient();
        boolean bl = hasXmlValue = tInfo.getXmlValueProperty() != null && !tInfo.getXmlValueProperty().isTransient();
        if (hasXmlValue) {
            hasXmlValue = CompilerHelper.isSimpleType(tInfo);
        }
        return hasXmlValue || hasXmlId;
    }

    private Class generateWrapperForMapClass(JavaClass mapClass, JavaClass keyClass, JavaClass valueClass, TypeMappingInfo typeMappingInfo) {
        Annotation[] annotations;
        PackageInfo packageInfo;
        String namespace;
        Vector namespaces;
        String packageName = JAXB_DEV;
        NamespaceResolver combinedNamespaceResolver = new NamespaceResolver();
        if (!this.helper.isBuiltInJavaType(keyClass)) {
            String keyPackageName = keyClass.getPackageName();
            packageName = String.valueOf(packageName) + DOT_CHR + keyPackageName;
            NamespaceInfo keyNamespaceInfo = this.getPackageInfoForPackage(keyClass).getNamespaceInfo();
            if (keyNamespaceInfo != null) {
                namespaces = keyNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if (!this.helper.isBuiltInJavaType(valueClass)) {
            String valuePackageName = valueClass.getPackageName();
            packageName = String.valueOf(packageName) + DOT_CHR + valuePackageName;
            NamespaceInfo valueNamespaceInfo = this.getPackageInfoForPackage(valueClass).getNamespaceInfo();
            if (valueNamespaceInfo != null) {
                namespaces = valueNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if ((namespace = this.defaultTargetNamespace) == null) {
            namespace = EMPTY_STRING;
        }
        if ((packageInfo = this.packageToPackageInfoMappings.get(mapClass.getPackageName())) == null) {
            packageInfo = this.getPackageToPackageInfoMappings().get(packageName);
        } else {
            if (packageInfo.getNamespace() != null) {
                namespace = packageInfo.getNamespace();
            }
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
        }
        if (packageInfo == null) {
            packageInfo = new PackageInfo();
            packageInfo.setNamespaceInfo(new NamespaceInfo());
            packageInfo.setNamespace(namespace);
            packageInfo.setNamespaceResolver(combinedNamespaceResolver);
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
        }
        int beginIndex = keyClass.getName().lastIndexOf(DOT_CHR.charValue()) + 1;
        String keyName = keyClass.getName().substring(beginIndex);
        int dollarIndex = keyName.indexOf(DOLLAR_SIGN_CHR.charValue());
        if (dollarIndex > -1) {
            keyName = keyName.substring(dollarIndex + 1);
        }
        beginIndex = valueClass.getName().lastIndexOf(DOT_CHR.charValue()) + 1;
        String valueName = valueClass.getName().substring(beginIndex);
        dollarIndex = valueName.indexOf(DOLLAR_SIGN_CHR.charValue());
        if (dollarIndex > -1) {
            valueName = valueName.substring(dollarIndex + 1);
        }
        String collectionClassShortName = mapClass.getRawName().substring(mapClass.getRawName().lastIndexOf(DOT_CHR.charValue()) + 1);
        String suggestedClassName = String.valueOf(keyName) + valueName + collectionClassShortName;
        String qualifiedClassName = String.valueOf(packageName) + DOT_CHR + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        String qualifiedInternalClassName = qualifiedClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String internalKeyName = keyClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String internalValueName = valueClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        org.eclipse.persistence.internal.libraries.asm.Type mapType = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + mapClass.getRawName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
        ClassWriter cw = new ClassWriter(2);
        String sig = "Lorg/eclipse/persistence/internal/jaxb/many/MapValue<L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;>;";
        cw.visit(49, 33, qualifiedInternalClassName, sig, "org/eclipse/persistence/internal/jaxb/many/MapValue", null);
        String fieldSig = L + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;";
        FieldVisitor fv = cw.visitField(1, "entry", L + mapType.getInternalName() + SEMI_COLON, fieldSig, null);
        AnnotationVisitor av = fv.visitAnnotation(org.eclipse.persistence.internal.libraries.asm.Type.getDescriptor(javax.xml.bind.annotation.XmlElement.class), true);
        if (typeMappingInfo != null && (annotations = typeMappingInfo.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.length) {
                Annotation nextAnnotation = annotations[i];
                if (nextAnnotation != null && !(nextAnnotation instanceof javax.xml.bind.annotation.XmlElement) && !(nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)) {
                    String annotationClassName = nextAnnotation.annotationType().getName();
                    av = fv.visitAnnotation(L + annotationClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON, true);
                    Method[] methodArray = nextAnnotation.annotationType().getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method next = methodArray[n2];
                        try {
                            Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                            if (nextValue instanceof Class) {
                                org.eclipse.persistence.internal.libraries.asm.Type nextType = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + ((Class)nextValue).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
                                nextValue = nextType;
                            }
                            av.visit(next.getName(), nextValue);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                        ++n2;
                    }
                    av.visitEnd();
                }
                ++i;
            }
        }
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/many/MapValue", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        String methodSig = "(L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;)V";
        mv = cw.visitMethod(1, "setItem", "(L" + mapType.getInternalName() + ";)V", methodSig, null);
        mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, qualifiedInternalClassName, "entry", L + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        methodSig = "()L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;";
        mv = cw.visitMethod(1, "getItem", "()L" + mapType.getInternalName() + SEMI_COLON, methodSig, null);
        mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, "entry", L + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "getItem", "()Ljava/lang/Object;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, qualifiedInternalClassName, "getItem", "()L" + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "setItem", "(Ljava/lang/Object;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, mapType.getInternalName());
        mv.visitMethodInsn(182, qualifiedInternalClassName, "setItem", "(L" + mapType.getInternalName() + ";)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        av = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        av.visit("namespace", namespace);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private Class generateWrapperForArrayClass(JavaClass arrayClass, TypeMappingInfo typeMappingInfo, Class xmlElementType, List<JavaClass> classesToProcess) {
        JavaClass componentClass = null;
        componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : arrayClass.getComponentType();
        if (componentClass.isArray()) {
            Class nestedArrayClass = this.arrayClassesToGeneratedClasses.get(componentClass.getName());
            if (nestedArrayClass == null) {
                nestedArrayClass = this.generateWrapperForArrayClass(componentClass, typeMappingInfo, xmlElementType, classesToProcess);
                this.arrayClassesToGeneratedClasses.put(componentClass.getName(), nestedArrayClass);
                classesToProcess.add(this.helper.getJavaClass(nestedArrayClass));
            }
            return this.generateArrayValue(arrayClass, this.helper.getJavaClass(nestedArrayClass), this.helper.getJavaClass(nestedArrayClass), typeMappingInfo);
        }
        return this.generateArrayValue(arrayClass, componentClass, componentClass, typeMappingInfo);
    }

    private Class generateArrayValue(JavaClass arrayClass, JavaClass componentClass, JavaClass nestedClass, TypeMappingInfo typeMappingInfo) {
        String qualifiedClassName;
        QName qName = null;
        if (this.helper.getJavaClass(ManyValue.class).isAssignableFrom(componentClass)) {
            String packageName = componentClass.getPackageName();
            qualifiedClassName = String.valueOf(nestedClass.getQualifiedName()) + ARRAY_CLASS_NAME_SUFFIX;
        } else {
            PackageInfo namespaceInfo;
            String packageName;
            if (componentClass.isPrimitive()) {
                packageName = ARRAY_PACKAGE_NAME;
                qualifiedClassName = String.valueOf(packageName) + DOT_CHR + componentClass.getName() + ARRAY_CLASS_NAME_SUFFIX;
            } else {
                packageName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getPackageName();
                if (componentClass.isMemberClass()) {
                    qualifiedClassName = componentClass.getName();
                    qualifiedClassName = qualifiedClassName.substring(qualifiedClassName.indexOf(DOLLAR_SIGN_CHR.charValue()) + 1);
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getPackageName() + DOT_CHR + qualifiedClassName + ARRAY_CLASS_NAME_SUFFIX;
                } else {
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getQualifiedName() + ARRAY_CLASS_NAME_SUFFIX;
                }
            }
            if (componentClass.isPrimitive() || this.helper.isBuiltInJavaType(componentClass)) {
                qName = (QName)this.helper.getXMLToJavaTypeMap().get(componentClass.getQualifiedName());
                if (qName != null) {
                    packageName = ARRAY_PACKAGE_NAME;
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + qName.getLocalPart() + ARRAY_CLASS_NAME_SUFFIX;
                }
                if ((namespaceInfo = this.getPackageToPackageInfoMappings().get(packageName)) == null) {
                    namespaceInfo = new PackageInfo();
                    namespaceInfo.setNamespaceInfo(new NamespaceInfo());
                    namespaceInfo.setNamespace(ARRAY_NAMESPACE);
                    namespaceInfo.setNamespaceResolver(new NamespaceResolver());
                    this.getPackageToPackageInfoMappings().put(packageName, namespaceInfo);
                }
            } else {
                namespaceInfo = this.getPackageInfoForPackage(componentClass.getPackage(), componentClass.getPackageName());
                this.getPackageToPackageInfoMappings().put(packageName, namespaceInfo);
            }
        }
        try {
            String qualifiedInternalClassName = qualifiedClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
            if (this.helper.getJavaClass(ManyValue.class).isAssignableFrom(componentClass)) {
                return this.generateClassFromBytes(qualifiedClassName, this.generateMultiDimensionalManyValueClass(typeMappingInfo, null, MultiDimensionalArrayValue.class, qualifiedInternalClassName, componentClass, arrayClass.getComponentType()));
            }
            return this.generateClassFromBytes(qualifiedClassName, this.generateManyValue(typeMappingInfo, null, ArrayValue.class, qualifiedInternalClassName, componentClass, componentClass));
        }
        catch (LinkageError e) {
            if (qName != null) {
                throw JAXBException.nameCollision(qName.getNamespaceURI(), qName.getLocalPart());
            }
            throw e;
        }
    }

    private JavaClass getObjectType(JavaClass javaClass) {
        if (javaClass.isPrimitive()) {
            String primitiveClassName = javaClass.getRawName();
            Class primitiveClass = this.getPrimitiveClass(primitiveClassName);
            return this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        }
        return javaClass;
    }

    private Class generateCollectionValue(JavaClass collectionClass, TypeMappingInfo typeMappingInfo, Class xmlElementType, List<JavaClass> classesToProcess) {
        int beginIndex;
        int dollarIndex;
        String name;
        Collection args;
        JavaClass componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : ((args = collectionClass.getActualTypeArguments()).size() > 0 ? (JavaClass)args.toArray()[0] : this.helper.getJavaClass(Object.class));
        boolean multiDimensional = false;
        if (componentClass.isPrimitive()) {
            Class primitiveClass = this.getPrimitiveClass(componentClass.getRawName());
            componentClass = this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        } else if (this.helper.getJavaClass(Collection.class).isAssignableFrom(componentClass)) {
            multiDimensional = true;
            Class nestedCollectionClass = this.collectionClassesToGeneratedClasses.get(componentClass.getName());
            if (nestedCollectionClass == null) {
                nestedCollectionClass = this.generateCollectionValue(componentClass, typeMappingInfo, xmlElementType, classesToProcess);
                this.arrayClassesToGeneratedClasses.put(componentClass.getName(), nestedCollectionClass);
                classesToProcess.add(this.helper.getJavaClass(nestedCollectionClass));
            }
            componentClass = this.helper.getJavaClass(nestedCollectionClass);
        } else if (componentClass.isArray()) {
            if (componentClass.getName().equals("[B")) {
                multiDimensional = false;
            } else {
                multiDimensional = true;
                Class nestedArrayClass = this.arrayClassesToGeneratedClasses.get(componentClass.getName());
                if (nestedArrayClass == null) {
                    nestedArrayClass = this.generateWrapperForArrayClass(componentClass, typeMappingInfo, xmlElementType, classesToProcess);
                    this.arrayClassesToGeneratedClasses.put(componentClass.getName(), nestedArrayClass);
                }
                componentClass = this.helper.getJavaClass(nestedArrayClass);
            }
        }
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(collectionClass.getPackageName());
        String namespace = EMPTY_STRING;
        if (this.defaultTargetNamespace != null) {
            namespace = this.defaultTargetNamespace;
        }
        PackageInfo componentNamespaceInfo = this.getPackageInfoForPackage(componentClass);
        String packageName = componentClass.getPackageName();
        packageName = "jaxb.dev.java.net." + packageName;
        if (packageInfo == null) {
            packageInfo = this.getPackageToPackageInfoMappings().get(packageName);
        } else {
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
            if (packageInfo.getNamespace() != null) {
                namespace = packageInfo.getNamespace();
            }
        }
        if (packageInfo == null) {
            if (componentNamespaceInfo != null) {
                packageInfo = componentNamespaceInfo;
            } else {
                packageInfo = new PackageInfo();
                packageInfo.setNamespaceInfo(new NamespaceInfo());
                packageInfo.setNamespaceResolver(new NamespaceResolver());
            }
            this.getPackageToPackageInfoMappings().put(packageName, packageInfo);
        }
        if ("[B".equals(name = componentClass.getName())) {
            name = "byteArray";
        }
        if ((dollarIndex = (name = name.substring(beginIndex = name.lastIndexOf(DOT_CHR.charValue()) + 1)).indexOf(DOLLAR_SIGN_CHR.charValue())) > -1) {
            name = name.substring(dollarIndex + 1);
        }
        String collectionClassRawName = collectionClass.getRawName();
        String collectionClassShortName = collectionClassRawName.substring(collectionClassRawName.lastIndexOf(DOT_CHR.charValue()) + 1);
        String suggestedClassName = String.valueOf(collectionClassShortName) + "Of" + name;
        String qualifiedClassName = String.valueOf(packageName) + DOT_CHR + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        String qualifiedInternalClassName = qualifiedClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        byte[] classBytes = multiDimensional ? this.generateMultiDimensionalManyValueClass(typeMappingInfo, namespace, MultiDimensionalCollectionValue.class, qualifiedInternalClassName, componentClass, collectionClass) : this.generateManyValue(typeMappingInfo, namespace, CollectionValue.class, qualifiedInternalClassName, componentClass, collectionClass);
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private byte[] generateManyValue(TypeMappingInfo typeMappingInfo, String namespace, Class superType, String classNameSeparatedBySlash, JavaClass componentType, JavaClass containerType) {
        ClassWriter cw = new ClassWriter(2);
        this.generateManyValueClass(cw, typeMappingInfo, namespace, superType, classNameSeparatedBySlash, componentType, containerType);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateManyValueClass(ClassWriter cw, TypeMappingInfo typeMappingInfo, String namespace, Class superType, String classNameSeparatedBySlash, JavaClass componentType, JavaClass containerType) {
        Annotation[] annotations;
        String componentClassNameSeparatedBySlash = this.getObjectType(componentType).getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String containerClassNameSeperatedBySlash = containerType.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        if ("[B".equals(componentClassNameSeparatedBySlash)) {
            cw.visit(49, 33, classNameSeparatedBySlash, L + org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(superType) + "<" + componentClassNameSeparatedBySlash + ">;", org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(superType), null);
        } else {
            cw.visit(49, 33, classNameSeparatedBySlash, L + org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(superType) + "<L" + componentClassNameSeparatedBySlash + ";>;", org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(superType), null);
        }
        AnnotationVisitor av = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        if (namespace != null) {
            av.visit("namespace", namespace);
        }
        if (classNameSeparatedBySlash.startsWith(ARRAY_PACKAGE_NAME.replace('.', '/')) && classNameSeparatedBySlash.contains("QName")) {
            av.visit("name", classNameSeparatedBySlash.substring(classNameSeparatedBySlash.lastIndexOf(47) + 1));
        }
        av.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(superType), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        if (!componentType.isPrimitive() && ArrayValue.class.isAssignableFrom(superType)) {
            mv = cw.visitMethod(1, "getItem", "()Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            Label l0 = new Label();
            mv.visitJumpInsn(199, l0);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(l0);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            mv.visitMethodInsn(185, "java/util/Collection", "size", "()I");
            mv.visitVarInsn(54, 1);
            mv.visitVarInsn(21, 1);
            mv.visitTypeInsn(189, componentClassNameSeparatedBySlash);
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Collection", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
            mv.visitInsn(87);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
            mv = cw.visitMethod(1, "setItem", "(Ljava/lang/Object;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "[L" + componentClassNameSeparatedBySlash + SEMI_COLON);
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;");
            mv.visitFieldInsn(181, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
        }
        mv = "[B".equals(componentClassNameSeparatedBySlash) ? cw.visitMethod(1, "getAdaptedValue", "()Ljava/util/Collection;", "()Ljava/util/Collection<" + componentClassNameSeparatedBySlash + ">;", null) : cw.visitMethod(1, "getAdaptedValue", "()Ljava/util/Collection;", "()Ljava/util/Collection<L" + componentClassNameSeparatedBySlash + ";>;", null);
        boolean hasXmlList = false;
        if (typeMappingInfo != null && (annotations = this.getAnnotations(typeMappingInfo)) != null) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (!(annotation instanceof javax.xml.bind.annotation.XmlElement) && !(annotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (annotation instanceof XmlList) {
                        hasXmlList = true;
                    }
                    av = mv.visitAnnotation(L + annotationType.getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON, true);
                    Method[] methodArray = annotation.annotationType().getDeclaredMethods();
                    int n3 = methodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method next = methodArray[n4];
                        try {
                            Object nextValue = next.invoke((Object)annotation, new Object[0]);
                            if (nextValue instanceof Class) {
                                nextValue = org.eclipse.persistence.internal.libraries.asm.Type.getType(L + ((Class)nextValue).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
                            }
                            av.visit(next.getName(), nextValue);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                        ++n4;
                    }
                    av.visitEnd();
                }
                ++n2;
            }
        }
        if (hasXmlList) {
            av = mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlValue;", true);
            av.visitEnd();
        } else {
            av = mv.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
            av.visit("name", ITEM);
            av.visit("nillable", true);
            av.visitEnd();
        }
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(superType), "getAdaptedValue", "()Ljava/util/Collection;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setAdaptedValue", "(Ljava/util/Collection;)V", "(Ljava/util/Collection<L" + componentClassNameSeparatedBySlash + ";>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(superType), "setAdaptedValue", "(Ljava/util/Collection;)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(4, "containerClass", "()Ljava/lang/Class;", "()Ljava/lang/Class<*>;", null);
        mv.visitCode();
        if (componentType.isPrimitive()) {
            mv.visitFieldInsn(178, this.getObjectType(componentType).getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()), "TYPE", "Ljava/lang/Class;");
        } else if (containerClassNameSeperatedBySlash.contains(SEMI_COLON)) {
            mv.visitLdcInsn(org.eclipse.persistence.internal.libraries.asm.Type.getType(containerClassNameSeperatedBySlash));
        } else {
            mv.visitLdcInsn(org.eclipse.persistence.internal.libraries.asm.Type.getType(L + containerClassNameSeperatedBySlash + SEMI_COLON));
        }
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private byte[] generateMultiDimensionalManyValueClass(TypeMappingInfo typeMappingInfo, String namespace, Class superType, String classNameSeparatedBySlash, JavaClass componentType, JavaClass containerType) {
        ClassWriter cw = new ClassWriter(2);
        this.generateManyValueClass(cw, typeMappingInfo, namespace, superType, classNameSeparatedBySlash, componentType, containerType);
        this.generateMultiDimensionalManyValueClass(cw, componentType);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateMultiDimensionalManyValueClass(ClassWriter cw, JavaClass componentType) {
        String componentClassNameSeparatedBySlash = componentType.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        MethodVisitor mv = cw.visitMethod(4, "componentClass", "()Ljava/lang/Class;", "()Ljava/lang/Class<L" + componentClassNameSeparatedBySlash + ";>;", null);
        mv.visitCode();
        mv.visitLdcInsn(org.eclipse.persistence.internal.libraries.asm.Type.getType(L + componentClassNameSeparatedBySlash + SEMI_COLON));
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private Class generateClassFromBytes(String className, byte[] classBytes) {
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    private String getNextAvailableClassName(String suggestedName) {
        int counter = 1;
        return this.getNextAvailableClassName(suggestedName, suggestedName, counter);
    }

    private String getNextAvailableClassName(String suggestedBaseName, String suggestedName, int counter) {
        for (Class nextClass : this.typeMappingInfoToGeneratedClasses.values()) {
            if (!nextClass.getName().equals(suggestedName)) continue;
            return this.getNextAvailableClassName(suggestedBaseName, String.valueOf(suggestedBaseName) + ++counter, counter);
        }
        return suggestedName;
    }

    private Class getPrimitiveClass(String primitiveClassName) {
        return ConversionManager.getDefaultManager().convertClassNameToClass(primitiveClassName);
    }

    private Class getObjectClass(Class primitiveClass) {
        ConversionManager.getDefaultManager();
        return ConversionManager.getObjectClass(primitiveClass);
    }

    public Map<Type, Class> getCollectionClassesToGeneratedClasses() {
        return this.collectionClassesToGeneratedClasses;
    }

    public Map<String, Class> getArrayClassesToGeneratedClasses() {
        return this.arrayClassesToGeneratedClasses;
    }

    public Map<Class, Type> getGeneratedClassesToCollectionClasses() {
        return this.generatedClassesToCollectionClasses;
    }

    public Map<Class, JavaClass> getGeneratedClassesToArrayClasses() {
        return this.generatedClassesToArrayClasses;
    }

    public Map<String, TypeInfo> getTypeInfosForPackage(String packageName) {
        HashMap<String, TypeInfo> typeInfos = new HashMap<String, TypeInfo>();
        ArrayList<JavaClass> jClasses = this.getTypeInfoClasses();
        for (JavaClass jClass : jClasses) {
            if (!jClass.getPackageName().equals(packageName)) continue;
            String key = jClass.getQualifiedName();
            typeInfos.put(key, this.typeInfo.get(key));
        }
        return typeInfos;
    }

    public void setPackageToNamespaceMappings(HashMap<String, NamespaceInfo> packageToNamespaceMappings) {
    }

    public void setPackageToPackageInfoMappings(HashMap<String, PackageInfo> packageToPackageInfoMappings) {
        this.packageToPackageInfoMappings = packageToPackageInfoMappings;
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            return null;
        }
        if (this.typeInfo == null) {
            this.typeInfoClasses = new ArrayList();
            this.typeInfo = new HashMap();
            this.typeQNames = new ArrayList();
            this.userDefinedSchemaTypes = new HashMap();
            this.packageToPackageInfoMappings = new HashMap();
        }
        JavaClass[] jClasses = new JavaClass[]{javaClass};
        this.buildNewTypeInfo(jClasses);
        TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
        String packageName = javaClass.getPackageName();
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        SchemaTypeInfo schemaInfo = new SchemaTypeInfo();
        schemaInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        if (info.isSetXmlRootElement()) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = info.getXmlRootElement();
            String elementName = xmlRE.getName();
            if (elementName.equals("##default") || elementName.equals(EMPTY_STRING)) {
                try {
                    elementName = info.getXmlNameTransformer().transformRootElementName(javaClass.getName());
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            String rootNamespace = xmlRE.getNamespace();
            QName rootElemName = null;
            rootElemName = rootNamespace.equals("##default") ? new QName(packageInfo.getNamespace(), elementName) : new QName(rootNamespace, elementName);
            schemaInfo.getGlobalElementDeclarations().add(rootElemName);
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getRawName(), false);
            this.addGlobalElement(rootElemName, declaration);
        }
        return schemaInfo;
    }

    public void buildNewTypeInfo(JavaClass[] javaClasses) {
        this.preBuildTypeInfo(javaClasses);
        JavaClass[] javaClassArray = javaClasses = this.postBuildTypeInfo(javaClasses);
        int n = javaClasses.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass next = javaClassArray[n2];
            this.processPropertyTypes(next);
            ++n2;
        }
    }

    private void preProcessCustomizer(JavaClass jClass, TypeInfo tInfo) {
        XmlCustomizer xmlCustomizer = (XmlCustomizer)this.helper.getAnnotation(jClass, XmlCustomizer.class);
        if (xmlCustomizer != null) {
            tInfo.setXmlCustomizer(xmlCustomizer.value().getName());
        }
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    Helper getHelper() {
        return this.helper;
    }

    public boolean isDefaultNamespaceAllowed() {
        return this.isDefaultNamespaceAllowed;
    }

    public List<ElementDeclaration> getLocalElements() {
        return this.localElements;
    }

    public Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedClasses() {
        return this.typeMappingInfoToGeneratedClasses;
    }

    public Map<TypeMappingInfo, Class> getTypeMappingInfoToAdapterClasses() {
        return this.typeMappingInfoToAdapterClasses;
    }

    public void addXmlRegistry(String factoryClassName, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry xmlReg) {
        this.xmlRegistries.put(factoryClassName, xmlReg);
    }

    private boolean isXmlRegistry(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        return this.helper.isAnnotationPresent(javaClass, XmlRegistry.class) || this.xmlRegistries.get(javaClass.getQualifiedName()) != null;
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
        return this.typeMappingInfoToSchemaType;
    }

    String getDefaultTargetNamespace() {
        return this.defaultTargetNamespace;
    }

    void setDefaultTargetNamespace(String defaultTargetNamespace) {
        this.defaultTargetNamespace = defaultTargetNamespace;
    }

    public void setDefaultNamespaceAllowed(boolean isDefaultNamespaceAllowed) {
        this.isDefaultNamespaceAllowed = isDefaultNamespaceAllowed;
    }

    HashMap<QName, ElementDeclaration> getElementDeclarationsForScope(String scopeClassName) {
        return this.elementDeclarations.get(scopeClassName);
    }

    private void addGlobalElement(QName key, ElementDeclaration declaration) {
        this.getGlobalElements().put(key, declaration);
        this.classesToProcessPropertyTypes.add(declaration.getJavaType());
    }

    private Map<Object, Object> createUserPropertiesMap(XmlProperty[] properties) {
        HashMap<Object, Object> propMap = new HashMap<Object, Object>();
        XmlProperty[] xmlPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            XmlProperty prop = xmlPropertyArray[n2];
            Object pvalue = prop.value();
            if (prop.valueType() != String.class) {
                pvalue = XMLConversionManager.getDefaultXMLManager().convertObject(prop.value(), prop.valueType());
            }
            propMap.put(prop.name(), pvalue);
            ++n2;
        }
        return propMap;
    }

    public boolean isMtomAttachment(Property property) {
        JavaClass ptype = property.getActualType();
        return this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, Image.class) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART);
    }

    public boolean hasSwaRef() {
        return this.hasSwaRef;
    }

    public void setHasSwaRef(boolean swaRef) {
        this.hasSwaRef = swaRef;
    }

    public List getReferencedByTransformer() {
        return this.referencedByTransformer;
    }

    public boolean isXmlAccessorFactorySupport() {
        return this.xmlAccessorFactorySupport;
    }

    public void setXmlAccessorFactorySupport(boolean value) {
        this.xmlAccessorFactorySupport = value;
    }

    public void setHasXmlBindings(boolean b) {
        this.hasXmlBindings = true;
    }

    public boolean hasXmlBindings() {
        return this.hasXmlBindings;
    }

    class PropertyComparitor
    implements Comparator<Property> {
        PropertyComparitor() {
        }

        @Override
        public int compare(Property p1, Property p2) {
            return p1.getPropertyName().compareTo(p2.getPropertyName());
        }
    }
}

