/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class WaterfallExecutor {
    public static void waterfall(Iterable<ExecutorService> executors, Callable<Callable<?>> callable) throws InterruptedException, ExecutionException {
        WaterfallExecutor.waterfall(executors.iterator(), callable);
    }

    private static void waterfall(Iterator<ExecutorService> executors, Callable<Callable<?>> callable) throws InterruptedException, ExecutionException {
        ExecutorService executor = null;
        try {
            executor = executors.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Not enough executors to service this Future task: " + callable);
        }
        if (executor == null) {
            throw new IllegalStateException("Not enough executors to service this Future task: " + callable);
        }
        Future<Callable<?>> task = executor.submit(callable);
        Callable<Callable<?>> value = task.get();
        if (value != null) {
            WaterfallExecutor.waterfall(executors, value);
        }
    }
}

