/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.opennms.core.fiber.Fiber;

public class VMTaskFiber
implements Fiber,
Runnable {
    private static final String MAIN_METHOD_NAME = "main";
    private static final String[] MAIN_PARAMETER_TYPES = new String[]{"[Ljava.lang.String;"};
    private static final String MAIN_RETURN_TYPE = "void";
    private static final String THREADGROUP_NAME_PREFIX = "TaskGroup:";
    private String m_taskName;
    private ThreadGroup m_thrGroup;
    private ClassLoader m_classLoader;
    private Method m_entryMethod;
    private String[] m_mainArgs;
    private int m_fiberStatus;

    private static Method findMain(Class<?> c) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean validModifiers;
            Class<?>[] args = methods[i].getParameterTypes();
            Class<?> retType = methods[i].getReturnType();
            int modifiers = methods[i].getModifiers();
            boolean bl = validModifiers = Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers);
            if (!validModifiers || !methods[i].getName().equals(MAIN_METHOD_NAME) || args.length != MAIN_PARAMETER_TYPES.length || !retType.getName().equals(MAIN_RETURN_TYPE)) continue;
            boolean isOK = true;
            for (int x = 0; isOK && x < args.length; ++x) {
                if (args[x].getName().equals(MAIN_PARAMETER_TYPES[x])) continue;
                isOK = false;
            }
            if (!isOK) continue;
            return methods[i];
        }
        return null;
    }

    public VMTaskFiber(String taskName, String entryClassName, String[] entryArguments, URL[] searchPaths) throws ClassNotFoundException, NoSuchMethodException {
        this.m_taskName = taskName;
        this.m_mainArgs = Arrays.copyOf(entryArguments, entryArguments.length);
        this.m_thrGroup = new ThreadGroup(THREADGROUP_NAME_PREFIX + this.m_taskName);
        this.m_thrGroup.setDaemon(false);
        this.m_classLoader = new URLClassLoader(Arrays.copyOf(searchPaths, searchPaths.length));
        Class<?> m_entryClass = this.m_classLoader.loadClass(entryClassName);
        this.m_entryMethod = VMTaskFiber.findMain(m_entryClass);
        if (this.m_entryMethod == null) {
            throw new NoSuchMethodException("main() method not found for class " + entryClassName);
        }
        this.m_fiberStatus = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] passedArgs = new Object[]{this.m_mainArgs};
        VMTaskFiber vMTaskFiber = this;
        synchronized (vMTaskFiber) {
            this.m_fiberStatus = 2;
        }
        try {
            this.m_entryMethod.invoke(null, passedArgs);
        }
        catch (Throwable throwable) {
            VMTaskFiber vMTaskFiber2 = this;
            synchronized (vMTaskFiber2) {
                this.m_fiberStatus = 4;
            }
        }
        finally {
            vMTaskFiber = this;
            synchronized (vMTaskFiber) {
                this.m_fiberStatus = 4;
            }
        }
    }

    @Override
    public synchronized void start() {
        this.m_fiberStatus = 1;
        Thread t = new Thread(this.m_thrGroup, this, this.m_taskName + "-main");
        t.setDaemon(false);
        t.setContextClassLoader(this.m_classLoader);
        t.start();
    }

    @Override
    public synchronized void stop() {
        if (this.m_fiberStatus != 4) {
            this.m_fiberStatus = 3;
        }
        this.m_thrGroup.interrupt();
    }

    @Override
    public synchronized int getStatus() {
        return this.m_fiberStatus;
    }

    @Override
    public String getName() {
        return this.m_taskName;
    }
}

