/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.spi.ClassLoadHelper;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchedulerAccessor
implements ResourceLoaderAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean overwriteExistingJobs = false;
    private String[] jobSchedulingDataLocations;
    private List<JobDetail> jobDetails;
    private Map<String, Calendar> calendars;
    private List<Trigger> triggers;
    private SchedulerListener[] schedulerListeners;
    private JobListener[] globalJobListeners;
    private JobListener[] jobListeners;
    private TriggerListener[] globalTriggerListeners;
    private TriggerListener[] triggerListeners;
    private PlatformTransactionManager transactionManager;
    protected ResourceLoader resourceLoader;

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setJobSchedulingDataLocation(String jobSchedulingDataLocation) {
        this.jobSchedulingDataLocations = new String[]{jobSchedulingDataLocation};
    }

    public void setJobSchedulingDataLocations(String[] jobSchedulingDataLocations) {
        this.jobSchedulingDataLocations = jobSchedulingDataLocations;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = new ArrayList<JobDetail>((Collection)Arrays.asList(jobDetails));
    }

    public void setCalendars(Map<String, Calendar> calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    public void setSchedulerListeners(SchedulerListener[] schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void setGlobalJobListeners(JobListener[] globalJobListeners) {
        this.globalJobListeners = globalJobListeners;
    }

    public void setJobListeners(JobListener[] jobListeners) {
        this.jobListeners = jobListeners;
    }

    public void setGlobalTriggerListeners(TriggerListener[] globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    public void setTriggerListeners(TriggerListener[] triggerListeners) {
        this.triggerListeners = triggerListeners;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    /*
     * Unable to fully structure code
     */
    protected void registerJobsAndTriggers() throws SchedulerException {
        transactionStatus = null;
        if (this.transactionManager != null) {
            transactionStatus = this.transactionManager.getTransaction(new DefaultTransactionDefinition());
        }
        try {
            block21: {
                if (this.jobSchedulingDataLocations != null) {
                    clh = new ResourceLoaderClassLoadHelper(this.resourceLoader);
                    clh.initialize();
                    try {
                        dataProcessorClass = this.getClass().getClassLoader().loadClass("org.quartz.xml.XMLSchedulingDataProcessor");
                        this.logger.debug("Using Quartz 1.8 XMLSchedulingDataProcessor");
                        dataProcessor = dataProcessorClass.getConstructor(new Class[]{ClassLoadHelper.class}).newInstance(new Object[]{clh});
                        processFileAndScheduleJobs = dataProcessorClass.getMethod("processFileAndScheduleJobs", new Class[]{String.class, Scheduler.class});
                        var9_8 = this.jobSchedulingDataLocations;
                        var8_9 = this.jobSchedulingDataLocations.length;
                        var7_10 = 0;
                        while (var7_10 < var8_9) {
                            location = var9_8[var7_10];
                            processFileAndScheduleJobs.invoke(dataProcessor, new Object[]{location, this.getScheduler()});
                            ++var7_10;
                        }
                        break block21;
                    }
                    catch (ClassNotFoundException v0) {
                        dataProcessorClass = this.getClass().getClassLoader().loadClass("org.quartz.xml.JobSchedulingDataProcessor");
                        this.logger.debug("Using Quartz 1.6 JobSchedulingDataProcessor");
                        dataProcessor = dataProcessorClass.getConstructor(new Class[]{ClassLoadHelper.class, Boolean.TYPE, Boolean.TYPE}).newInstance(new Object[]{clh, true, true});
                        processFileAndScheduleJobs = dataProcessorClass.getMethod("processFileAndScheduleJobs", new Class[]{String.class, Scheduler.class, Boolean.TYPE});
                        var9_8 = this.jobSchedulingDataLocations;
                        var8_9 = this.jobSchedulingDataLocations.length;
                        var7_10 = 0;
                        ** while (var7_10 < var8_9)
                    }
lbl-1000:
                    // 1 sources

                    {
                        location = var9_8[var7_10];
                        processFileAndScheduleJobs.invoke(dataProcessor, new Object[]{location, this.getScheduler(), this.overwriteExistingJobs});
                        ++var7_10;
                        continue;
                    }
                }
            }
            if (this.jobDetails != null) {
                for (JobDetail jobDetail : this.jobDetails) {
                    this.addJobToScheduler(jobDetail);
                }
            } else {
                this.jobDetails = new LinkedList<JobDetail>();
            }
            if (this.calendars != null) {
                for (String calendarName : this.calendars.keySet()) {
                    calendar = this.calendars.get(calendarName);
                    this.getScheduler().addCalendar(calendarName, calendar, true, true);
                }
            }
            if (this.triggers != null) {
                for (Trigger trigger : this.triggers) {
                    this.addTriggerToScheduler(trigger);
                }
            }
        }
        catch (Throwable ex) {
            if (transactionStatus != null) {
                try {
                    this.transactionManager.rollback(transactionStatus);
                }
                catch (TransactionException tex) {
                    this.logger.error("Job registration exception overridden by rollback exception", ex);
                    throw tex;
                }
            }
            if (ex instanceof SchedulerException) {
                throw (SchedulerException)ex;
            }
            if (ex instanceof Exception) {
                throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage(), ex);
            }
            throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage());
        }
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
        }
    }

    private boolean addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        if (this.overwriteExistingJobs || this.getScheduler().getJobDetail(jobDetail.getName(), jobDetail.getGroup()) == null) {
            this.getScheduler().addJob(jobDetail, true);
            return true;
        }
        return false;
    }

    private boolean addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists;
        boolean bl = triggerExists = this.getScheduler().getTrigger(trigger.getName(), trigger.getGroup()) != null;
        if (!triggerExists || this.overwriteExistingJobs) {
            JobDetail jobDetail;
            if (trigger instanceof JobDetailAwareTrigger && !this.jobDetails.contains(jobDetail = ((JobDetailAwareTrigger)trigger).getJobDetail()) && this.addJobToScheduler(jobDetail)) {
                this.jobDetails.add(jobDetail);
            }
            if (!triggerExists) {
                try {
                    this.getScheduler().scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored");
                    }
                    if (this.overwriteExistingJobs) {
                        this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                    }
                }
            } else {
                this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
            }
            return true;
        }
        return false;
    }

    protected void registerListeners() throws SchedulerException {
        SchedulerListener listener;
        int n;
        int n2;
        SchedulerListener[] schedulerListenerArray;
        if (this.schedulerListeners != null) {
            schedulerListenerArray = this.schedulerListeners;
            n2 = this.schedulerListeners.length;
            n = 0;
            while (n < n2) {
                listener = schedulerListenerArray[n];
                this.getScheduler().addSchedulerListener(listener);
                ++n;
            }
        }
        if (this.globalJobListeners != null) {
            schedulerListenerArray = this.globalJobListeners;
            n2 = this.globalJobListeners.length;
            n = 0;
            while (n < n2) {
                listener = schedulerListenerArray[n];
                this.getScheduler().addGlobalJobListener((JobListener)listener);
                ++n;
            }
        }
        if (this.jobListeners != null) {
            schedulerListenerArray = this.jobListeners;
            n2 = this.jobListeners.length;
            n = 0;
            while (n < n2) {
                listener = schedulerListenerArray[n];
                this.getScheduler().addJobListener((JobListener)listener);
                ++n;
            }
        }
        if (this.globalTriggerListeners != null) {
            schedulerListenerArray = this.globalTriggerListeners;
            n2 = this.globalTriggerListeners.length;
            n = 0;
            while (n < n2) {
                listener = schedulerListenerArray[n];
                this.getScheduler().addGlobalTriggerListener((TriggerListener)listener);
                ++n;
            }
        }
        if (this.triggerListeners != null) {
            schedulerListenerArray = this.triggerListeners;
            n2 = this.triggerListeners.length;
            n = 0;
            while (n < n2) {
                listener = schedulerListenerArray[n];
                this.getScheduler().addTriggerListener((TriggerListener)listener);
                ++n;
            }
        }
    }

    protected abstract Scheduler getScheduler();
}

