/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityManagerFactoryAccessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EntityManagerFactory entityManagerFactory;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map<String, Object> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    protected EntityManager createEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "No EntityManagerFactory specified");
        Map<String, Object> properties = this.getJpaPropertyMap();
        return !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
    }

    protected EntityManager getTransactionalEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "No EntityManagerFactory specified");
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, this.getJpaPropertyMap());
    }
}

