/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import org.springframework.mock.web.portlet.MockCacheControl;
import org.springframework.mock.web.portlet.MockPortletResponse;
import org.springframework.mock.web.portlet.MockPortletURL;
import org.springframework.mock.web.portlet.MockResourceURL;
import org.springframework.util.CollectionUtils;

public class MockMimeResponse
extends MockPortletResponse
implements MimeResponse {
    private PortletRequest request;
    private String contentType;
    private String characterEncoding = "ISO-8859-1";
    private PrintWriter writer;
    private Locale locale = Locale.getDefault();
    private int bufferSize = 4096;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final CacheControl cacheControl = new MockCacheControl();
    private boolean committed;
    private String includedUrl;
    private String forwardedUrl;

    public MockMimeResponse() {
    }

    public MockMimeResponse(PortalContext portalContext) {
        super(portalContext);
    }

    public MockMimeResponse(PortalContext portalContext, PortletRequest request) {
        super(portalContext);
        this.request = request;
    }

    public void setContentType(String contentType) {
        Enumeration supportedTypes;
        if (this.request != null && !CollectionUtils.contains(supportedTypes = this.request.getResponseContentTypes(), (Object)contentType)) {
            throw new IllegalArgumentException("Content type [" + contentType + "] not in supported list: " + Collections.list(supportedTypes));
        }
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.outputStream, this.characterEncoding) : new OutputStreamWriter(this.outputStream);
            this.writer = new PrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.outputStream.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.outputStream.toString(this.characterEncoding) : this.outputStream.toString();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        this.committed = true;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.outputStream.reset();
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentType = null;
        this.locale = null;
    }

    public OutputStream getPortletOutputStream() throws IOException {
        return this.outputStream;
    }

    public PortletURL createRenderURL() {
        return new MockPortletURL(this.getPortalContext(), "render");
    }

    public PortletURL createActionURL() {
        return new MockPortletURL(this.getPortalContext(), "action");
    }

    public ResourceURL createResourceURL() {
        return new MockResourceURL();
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }
}

