/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.NotificationTask;
import org.snmp4j.agent.ProxyForwardRequest;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.ProxyMap;
import org.snmp4j.agent.RequestHandler;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.mo.snmp.CoexistenceInfoProvider;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestFactory;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.agent.util.TemporaryList;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.util.WorkerTask;

public class CommandProcessor
implements CommandResponder,
NotificationOriginator {
    private static final LogAdapter logger = LogFactory.getLogger(CommandProcessor.class);
    private static final int MAX_INTERNAL_REQUEST_TIMEOUT = 300000;
    protected WorkerPool threadPool = null;
    protected VACM vacm = null;
    protected Vector moServers;
    protected OctetString ownContextEngineID;
    protected Vector pduHandler;
    protected TemporaryList requestList;
    protected RequestFactory requestFactory;
    protected NotificationOriginator notificationOriginator;
    protected ProxyMap proxyForwarder;
    protected CoexistenceInfoProvider coexistenceProvider;
    private transient Vector counterListeners;

    public CommandProcessor(OctetString contextEngineID) {
        this.ownContextEngineID = contextEngineID;
        this.moServers = new Vector();
        this.requestList = new TemporaryList(300000);
        this.pduHandler = new Vector();
        this.pduHandler.add(new GetHandler());
        this.pduHandler.add(new GetNextHandler());
        this.pduHandler.add(new SetHandler());
        this.pduHandler.add(new GetBulkHandler());
        this.requestFactory = new DefaultRequestFactory();
    }

    public void setInternalRequestTimeout(int timeoutMillis) {
        this.requestList.setTimeout(timeoutMillis);
    }

    public int getInternalRequestTimeout() {
        return this.requestList.getTimeout();
    }

    public void processPdu(CommandResponderEvent event) {
        if (event.getPDU() != null) {
            CoexistenceInfo cinfo = null;
            OctetString sname = new OctetString(event.getSecurityName());
            if (event.getPDU() instanceof ScopedPDU) {
                ScopedPDU spdu = (ScopedPDU)event.getPDU();
                cinfo = new CoexistenceInfo(sname, spdu.getContextEngineID(), spdu.getContextName());
            } else if (this.coexistenceProvider != null) {
                CoexistenceInfo[] cinfos = this.coexistenceProvider.getCoexistenceInfo(sname);
                if (cinfos != null && cinfos.length > 0) {
                    for (int i = 0; i < cinfos.length; ++i) {
                        if (!this.coexistenceProvider.passesFilter(event.getPeerAddress(), cinfos[i])) continue;
                        cinfo = cinfos[i];
                        break;
                    }
                    if (cinfo == null) {
                        logger.warn("Access attempt from " + event.getPeerAddress() + " denied because of source address filtering");
                        this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpInBadCommunityNames));
                        return;
                    }
                    event.setMaxSizeResponsePDU(cinfo.getMaxMessageSize());
                } else {
                    if (logger.isInfoEnabled()) {
                        logger.info("Community name '" + sname + "' not found in SNMP-COMMUNITY-MIB");
                    }
                    this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpInBadCommunityNames));
                    return;
                }
            }
            if (cinfo == null || this.ownContextEngineID.equals(cinfo.getContextEngineID())) {
                event.setProcessed(true);
                Command command = new Command(event, cinfo);
                if (this.threadPool != null) {
                    this.threadPool.execute(command);
                } else {
                    command.run();
                }
            } else if (this.proxyForwarder != null) {
                ProxyForwardRequest request = new ProxyForwardRequest(event, cinfo);
                ProxyForwarder proxy = this.proxyForwarder.get(cinfo.getContextEngineID(), request.getProxyType());
                ProxyCommand command = new ProxyCommand(proxy, request);
                if (proxy != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processsing proxy request with proxy forwarder " + proxy);
                    }
                    if (this.threadPool != null) {
                        this.threadPool.execute(command);
                    } else {
                        command.run();
                    }
                } else {
                    this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpProxyDrops));
                }
            } else {
                this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpSilentDrops));
            }
        }
    }

    public void setThreadPool(WorkerPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setWorkerPool(WorkerPool threadPool) {
        this.threadPool = threadPool;
    }

    public VACM getVacm() {
        return this.vacm;
    }

    public void setVacm(VACM vacm) {
        this.vacm = vacm;
    }

    public OctetString getContextEngineID() {
        return this.ownContextEngineID;
    }

    public void setContextEngineID(OctetString contextEngineID) {
        this.ownContextEngineID = contextEngineID;
    }

    public Object notify(OctetString context, OID notificationID, VariableBinding[] vbs) {
        return this.notify(context, notificationID, null, vbs);
    }

    public Object notify(OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs) {
        if (this.notificationOriginator != null) {
            NotificationTask notifyTask = new NotificationTask(this.notificationOriginator, context, notificationID, sysUpTime, vbs);
            if (this.threadPool != null) {
                this.threadPool.execute(notifyTask);
                return notifyTask;
            }
            notifyTask.run();
            return notifyTask.getResponses();
        }
        logger.warn("Could not sent notification '" + notificationID + "'=" + Arrays.asList(vbs) + " because NotificationOriginator not set");
        return null;
    }

    public void setNotificationOriginator(NotificationOriginator notificationOriginator) {
        this.notificationOriginator = notificationOriginator;
    }

    public void setCoexistenceProvider(CoexistenceInfoProvider coexistenceProvider) {
        this.coexistenceProvider = coexistenceProvider;
    }

    public ProxyForwarder addProxyForwarder(ProxyForwarder proxyForwarder, OctetString contextEngineID, int proxyType) {
        if (this.proxyForwarder == null) {
            this.proxyForwarder = new ProxyMap();
        }
        return this.proxyForwarder.add(proxyForwarder, contextEngineID, proxyType);
    }

    public ProxyForwarder removeProxyForwarder(OctetString contextEngineID, int proxyType) {
        if (this.proxyForwarder != null) {
            return this.proxyForwarder.remove(contextEngineID, proxyType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestHandler getHandler(int pduType) {
        Vector vector = this.pduHandler;
        synchronized (vector) {
            for (int i = 0; i < this.pduHandler.size(); ++i) {
                RequestHandler handler = (RequestHandler)this.pduHandler.get(i);
                if (!handler.isSupported(pduType)) continue;
                return handler;
            }
        }
        return null;
    }

    protected void dispatchCommand(CommandResponderEvent command, CoexistenceInfo cinfo) {
        RequestHandler handler = this.getHandler(command.getPDU().getType());
        if (handler != null) {
            this.processRequest(command, cinfo, handler);
        } else {
            this.sendUnknownPDUHandlersReport(command);
        }
    }

    private void sendUnknownPDUHandlersReport(CommandResponderEvent command) {
        logger.info("No PDU handler found for request " + command);
        CounterEvent counter = new CounterEvent(this, SnmpConstants.snmpUnknownPDUHandlers);
        this.fireIncrementCounter(counter);
        if (command.getMessageProcessingModel() == 3 && command.getPDU() instanceof ScopedPDU) {
            ScopedPDU request = (ScopedPDU)command.getPDU();
            ScopedPDU report = new ScopedPDU();
            report.setContextEngineID(request.getContextEngineID());
            report.setContextName(request.getContextName());
            report.setType(-88);
            report.add(new VariableBinding(counter.getOid(), counter.getCurrentValue()));
            this.sendResponse(command, report);
        } else {
            PDU resp = (PDU)command.getPDU().clone();
            resp.setErrorStatus(5);
            this.sendResponse(command, resp);
        }
    }

    protected void processRequest(CommandResponderEvent command, CoexistenceInfo cinfo, RequestHandler handler) {
        Request req = this.requestFactory.createRequest(command, cinfo);
        this.requestList.add(req);
        MOServer server = null;
        OctetString context = req.getContext();
        OctetString viewName = this.getViewName(command, cinfo, req.getViewType());
        if (viewName == null) {
            this.setAuthorizationError(req, 2);
        } else {
            req.setViewName(viewName);
            server = this.getServer(context);
            this.processRequest(server, handler, req);
        }
        this.finalizeRequest(command, req, server);
    }

    protected void reprocessRequest(MOServer server, SnmpRequest req) {
        RequestHandler handler = this.getHandler(req.getInitiatingEvent().getPDU().getType());
        if (handler != null) {
            req.resetProcessedStatus();
            req.incReprocessCounter();
            this.processRequest(server, handler, req);
        } else {
            this.sendUnknownPDUHandlersReport(req.getInitiatingEvent());
        }
    }

    protected void processRequest(MOServer server, RequestHandler handler, Request req) {
        if (server == null) {
            logger.error("No server for " + req.getContext() + " found -> request cannot be processed");
            req.setErrorStatus(5);
        } else {
            handler.processPdu(req, server);
        }
    }

    protected void finalizeRequest(CommandResponderEvent command, Request req, MOServer server) {
        if (req.isComplete()) {
            this.requestList.remove(req);
            this.sendResponse(command, (PDU)req.getResponse());
            if (server != null) {
                this.release(server, req);
            }
        }
    }

    protected void release(MOServer server, Request req) {
        Iterator it = req.iterator();
        while (it.hasNext()) {
            SubRequest sreq = (SubRequest)it.next();
            if (sreq.getTargetMO() == null) continue;
            server.unlock(req, sreq.getTargetMO());
        }
    }

    protected void sendResponse(CommandResponderEvent requestEvent, PDU response) {
        MessageDispatcher disp = requestEvent.getMessageDispatcher();
        try {
            if (response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                if (response.getType() != -88) {
                    if (requestEvent.getPDU().getType() == -91) {
                        while (response.size() > 0 && response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                            response.trim();
                        }
                    } else {
                        response.clear();
                        response.setRequestID(requestEvent.getPDU().getRequestID());
                        response.setErrorStatus(1);
                    }
                }
                if (response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                    this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpSilentDrops));
                    return;
                }
            }
            StatusInformation status = new StatusInformation();
            StateReference stateRef = requestEvent.getStateReference();
            if (stateRef == null) {
                logger.warn("No state reference available for requestEvent=" + requestEvent + ". Cannot return response=" + response);
            } else {
                stateRef.setTransportMapping(requestEvent.getTransportMapping());
                disp.returnResponsePdu(requestEvent.getMessageProcessingModel(), requestEvent.getSecurityModel(), requestEvent.getSecurityName(), requestEvent.getSecurityLevel(), response, requestEvent.getMaxSizeResponsePDU(), requestEvent.getStateReference(), status);
            }
        }
        catch (MessageException ex) {
            logger.error("Failed to send response to request " + requestEvent, ex);
        }
    }

    protected void setAuthorizationError(Request req, int vacmStatus) {
        if (req.size() > 0) {
            SubRequest sreq = (SubRequest)req.iterator().next();
            sreq.getStatus().setErrorStatus(16);
        } else {
            req.setErrorStatus(16);
        }
    }

    public void addPduHandler(RequestHandler handler) {
        this.pduHandler.add(handler);
    }

    public void removePduHandler(RequestHandler handler) {
        this.pduHandler.remove(handler);
    }

    public void addMOServer(MOServer server) {
        this.moServers.add(server);
    }

    public void removeMOServer(MOServer server) {
        this.moServers.remove(server);
    }

    public MOServer getServer(OctetString context) {
        for (int i = 0; i < this.moServers.size(); ++i) {
            MOServer s = (MOServer)this.moServers.get(i);
            if (!s.isContextSupported(context)) continue;
            return s;
        }
        return null;
    }

    public TemporaryList getRequestList() {
        return this.requestList;
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public ProxyMap getProxyForwarder() {
        return this.proxyForwarder;
    }

    public CoexistenceInfoProvider getCoexistenceProvider() {
        return this.coexistenceProvider;
    }

    protected OctetString getViewName(CommandResponderEvent req, CoexistenceInfo cinfo, int viewType) {
        OctetString viewName = this.vacm.getViewName(cinfo.getContextName(), cinfo.getSecurityName(), req.getSecurityModel(), req.getSecurityLevel(), viewType);
        return viewName;
    }

    protected void processNextSubRequest(Request request, MOServer server, OctetString context, SubRequest sreq) throws NoSuchElementException {
        DefaultMOContextScope scope = (DefaultMOContextScope)sreq.getScope();
        MOQuery query = sreq.getQuery();
        if (query == null) {
            query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName());
            sreq.setQuery(query);
        }
        while (!sreq.getStatus().isProcessed()) {
            ManagedObject mo = server.lookup(query);
            if (mo == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("EndOfMibView at scope=" + scope + " and query " + query);
                }
                sreq.getVariableBinding().setVariable(Null.endOfMibView);
                sreq.getStatus().setPhaseComplete(true);
                continue;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing NEXT query " + query + " with " + mo + " sub-request with index " + sreq.getIndex());
                }
                boolean counter64Skip = false;
                if (mo.next(sreq) && !(counter64Skip = request.getMessageProcessingModel() == 0 && sreq.getVariableBinding().getSyntax() == 70)) continue;
                sreq.getVariableBinding().setVariable(Null.instance);
                if (counter64Skip) {
                    scope.lowerBound = sreq.getVariableBinding().getOid();
                    scope.lowerIncluded = false;
                    sreq.getStatus().setProcessed(false);
                    continue;
                }
                scope.substractScope(mo.getScope());
                query.substractScope(mo.getScope());
            }
            catch (Exception moex) {
                if (logger.isDebugEnabled()) {
                    moex.printStackTrace();
                }
                logger.error("Exception occurred while executing NEXT query: " + moex.getMessage(), moex);
                if (sreq.getStatus().getErrorStatus() == 0) {
                    sreq.getStatus().setErrorStatus(5);
                }
                if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                throw new RuntimeException(moex);
            }
        }
    }

    public synchronized void addCounterListener(CounterListener l) {
        if (this.counterListeners == null) {
            this.counterListeners = new Vector(2);
        }
        this.counterListeners.add(l);
    }

    public synchronized void removeCounterListener(CounterListener l) {
        if (this.counterListeners != null) {
            this.counterListeners.remove(l);
        }
    }

    protected void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            Vector listeners = this.counterListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((CounterListener)listeners.elementAt(i)).incrementCounter(event);
            }
        }
    }

    private static void initRequestPhase(Request request) {
        if (request.getPhase() == -1) {
            request.nextPhase();
        }
    }

    static class DefaultRequestFactory
    implements RequestFactory {
        DefaultRequestFactory() {
        }

        public Request createRequest(EventObject initiatingEvent, CoexistenceInfo cinfo) {
            return new SnmpRequest((CommandResponderEvent)initiatingEvent, cinfo);
        }
    }

    class VACMQuery
    extends DefaultMOQuery {
        private OctetString viewName;

        public VACMQuery(OctetString context, OID lowerBound, boolean isLowerIncluded, OID upperBound, boolean isUpperIncluded, OctetString viewName) {
            super(new DefaultMOContextScope(context, lowerBound, isLowerIncluded, upperBound, isUpperIncluded));
            this.viewName = viewName;
        }

        public VACMQuery(OctetString context, OID lowerBound, boolean isLowerIncluded, OID upperBound, boolean isUpperIncluded, OctetString viewName, boolean isWriteAccessIntended, Object source) {
            super(new DefaultMOContextScope(context, lowerBound, isLowerIncluded, upperBound, isUpperIncluded), isWriteAccessIntended, source);
            this.viewName = viewName;
        }

        public boolean isSearchQuery() {
            MOContextScope scope = this.getScope();
            return !scope.isLowerIncluded() && (scope.getUpperBound() == null || !scope.getUpperBound().equals(scope.getLowerBound()));
        }

        public boolean matchesQuery(ManagedObject managedObject) {
            OID oid;
            if (this.isSearchQuery()) {
                oid = managedObject.find(this.getScope());
                if (oid == null) {
                    return false;
                }
            } else {
                oid = this.getScope().getLowerBound();
            }
            return CommandProcessor.this.vacm.isAccessAllowed(this.viewName, oid) == 0;
        }

        public boolean isAccessAllowed(OID oid) {
            return CommandProcessor.this.vacm.isAccessAllowed(this.viewName, oid) == 0;
        }

        public String toString() {
            return super.toString() + "[viewName=" + this.viewName + "]";
        }
    }

    class GetBulkHandler
    implements RequestHandler {
        GetBulkHandler() {
        }

        public boolean isSupported(int pduType) {
            return pduType == -91;
        }

        public void processPdu(Request request, MOServer server) {
            block5: {
                CommandProcessor.initRequestPhase(request);
                OctetString context = request.getContext();
                SnmpRequest req = (SnmpRequest)request;
                int nonRep = req.getNonRepeaters();
                try {
                    SubRequest sreq;
                    int i;
                    SubRequestIterator it = (SubRequestIterator)request.iterator();
                    for (i = 0; i < nonRep && it.hasNext(); ++i) {
                        sreq = it.nextSubRequest();
                        if (sreq.isComplete()) continue;
                        CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                    }
                    while (it.hasNext()) {
                        sreq = it.nextSubRequest();
                        if (!sreq.isComplete()) {
                            CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                            sreq.updateNextRepetition();
                        }
                        ++i;
                    }
                }
                catch (NoSuchElementException nsex) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("GETBULK request response PDU size limit reached");
                }
            }
        }
    }

    class GetHandler
    implements RequestHandler {
        GetHandler() {
        }

        public boolean isSupported(int pduType) {
            return pduType == -96;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void processPdu(Request request, MOServer server) {
            CommandProcessor.initRequestPhase(request);
            OctetString context = request.getContext();
            try {
                SubRequestIterator it = (SubRequestIterator)request.iterator();
                while (it.hasNext()) {
                    ManagedObject mo;
                    SubRequest sreq = it.nextSubRequest();
                    MOScope scope = sreq.getScope();
                    MOQuery query = sreq.getQuery();
                    if (query == null) {
                        query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName());
                        sreq.setQuery(query);
                    }
                    if ((mo = server.lookup(query)) == null) {
                        sreq.getVariableBinding().setVariable(Null.noSuchObject);
                        sreq.getStatus().setPhaseComplete(true);
                        continue;
                    }
                    try {
                        mo.get(sreq);
                        if (request.getMessageProcessingModel() != 0 || sreq.getVariableBinding().getSyntax() != 70) continue;
                        sreq.getVariableBinding().setVariable(Null.noSuchInstance);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.warn(moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(5);
                        }
                        if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error("SubRequest not found");
                request.setErrorStatus(5);
            }
        }
    }

    class SetHandler
    implements RequestHandler {
        SetHandler() {
        }

        public void prepare(OctetString context, Request request, MOServer server) {
            try {
                SubRequestIterator it = (SubRequestIterator)request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    SubRequest sreq = it.nextSubRequest();
                    if (sreq.isComplete()) continue;
                    MOScope scope = sreq.getScope();
                    MOQuery query = sreq.getQuery();
                    if (query == null) {
                        query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName());
                        sreq.setQuery(query);
                    }
                    if (!query.getScope().isCovered(new DefaultMOContextScope(context, scope))) {
                        sreq.getStatus().setErrorStatus(6);
                        continue;
                    }
                    ManagedObject mo = server.lookup(query);
                    if (mo == null) {
                        if (query instanceof VACMQuery && !((VACMQuery)query).isAccessAllowed(scope.getLowerBound())) {
                            sreq.getStatus().setErrorStatus(6);
                        } else {
                            sreq.getStatus().setErrorStatus(11);
                        }
                        break;
                    }
                    sreq.setTargetMO(mo);
                    if (server.lock(sreq.getRequest(), mo, CommandProcessor.this.requestList.getTimeout())) {
                        try {
                            mo.prepare(sreq);
                            continue;
                        }
                        catch (Exception moex) {
                            logger.error("Set request " + request + " failed with exception", moex);
                            if (sreq.getStatus().getErrorStatus() == 0) {
                                sreq.getStatus().setErrorStatus(5);
                            }
                            if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                            throw new RuntimeException(moex);
                        }
                    }
                    logger.warn("Set request " + request + " failed because " + mo + " could not be locked");
                    if (sreq.getStatus().getErrorStatus() != 0) continue;
                    sreq.getStatus().setErrorStatus(5);
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error("Cannot find sub-request: ", nsex);
                request.setErrorStatus(5);
            }
        }

        public void processPdu(Request request, MOServer server) {
            OctetString context;
            block10: {
                context = request.getContext();
                try {
                    while (request.getPhase() < 4) {
                        int phase = request.nextPhase();
                        switch (phase) {
                            case 1: {
                                this.prepare(context, request, server);
                                break;
                            }
                            case 2: {
                                this.commit(context, request, server);
                                break;
                            }
                            case 3: {
                                this.undo(context, request, server);
                                break;
                            }
                            case 4: {
                                this.cleanup(context, request, server);
                                return;
                            }
                        }
                        if (request.isPhaseComplete()) continue;
                        return;
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        ex.printStackTrace();
                    }
                    logger.error("Failed to process SET request, trying to clean it up...", ex);
                    if (!SNMP4JSettings.isFowardRuntimeExceptions()) break block10;
                    throw new RuntimeException(ex);
                }
            }
            this.cleanup(context, request, server);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void undo(OctetString context, Request request, MOServer server) {
            try {
                SubRequestIterator it = (SubRequestIterator)request.iterator();
                while (it.hasNext()) {
                    SubRequest sreq = it.nextSubRequest();
                    if (sreq.isComplete()) continue;
                    OID oid = sreq.getVariableBinding().getOid();
                    ManagedObject mo = sreq.getTargetMO();
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        mo = server.lookup(new DefaultMOQuery(scope, true, request));
                    }
                    if (mo == null) {
                        sreq.getStatus().setErrorStatus(15);
                        continue;
                    }
                    try {
                        mo.undo(sreq);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error(moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(15);
                        }
                        if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error("Cannot find sub-request: ", nsex);
                request.setErrorStatus(5);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void commit(OctetString context, Request request, MOServer server) {
            try {
                SubRequestIterator it = (SubRequestIterator)request.iterator();
                while (request.getErrorStatus() == 0 && it.hasNext()) {
                    SubRequest sreq = it.nextSubRequest();
                    if (sreq.isComplete()) continue;
                    OID oid = sreq.getVariableBinding().getOid();
                    ManagedObject mo = sreq.getTargetMO();
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        mo = server.lookup(new DefaultMOQuery(scope, true, request));
                    }
                    if (mo == null) {
                        sreq.getStatus().setErrorStatus(14);
                        continue;
                    }
                    try {
                        mo.commit(sreq);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error(moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(14);
                        }
                        if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error("Cannot find sub-request: ", nsex);
                request.setErrorStatus(5);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void cleanup(OctetString context, Request request, MOServer server) {
            try {
                SubRequestIterator it = (SubRequestIterator)request.iterator();
                while (it.hasNext()) {
                    SubRequest sreq = it.nextSubRequest();
                    if (sreq.isComplete()) continue;
                    OID oid = sreq.getVariableBinding().getOid();
                    ManagedObject mo = sreq.getTargetMO();
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        mo = server.lookup(new DefaultMOQuery(scope));
                    }
                    if (mo == null) {
                        sreq.completed();
                        continue;
                    }
                    server.unlock(sreq.getRequest(), mo);
                    try {
                        mo.cleanup(sreq);
                        sreq.getStatus().setPhaseComplete(true);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error(moex);
                        if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                logger.error("Cannot find sub-request: ", nsex);
                if (!logger.isDebugEnabled()) return;
                nsex.printStackTrace();
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == -93;
        }
    }

    class GetNextHandler
    implements RequestHandler {
        GetNextHandler() {
        }

        public void processPdu(Request request, MOServer server) {
            CommandProcessor.initRequestPhase(request);
            OctetString context = request.getContext();
            try {
                SubRequestIterator it = (SubRequestIterator)request.iterator();
                while (it.hasNext()) {
                    SubRequest sreq = it.nextSubRequest();
                    CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error("SubRequest not found");
                request.setErrorStatus(5);
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == -95;
        }
    }

    class ProxyCommand
    implements WorkerTask {
        private ProxyForwardRequest request;
        private ProxyForwarder forwarder;

        public ProxyCommand(ProxyForwarder forwarder, ProxyForwardRequest event) {
            this.forwarder = forwarder;
            this.request = event;
        }

        public void run() {
            if (this.forwarder.forward(this.request)) {
                PDU response = this.request.getResponsePDU();
                if (response != null) {
                    CommandProcessor.this.sendResponse(this.request.getCommandEvent(), response);
                }
            } else if (this.request.getProxyType() != 3) {
                CounterEvent cevent = new CounterEvent(this, SnmpConstants.snmpProxyDrops);
                CommandProcessor.this.fireIncrementCounter(cevent);
                CommandResponderEvent cre = this.request.getCommandEvent();
                if (cre.getMessageProcessingModel() == 3 && cre.getStateReference() != null) {
                    ScopedPDU reportPDU = new ScopedPDU();
                    reportPDU.setType(-88);
                    reportPDU.setContextEngineID(this.request.getContextEngineID());
                    reportPDU.setContextName(this.request.getContext());
                    reportPDU.add(new VariableBinding(SnmpConstants.snmpProxyDrops, cevent.getCurrentValue()));
                    CommandProcessor.this.sendResponse(this.request.getCommandEvent(), reportPDU);
                }
            }
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }

    class Command
    implements WorkerTask {
        private CommandResponderEvent request;
        private CoexistenceInfo cinfo;

        public Command(CommandResponderEvent event, CoexistenceInfo cinfo) {
            this.request = event;
            this.cinfo = cinfo;
        }

        public void run() {
            CommandProcessor.this.dispatchCommand(this.request, this.cinfo);
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }
}

