/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.LogUtils;

public class StreamGobbler
extends Thread {
    private InputStream in = null;
    private PrintWriter pwOut = null;
    private boolean quit = false;

    public StreamGobbler() {
    }

    public StreamGobbler(InputStream in) {
        this();
        this.in = in;
        this.pwOut = new PrintWriter(System.out, true);
    }

    public StreamGobbler(InputStream in, OutputStream out) {
        this();
        this.in = in;
        this.pwOut = new PrintWriter(out, true);
    }

    public StreamGobbler(InputStream in, PrintWriter pwOut) {
        this();
        this.in = in;
        this.pwOut = pwOut;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void quit() {
        this.quit = true;
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Object cannot be deserialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(this.in);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null && !this.quit) {
                this.pwOut.println(line);
            }
        }
        catch (Throwable e) {
            try {
                LogUtils.debugf((Object)this, e, "Unable to read lines.", new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                throw throwable;
            }
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(isr);
        }
        IOUtils.closeQuietly(br);
        IOUtils.closeQuietly(isr);
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("Object cannot be serialized");
    }
}

