/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.opennms.core.utils.LogUtils;

public abstract class ParameterMap {
    public static long getKeyedLong(Map map, String key, long defValue) {
        if (map == null) {
            return defValue;
        }
        long value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            try {
                value = Long.parseLong((String)oValue);
            }
            catch (NumberFormatException ne) {
                value = defValue;
                LogUtils.infof(ParameterMap.class, ne, "getKeyedLong: Failed to convert value %s for key %s", oValue, key);
            }
            map.put(key, new Long(value));
        } else if (oValue != null) {
            value = ((Number)oValue).longValue();
        }
        return value;
    }

    public static int getKeyedInteger(Map map, String key, int defValue) {
        return new Long(ParameterMap.getKeyedLong(map, key, new Long(defValue))).intValue();
    }

    public static final int[] getKeyedIntegerArray(Map map, String key, int[] defValues) {
        if (map == null) {
            return defValues;
        }
        int[] result = defValues;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof int[]) {
            result = (int[])oValue;
        } else if (oValue != null) {
            ArrayList<Integer> tmpList = new ArrayList<Integer>(5);
            StringTokenizer ints = new StringTokenizer(oValue.toString(), " ;:,");
            while (ints.hasMoreElements()) {
                String token = ints.nextToken();
                try {
                    int x = Integer.parseInt(token);
                    tmpList.add(x);
                }
                catch (NumberFormatException e) {
                    LogUtils.warnf(ParameterMap.class, e, "getKeyedIntegerArray: failed to convert value %s to int array for key %s due to value %s", oValue, key, token);
                }
            }
            result = new int[tmpList.size()];
            for (int x = 0; x < result.length; ++x) {
                result[x] = (Integer)tmpList.get(x);
            }
            map.put(key, result);
        }
        return result;
    }

    public static String getKeyedString(Map map, String key, String defValue) {
        if (map == null) {
            return defValue;
        }
        String value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            value = (String)oValue;
        } else if (oValue != null) {
            value = oValue.toString();
            map.put(key, value);
        }
        return value;
    }

    public static boolean getKeyedBoolean(Map map, String key, boolean defValue) {
        if (map == null) {
            return defValue;
        }
        boolean value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            oValue = Boolean.valueOf((String)oValue);
        }
        if (oValue != null && oValue instanceof Boolean) {
            try {
                value = (Boolean)oValue;
            }
            catch (NumberFormatException ne) {
                value = defValue;
                LogUtils.infof(ParameterMap.class, ne, "getKeyedBoolean: Failed to convert value %s for key %s", oValue, key);
            }
            map.put(key, value);
        } else if (oValue != null) {
            value = (Boolean)oValue;
        }
        return value;
    }

    public static <T> T getKeyedValue(Map<String, T> map, String key, T defValue) {
        if (map == null) {
            return defValue;
        }
        T oValue = map.get(key);
        if (oValue != null) {
            return oValue;
        }
        map.put(key, defValue);
        return defValue;
    }
}

