/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.oxm.GenericMarshaller;
import org.springframework.oxm.GenericUnmarshaller;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.mime.MimeContainer;
import org.springframework.oxm.mime.MimeMarshaller;
import org.springframework.oxm.mime.MimeUnmarshaller;
import org.springframework.oxm.support.SaxResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaxb2Marshaller
implements MimeMarshaller,
MimeUnmarshaller,
GenericMarshaller,
GenericUnmarshaller,
BeanClassLoaderAware,
InitializingBean {
    private static final String CID = "cid:";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String contextPath;
    private Class<?>[] classesToBeBound;
    private Map<String, ?> jaxbContextProperties;
    private Map<String, ?> marshallerProperties;
    private Map<String, ?> unmarshallerProperties;
    private Marshaller.Listener marshallerListener;
    private Unmarshaller.Listener unmarshallerListener;
    private ValidationEventHandler validationEventHandler;
    private XmlAdapter<?, ?>[] adapters;
    private Resource[] schemaResources;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private boolean mtomEnabled = false;
    private ClassLoader beanClassLoader;
    private JAXBContext jaxbContext;
    private Schema schema;
    private boolean lazyInit = false;

    public void setContextPaths(String ... contextPaths) {
        Assert.notEmpty(contextPaths, "'contextPaths' must not be empty");
        this.contextPath = StringUtils.arrayToDelimitedString(contextPaths, ":");
    }

    public void setContextPath(String contextPath) {
        Assert.hasText(contextPath, "'contextPath' must not be null");
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setClassesToBeBound(Class<?> ... classesToBeBound) {
        Assert.notEmpty(classesToBeBound, "'classesToBeBound' must not be empty");
        this.classesToBeBound = classesToBeBound;
    }

    public Class<?>[] getClassesToBeBound() {
        return this.classesToBeBound;
    }

    public void setJaxbContextProperties(Map<String, ?> jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    public void setMarshallerProperties(Map<String, ?> properties) {
        this.marshallerProperties = properties;
    }

    public void setUnmarshallerProperties(Map<String, ?> properties) {
        this.unmarshallerProperties = properties;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void setAdapters(XmlAdapter<?, ?>[] adapters) {
        this.adapters = adapters;
    }

    public void setSchema(Resource schemaResource) {
        this.schemaResources = new Resource[]{schemaResource};
    }

    public void setSchemas(Resource[] schemaResources) {
        this.schemaResources = schemaResources;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public final void afterPropertiesSet() throws Exception {
        if (StringUtils.hasLength(this.getContextPath()) && !ObjectUtils.isEmpty(this.getClassesToBeBound())) {
            throw new IllegalArgumentException("Specify either 'contextPath' or 'classesToBeBound property'; not both");
        }
        if (!StringUtils.hasLength(this.getContextPath()) && ObjectUtils.isEmpty(this.getClassesToBeBound())) {
            throw new IllegalArgumentException("Setting either 'contextPath' or 'classesToBeBound' is required");
        }
        if (!this.lazyInit) {
            this.getJaxbContext();
        }
        if (!ObjectUtils.isEmpty(this.schemaResources)) {
            this.schema = this.loadSchema(this.schemaResources, this.schemaLanguage);
        }
    }

    protected synchronized JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            try {
                if (StringUtils.hasLength(this.getContextPath())) {
                    this.jaxbContext = this.createJaxbContextFromContextPath();
                } else if (!ObjectUtils.isEmpty(this.getClassesToBeBound())) {
                    this.jaxbContext = this.createJaxbContextFromClasses();
                }
            }
            catch (JAXBException ex) {
                throw this.convertJaxbException(ex);
            }
        }
        return this.jaxbContext;
    }

    private JAXBContext createJaxbContextFromContextPath() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Creating JAXBContext with context path [" + this.getContextPath() + "]");
        }
        if (this.jaxbContextProperties != null) {
            if (this.beanClassLoader != null) {
                return JAXBContext.newInstance(this.getContextPath(), this.beanClassLoader, this.jaxbContextProperties);
            }
            return JAXBContext.newInstance(this.getContextPath(), ClassUtils.getDefaultClassLoader(), this.jaxbContextProperties);
        }
        if (this.beanClassLoader != null) {
            return JAXBContext.newInstance(this.getContextPath(), this.beanClassLoader);
        }
        return JAXBContext.newInstance(this.getContextPath());
    }

    private JAXBContext createJaxbContextFromClasses() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Creating JAXBContext with classes to be bound [" + StringUtils.arrayToCommaDelimitedString(this.getClassesToBeBound()) + "]");
        }
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((Class[])this.getClassesToBeBound(), this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((Class[])this.getClassesToBeBound());
    }

    private Schema loadSchema(Resource[] resources, String schemaLanguage) throws IOException, SAXException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Setting validation schema to " + StringUtils.arrayToCommaDelimitedString(this.schemaResources));
        }
        Assert.notEmpty(resources, "No resources given");
        Assert.hasLength(schemaLanguage, "No schema language provided");
        Source[] schemaSources = new Source[resources.length];
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        int i = 0;
        while (i < resources.length) {
            Assert.notNull(resources[i], "Resource is null");
            Assert.isTrue(resources[i].exists(), "Resource " + resources[i] + " does not exist");
            InputSource inputSource = SaxResourceUtils.createInputSource(resources[i]);
            schemaSources[i] = new SAXSource(xmlReader, inputSource);
            ++i;
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        return schemaFactory.newSchema(schemaSources);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return this.supportsInternal(clazz, true);
    }

    @Override
    public boolean supports(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            if (JAXBElement.class.equals((Object)parameterizedType.getRawType()) && parameterizedType.getActualTypeArguments().length == 1) {
                Type typeArgument = parameterizedType.getActualTypeArguments()[0];
                if (typeArgument instanceof Class) {
                    Class classArgument = (Class)typeArgument;
                    return this.isPrimitiveWrapper(classArgument) || this.isStandardClass(classArgument) || this.supportsInternal(classArgument, false);
                }
                if (typeArgument instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)typeArgument;
                    return arrayType.getGenericComponentType().equals(Byte.TYPE);
                }
            }
        } else if (genericType instanceof Class) {
            Class clazz = (Class)genericType;
            return this.supportsInternal(clazz, true);
        }
        return false;
    }

    private boolean supportsInternal(Class<?> clazz, boolean checkForXmlRootElement) {
        if (checkForXmlRootElement && AnnotationUtils.findAnnotation(clazz, XmlRootElement.class) == null) {
            return false;
        }
        if (StringUtils.hasLength(this.getContextPath())) {
            String[] contextPaths;
            String packageName = ClassUtils.getPackageName(clazz);
            String[] stringArray = contextPaths = StringUtils.tokenizeToStringArray(this.getContextPath(), ":");
            int n = contextPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String contextPath = stringArray[n2];
                if (contextPath.equals(packageName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (!ObjectUtils.isEmpty(this.getClassesToBeBound())) {
            return Arrays.asList(this.getClassesToBeBound()).contains(clazz);
        }
        return false;
    }

    private boolean isPrimitiveWrapper(Class<?> clazz) {
        return Boolean.class.equals(clazz) || Byte.class.equals(clazz) || Short.class.equals(clazz) || Integer.class.equals(clazz) || Long.class.equals(clazz) || Float.class.equals(clazz) || Double.class.equals(clazz);
    }

    private boolean isStandardClass(Class<?> clazz) {
        return String.class.equals(clazz) || BigInteger.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || QName.class.isAssignableFrom(clazz) || URI.class.equals(clazz) || XMLGregorianCalendar.class.isAssignableFrom(clazz) || Duration.class.isAssignableFrom(clazz) || Image.class.equals(clazz) || DataHandler.class.equals(clazz) || UUID.class.equals(clazz);
    }

    @Override
    public void marshal(Object graph, Result result) throws XmlMappingException {
        this.marshal(graph, result, null);
    }

    @Override
    public void marshal(Object graph, Result result, MimeContainer mimeContainer) throws XmlMappingException {
        try {
            Marshaller marshaller = this.createMarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                marshaller.setAttachmentMarshaller(new Jaxb2AttachmentMarshaller(mimeContainer));
            }
            if (StaxUtils.isStaxResult(result)) {
                this.marshalStaxResult(marshaller, graph, result);
            } else {
                marshaller.marshal(graph, result);
            }
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    private void marshalStaxResult(Marshaller jaxbMarshaller, Object graph, Result staxResult) throws JAXBException {
        XMLStreamWriter streamWriter = StaxUtils.getXMLStreamWriter(staxResult);
        if (streamWriter != null) {
            jaxbMarshaller.marshal(graph, streamWriter);
        } else {
            XMLEventWriter eventWriter = StaxUtils.getXMLEventWriter(staxResult);
            if (eventWriter != null) {
                jaxbMarshaller.marshal(graph, eventWriter);
            } else {
                throw new IllegalArgumentException("StAX Result contains neither XMLStreamWriter nor XMLEventConsumer");
            }
        }
    }

    protected Marshaller createMarshaller() {
        try {
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            this.initJaxbMarshaller(marshaller);
            return marshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected void initJaxbMarshaller(Marshaller marshaller) throws JAXBException {
        if (this.marshallerProperties != null) {
            for (String name : this.marshallerProperties.keySet()) {
                marshaller.setProperty(name, this.marshallerProperties.get(name));
            }
        }
        if (this.marshallerListener != null) {
            marshaller.setListener(this.marshallerListener);
        }
        if (this.validationEventHandler != null) {
            marshaller.setEventHandler(this.validationEventHandler);
        }
        if (this.adapters != null) {
            XmlAdapter<?, ?>[] xmlAdapterArray = this.adapters;
            int n = this.adapters.length;
            int n2 = 0;
            while (n2 < n) {
                XmlAdapter<?, ?> adapter = xmlAdapterArray[n2];
                marshaller.setAdapter(adapter);
                ++n2;
            }
        }
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
    }

    @Override
    public Object unmarshal(Source source) throws XmlMappingException {
        return this.unmarshal(source, null);
    }

    @Override
    public Object unmarshal(Source source, MimeContainer mimeContainer) throws XmlMappingException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                unmarshaller.setAttachmentUnmarshaller(new Jaxb2AttachmentUnmarshaller(mimeContainer));
            }
            if (StaxUtils.isStaxSource(source)) {
                return this.unmarshalStaxSource(unmarshaller, source);
            }
            return unmarshaller.unmarshal(source);
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    private Object unmarshalStaxSource(Unmarshaller jaxbUnmarshaller, Source staxSource) throws JAXBException {
        XMLStreamReader streamReader = StaxUtils.getXMLStreamReader(staxSource);
        if (streamReader != null) {
            return jaxbUnmarshaller.unmarshal(streamReader);
        }
        XMLEventReader eventReader = StaxUtils.getXMLEventReader(staxSource);
        if (eventReader != null) {
            return jaxbUnmarshaller.unmarshal(eventReader);
        }
        throw new IllegalArgumentException("StaxSource contains neither XMLStreamReader nor XMLEventReader");
    }

    protected Unmarshaller createUnmarshaller() {
        try {
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            this.initJaxbUnmarshaller(unmarshaller);
            return unmarshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected void initJaxbUnmarshaller(Unmarshaller unmarshaller) throws JAXBException {
        if (this.unmarshallerProperties != null) {
            for (String name : this.unmarshallerProperties.keySet()) {
                unmarshaller.setProperty(name, this.unmarshallerProperties.get(name));
            }
        }
        if (this.unmarshallerListener != null) {
            unmarshaller.setListener(this.unmarshallerListener);
        }
        if (this.validationEventHandler != null) {
            unmarshaller.setEventHandler(this.validationEventHandler);
        }
        if (this.adapters != null) {
            XmlAdapter<?, ?>[] xmlAdapterArray = this.adapters;
            int n = this.adapters.length;
            int n2 = 0;
            while (n2 < n) {
                XmlAdapter<?, ?> adapter = xmlAdapterArray[n2];
                unmarshaller.setAdapter(adapter);
                ++n2;
            }
        }
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
    }

    protected XmlMappingException convertJaxbException(JAXBException ex) {
        if (ex instanceof ValidationException) {
            return new ValidationFailureException("JAXB validation exception", ex);
        }
        if (ex instanceof MarshalException) {
            return new MarshallingFailureException("JAXB marshalling exception", ex);
        }
        if (ex instanceof UnmarshalException) {
            return new UnmarshallingFailureException("JAXB unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown JAXB exception", ex);
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private byte[] data;
        private String contentType;
        private int offset;
        private int length;

        private ByteArrayDataSource(String contentType, byte[] data, int offset, int length) {
            this.contentType = contentType;
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data, this.offset, this.length);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return "ByteArrayDataSource";
        }
    }

    private static class Jaxb2AttachmentMarshaller
    extends AttachmentMarshaller {
        private final MimeContainer mimeContainer;

        private Jaxb2AttachmentMarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(mimeType, data, offset, length);
            return this.addMtomAttachment(new DataHandler(dataSource), elementNamespace, elementLocalName);
        }

        public String addMtomAttachment(DataHandler dataHandler, String elementNamespace, String elementLocalName) {
            String host = this.getHost(elementNamespace, dataHandler);
            String contentId = UUID.randomUUID() + "@" + host;
            this.mimeContainer.addAttachment("<" + contentId + ">", dataHandler);
            try {
                contentId = URLEncoder.encode(contentId, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            return Jaxb2Marshaller.CID + contentId;
        }

        private String getHost(String elementNamespace, DataHandler dataHandler) {
            try {
                URI uri = new URI(elementNamespace);
                return uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                return dataHandler.getName();
            }
        }

        public String addSwaRefAttachment(DataHandler dataHandler) {
            String contentId = UUID.randomUUID() + "@" + dataHandler.getName();
            this.mimeContainer.addAttachment(contentId, dataHandler);
            return contentId;
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.convertToXopPackage();
        }
    }

    private static class Jaxb2AttachmentUnmarshaller
    extends AttachmentUnmarshaller {
        private final MimeContainer mimeContainer;

        private Jaxb2AttachmentUnmarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public byte[] getAttachmentAsByteArray(String cid) {
            try {
                DataHandler dataHandler = this.getAttachmentAsDataHandler(cid);
                return FileCopyUtils.copyToByteArray(dataHandler.getInputStream());
            }
            catch (IOException ex) {
                throw new UnmarshallingFailureException("Couldn't read attachment", ex);
            }
        }

        public DataHandler getAttachmentAsDataHandler(String contentId) {
            if (contentId.startsWith(Jaxb2Marshaller.CID)) {
                contentId = contentId.substring(Jaxb2Marshaller.CID.length());
                try {
                    contentId = URLDecoder.decode(contentId, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                contentId = String.valueOf('<') + contentId + '>';
            }
            return this.mimeContainer.getAttachment(contentId);
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.isXopPackage();
        }
    }
}

