/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.LinkedList;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.util.SchedulerTask;
import org.snmp4j.util.ThreadPool;

public class TaskScheduler
implements Runnable {
    private LogAdapter logger = LogFactory.getLogger(TaskScheduler.class);
    private static final long DEFAULT_SCHEDULER_TIMEOUT = 5L;
    private LinkedList tasks = new LinkedList();
    private ThreadPool threadPool;
    private boolean stop;
    protected long schedulerTimeout = 5L;

    public TaskScheduler(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public synchronized void addTask(SchedulerTask task) {
        this.tasks.addLast(task);
        this.notify();
    }

    public synchronized boolean removeTask(SchedulerTask task) {
        return this.tasks.remove(task);
    }

    public synchronized void clear() {
        this.tasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            boolean readyToRun = false;
            Object object = this;
            synchronized (object) {
                for (int i = 0; i < this.tasks.size(); ++i) {
                    SchedulerTask task = (SchedulerTask)this.tasks.get(i);
                    if (task.isDone()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Task '" + task + "' is done");
                        }
                        this.tasks.removeFirst();
                        continue;
                    }
                    if (!task.isReadyToRun()) continue;
                    readyToRun = true;
                    while (!this.threadPool.tryToExecute(task)) {
                        try {
                            ThreadPool threadPool = this.threadPool;
                            synchronized (threadPool) {
                                this.threadPool.wait(this.schedulerTimeout);
                            }
                        }
                        catch (InterruptedException ex) {
                            this.logger.warn("Scheduler interrupted, aborting...");
                            this.stop = true;
                            break;
                        }
                    }
                    this.tasks.addLast(this.tasks.removeFirst());
                    --i;
                }
            }
            if (readyToRun) continue;
            try {
                if (this.threadPool.isIdle()) {
                    object = this;
                    synchronized (object) {
                        this.wait(this.schedulerTimeout);
                        continue;
                    }
                }
                object = this.threadPool;
                synchronized (object) {
                    this.threadPool.wait(this.schedulerTimeout);
                }
            }
            catch (InterruptedException ex1) {
                this.logger.warn("Scheduler interrupted, aborting...");
                this.stop = true;
            }
        }
        this.logger.info("Scheduler stopped.");
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isStop() {
        return this.stop;
    }
}

