/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpAdminString;
import org.snmp4j.agent.mo.snmp.SnmpTagValue;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpNotificationMIB
implements MOGroup {
    private static final LogAdapter logger = LogFactory.getLogger(SnmpNotificationMIB.class);
    public static final OID oidSnmpNotifyEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 13, 1, 1, 1});
    public static final int colSnmpNotifyTag = 2;
    public static final int colSnmpNotifyType = 3;
    public static final int colSnmpNotifyStorageType = 4;
    public static final int colSnmpNotifyRowStatus = 5;
    public static final int idxSnmpNotifyTag = 0;
    public static final int idxSnmpNotifyType = 1;
    public static final int idxSnmpNotifyStorageType = 2;
    public static final int idxSnmpNotifyRowStatus = 3;
    private static MOTableSubIndex[] snmpNotifyEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32)};
    private static MOTableIndex snmpNotifyEntryIndex = new MOTableIndex(snmpNotifyEntryIndexes, true);
    private DefaultMOTable snmpNotifyEntry;
    private DefaultMOMutableTableModel snmpNotifyEntryModel;
    public static final OID oidSnmpNotifyFilterEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 13, 1, 3, 1});
    public static final int colSnmpNotifyFilterMask = 2;
    public static final int colSnmpNotifyFilterType = 3;
    public static final int colSnmpNotifyFilterStorageType = 4;
    public static final int colSnmpNotifyFilterRowStatus = 5;
    public static final int idxSnmpNotifyFilterSubtree = 1;
    public static final int idxSnmpNotifyFilterMask = 0;
    public static final int idxSnmpNotifyFilterType = 1;
    public static final int idxSnmpNotifyFilterStorageType = 2;
    public static final int idxSnmpNotifyFilterRowStatus = 3;
    private static MOTableSubIndex[] snmpNotifyFilterEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32), new MOTableSubIndex(6, 0, 128)};
    private static MOTableIndex snmpNotifyFilterEntryIndex = new MOTableIndex(snmpNotifyFilterEntryIndexes, true);
    private DefaultMOTable snmpNotifyFilterEntry;
    private DefaultMOMutableTableModel snmpNotifyFilterEntryModel;
    public static final OID oidSnmpNotifyFilterProfileEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 13, 1, 2, 1});
    public static final int colSnmpNotifyFilterProfileName = 1;
    public static final int colSnmpNotifyFilterProfileStorType = 2;
    public static final int colSnmpNotifyFilterProfileRowStatus = 3;
    public static final int idxSnmpNotifyFilterProfileName = 0;
    public static final int idxSnmpNotifyFilterProfileStorType = 1;
    public static final int idxSnmpNotifyFilterProfileRowStatus = 2;
    private static MOTableSubIndex[] snmpNotifyFilterProfileEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32)};
    private static MOTableIndex snmpNotifyFilterProfileEntryIndex = new MOTableIndex(snmpNotifyFilterProfileEntryIndexes, true);
    private DefaultMOTable snmpNotifyFilterProfileEntry;
    private DefaultMOMutableTableModel snmpNotifyFilterProfileEntryModel;

    public SnmpNotificationMIB() {
        this.createSnmpNotifyEntry();
        this.createSnmpNotifyFilterEntry();
        this.createSnmpNotifyFilterProfileEntry();
    }

    private void createSnmpNotifyEntry() {
        MOColumn[] snmpNotifyEntryColumns = new MOColumn[]{new SnmpTagValue(2, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(new byte[0]), true), new Enumerated(3, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2}), new StorageType(4, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(5)};
        this.snmpNotifyEntry = new DefaultMOTable(oidSnmpNotifyEntry, snmpNotifyEntryIndex, snmpNotifyEntryColumns);
        this.snmpNotifyEntryModel = new DefaultMOMutableTableModel();
        this.snmpNotifyEntryModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.snmpNotifyEntry.setModel(this.snmpNotifyEntryModel);
    }

    private void createSnmpNotifyFilterEntry() {
        MOColumn[] snmpNotifyFilterEntryColumns = new MOColumn[4];
        snmpNotifyFilterEntryColumns[0] = new MOMutableColumn(2, 4, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(new byte[0]), true);
        ((MOMutableColumn)snmpNotifyFilterEntryColumns[0]).addMOValueValidationListener(new SnmpNotifyFilterMaskValidator());
        snmpNotifyFilterEntryColumns[1] = new Enumerated(3, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2});
        snmpNotifyFilterEntryColumns[2] = new StorageType(4, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        snmpNotifyFilterEntryColumns[3] = new RowStatus(5);
        this.snmpNotifyFilterEntry = new DefaultMOTable(oidSnmpNotifyFilterEntry, snmpNotifyFilterEntryIndex, snmpNotifyFilterEntryColumns);
        this.snmpNotifyFilterEntryModel = new DefaultMOMutableTableModel();
        this.snmpNotifyFilterEntryModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.snmpNotifyFilterEntry.setModel(this.snmpNotifyFilterEntryModel);
    }

    private void createSnmpNotifyFilterProfileEntry() {
        MOColumn[] snmpNotifyFilterProfileEntryColumns = new MOColumn[]{new SnmpAdminString(1, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(), true, 1, 32), new StorageType(2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(3)};
        this.snmpNotifyFilterProfileEntry = new DefaultMOTable(oidSnmpNotifyFilterProfileEntry, snmpNotifyFilterProfileEntryIndex, snmpNotifyFilterProfileEntryColumns);
        this.snmpNotifyFilterProfileEntryModel = new DefaultMOMutableTableModel();
        this.snmpNotifyFilterProfileEntryModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.snmpNotifyFilterProfileEntry.setModel(this.snmpNotifyFilterProfileEntryModel);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmpNotifyEntry, context);
        server.register(this.snmpNotifyFilterEntry, context);
        server.register(this.snmpNotifyFilterProfileEntry, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpNotifyEntry, context);
        server.unregister(this.snmpNotifyFilterEntry, context);
        server.unregister(this.snmpNotifyFilterProfileEntry, context);
    }

    public boolean addNotifyEntry(OctetString name, OctetString tag, int type, int storageType) {
        Variable[] vbs = new Variable[this.snmpNotifyEntry.getColumnCount()];
        int n = 0;
        vbs[n++] = tag;
        vbs[n++] = new Integer32(type);
        vbs[n++] = new Integer32(storageType);
        vbs[n++] = new Integer32(1);
        OID index = name.toSubIndex(true);
        MOTableRow row = this.snmpNotifyEntry.createRow(index, vbs);
        this.snmpNotifyEntry.addRow(row);
        return true;
    }

    public DefaultMOTable getNotifyTable() {
        return this.snmpNotifyEntry;
    }

    public DefaultMOTable getNotifyFilterTable() {
        return this.snmpNotifyFilterEntry;
    }

    public DefaultMOTable getNotifyFilterProfileTable() {
        return this.snmpNotifyFilterProfileEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFilter(final OctetString filterName) {
        MOTableRowFilter selectFilter = new MOTableRowFilter(){

            public boolean passesFilter(MOTableRow row) {
                Integer32 rs = (Integer32)row.getValue(2);
                if (rs == null) {
                    return false;
                }
                return rs.getValue() == 1 && filterName.equals(row.getValue(0));
            }
        };
        DefaultMOMutableTableModel defaultMOMutableTableModel = this.snmpNotifyFilterProfileEntryModel;
        synchronized (defaultMOMutableTableModel) {
            Iterator it = this.snmpNotifyFilterProfileEntryModel.iterator(selectFilter);
            return it.hasNext();
        }
    }

    public boolean passesFilter(final OctetString filterName, OID notificationID, VariableBinding[] vbs) {
        MOTableRowFilter selectFilter = new MOTableRowFilter(){

            public boolean passesFilter(MOTableRow row) {
                Integer32 rs = (Integer32)row.getValue(2);
                if (rs == null) {
                    return false;
                }
                return rs.getValue() == 1 && filterName.equals(row.getValue(0));
            }
        };
        List profiles = this.snmpNotifyFilterProfileEntryModel.getRows(null, null, selectFilter);
        return this.passesFilter(notificationID, vbs, profiles);
    }

    public boolean passesFilter(OID paramsIndex, OID notificationID, VariableBinding[] vbs) {
        RowStatus.ActiveRowsFilter activeFilter = new RowStatus.ActiveRowsFilter(2);
        List profiles = this.snmpNotifyFilterProfileEntryModel.getRows(paramsIndex, paramsIndex.successor(), activeFilter);
        return this.passesFilter(notificationID, vbs, profiles);
    }

    private boolean passesFilter(OID notificationID, VariableBinding[] vbs, List profiles) {
        RowStatus.ActiveRowsFilter activeFilter;
        OID profileNameOIDNext;
        if (profiles.size() == 0) {
            return true;
        }
        OctetString profileName = (OctetString)((MOTableRow)profiles.get(0)).getValue(0);
        OID profileNameOID = profileName.toSubIndex(false);
        List filters = this.snmpNotifyFilterEntryModel.getRows(profileNameOID, profileNameOIDNext = profileNameOID.nextPeer(), activeFilter = new RowStatus.ActiveRowsFilter(3));
        if (filters.size() == 0) {
            return false;
        }
        TreeMap<OID, Integer32> oidMatches = new TreeMap<OID, Integer32>();
        TreeMap[] vbMatches = new TreeMap[vbs.length];
        Iterator it = filters.iterator();
        while (it.hasNext()) {
            MOTableRow row = (MOTableRow)it.next();
            Variable[] indexValues = snmpNotifyFilterEntryIndex.getIndexValues(row.getIndex());
            OID subtree = (OID)indexValues[1];
            OctetString mask = (OctetString)row.getValue(0);
            Integer32 type = (Integer32)row.getValue(1);
            OID subtreeWithLength = new OID();
            subtreeWithLength.append(subtree.size());
            subtreeWithLength.append(subtree);
            if (SnmpNotificationMIB.isInSubtree(notificationID, subtree, mask)) {
                oidMatches.put(subtreeWithLength, type);
            }
            for (int i = 0; i < vbs.length; ++i) {
                if (!SnmpNotificationMIB.isInSubtree(vbs[i].getOid(), subtree, mask)) continue;
                if (vbMatches[i] == null) {
                    vbMatches[i] = new TreeMap();
                }
                vbMatches[i].put(subtreeWithLength, type);
            }
        }
        if (oidMatches.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Filter " + profileName + " has no matches for notification ID " + notificationID);
            }
            return false;
        }
        if (((Integer32)oidMatches.get(oidMatches.lastKey())).getValue() == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("Notification ID " + notificationID + " is excluded from filter " + profileName);
            }
            return false;
        }
        for (int i = 0; i < vbMatches.length; ++i) {
            if (vbMatches[i] == null || vbMatches[i].size() <= 0 || ((Integer32)vbMatches[i].get(vbMatches[i].lastKey())).getValue() != 2) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Variable binding " + vbs[i] + " is not in filter " + profileName);
            }
            return false;
        }
        return true;
    }

    private static boolean isInSubtree(OID oid, OID subtree, OctetString mask) {
        OID maskedSubtree = subtree.mask(mask);
        OID maskedOID = oid.mask(mask);
        if (maskedOID.equals(maskedSubtree)) {
            return true;
        }
        return maskedOID.startsWith(maskedSubtree);
    }

    static class SnmpNotifyFilterMaskValidator
    implements MOValueValidationListener {
        SnmpNotifyFilterMaskValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 16) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    public static final class SnmpNotifyFilterTypeEnum {
        public static final int included = 1;
        public static final int excluded = 2;
    }

    public static final class SnmpNotifyTypeEnum {
        public static final int trap = 1;
        public static final int inform = 2;
    }
}

