/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;

public class DBUtils {
    private final Set<Statement> m_statements = Collections.synchronizedSet(new HashSet());
    private final Set<ResultSet> m_resultSets = Collections.synchronizedSet(new HashSet());
    private final Set<Connection> m_connections = Collections.synchronizedSet(new HashSet());
    private Class<?> m_loggingClass;

    public DBUtils() {
        this(DBUtils.class);
    }

    public DBUtils(Class<?> loggingClass) {
        this.m_loggingClass = loggingClass;
    }

    public DBUtils(Class<?> loggingClass, Object ... targets) {
        this(loggingClass);
        for (Object o : targets) {
            this.watch(o);
        }
    }

    public DBUtils setLoggingClass(Class<?> c) {
        this.m_loggingClass = c;
        return this;
    }

    public DBUtils watch(Object o) {
        if (o instanceof Statement) {
            this.m_statements.add((Statement)o);
        } else if (o instanceof ResultSet) {
            this.m_resultSets.add((ResultSet)o);
        } else if (o instanceof Connection) {
            this.m_connections.add((Connection)o);
        }
        return this;
    }

    public void cleanUp() {
        for (ResultSet rs : this.m_resultSets) {
            if (rs == null) continue;
            try {
                rs.close();
            }
            catch (Throwable e) {
                this.log().warn("Unable to close result set", e);
            }
        }
        this.m_resultSets.clear();
        for (Statement s : this.m_statements) {
            if (s == null) continue;
            try {
                s.close();
            }
            catch (Throwable e) {
                this.log().warn("Unable to close statement", e);
            }
        }
        this.m_statements.clear();
        for (Connection c : this.m_connections) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable e) {
                this.log().warn("Unable to close connection", e);
            }
        }
        this.m_connections.clear();
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.m_loggingClass);
    }
}

