/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.PollAnticipator;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.xml.event.Event;

public class MockPathOutage
extends MockElement {
    int m_nodeId;
    InetAddress m_ipAddr;
    String m_svcName;
    int m_lostEventId;
    int m_regainedEventId;
    Timestamp m_lostEventTime;
    Timestamp m_regainedEventTime;
    private int m_pollCount;
    private List<PollAnticipator> m_triggers = new ArrayList<PollAnticipator>();

    public MockPathOutage(MockNetwork parent, int nodeId, InetAddress ipAddr, String svcName) {
        super(parent);
        this.m_nodeId = nodeId;
        this.m_ipAddr = ipAddr;
        this.m_svcName = svcName;
    }

    public MockPathOutage(MockNetwork parent, MockService svc) {
        this(parent, svc.getNodeId(), InetAddressUtils.addr((String)svc.getIpAddr()), svc.getSvcName());
    }

    public void setLostEvent(int eventId, Timestamp eventTime) {
        this.m_lostEventId = eventId;
        this.m_lostEventTime = eventTime;
    }

    public void setRegainedEvent(int eventId, Timestamp eventTime) {
        this.m_regainedEventId = eventId;
        this.m_regainedEventTime = eventTime;
    }

    public boolean isForService(MockService svc) {
        return this.m_nodeId == svc.getNodeId() && this.m_ipAddr.equals(svc.getIpAddr()) && this.m_svcName == svc.getNodeLabel();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "Outage[" + this.m_nodeId + "/" + this.m_ipAddr + "/" + (this.m_svcName == null ? "" + this.m_svcName : this.m_svcName) + " cause: " + this.m_lostEventId + " resolution: " + this.m_regainedEventId + " ]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof MockPathOutage)) {
            return false;
        }
        MockPathOutage outage = (MockPathOutage)o;
        return this.m_nodeId == outage.m_nodeId && this.m_ipAddr.equals(outage.m_ipAddr) && this.m_svcName == outage.m_svcName && this.m_lostEventId == outage.m_lostEventId && (this.m_lostEventTime == null ? outage.m_lostEventTime == null : this.m_lostEventTime.equals(outage.m_lostEventTime)) && this.m_regainedEventId == outage.m_regainedEventId && (this.m_regainedEventTime == null ? outage.m_regainedEventTime == null : this.m_regainedEventTime.equals(outage.m_regainedEventTime));
    }

    public String toDetailedString() {
        return "Outage[" + this.m_nodeId + ":" + this.m_ipAddr + ":" + this.m_svcName + ":" + this.m_lostEventId + ":" + this.m_lostEventTime + ":" + this.m_regainedEventId + ":" + this.m_regainedEventTime + "]";
    }

    @Override
    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitPathOutage(this);
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(int nodeId) {
        this.m_nodeId = nodeId;
    }

    public InetAddress getIpAddress() {
        return this.m_ipAddr;
    }

    public void setIpAddress(InetAddress ipAddr) {
        this.m_ipAddr = ipAddr;
    }

    public String getServiceName() {
        return this.m_svcName;
    }

    public void setServiceName(String svcName) {
        this.m_svcName = svcName;
    }

    @Override
    public void addAnticipator(PollAnticipator trigger) {
        this.m_triggers.add(trigger);
    }

    @Override
    Object getKey() {
        return this.m_svcName;
    }

    @Override
    public int getPollCount() {
        return this.m_pollCount;
    }

    @Override
    public PollStatus getPollStatus() {
        return PollStatus.up();
    }

    @Override
    public void removeAnticipator(PollAnticipator trigger) {
        this.m_triggers.remove(trigger);
    }

    @Override
    public void resetPollCount() {
        this.m_pollCount = 0;
    }

    @Override
    public Event createDownEvent() {
        return null;
    }

    @Override
    public Event createUpEvent() {
        return null;
    }

    @Override
    public Event createNewEvent() {
        return null;
    }

    @Override
    public Event createDeleteEvent() {
        return null;
    }
}

