/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class MockMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(MockMonitor.class);
    private MockNetwork m_network;
    private String m_svcName;

    public MockMonitor() {
        this.m_network = new MockNetwork();
    }

    public MockMonitor(MockNetwork network, String svcName) {
        this.m_network = network;
        this.m_svcName = svcName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService monSvc, Map<String, Object> parameters) {
        if (parameters.containsKey("status")) {
            int statusCode = MockMonitor.getKeyedInteger(parameters, (String)"status", (Integer)0);
            String reason = MockMonitor.getKeyedString(parameters, (String)"reason", null);
            return PollStatus.get((int)statusCode, (String)reason);
        }
        MockNetwork mockNetwork = this.m_network;
        synchronized (mockNetwork) {
            return this.doPoll(monSvc.getNodeId(), monSvc.getIpAddr(), this.m_svcName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollStatus doPoll(int nodeId, String ipAddr, String svcName) {
        MockNetwork mockNetwork = this.m_network;
        synchronized (mockNetwork) {
            MockService svc = this.m_network.getService(nodeId, ipAddr, svcName);
            if (svc == null) {
                LOG.info("Invalid Poll: {}/{}/{}", new Object[]{nodeId, ipAddr, svcName});
                this.m_network.receivedInvalidPoll(ipAddr, svcName);
                return PollStatus.unknown((String)"Mock.");
            }
            LOG.info("Poll: [{}/{}/{}]", new Object[]{svc.getInterface().getNode().getLabel(), ipAddr, svcName});
            PollStatus pollStatus = svc.poll();
            return PollStatus.get((int)pollStatus.getStatusCode(), (String)pollStatus.getReason());
        }
    }

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        PollStatus pollStatus = this.doPoll(svc.getNodeId(), svc.getIpAddr(), this.m_svcName);
        attributes.put("status", Integer.toString(pollStatus.getStatusCode()));
        attributes.put("reason", pollStatus.getReason());
        return attributes;
    }
}

