/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitorAdapter;

public class PollAnticipator {
    List<MockService> m_anticipatedPolls = new ArrayList<MockService>();
    List<MockService> m_unanticipatedPolls = new ArrayList<MockService>();

    public void anticipateAllServices(MockElement element) {
        MockVisitorAdapter anticipateSvcs = new MockVisitorAdapter(){

            @Override
            public void visitService(MockService svc) {
                PollAnticipator.this.anticipatePoll(svc);
            }
        };
        element.visit(anticipateSvcs);
    }

    public synchronized void anticipatePoll(MockService svc) {
        this.m_anticipatedPolls.add(svc);
    }

    public synchronized void poll(MockService service) {
        if (this.m_anticipatedPolls.contains(service)) {
            this.m_anticipatedPolls.remove(service);
        } else {
            this.m_unanticipatedPolls.add(service);
        }
        if (this.m_anticipatedPolls.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void reset() {
        this.m_anticipatedPolls.clear();
        this.m_unanticipatedPolls.clear();
    }

    public Collection<MockService> unanticipatedPolls() {
        return Collections.unmodifiableCollection(this.m_unanticipatedPolls);
    }

    private void waitFor(long millis) {
        try {
            this.wait(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized Collection<MockService> waitForAnticipated(long millis) {
        long start;
        long now = start = System.currentTimeMillis();
        while (now - start < millis) {
            if (this.m_anticipatedPolls.isEmpty()) {
                return new ArrayList<MockService>(0);
            }
            this.waitFor(millis);
            now = System.currentTimeMillis();
        }
        return Collections.unmodifiableCollection(this.m_anticipatedPolls);
    }
}

