/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.CatFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.CategoryGroup;
import org.opennms.netmgt.config.categories.Catinfo;

public class MockCategoryFactory
implements CatFactory {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private Catinfo m_config;
    private static final String CATEGORY_CONFIG = "<catinfo> <header>  <rev>1.3</rev>  <created>Wednesday, February 6, 2002 10:10:00 AM EST</created>  <mstation>checkers</mstation> </header> <categorygroup>  <name>WebConsole</name>  <comment>Service Level Availability by Functional Group</comment>  <common>   <rule><![CDATA[ipaddr IPLIKE *.*.*.*]]></rule>  </common>  <categories>   <category>    <label><![CDATA[Network Interfaces]]></label>    <comment>This is a very simple category</comment>    <normal>99</normal>    <warning>97</warning>    <service>ICMP</service>    <service>SNMP</service>    <rule><![CDATA[(isICMP | isSNMP) & (ipaddr != \"0.0.0.0\")]]></rule>   </category> <category>    <label><![CDATA[Web Servers]]></label>    <comment>This is a more complex category</comment>    <normal>99</normal>    <warning>97</warning>    <service>HTTP</service>    <service>HTTPS</service>    <rule><![CDATA[isHTTP | isHTTPS]]></rule>   </category>  </categories> </categorygroup></catinfo>";

    public MockCategoryFactory() throws IOException {
        this(CATEGORY_CONFIG);
    }

    public MockCategoryFactory(String config) throws IOException {
        this.m_config = (Catinfo)JaxbUtils.unmarshal(Catinfo.class, (String)config);
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public synchronized Catinfo getConfig() {
        return this.m_config;
    }

    public synchronized Category getCategory(String name) {
        for (CategoryGroup cg : this.m_config.getCategoryGroups()) {
            for (Category cat : cg.getCategories()) {
                if (!cat.getLabel().equals(name)) continue;
                return cat;
            }
        }
        return null;
    }

    public synchronized String getEffectiveRule(String catlabel) {
        for (CategoryGroup cg : this.m_config.getCategoryGroups()) {
            for (Category cat : cg.getCategories()) {
                if (!cat.getLabel().equals(catlabel)) continue;
                return "(" + cg.getCommon().getRule() + ") & (" + cat.getRule() + ")";
            }
        }
        return null;
    }

    public double getNormal(String catlabel) {
        return 0.0;
    }

    public double getWarning(String catlabel) {
        return 0.0;
    }
}

