/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.opennms.netmgt.mock.MockNotification;
import org.opennms.test.mock.MockUtil;

public class NotificationAnticipator {
    List<MockNotification> m_anticipated = new ArrayList<MockNotification>();
    List<MockNotification> m_unanticipated = new ArrayList<MockNotification>();
    List<MockNotification[]> m_earlyArrival = new ArrayList<MockNotification[]>();
    List<MockNotification[]> m_lateBloomers = new ArrayList<MockNotification[]>();
    long m_expectedDiff = 1000L;

    public void setExpectedDifference(long expectedDiff) {
        this.m_expectedDiff = expectedDiff;
    }

    public long getExpectedDifference() {
        return this.m_expectedDiff;
    }

    public void anticipateNotification(MockNotification mn) {
        MockUtil.println((String)("Anticipating notification: " + mn));
        this.m_anticipated.add(mn);
    }

    public synchronized void notificationReceived(MockNotification mn) {
        int i = this.m_anticipated.indexOf(mn);
        if (i != -1) {
            MockNotification notification = this.m_anticipated.get(i);
            long receivedTime = mn.getExpectedTime();
            long expectedTime = notification.getExpectedTime();
            long difference = expectedTime - receivedTime;
            if (Math.abs(difference) < this.m_expectedDiff) {
                MockUtil.println((String)("Received expected notification: " + mn));
                this.m_anticipated.remove(mn);
                this.notifyAll();
            } else {
                MockNotification[] n = new MockNotification[]{notification, mn};
                if (difference > 0L) {
                    MockUtil.println((String)("Received early notification: " + mn));
                    this.m_earlyArrival.add(n);
                } else {
                    MockUtil.println((String)("Received late notification: " + mn));
                    this.m_lateBloomers.add(n);
                }
            }
        } else {
            MockUtil.println((String)("Received unexpected notification: " + mn));
            this.m_unanticipated.add(mn);
        }
    }

    public Collection<MockNotification> getAnticipatedNotifications() {
        return Collections.unmodifiableCollection(this.m_anticipated);
    }

    public void reset() {
        this.m_anticipated = new ArrayList<MockNotification>();
        this.m_unanticipated = new ArrayList<MockNotification>();
    }

    public Collection<MockNotification> getUnanticipated() {
        return Collections.unmodifiableCollection(this.m_unanticipated);
    }

    public synchronized Collection<MockNotification> waitForAnticipated(long millis) {
        long start;
        long now = start = System.currentTimeMillis();
        for (long waitTime = millis; waitTime > 0L; waitTime -= now - start) {
            if (this.m_anticipated.isEmpty()) {
                return new ArrayList<MockNotification>(0);
            }
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        return this.getAnticipatedNotifications();
    }

    public void verifyAnticipated(long lastNotifyTime, long waitTime, long sleepTime) {
        StringBuffer problems = new StringBuffer();
        long totalWaitTime = Math.max(0L, lastNotifyTime + waitTime - System.currentTimeMillis());
        Collection<MockNotification> missingNotifications = this.waitForAnticipated(totalWaitTime);
        long now = System.currentTimeMillis();
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (missingNotifications.size() != 0) {
            problems.append(missingNotifications.size() + " expected notifications still outstanding:\n");
            problems.append(NotificationAnticipator.listNotifications("\t", missingNotifications));
        }
        if (this.getUnanticipated().size() != 0) {
            problems.append(this.getUnanticipated().size() + " unanticipated notifications received:\n");
            problems.append(NotificationAnticipator.listNotifications("\t", this.getUnanticipated()));
        }
        if (this.m_earlyArrival.size() != 0) {
            problems.append(this.m_earlyArrival.size() + " early notifications received:\n");
            problems.append(NotificationAnticipator.listNotifications("\t", this.m_earlyArrival));
        }
        if (this.m_lateBloomers.size() != 0) {
            problems.append(this.m_lateBloomers.size() + " late notifications received:\n");
            problems.append(NotificationAnticipator.listNotifications("\t", this.m_lateBloomers));
        }
        if (lastNotifyTime > now) {
            problems.append("Anticipated notifications received at " + lastNotifyTime + ", later than the last expected time of " + now + "\n");
        }
        if (problems.length() > 0) {
            problems.deleteCharAt(problems.length() - 1);
            Assert.fail((String)problems.toString());
        }
    }

    private static String listNotifications(String prefix, Collection<?> notifications) {
        StringBuffer b = new StringBuffer();
        for (Object o : notifications) {
            MockNotification notification;
            MockNotification received = null;
            if (o instanceof MockNotification[]) {
                notification = ((MockNotification[])o)[0];
                received = ((MockNotification[])o)[1];
            } else {
                notification = (MockNotification)o;
            }
            b.append(prefix);
            b.append(notification);
            if (received != null) {
                b.append(" (received: ");
                b.append(received.getExpectedTime());
                b.append(")");
            }
            b.append("\n");
        }
        return b.toString();
    }
}

