/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;

public class MockNode
extends MockContainer<MockNetwork, MockElement> {
    String m_label;
    String m_location = "Default";
    int m_nodeid;
    int m_nextIfIndex = 1;

    public MockNode(MockNetwork network, int nodeid, String label) {
        super(network);
        this.m_nodeid = nodeid;
        this.m_label = label;
    }

    public MockInterface addInterface(String ipAddr) {
        return this.addMember(new MockInterface(this, ipAddr));
    }

    public MockInterface getInterface(String ipAddr) {
        return (MockInterface)this.getMember(ipAddr);
    }

    @Override
    Object getKey() {
        return this.m_nodeid;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    @Override
    public MockNetwork getNetwork() {
        return (MockNetwork)this.getParent();
    }

    public int getNodeId() {
        return this.m_nodeid;
    }

    public int getNextIfIndex() {
        return this.m_nextIfIndex++;
    }

    public void removeInterface(MockInterface iface) {
        this.removeMember(iface);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.m_nodeid).append("label", (Object)this.m_label).append("location", (Object)this.m_location).append("members", this.getMembers()).toString();
    }

    @Override
    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitNode(this);
        this.visitMembers(v);
    }

    @Override
    public Event createUpEvent() {
        return MockEventUtil.createNodeUpEvent("Test", this);
    }

    @Override
    public Event createDownEvent() {
        return MockEventUtil.createNodeDownEvent("Test", this);
    }

    public Event createDownEventWithReason(String reason) {
        return MockEventUtil.createNodeDownEventWithReason("Test", this, reason);
    }

    @Override
    public Event createNewEvent() {
        return MockEventUtil.createNodeAddedEvent("Test", this);
    }

    @Override
    public Event createDeleteEvent() {
        return MockEventUtil.createNodeDeletedEvent("Test", this);
    }

    public Event createNodeLabelChangedEvent(String newLabel) {
        EventBuilder event = MockEventUtil.createEventBuilder("Test", "uei.opennms.org/nodes/nodeLabelChanged");
        event.setNodeid((long)this.m_nodeid);
        event.addParam("nodelabel", newLabel);
        return event.getEvent();
    }
}

