/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.PollAnticipator;
import org.opennms.netmgt.poller.PollStatus;

public abstract class MockContainer<P extends MockContainer<?, ?>, C extends MockElement>
extends MockElement {
    private volatile Map<Object, C> m_members = new HashMap<Object, C>();

    protected MockContainer(P parent) {
        super((MockContainer<?, ? extends MockElement>)parent);
    }

    @Override
    public void addAnticipator(final PollAnticipator trigger) {
        MockVisitorAdapter triggerAdder = new MockVisitorAdapter(){

            @Override
            public void visitService(MockService service) {
                service.addAnticipator(trigger);
            }
        };
        this.visit(triggerAdder);
    }

    protected C addMember(C element) {
        this.m_members.put(((MockElement)element).getKey(), element);
        ((MockElement)element).setParent(this);
        return element;
    }

    protected MockElement getMember(Object key) {
        return (MockElement)this.m_members.get(key);
    }

    protected List<C> getMembers() {
        return new ArrayList<C>(this.m_members.values());
    }

    @Override
    public int getPollCount() {
        class PollCounter
        extends MockVisitorAdapter {
            int pollCount = 0;

            PollCounter() {
            }

            int getPollCount() {
                return this.pollCount;
            }

            @Override
            public void visitService(MockService service) {
                this.pollCount += service.getPollCount();
            }
        }
        PollCounter pollCounter = new PollCounter();
        this.visit(pollCounter);
        return pollCounter.getPollCount();
    }

    @Override
    public PollStatus getPollStatus() {
        for (MockElement element : this.m_members.values()) {
            if (!element.getPollStatus().isUp()) continue;
            return PollStatus.up();
        }
        return PollStatus.down();
    }

    @Override
    public void removeAnticipator(final PollAnticipator trigger) {
        MockVisitorAdapter triggerRemover = new MockVisitorAdapter(){

            @Override
            public void visitService(MockService service) {
                service.removeAnticipator(trigger);
            }
        };
        this.visit(triggerRemover);
    }

    protected void removeMember(MockElement element) {
        this.m_members.remove(element.getKey());
        element.setParent(null);
    }

    @Override
    public void resetPollCount() {
        class PollCountReset
        extends MockVisitorAdapter {
            PollCountReset() {
            }

            @Override
            public void visitService(MockService service) {
                service.resetPollCount();
            }
        }
        PollCountReset pollCounter = new PollCountReset();
        this.visit(pollCounter);
    }

    @Override
    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitContainer(this);
    }

    protected void visitMembers(MockVisitor v) {
        for (MockElement element : this.m_members.values()) {
            element.visit(v);
        }
    }
}

