/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.Map;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class MockMonitor
implements ServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(MockMonitor.class);
    private MockNetwork m_network;
    private String m_svcName;

    public MockMonitor() {
        this.m_network = new MockNetwork();
    }

    public MockMonitor(MockNetwork network, String svcName) {
        this.m_network = network;
        this.m_svcName = svcName;
    }

    public void initialize(MonitoredService svc) {
    }

    public void initialize(Map<String, Object> parameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService monSvc, Map<String, Object> parameters) {
        MockNetwork mockNetwork = this.m_network;
        synchronized (mockNetwork) {
            int nodeId = monSvc.getNodeId();
            String ipAddr = monSvc.getIpAddr();
            MockService svc = this.m_network.getService(nodeId, ipAddr, this.m_svcName);
            if (svc == null) {
                LOG.info("Invalid Poll: {}/{}", (Object)ipAddr, (Object)this.m_svcName);
                this.m_network.receivedInvalidPoll(ipAddr, this.m_svcName);
                return PollStatus.unknown();
            }
            LOG.info("Poll: [{}/{}/{}]", new Object[]{svc.getInterface().getNode().getLabel(), ipAddr, this.m_svcName});
            PollStatus pollStatus = svc.poll();
            return PollStatus.get((int)pollStatus.getStatusCode(), (String)pollStatus.getReason());
        }
    }

    public void release() {
    }

    public void release(MonitoredService svc) {
    }
}

