/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.ServiceMonitor;

public class MockMonitor
implements ServiceMonitor {
    private MockNetwork m_network;
    private String m_svcName;

    public MockMonitor() {
    }

    public MockMonitor(MockNetwork network, String svcName) {
        this.m_network = network;
        this.m_svcName = svcName;
    }

    public void initialize(MonitoredService svc) {
    }

    public void initialize(Map<String, Object> parameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService monSvc, Map<String, Object> parameters) {
        MockNetwork mockNetwork = this.m_network;
        synchronized (mockNetwork) {
            int nodeId = monSvc.getNodeId();
            String ipAddr = monSvc.getIpAddr();
            MockService svc = this.m_network.getService(nodeId, ipAddr, this.m_svcName);
            if (svc == null) {
                LogUtils.infof((Object)this, (String)"Invalid Poll: %s/%s", (Object[])new Object[]{ipAddr, this.m_svcName});
                this.m_network.receivedInvalidPoll(ipAddr, this.m_svcName);
                return PollStatus.unknown();
            }
            LogUtils.infof((Object)this, (String)"Poll: [%s/%s/%s]", (Object[])new Object[]{svc.getInterface().getNode().getLabel(), ipAddr, this.m_svcName});
            PollStatus pollStatus = svc.poll();
            return PollStatus.get((int)pollStatus.getStatusCode(), (String)pollStatus.getReason());
        }
    }

    public void release() {
    }

    public void release(MonitoredService svc) {
    }
}

