/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.net.InetAddress;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.xml.event.Event;

public class MockInterface
extends MockContainer<MockNode, MockService> {
    private String m_ifAlias;
    private final InetAddress m_inetAddr;
    private final int m_ifIndex;

    public MockInterface(MockNode node, String ipAddr) {
        super(node);
        this.m_ifIndex = node.getNextIfIndex();
        this.m_inetAddr = InetAddressUtils.addr((String)ipAddr);
        if (this.m_inetAddr == null) {
            throw new IllegalArgumentException("unable to convert " + ipAddr + " to an InetAddress.");
        }
    }

    public MockService addService(String svcName, int serviceId) {
        return this.addMember(new MockService(this, svcName, serviceId));
    }

    public String getIpAddr() {
        return InetAddressUtils.toIpAddrString((InetAddress)this.m_inetAddr);
    }

    @Override
    Object getKey() {
        return this.getIpAddr();
    }

    @Override
    public MockNetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    public MockNode getNode() {
        return (MockNode)this.getParent();
    }

    public int getNodeId() {
        return this.getNode().getNodeId();
    }

    public String getNodeLabel() {
        return this.getNode().getLabel();
    }

    @Override
    public PollStatus getPollStatus() {
        String critSvcName = this.getNetwork().getCriticalService();
        final MockService critSvc = this.getService(critSvcName);
        class IFStatusCalculator
        extends MockVisitorAdapter {
            PollStatus status = PollStatus.down();

            IFStatusCalculator() {
            }

            public PollStatus getStatus() {
                return this.status;
            }

            @Override
            public void visitService(MockService svc) {
                if ((critSvc == null || critSvc.equals(svc)) && svc.getPollStatus().isUp()) {
                    this.status = PollStatus.up();
                }
            }
        }
        IFStatusCalculator calc = new IFStatusCalculator();
        this.visit(calc);
        return calc.getStatus();
    }

    public MockService getService(String svcName) {
        return (MockService)this.getMember(svcName);
    }

    public List<MockService> getServices() {
        return this.getMembers();
    }

    public void removeService(MockService svc) {
        this.removeMember(svc);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ifAlias", (Object)this.m_ifAlias).append("ifIndex", this.m_ifIndex).append("inetAddr", (Object)InetAddressUtils.str((InetAddress)this.m_inetAddr)).append("members", this.getMembers()).toString();
    }

    @Override
    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitInterface(this);
        this.visitMembers(v);
    }

    @Override
    public Event createDownEvent() {
        return MockEventUtil.createInterfaceDownEvent("Test", this);
    }

    @Override
    public Event createUpEvent() {
        return MockEventUtil.createInterfaceUpEvent("Test", this);
    }

    @Override
    public Event createNewEvent() {
        return MockEventUtil.createNodeGainedInterfaceEvent("Test", this);
    }

    @Override
    public Event createDeleteEvent() {
        return MockEventUtil.createInterfaceDeletedEvent("Test", this);
    }

    public void setIfAlias(String ifAlias) {
        this.m_ifAlias = ifAlias;
    }

    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public InetAddress getAddress() {
        return this.m_inetAddr;
    }

    public int getIfIndex() {
        return this.m_ifIndex;
    }
}

