/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.categories.CatFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;

public class MockCategoryFactory
implements CatFactory {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private Catinfo m_config;
    private static final String CATEGORY_CONFIG = "<catinfo> <header>  <rev>1.3</rev>  <created>Wednesday, February 6, 2002 10:10:00 AM EST</created>  <mstation>checkers</mstation> </header> <categorygroup>  <name>WebConsole</name>  <comment>Service Level Availability by Functional Group</comment>  <common>   <rule><![CDATA[ipaddr IPLIKE *.*.*.*]]></rule>  </common>  <categories>   <category>    <label><![CDATA[Network Interfaces]]></label>    <comment>This is a very simple category</comment>    <normal>99</normal>    <warning>97</warning>    <service>ICMP</service>    <service>SNMP</service>    <rule><![CDATA[(isICMP | isSNMP) & (ipaddr != \"0.0.0.0\")]]></rule>   </category> <category>    <label><![CDATA[Web Servers]]></label>    <comment>This is a more complex category</comment>    <normal>99</normal>    <warning>97</warning>    <service>HTTP</service>    <service>HTTPS</service>    <rule><![CDATA[isHTTP | isHTTPS]]></rule>   </category>  </categories> </categorygroup></catinfo>";

    public MockCategoryFactory() throws MarshalException, ValidationException, IOException {
        this(CATEGORY_CONFIG);
    }

    public MockCategoryFactory(String config) throws MarshalException, ValidationException, IOException {
        this.m_config = (Catinfo)CastorUtils.unmarshal(Catinfo.class, (InputStream)new ByteArrayInputStream(config.getBytes()));
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public synchronized Catinfo getConfig() {
        return this.m_config;
    }

    public synchronized Category getCategory(String name) {
        for (Categorygroup cg : this.m_config.getCategorygroupCollection()) {
            for (Category cat : cg.getCategories().getCategoryCollection()) {
                if (!cat.getLabel().equals(name)) continue;
                return cat;
            }
        }
        return null;
    }

    public synchronized String getEffectiveRule(String catlabel) {
        for (Categorygroup cg : this.m_config.getCategorygroupCollection()) {
            for (Category cat : cg.getCategories().getCategoryCollection()) {
                if (!cat.getLabel().equals(catlabel)) continue;
                return "(" + cg.getCommon().getRule() + ") & (" + cat.getRule() + ")";
            }
        }
        return null;
    }

    public double getNormal(String catlabel) {
        return 0.0;
    }

    public double getWarning(String catlabel) {
        return 0.0;
    }
}

