/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.system.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.opennms.test.system.api.ExistingTestEnvironment;
import org.opennms.test.system.api.NewTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;
import org.opennms.test.system.api.TestEnvironmentProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEnvironmentBuilder {
    private static Logger LOG = LoggerFactory.getLogger(TestEnvironmentBuilder.class);
    private String m_name = null;
    EnumMap<TestEnvironmentProperty, Object> properties = new EnumMap(TestEnvironmentProperty.class);
    private Set<NewTestEnvironment.ContainerAlias> m_containers = new LinkedHashSet<NewTestEnvironment.ContainerAlias>();
    private OpenNMSEnvironmentBuilder m_opennmsEnvironmentBuilder;
    private EnvironmentBuilder m_minionEnvironmentBuilder;

    public TestEnvironmentBuilder skipTearDown(boolean skipTearDown) {
        this.properties.put(TestEnvironmentProperty.SKIP_TEAR_DOWN, (Object)skipTearDown);
        return this;
    }

    public TestEnvironmentBuilder useExisting(boolean useExisting) {
        this.properties.put(TestEnvironmentProperty.USE_EXISTING, (Object)useExisting);
        return this;
    }

    public TestEnvironmentBuilder all() {
        this.opennms();
        this.minion();
        this.snmpd();
        this.tomcat();
        return this;
    }

    public TestEnvironmentBuilder allWithAdditionalMinions() {
        return this.all().minionWithSameLocation().minionWithOtherLocation();
    }

    public TestEnvironmentBuilder postgres() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.POSTGRES)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.POSTGRES);
        return this;
    }

    public TestEnvironmentBuilder kafka() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.KAFKA)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.KAFKA);
        return this;
    }

    public TestEnvironmentBuilder es2() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.ELASTICSEARCH_2)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.ELASTICSEARCH_2);
        return this;
    }

    public TestEnvironmentBuilder es5() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.ELASTICSEARCH_5)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.ELASTICSEARCH_5);
        return this;
    }

    public TestEnvironmentBuilder es6() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.ELASTICSEARCH_6)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.ELASTICSEARCH_6);
        return this;
    }

    public TestEnvironmentBuilder opennms() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.OPENNMS)) {
            return this;
        }
        this.postgres();
        this.m_containers.add(NewTestEnvironment.ContainerAlias.OPENNMS);
        return this;
    }

    public TestEnvironmentBuilder minion() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.MINION)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.MINION);
        return this;
    }

    public TestEnvironmentBuilder minionWithSameLocation() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.MINION_SAME_LOCATION)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.MINION_SAME_LOCATION);
        return this;
    }

    public TestEnvironmentBuilder minionWithOtherLocation() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.MINION_OTHER_LOCATION)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.MINION_OTHER_LOCATION);
        return this;
    }

    public TestEnvironmentBuilder snmpd() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.SNMPD)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.SNMPD);
        return this;
    }

    public TestEnvironmentBuilder tomcat() {
        this.m_containers.add(NewTestEnvironment.ContainerAlias.TOMCAT);
        return this;
    }

    public TestEnvironmentBuilder name(String name) {
        this.m_name = name;
        return this;
    }

    public OpenNMSEnvironmentBuilder withOpenNMSEnvironment() {
        if (this.m_opennmsEnvironmentBuilder == null) {
            this.m_opennmsEnvironmentBuilder = new OpenNMSEnvironmentBuilder();
        }
        return this.m_opennmsEnvironmentBuilder;
    }

    public EnvironmentBuilder withMinionEnvironment() {
        if (this.m_minionEnvironmentBuilder == null) {
            this.m_minionEnvironmentBuilder = new EnvironmentBuilder();
        }
        return this.m_minionEnvironmentBuilder;
    }

    public TestEnvironment build() {
        if (this.m_containers.size() == 0) {
            this.all();
        }
        LOG.debug("Creating environment with containers: {}", this.m_containers);
        if (((Boolean)this.properties.get((Object)TestEnvironmentProperty.USE_EXISTING)).booleanValue()) {
            return new ExistingTestEnvironment();
        }
        Path opennmsOverlay = this.m_opennmsEnvironmentBuilder == null ? null : this.m_opennmsEnvironmentBuilder.build();
        Path minionOverlay = this.m_minionEnvironmentBuilder == null ? null : this.m_minionEnvironmentBuilder.build();
        return new NewTestEnvironment(this.m_name, this.properties, opennmsOverlay, minionOverlay, this.m_containers);
    }

    public static class OpenNMSEnvironmentBuilder
    extends EnvironmentBuilder {
        private boolean m_optIn = false;

        public OpenNMSEnvironmentBuilder optIn(boolean optIn) {
            this.m_optIn = optIn;
            return this;
        }

        @Override
        public OpenNMSEnvironmentBuilder addFiles(Path directory, String targetDirectory) {
            super.addFiles(directory, targetDirectory);
            return this;
        }

        @Override
        public OpenNMSEnvironmentBuilder addFile(String contents, String target) {
            super.addFile(contents, target);
            return this;
        }

        @Override
        public OpenNMSEnvironmentBuilder addFile(URL source, String target) {
            super.addFile(source, target);
            return this;
        }

        @Override
        public Path build() {
            File datachoices = this.createFile("etc/org.opennms.features.datachoices.cfg");
            try (FileWriter w = new FileWriter(datachoices);){
                w.write("enabled=" + this.m_optIn + "\nacknowledged-by=admin\nacknowledged-at=Thu Mar 24 10\\:41\\:25 EDT 2016\n");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create opt-in enabled=" + this.m_optIn + " file in $OPENNMS_HOME/etc!", e);
            }
            return super.build();
        }
    }

    public static class EnvironmentBuilder {
        private static final String TEMP_DIR_PREFIX = "container-overlay";
        private Path m_overlay;

        public EnvironmentBuilder addFiles(Path directory, String targetDirectory) {
            if (directory == null || !directory.toFile().isDirectory()) {
                throw new RuntimeException("You must specify a source directory!");
            }
            Path root = directory.toAbsolutePath();
            try (Stream<Path> paths = Files.walk(root, new FileVisitOption[0]);){
                paths.forEach(from -> {
                    if (from.toFile().isDirectory()) {
                        return;
                    }
                    System.err.println("from=" + from);
                    Path to = Paths.get(targetDirectory, new String[0]).resolve(root.relativize((Path)from));
                    System.err.println("to=" + to);
                    try {
                        this.addFile(from.toFile().toURI().toURL(), to.toString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to copy " + from + " to " + to);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("failed to walk directory " + root, e);
            }
            return this;
        }

        public EnvironmentBuilder addFile(String contents, String target) {
            File targetFile = this.createFile(target);
            try (FileWriter w = new FileWriter(targetFile);){
                w.write(contents);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + target + " file in $OPENNMS_HOME!", e);
            }
            return this;
        }

        /*
         * Exception decompiling
         */
        public EnvironmentBuilder addFile(URL source, String target) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Path build() {
            return this.m_overlay;
        }

        protected File createFile(String path) {
            if (this.m_overlay == null) {
                try {
                    this.m_overlay = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toAbsolutePath();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create container-overlay temporary directory!");
                }
            }
            Path filePath = this.m_overlay.resolve(path);
            filePath.getParent().toFile().mkdirs();
            File file = filePath.toFile();
            return file;
        }
    }
}

