/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.system.api;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.PortBinding;
import java.net.InetSocketAddress;
import java.util.List;
import org.opennms.test.system.api.NewTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;
import org.opennms.test.system.api.junit.ExternalResourceRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestEnvironment
extends ExternalResourceRule
implements TestEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestEnvironment.class);

    public abstract DockerClient getDockerClient();

    @Override
    public InetSocketAddress getServiceAddress(NewTestEnvironment.ContainerAlias alias, int port) {
        return this.getServiceAddress(alias, port, "tcp");
    }

    @Override
    public InetSocketAddress getServiceAddress(NewTestEnvironment.ContainerAlias alias, int port, String type) {
        LOG.trace("Getting container info for alias {}", (Object)alias);
        ContainerInfo info = this.getContainerInfo(alias);
        if (info == null) {
            throw new IllegalArgumentException(String.format("No container found with alias: %s", new Object[]{alias}));
        }
        return this.getServiceAddress(info, port, type);
    }

    @Override
    public InetSocketAddress getServiceAddress(ContainerInfo info, int port, String type) {
        if (info != null) {
            LOG.trace("Getting service address for container {}/{}", (Object)info.id(), (Object)info.name());
        }
        String portKey = port + "/" + type;
        List bindings = (List)info.networkSettings().ports().get((Object)portKey);
        if (bindings == null || bindings.size() == 0) {
            throw new IllegalArgumentException(String.format("No bindings found for port %s on alias: %s", portKey, info.name()));
        }
        PortBinding binding = (PortBinding)bindings.iterator().next();
        String host = "0.0.0.0".equals(binding.hostIp()) ? this.getDockerClient().getHost() : binding.hostIp();
        return new InetSocketAddress(host, (int)Integer.valueOf(binding.hostPort()));
    }
}

