/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.system.api.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.apache.cxf.common.util.Base64Utility;

public class RestClient {
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private final InetSocketAddress addr;
    private final String authorizationHeader;

    public RestClient(InetSocketAddress addr) {
        this(addr, "admin", "admin");
    }

    public RestClient(InetSocketAddress addr, String username, String password) {
        this.addr = addr;
        this.authorizationHeader = "Basic " + Base64Utility.encode((byte[])(username + ":" + password).getBytes());
    }

    public String getDisplayVersion() {
        WebTarget target = this.getTarget().path("info");
        String json = (String)this.getBuilder(target).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode actualObj = mapper.readTree(json);
            return actualObj.get("displayVersion").asText();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private WebTarget getTarget() {
        Client client = ClientBuilder.newClient();
        return client.target(String.format("http://%s:%d/opennms/rest", this.addr.getHostString(), this.addr.getPort()));
    }

    private Invocation.Builder getBuilder(WebTarget target) {
        return target.request().header("Authorization", (Object)this.authorizationHeader);
    }
}

