/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.system.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jayway.awaitility.Awaitility;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.exceptions.ContainerNotFoundException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.helpers.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opennms.test.system.api.AbstractTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;
import org.opennms.test.system.api.TestEnvironmentProperty;
import org.opennms.test.system.api.utils.RestClient;
import org.opennms.test.system.api.utils.SshClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTestEnvironment
extends AbstractTestEnvironment
implements TestEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(NewTestEnvironment.class);
    private static final Random m_random = new Random();
    public static final EnumMap<ContainerAlias, String> MINION_LOCATIONS = new EnumMap<ContainerAlias, String>(ContainerAlias.class){
        {
            this.put(ContainerAlias.MINION, "MINION");
            this.put(ContainerAlias.MINION_SAME_LOCATION, "MINION");
            this.put(ContainerAlias.MINION_OTHER_LOCATION, "BANANA");
        }
    };
    public static final EnumMap<ContainerAlias, String> MINION_IDS = new EnumMap<ContainerAlias, String>(ContainerAlias.class){
        {
            this.put(ContainerAlias.MINION, "00000000-0000-0000-0000-000000ddba11");
            this.put(ContainerAlias.MINION_SAME_LOCATION, "00000000-0000-0000-0000-000000ddba22");
            this.put(ContainerAlias.MINION_OTHER_LOCATION, "00000000-0000-0000-0000-000000ddba33");
        }
    };
    public static final EnumMap<ContainerAlias, Boolean> INITIALIZED_OVERLAYS = new EnumMap(ContainerAlias.class);
    public static final ImmutableMap<ContainerAlias, String> IMAGES_BY_ALIAS = new ImmutableMap.Builder().put((Object)ContainerAlias.ELASTICSEARCH_2, (Object)"elasticsearch:2-alpine").put((Object)ContainerAlias.ELASTICSEARCH_5, (Object)"elasticsearch:5-alpine").put((Object)ContainerAlias.KAFKA, (Object)"spotify/kafka@sha256:cf8f8f760b48a07fb99df24fab8201ec8b647634751e842b67103a25a388981b").put((Object)ContainerAlias.MINION, (Object)"stests/minion").put((Object)ContainerAlias.MINION_SAME_LOCATION, (Object)"stests/minion").put((Object)ContainerAlias.MINION_OTHER_LOCATION, (Object)"stests/minion").put((Object)ContainerAlias.OPENNMS, (Object)"stests/opennms").put((Object)ContainerAlias.POSTGRES, (Object)"postgres:9.5.1").put((Object)ContainerAlias.SNMPD, (Object)"stests/snmpd").put((Object)ContainerAlias.TOMCAT, (Object)"stests/tomcat").build();
    private final String name;
    private final EnumMap<TestEnvironmentProperty, Object> properties;
    private Path overlayDirectory;
    private Path minionOverlayDirectory;
    private Collection<ContainerAlias> start;
    private final Set<String> createdContainerIds = Sets.newLinkedHashSet();
    private final Map<ContainerAlias, ContainerInfo> containerInfoByAlias = Maps.newHashMap();
    private final Map<ContainerAlias, Set<Integer>> ports = Maps.newConcurrentMap();
    private DockerClient docker;

    public NewTestEnvironment(String name, EnumMap<TestEnvironmentProperty, Object> properties, Path overlayDirectory, Path minionOverlayDirectory, Collection<ContainerAlias> containers) {
        this.properties = properties;
        this.overlayDirectory = overlayDirectory;
        this.minionOverlayDirectory = minionOverlayDirectory;
        this.start = containers;
        this.name = name;
    }

    public String getName() {
        return this.name == null ? this.description.getTestClass().getSimpleName() : this.name;
    }

    @Override
    protected void before() throws Throwable {
        this.docker = DefaultDockerClient.fromEnv().build();
        this.spawnKafka();
        this.spawnElasticsearch2();
        this.spawnElasticsearch5();
        this.spawnPostgres();
        this.waitForPostgres();
        LOG.debug("Starting containers: {}", this.start);
        this.spawnOpenNMS();
        this.spawnSnmpd();
        this.spawnTomcat();
        this.spawnMinions();
        LOG.debug("Waiting for other containers to be ready: {}", this.start);
        this.waitForOpenNMS();
        this.waitForSnmpd();
        this.waitForTomcat();
        this.waitForMinions();
    }

    @Override
    protected void after(boolean didFail, Throwable failure) {
        if (this.docker == null) {
            LOG.warn("Docker instance is null. Skipping tear down.");
            return;
        }
        if (didFail) {
            LOG.error("Test failed!", failure);
        }
        ArrayList<String> containerIds = new ArrayList<String>(this.createdContainerIds);
        Collections.reverse(containerIds);
        LOG.info("************************************************************");
        LOG.info("Gathering container output...");
        LOG.info("************************************************************");
        for (String containerId : containerIds) {
            try {
                LogStream logStream = this.docker.logs(containerId, new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
                ContainerAlias container = this.getContainerName(containerId);
                String containerName = container == null ? containerId : container.toString().toLowerCase();
                Path outputPath = Paths.get("target", this.getName() + "-" + containerName + "-output.log");
                LOG.info("* writing stdout/stderr for {} to {}", (Object)containerId, (Object)outputPath);
                try {
                    FileWriter fw = new FileWriter(outputPath.toFile());
                    Throwable throwable = null;
                    try {
                        fw.write(logStream.readFully());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fw == null) continue;
                        if (throwable != null) {
                            try {
                                fw.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fw.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Unable to write to {}", (Object)outputPath, (Object)e);
                }
            }
            catch (DockerException | InterruptedException e) {
                LOG.warn("Failed to get stdout/stderr for container {}.", e);
            }
        }
        if (!((Boolean)this.properties.getOrDefault((Object)TestEnvironmentProperty.SKIP_TEAR_DOWN, Boolean.FALSE)).booleanValue()) {
            for (String containerId : containerIds) {
                this.destroyContainer(containerId);
            }
            this.containerInfoByAlias.clear();
            this.createdContainerIds.clear();
            this.ports.clear();
        } else {
            LOG.info("Skipping tear down.");
        }
        this.docker.close();
    }

    protected void destroyContainer(String containerId) {
        block4: {
            ContainerAlias alias = this.getContainerName(containerId);
            LOG.info("************************************************************");
            LOG.info("Shutting down container {} ({})", (Object)alias, (Object)containerId);
            LOG.info("************************************************************");
            Set containerSockets = this.ports.containsKey((Object)alias) ? this.ports.get((Object)alias).stream().map(port -> this.getServiceAddress(alias, (int)port)).collect(Collectors.toSet()) : Collections.emptySet();
            try {
                Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> {
                    try {
                        LOG.debug("Stopping container {} ({})", (Object)alias, (Object)containerId);
                        this.docker.stopContainer(containerId, 3);
                    }
                    catch (Exception e) {
                        LOG.error("Attempt to stop container {} ({}) failed.  Will try again.", new Object[]{alias, containerId, e});
                    }
                    return containerSockets.parallelStream().map(addr -> {
                        if (addr == null) {
                            return true;
                        }
                        return this.checkSocket((InetSocketAddress)addr);
                    }).allMatch(Predicate.isEqual(Boolean.TRUE));
                });
            }
            catch (Exception e) {
                LOG.error("************************************************************");
                LOG.error("Failed to shut down container {} ({}).  Giving up.", new Object[]{alias, containerId, e});
                LOG.error("************************************************************");
            }
            LOG.debug("************************************************************");
            LOG.debug("Removing container {} ({})", (Object)alias, (Object)containerId);
            LOG.debug("************************************************************");
            try {
                this.docker.removeContainer(containerId);
            }
            catch (Exception e) {
                if (e instanceof ContainerNotFoundException) break block4;
                LOG.error("************************************************************");
                LOG.error("Failed to remove container {} ({}).", new Object[]{alias, containerId, e});
                LOG.error("************************************************************");
            }
        }
    }

    private Boolean checkSocket(InetSocketAddress addr) {
        try (Socket sock = new Socket();){
            sock.connect(addr, 50);
        }
        catch (Exception e) {
            LOG.debug("Port {} is available!", (Object)addr);
            return true;
        }
        LOG.debug("Port {} is still active. :(", (Object)addr);
        return false;
    }

    @Override
    public Set<ContainerAlias> getContainerAliases() {
        return this.containerInfoByAlias.keySet();
    }

    @Override
    public ContainerInfo getContainerInfo(ContainerAlias alias) {
        return this.containerInfoByAlias.get((Object)alias);
    }

    private ContainerAlias getContainerName(String containerId) {
        for (ContainerAlias alias : this.start) {
            ContainerInfo info = this.containerInfoByAlias.get((Object)alias);
            if (info == null || !containerId.equals(info.id())) continue;
            return alias;
        }
        return null;
    }

    private void spawnPostgres() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.POSTGRES;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        LOG.debug("Starting PostgreSQL");
        HostConfig.Builder builder = HostConfig.builder().publishAllPorts(Boolean.valueOf(true));
        this.spawnContainer(alias, builder, Collections.emptyList());
    }

    private void spawnElasticsearch2() throws DockerException, InterruptedException, IOException {
        this.spawnElasticsearch(ContainerAlias.ELASTICSEARCH_2);
    }

    private void spawnElasticsearch5() throws DockerException, InterruptedException, IOException {
        this.spawnElasticsearch(ContainerAlias.ELASTICSEARCH_5);
    }

    private void spawnElasticsearch(ContainerAlias alias) throws DockerException, InterruptedException, IOException {
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        LOG.debug("Starting Elasticsearch");
        HostConfig.Builder builder = HostConfig.builder().publishAllPorts(Boolean.valueOf(true));
        this.spawnContainer(alias, builder);
    }

    private void spawnKafka() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.KAFKA;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        LOG.debug("Starting Kafka");
        Integer zookeeperPort = NewTestEnvironment.getAvailablePort(2181, 2681);
        Integer kafkaPort = NewTestEnvironment.getAvailablePort(9092, 9592);
        HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
        portBindings.put("2181", Collections.singletonList(PortBinding.of((String)"0.0.0.0", (int)zookeeperPort)));
        portBindings.put("9092", Collections.singletonList(PortBinding.of((String)"0.0.0.0", (int)kafkaPort)));
        List<String> env = Arrays.asList("ADVERTISED_HOST=" + InetAddress.getLocalHost().getHostAddress(), "ADVERTISED_PORT=" + ((PortBinding)((List)portBindings.get("9092")).get(0)).hostPort(), "NUM_PARTITIONS=" + this.properties.getOrDefault((Object)TestEnvironmentProperty.KAFKA_PARTITIONS, 10));
        HostConfig.Builder builder = HostConfig.builder().portBindings(portBindings);
        this.spawnContainer(alias, builder, env);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getAvailablePort(int min, int max) {
        PrimitiveIterator.OfInt it = m_random.ints(min, max).iterator();
        while (it.hasNext()) {
            try (ServerSocket socket = new ServerSocket((Integer)it.next());){
                int n = socket.getLocalPort();
                return n;
            }
            catch (Throwable throwable6) {
            }
        }
        throw new IllegalStateException("Can't find an available network port");
    }

    private void spawnOpenNMS() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.OPENNMS;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        Path overlayRoot = this.initializeOverlayRoot(alias);
        Path opennmsOverlay = overlayRoot.resolve("opennms-overlay");
        Path opennmsLogs = overlayRoot.resolve("opennms-logs");
        Path opennmsKarafLogs = overlayRoot.resolve("opennms-karaf-logs");
        Files.createDirectories(opennmsOverlay, new FileAttribute[0]);
        Files.createDirectories(opennmsLogs, new FileAttribute[0]);
        Files.createDirectories(opennmsKarafLogs, new FileAttribute[0]);
        if (this.overlayDirectory != null) {
            Files.find(this.overlayDirectory, 10, (path, attr) -> path.toFile().isFile(), new FileVisitOption[0]).forEach(path -> {
                Path relative = Paths.get(this.overlayDirectory.toFile().toURI().relativize(path.toFile().toURI()).getPath(), new String[0]);
                Path to = Paths.get(opennmsOverlay.toString(), relative.toString());
                LOG.debug("Copying {} to {}", (Object)path.toAbsolutePath(), (Object)to.toAbsolutePath());
                try {
                    Files.createDirectories(to.getParent(), new FileAttribute[0]);
                    Files.copy(path.toAbsolutePath(), to.toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        ArrayList<String> binds = new ArrayList<String>();
        binds.add(opennmsOverlay.toString() + ":/opennms-docker-overlay");
        binds.add(opennmsLogs.toString() + ":/var/log/opennms");
        binds.add(opennmsKarafLogs.toString() + ":/opt/opennms/data/log");
        ArrayList<String> links = new ArrayList<String>();
        links.add(String.format("%s:postgres", this.containerInfoByAlias.get((Object)ContainerAlias.POSTGRES).name()));
        if (this.isEnabled(ContainerAlias.ELASTICSEARCH_2)) {
            links.add(String.format("%s:elasticsearch", this.containerInfoByAlias.get((Object)ContainerAlias.ELASTICSEARCH_2).name()));
        } else if (this.isEnabled(ContainerAlias.ELASTICSEARCH_5)) {
            links.add(String.format("%s:elasticsearch", this.containerInfoByAlias.get((Object)ContainerAlias.ELASTICSEARCH_5).name()));
        }
        if (this.isEnabled(ContainerAlias.KAFKA)) {
            links.add(String.format("%s:kafka", this.containerInfoByAlias.get((Object)ContainerAlias.KAFKA).name()));
        }
        HostConfig.Builder builder = HostConfig.builder().privileged(Boolean.valueOf(true)).publishAllPorts(Boolean.valueOf(true)).links(links).binds(binds);
        this.spawnContainer(alias, builder, Collections.emptyList());
    }

    private void spawnSnmpd() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.SNMPD;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        this.spawnContainer(alias, HostConfig.builder(), Collections.emptyList());
    }

    private void spawnTomcat() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.TOMCAT;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        this.spawnContainer(alias, HostConfig.builder(), Collections.emptyList());
    }

    private void spawnMinions() throws DockerException, InterruptedException, IOException {
        for (ContainerAlias alias : Arrays.asList(ContainerAlias.MINION, ContainerAlias.MINION_SAME_LOCATION, ContainerAlias.MINION_OTHER_LOCATION)) {
            if (!this.isEnabled(alias) || !this.isSpawned(alias)) continue;
            Path overlayRoot = this.initializeOverlayRoot(alias);
            Path minionOverlay = overlayRoot.resolve("minion-overlay");
            Path minionKarafLogs = overlayRoot.resolve("minion-karaf-logs");
            Files.createDirectories(minionOverlay.resolve("etc"), new FileAttribute[0]);
            Files.createDirectories(minionKarafLogs, new FileAttribute[0]);
            try (FileWriter fw = new FileWriter(minionOverlay.resolve("etc/clean.disabled").toFile());){
                fw.write("true\n".toCharArray());
            }
            if (this.minionOverlayDirectory != null) {
                Files.find(this.minionOverlayDirectory, 10, (path, attr) -> path.toFile().isFile(), new FileVisitOption[0]).forEach(path -> {
                    Path relative = Paths.get(this.minionOverlayDirectory.toFile().toURI().relativize(path.toFile().toURI()).getPath(), new String[0]);
                    Path to = Paths.get(minionOverlay.toString(), relative.toString());
                    LOG.debug("Copying {} to {}", (Object)path.toAbsolutePath(), (Object)to.toAbsolutePath());
                    try {
                        Files.createDirectories(to.getParent(), new FileAttribute[0]);
                        Files.deleteIfExists(to.toAbsolutePath());
                        Files.copy(path.toAbsolutePath(), to.toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            ArrayList<String> binds = new ArrayList<String>();
            binds.add(minionOverlay.toString() + ":/minion-docker-overlay");
            binds.add(minionKarafLogs.toString() + ":/opt/minion/data/log");
            ArrayList links = Lists.newArrayList();
            links.add(String.format("%s:opennms", this.containerInfoByAlias.get((Object)ContainerAlias.OPENNMS).name()));
            links.add(String.format("%s:snmpd", this.containerInfoByAlias.get((Object)ContainerAlias.SNMPD).name()));
            links.add(String.format("%s:tomcat", this.containerInfoByAlias.get((Object)ContainerAlias.TOMCAT).name()));
            if (this.isEnabled(ContainerAlias.KAFKA)) {
                links.add(String.format("%s:kafka", this.containerInfoByAlias.get((Object)ContainerAlias.KAFKA).name()));
            }
            HostConfig.Builder builder = HostConfig.builder().publishAllPorts(Boolean.valueOf(true)).links((List)links).binds(binds);
            List<String> env = Arrays.asList("MINION_LOCATION=" + MINION_LOCATIONS.get((Object)alias), "MINION_ID=" + MINION_IDS.get((Object)alias));
            this.spawnContainer(alias, builder, env);
        }
    }

    private Path initializeOverlayRoot(ContainerAlias alias) {
        Path overlayRoot = Paths.get("target", "overlays", this.getName(), alias.toString()).toAbsolutePath();
        if (!this.isInitialized(alias)) {
            FileUtils.removeDir((File)overlayRoot.toFile());
        }
        INITIALIZED_OVERLAYS.put(alias, true);
        return overlayRoot;
    }

    private boolean isInitialized(ContainerAlias alias) {
        return INITIALIZED_OVERLAYS.containsKey((Object)alias) && INITIALIZED_OVERLAYS.get((Object)alias) != false;
    }

    private boolean isEnabled(ContainerAlias alias) {
        return this.start.contains((Object)alias);
    }

    private boolean isSpawned(ContainerAlias alias) {
        return !this.containerInfoByAlias.containsKey((Object)alias);
    }

    private void spawnContainer(ContainerAlias alias, HostConfig.Builder hostConfigBuilder) throws DockerException, InterruptedException, IOException {
        this.spawnContainer(alias, hostConfigBuilder, Collections.emptyList());
    }

    private void spawnContainer(ContainerAlias alias, HostConfig.Builder hostConfigBuilder, List<String> env) throws DockerException, InterruptedException, IOException {
        HostConfig hostConfig = hostConfigBuilder.build();
        ContainerConfig containerConfig = ContainerConfig.builder().image((String)IMAGES_BY_ALIAS.get((Object)alias)).hostConfig(hostConfig).hostname(this.getName() + ".local").env(env).exposedPorts(hostConfig.portBindings() != null ? hostConfig.portBindings().keySet() : Collections.emptySet()).build();
        ContainerCreation containerCreation = this.docker.createContainer(containerConfig);
        String containerId = containerCreation.id();
        this.createdContainerIds.add(containerId);
        this.docker.startContainer(containerId);
        ContainerInfo containerInfo = this.docker.inspectContainer(containerId);
        LOG.info("************************************************************");
        LOG.info("{} container info: {}", (Object)alias, (Object)containerId);
        LOG.info("************************************************************");
        if (!containerInfo.state().running().booleanValue()) {
            throw new IllegalStateException("Could not start the " + (Object)((Object)alias) + " container");
        }
        if (hostConfig.portBindings() != null) {
            Set containerPorts = Sets.newConcurrentHashSet();
            hostConfig.portBindings().keySet().forEach(pb -> containerPorts.add(Integer.valueOf(pb)));
            this.ports.put(alias, containerPorts);
        }
        this.containerInfoByAlias.put(alias, containerInfo);
    }

    private void waitForPostgres() {
        ContainerAlias alias = ContainerAlias.POSTGRES;
        if (!this.isEnabled(alias)) {
            return;
        }
        final InetSocketAddress postgresAddr = this.getServiceAddress(alias, 5432);
        Callable<Boolean> isConnected = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    Socket socket = new Socket(postgresAddr.getAddress(), postgresAddr.getPort());
                    socket.setReuseAddress(true);
                    InputStream is = socket.getInputStream();
                    OutputStream os = socket.getOutputStream();
                    os.write("\u00af\\_(\u30c4)_/\u00af\n".getBytes());
                    os.close();
                    is.close();
                    socket.close();
                    return true;
                }
                catch (Throwable t) {
                    LOG.debug("PostgreSQL connect failed: " + t.getMessage());
                    return null;
                }
            }
        };
        LOG.info("************************************************************");
        LOG.info("Waiting for PostgreSQL service @ {}.", (Object)postgresAddr);
        LOG.info("************************************************************");
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).until((Callable)isConnected, Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private void waitForOpenNMS() throws Exception {
        ContainerAlias alias = ContainerAlias.OPENNMS;
        if (!this.isEnabled(alias)) {
            return;
        }
        InetSocketAddress httpAddr = this.getServiceAddress(alias, 8980);
        final RestClient restClient = new RestClient(httpAddr);
        Callable<String> getDisplayVersion = new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    String displayVersion = restClient.getDisplayVersion();
                    LOG.info("Connected to OpenNMS version {}", (Object)displayVersion);
                    return displayVersion;
                }
                catch (Throwable t) {
                    LOG.debug("Version lookup failed: " + t.getMessage());
                    return null;
                }
            }
        };
        LOG.info("************************************************************");
        LOG.info("Waiting for OpenNMS REST service @ {}.", (Object)httpAddr);
        LOG.info("************************************************************");
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).until((Callable)getDisplayVersion, Matchers.is((Matcher)Matchers.notNullValue()));
        LOG.info("************************************************************");
        LOG.info("OpenNMS's REST service is online.");
        LOG.info("************************************************************");
        InetSocketAddress sshAddr = this.getServiceAddress(alias, 8101);
        LOG.info("************************************************************");
        LOG.info("Waiting for OpenNMS SSH service @ {}.", (Object)sshAddr);
        LOG.info("************************************************************");
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(SshClient.canConnectViaSsh(sshAddr, "admin", "admin"));
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> NewTestEnvironment.listFeatures(sshAddr, false));
        LOG.info("************************************************************");
        LOG.info("OpenNMS's Karaf Shell is online.");
        LOG.info("************************************************************");
    }

    private void waitForSnmpd() throws Exception {
        ContainerAlias alias = ContainerAlias.SNMPD;
        if (!this.isEnabled(alias)) {
            return;
        }
    }

    private void waitForTomcat() throws Exception {
        ContainerAlias alias = ContainerAlias.TOMCAT;
        if (!this.isEnabled(alias)) {
            return;
        }
    }

    private void waitForMinions() throws Exception {
        for (ContainerAlias alias : Arrays.asList(ContainerAlias.MINION, ContainerAlias.MINION_SAME_LOCATION, ContainerAlias.MINION_OTHER_LOCATION)) {
            if (!this.isEnabled(alias)) {
                return;
            }
            InetSocketAddress sshAddr = this.getServiceAddress(alias, 8201);
            LOG.info("************************************************************");
            LOG.info("Waiting for Minion @ {} to establish connectivity with OpenNMS instance.", (Object)sshAddr);
            LOG.info("************************************************************");
            Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> this.canMinionConnectToOpenNMS(sshAddr));
            Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> NewTestEnvironment.listFeatures(sshAddr, true));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canMinionConnectToOpenNMS(InetSocketAddress sshAddr) {
        try (SshClient sshClient = new SshClient(sshAddr, "admin", "admin");){
            PrintStream pipe = sshClient.openShell();
            pipe.println("minion:ping");
            pipe.println("logout");
            Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(sshClient.isShellClosedCallable());
            String shellOutput = sshClient.getStdout();
            LOG.info("minion:ping output: {}", (Object)shellOutput);
            boolean bl = StringUtils.countMatches((String)shellOutput, (String)"OK") >= 2;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Failed to reach the Minion from OpenNMS.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static boolean listFeatures(InetSocketAddress sshAddr, boolean karaf4) {
        try {
            Throwable throwable = null;
            try (SshClient sshClient = new SshClient(sshAddr, "admin", "admin");){
                boolean bl;
                PrintStream pipe = sshClient.openShell();
                if (karaf4) {
                    pipe.println("feature:list -i");
                } else {
                    pipe.println("features:list -i");
                }
                pipe.println("list");
                pipe.println("logout");
                try {
                    Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(sshClient.isShellClosedCallable());
                    bl = true;
                }
                catch (Throwable throwable2) {
                    try {
                        LOG.info("Features installed:\n{}", (Object)sshClient.getStdout());
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                LOG.info("Features installed:\n{}", (Object)sshClient.getStdout());
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to list features.", (Throwable)e);
            return false;
        }
    }

    @Override
    public DockerClient getDockerClient() {
        return this.docker;
    }

    public static enum ContainerAlias {
        ELASTICSEARCH_2,
        ELASTICSEARCH_5,
        KAFKA,
        MINION,
        MINION_SAME_LOCATION,
        MINION_OTHER_LOCATION,
        OPENNMS,
        POSTGRES,
        SNMPD,
        TOMCAT;

    }
}

