/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.system.api;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.opennms.test.system.api.ExistingTestEnvironment;
import org.opennms.test.system.api.NewTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEnvironmentBuilder {
    private static Logger LOG = LoggerFactory.getLogger(TestEnvironmentBuilder.class);
    private String m_name = null;
    private boolean m_skipTearDown = false;
    private boolean m_useExisting = false;
    private Map<NewTestEnvironment.ContainerAlias, List<String>> m_binds = new HashMap<NewTestEnvironment.ContainerAlias, List<String>>();
    private Set<NewTestEnvironment.ContainerAlias> m_containers = new LinkedHashSet<NewTestEnvironment.ContainerAlias>();
    private Path m_opennmsOverlay;

    public TestEnvironmentBuilder skipTearDown(boolean skipTearDown) {
        this.m_skipTearDown = skipTearDown;
        return this;
    }

    public TestEnvironmentBuilder useExisting(boolean useExisting) {
        this.m_useExisting = useExisting;
        return this;
    }

    public TestEnvironmentBuilder all() throws IOException {
        this.opennms();
        this.minion();
        this.snmpd();
        this.tomcat();
        return this;
    }

    public TestEnvironmentBuilder postgres() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.POSTGRES)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.POSTGRES);
        return this;
    }

    public TestEnvironmentBuilder opennms() throws IOException {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.OPENNMS)) {
            return this;
        }
        this.postgres();
        this.m_containers.add(NewTestEnvironment.ContainerAlias.OPENNMS);
        return this;
    }

    public TestEnvironmentBuilder minion() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.MINION)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.MINION);
        return this;
    }

    public TestEnvironmentBuilder snmpd() {
        if (this.m_containers.contains((Object)NewTestEnvironment.ContainerAlias.SNMPD)) {
            return this;
        }
        this.m_containers.add(NewTestEnvironment.ContainerAlias.SNMPD);
        return this;
    }

    public TestEnvironmentBuilder tomcat() {
        this.m_containers.add(NewTestEnvironment.ContainerAlias.TOMCAT);
        return this;
    }

    public TestEnvironmentBuilder name(String name) {
        this.m_name = name;
        return this;
    }

    public TestEnvironmentBuilder optIn(boolean optIn) {
        File datachoices = this.createFile("etc/org.opennms.features.datachoices.cfg");
        try (FileWriter w = new FileWriter(datachoices);){
            w.write("enabled=" + optIn + "\n" + "acknowledged-by=admin\n" + "acknowledged-at=Thu Mar 24 10\\:41\\:25 EDT 2016\n");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create opt-in=" + optIn + " file in $OPENNMS_HOME/etc!", e);
        }
        return this;
    }

    public TestEnvironmentBuilder addFile(String contents, String target) {
        File targetFile = this.createFile(target);
        try (FileWriter w = new FileWriter(targetFile);){
            w.write(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create " + target + " file in $OPENNMS_HOME!", e);
        }
        return this;
    }

    /*
     * Exception decompiling
     */
    public TestEnvironmentBuilder addFile(URL source, String target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected File createFile(String path) {
        if (this.m_opennmsOverlay == null) {
            this.m_opennmsOverlay = Files.createTempDir().toPath();
        }
        Path filePath = this.m_opennmsOverlay.resolve(path);
        filePath.getParent().toFile().mkdirs();
        File file = filePath.toFile();
        return file;
    }

    public TestEnvironment build() throws IOException {
        if (this.m_containers.size() == 0) {
            this.all();
        }
        LOG.debug("Creating environment with containers: {}", this.m_containers);
        if (this.m_useExisting) {
            return new ExistingTestEnvironment();
        }
        return new NewTestEnvironment(this.m_name, this.m_skipTearDown, this.m_opennmsOverlay, this.m_containers);
    }

    private String generateRandomName() {
        String id;
        while (!(id = UUID.randomUUID().toString()).matches("^[a-zA-Z]")) {
        }
        return id;
    }
}

