/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.system.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jayway.awaitility.Awaitility;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.helpers.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opennms.test.system.api.AbstractTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;
import org.opennms.test.system.api.utils.RestClient;
import org.opennms.test.system.api.utils.SshClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTestEnvironment
extends AbstractTestEnvironment
implements TestEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(NewTestEnvironment.class);
    public static final ImmutableMap<ContainerAlias, String> IMAGES_BY_ALIAS = new ImmutableMap.Builder().put((Object)ContainerAlias.POSTGRES, (Object)"postgres:9.5.1").put((Object)ContainerAlias.OPENNMS, (Object)"stests/opennms").put((Object)ContainerAlias.MINION, (Object)"stests/minion").put((Object)ContainerAlias.SNMPD, (Object)"stests/snmpd").put((Object)ContainerAlias.TOMCAT, (Object)"stests/tomcat").build();
    private final String name;
    private final boolean skipTearDown;
    private Path overlayDirectory;
    private Collection<ContainerAlias> start;
    private final Set<String> createdContainerIds = Sets.newHashSet();
    private final Map<ContainerAlias, ContainerInfo> containerInfoByAlias = Maps.newHashMap();
    private DockerClient docker;

    public NewTestEnvironment(String name, boolean skipTearDown, Path overlayDirectory, Collection<ContainerAlias> containers) {
        this.name = name;
        this.skipTearDown = skipTearDown;
        this.overlayDirectory = overlayDirectory;
        this.start = containers;
    }

    @Override
    protected void before() throws Throwable {
        this.docker = DefaultDockerClient.fromEnv().build();
        LOG.debug("Starting containers: {}", this.start);
        this.spawnPostgres();
        this.spawnOpenNMS();
        this.spawnSnmpd();
        this.spawnTomcat();
        this.spawnMinion();
        LOG.debug("Waiting for containers to be ready: {}", this.start);
        this.waitForPostgres();
        this.waitForOpenNMS();
        this.waitForSnmpd();
        this.waitForTomcat();
        this.waitForMinion();
    }

    @Override
    protected void after(boolean didFail) {
        if (this.docker == null) {
            LOG.warn("Docker instance is null. Skipping tear down.");
            return;
        }
        LOG.info("************************************************************");
        LOG.info("Gathering container output...");
        LOG.info("************************************************************");
        for (String containerId : this.createdContainerIds) {
            try {
                LogStream logStream = this.docker.logs(containerId, new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
                LOG.info("************************************************************");
                LOG.info("Start of stdout/stderr for {}:", (Object)containerId);
                LOG.info("************************************************************");
                LOG.info(logStream.readFully());
                LOG.info("************************************************************");
                LOG.info("End of stdout/stderr for {}:", (Object)containerId);
                LOG.info("************************************************************");
            }
            catch (DockerException | InterruptedException e) {
                LOG.warn("Failed to get stdout/stderr for container {}.", e);
            }
        }
        if (!this.skipTearDown) {
            for (String containerId : this.createdContainerIds) {
                try {
                    LOG.info("************************************************************");
                    LOG.info("Killing and removing container with id: {}", (Object)containerId);
                    LOG.info("************************************************************");
                    this.docker.killContainer(containerId);
                    this.docker.removeContainer(containerId);
                }
                catch (Exception e) {
                    LOG.error("************************************************************");
                    LOG.error("Failed to kill and/or remove container with id: {}", (Object)containerId, (Object)e);
                    LOG.error("************************************************************");
                }
            }
            this.containerInfoByAlias.clear();
            this.createdContainerIds.clear();
        } else {
            LOG.info("Skipping tear down.");
        }
        this.docker.close();
    }

    @Override
    public Set<ContainerAlias> getContainerAliases() {
        return this.containerInfoByAlias.keySet();
    }

    @Override
    public ContainerInfo getContainerInfo(ContainerAlias alias) {
        return this.containerInfoByAlias.get((Object)alias);
    }

    private void spawnPostgres() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.POSTGRES;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        HostConfig.Builder builder = HostConfig.builder().publishAllPorts(Boolean.valueOf(true));
        this.spawnContainer(alias, builder);
    }

    private void spawnOpenNMS() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.OPENNMS;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        Path overlayRoot = Paths.get("target", "overlays", this.description.getTestClass().getSimpleName()).toAbsolutePath();
        if (overlayRoot.toFile().exists()) {
            FileUtils.removeDir((File)overlayRoot.toFile());
        }
        Path opennmsOverlay = overlayRoot.resolve("opennms-overlay");
        Path opennmsLogs = overlayRoot.resolve("opennms-logs");
        Path opennmsKarafLogs = overlayRoot.resolve("opennms-karaf-logs");
        Files.createDirectories(opennmsOverlay, new FileAttribute[0]);
        Files.createDirectories(opennmsLogs, new FileAttribute[0]);
        Files.createDirectories(opennmsKarafLogs, new FileAttribute[0]);
        Files.find(this.overlayDirectory, 10, (path, attr) -> path.toFile().isFile(), new FileVisitOption[0]).forEach(path -> {
            Path relative = Paths.get(this.overlayDirectory.toFile().toURI().relativize(path.toFile().toURI()).getPath(), new String[0]);
            Path to = Paths.get(opennmsOverlay.toString(), relative.toString());
            LOG.debug("Copying {} to {}", (Object)path.toAbsolutePath(), (Object)to.toAbsolutePath());
            try {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
                Files.copy(path.toAbsolutePath(), to.toAbsolutePath(), new CopyOption[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        ArrayList<String> binds = new ArrayList<String>();
        binds.add(opennmsOverlay.toString() + ":/opennms-docker-overlay");
        binds.add(opennmsLogs.toString() + ":/var/log/opennms");
        binds.add(opennmsKarafLogs.toString() + ":/opt/opennms/data/log");
        HostConfig.Builder builder = HostConfig.builder().privileged(Boolean.valueOf(true)).publishAllPorts(Boolean.valueOf(true)).links(new String[]{String.format("%s:postgres", this.containerInfoByAlias.get((Object)ContainerAlias.POSTGRES).name())}).binds(binds);
        this.spawnContainer(alias, builder);
    }

    private void spawnSnmpd() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.SNMPD;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        this.spawnContainer(alias, HostConfig.builder());
    }

    private void spawnTomcat() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.TOMCAT;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        this.spawnContainer(alias, HostConfig.builder());
    }

    private void spawnMinion() throws DockerException, InterruptedException, IOException {
        ContainerAlias alias = ContainerAlias.MINION;
        if (!this.isEnabled(alias) || !this.isSpawned(alias)) {
            return;
        }
        ArrayList links = Lists.newArrayList();
        links.add(String.format("%s:opennms", this.containerInfoByAlias.get((Object)ContainerAlias.OPENNMS).name()));
        links.add(String.format("%s:snmpd", this.containerInfoByAlias.get((Object)ContainerAlias.SNMPD).name()));
        links.add(String.format("%s:tomcat", this.containerInfoByAlias.get((Object)ContainerAlias.TOMCAT).name()));
        HostConfig.Builder builder = HostConfig.builder().publishAllPorts(Boolean.valueOf(true)).links((List)links);
        this.spawnContainer(alias, builder);
    }

    private boolean isEnabled(ContainerAlias alias) {
        return this.start.contains((Object)alias);
    }

    private boolean isSpawned(ContainerAlias alias) {
        return !this.containerInfoByAlias.containsKey((Object)alias);
    }

    private void spawnContainer(ContainerAlias alias, HostConfig.Builder hostConfigBuilder) throws DockerException, InterruptedException, IOException {
        ContainerConfig containerConfig = ContainerConfig.builder().image((String)IMAGES_BY_ALIAS.get((Object)alias)).hostConfig(hostConfigBuilder.build()).hostname(this.name + ".local").build();
        ContainerCreation containerCreation = this.docker.createContainer(containerConfig);
        String containerId = containerCreation.id();
        this.createdContainerIds.add(containerId);
        this.docker.startContainer(containerId);
        ContainerInfo containerInfo = this.docker.inspectContainer(containerId);
        LOG.info("************************************************************");
        LOG.info("{} container info: {}", (Object)alias, (Object)containerId);
        LOG.info("************************************************************");
        if (!containerInfo.state().running().booleanValue()) {
            throw new IllegalStateException("Could not start the " + (Object)((Object)alias) + " container");
        }
        this.containerInfoByAlias.put(alias, containerInfo);
    }

    private void waitForPostgres() {
        ContainerAlias alias = ContainerAlias.POSTGRES;
        if (!this.isEnabled(alias)) {
            return;
        }
        final InetSocketAddress postgresAddr = this.getServiceAddress(alias, 5432);
        Callable<Boolean> isConnected = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    Socket socket = new Socket(postgresAddr.getAddress(), postgresAddr.getPort());
                    socket.setReuseAddress(true);
                    InputStream is = socket.getInputStream();
                    OutputStream os = socket.getOutputStream();
                    os.write("\u00af\\_(\u30c4)_/\u00af\n".getBytes());
                    os.close();
                    is.close();
                    socket.close();
                    return true;
                }
                catch (Throwable t) {
                    LOG.debug("PostgreSQL connect failed: " + t.getMessage());
                    return null;
                }
            }
        };
        LOG.info("************************************************************");
        LOG.info("Waiting for PostgreSQL service @ {}.", (Object)postgresAddr);
        LOG.info("************************************************************");
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).until((Callable)isConnected, Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private void waitForOpenNMS() throws Exception {
        ContainerAlias alias = ContainerAlias.OPENNMS;
        if (!this.isEnabled(alias)) {
            return;
        }
        InetSocketAddress httpAddr = this.getServiceAddress(alias, 8980);
        final RestClient restClient = new RestClient(httpAddr);
        Callable<String> getDisplayVersion = new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    String displayVersion = restClient.getDisplayVersion();
                    LOG.info("Connected to OpenNMS version {}", (Object)displayVersion);
                    return displayVersion;
                }
                catch (Throwable t) {
                    LOG.debug("Version lookup failed: " + t.getMessage());
                    return null;
                }
            }
        };
        LOG.info("************************************************************");
        LOG.info("Waiting for REST service @ {}.", (Object)httpAddr);
        LOG.info("************************************************************");
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).until((Callable)getDisplayVersion, Matchers.is((Matcher)Matchers.notNullValue()));
        LOG.info("************************************************************");
        LOG.info("OpenNMS's REST service is online.");
        LOG.info("************************************************************");
        InetSocketAddress sshAddr = this.getServiceAddress(alias, 8101);
        LOG.info("************************************************************");
        LOG.info("Waiting for SSH service @ {}.", (Object)sshAddr);
        LOG.info("************************************************************");
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(SshClient.canConnectViaSsh(sshAddr, "admin", "admin"));
        NewTestEnvironment.listFeatures(sshAddr, false);
        LOG.info("************************************************************");
        LOG.info("OpenNMS's Karaf Shell is online.");
        LOG.info("************************************************************");
    }

    private void waitForSnmpd() throws Exception {
        ContainerAlias alias = ContainerAlias.SNMPD;
        if (!this.isEnabled(alias)) {
            return;
        }
    }

    private void waitForTomcat() throws Exception {
        ContainerAlias alias = ContainerAlias.TOMCAT;
        if (!this.isEnabled(alias)) {
            return;
        }
    }

    private void waitForMinion() throws Exception {
        ContainerAlias alias = ContainerAlias.MINION;
        if (!this.isEnabled(alias)) {
            return;
        }
        InetSocketAddress sshAddr = this.getServiceAddress(alias, 8201);
        LOG.info("************************************************************");
        LOG.info("Waiting for SSH service for Karaf instance @ {}.", (Object)sshAddr);
        LOG.info("************************************************************");
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(SshClient.canConnectViaSsh(sshAddr, "admin", "admin"));
        NewTestEnvironment.listFeatures(sshAddr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listFeatures(InetSocketAddress sshAddr, boolean karaf4) throws Exception {
        try (SshClient sshClient = new SshClient(sshAddr, "admin", "admin");){
            PrintStream pipe = sshClient.openShell();
            if (karaf4) {
                pipe.println("feature:list -i");
            } else {
                pipe.println("features:list -i");
            }
            pipe.println("list");
            pipe.println("logout");
            try {
                Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(sshClient.isShellClosedCallable());
            }
            finally {
                LOG.info("Features installed:\n{}", (Object)sshClient.getStdout());
            }
        }
    }

    @Override
    public DockerClient getDockerClient() {
        return this.docker;
    }

    public static enum ContainerAlias {
        POSTGRES,
        OPENNMS,
        MINION,
        SNMPD,
        TOMCAT;

    }
}

