/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.system.api;

import com.google.common.collect.Maps;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.test.system.api.AbstractTestEnvironment;
import org.opennms.test.system.api.NewTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;

public class ExistingTestEnvironment
extends AbstractTestEnvironment
implements TestEnvironment {
    private DockerClient docker;
    private final Map<NewTestEnvironment.ContainerAlias, ContainerInfo> containerInfo = Maps.newHashMap();

    @Override
    protected void before() throws Throwable {
        HashMap aliasesByImage = Maps.newHashMap();
        for (Map.Entry entry : NewTestEnvironment.IMAGES_BY_ALIAS.entrySet()) {
            aliasesByImage.put(entry.getValue(), entry.getKey());
        }
        this.docker = DefaultDockerClient.fromEnv().build();
        for (Container container : this.docker.listContainers(new DockerClient.ListContainersParam[0])) {
            NewTestEnvironment.ContainerAlias alias = (NewTestEnvironment.ContainerAlias)((Object)aliasesByImage.get(container.image()));
            if (alias == null) continue;
            this.containerInfo.put(alias, this.docker.inspectContainer(container.id()));
        }
    }

    @Override
    protected void after(boolean didFail) {
        if (this.docker == null) {
            return;
        }
        this.docker.close();
        this.docker = null;
    }

    @Override
    public ContainerInfo getContainerInfo(NewTestEnvironment.ContainerAlias alias) {
        return this.containerInfo.get((Object)alias);
    }

    @Override
    public Set<NewTestEnvironment.ContainerAlias> getContainerAliases() {
        return this.containerInfo.keySet();
    }

    @Override
    public DockerClient getDockerClient() {
        return this.docker;
    }
}

