/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest;

import ch.qos.logback.classic.Logger;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.io.Files;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.opennms.smoketest.LocalTestEnvironment;
import org.opennms.smoketest.OpenNMSTestException;
import org.opennms.smoketest.ResponseData;
import org.opennms.test.system.api.NewTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;
import org.opennms.test.system.api.TestEnvironmentBuilder;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OpenNMSSeleniumTestCase {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(OpenNMSSeleniumTestCase.class);
    private static final String APACHE_LOG_LEVEL = "INFO";
    private static boolean m_useDocker = Boolean.getBoolean("org.opennms.smoketest.docker");
    private static TestEnvironment m_testEnvironment = null;
    public static final long LOAD_TIMEOUT;
    public static final long REQ_TIMEOUT;
    public static final String BASIC_AUTH_USERNAME = "admin";
    public static final String BASIC_AUTH_PASSWORD = "admin";
    public static final String REQUISITION_NAME = "SeleniumTestGroup";
    public static final String USER_NAME = "SmokeTestUser";
    public static final String GROUP_NAME = "SmokeTestGroup";
    protected static final boolean usePhantomJS;
    protected static final boolean useChrome;
    protected WebDriver m_driver = null;
    protected WebDriverWait wait = null;
    protected WebDriverWait requisitionWait = null;
    @Rule
    public TestWatcher m_watcher = new TestWatcher(){

        protected void starting(Description description) {
            OpenNMSSeleniumTestCase.this.m_driver = OpenNMSSeleniumTestCase.this.getDriver();
            LOG.debug("Using driver: {}", (Object)OpenNMSSeleniumTestCase.this.m_driver);
            OpenNMSSeleniumTestCase.this.setImplicitWait();
            OpenNMSSeleniumTestCase.this.m_driver.manage().window().setPosition(new Point(0, 0));
            OpenNMSSeleniumTestCase.this.m_driver.manage().window().setSize(new Dimension(2048, 10000));
            OpenNMSSeleniumTestCase.this.wait = new WebDriverWait(OpenNMSSeleniumTestCase.this.m_driver, TimeUnit.SECONDS.convert(LOAD_TIMEOUT, TimeUnit.MILLISECONDS));
            OpenNMSSeleniumTestCase.this.requisitionWait = new WebDriverWait(OpenNMSSeleniumTestCase.this.m_driver, TimeUnit.SECONDS.convert(REQ_TIMEOUT, TimeUnit.MILLISECONDS));
            OpenNMSSeleniumTestCase.this.m_driver.get(OpenNMSSeleniumTestCase.this.getBaseUrl() + "opennms/login.jsp");
            OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.name((String)"j_username")));
            OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.name((String)"j_password")));
            OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.name((String)"Login")));
            OpenNMSSeleniumTestCase.this.enterText(By.name((String)"j_username"), "admin");
            OpenNMSSeleniumTestCase.this.enterText(By.name((String)"j_password"), "admin");
            OpenNMSSeleniumTestCase.this.findElementByName("Login").click();
            OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//div[@id='content']")));
            try {
                OpenNMSSeleniumTestCase.this.setImplicitWait(0L, TimeUnit.MILLISECONDS);
                try {
                    OpenNMSSeleniumTestCase.this.findElementById("login-attempt-failed");
                    Assert.fail((String)("Login failed: " + OpenNMSSeleniumTestCase.this.findElementById("login-attempt-failed-reason").getText()));
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            finally {
                OpenNMSSeleniumTestCase.this.setImplicitWait();
            }
            this.cleanUp();
        }

        protected void failed(Throwable e, Description description) {
            String testName = description.getMethodName();
            LOG.debug("Test {} failed... attempting to take screenshot.", (Object)testName);
            if (OpenNMSSeleniumTestCase.this.m_driver != null && OpenNMSSeleniumTestCase.this.m_driver instanceof TakesScreenshot) {
                TakesScreenshot shot = (TakesScreenshot)OpenNMSSeleniumTestCase.this.m_driver;
                try {
                    File from = (File)shot.getScreenshotAs(OutputType.FILE);
                    String screenshotFileName = "target" + File.separator + "screenshots" + File.separator + description.getClassName() + "." + testName + ".png";
                    File to = new File(screenshotFileName);
                    LOG.debug("Screenshot saved to: {}", (Object)from);
                    try {
                        to.getParentFile().mkdirs();
                        Files.move((File)from, (File)to);
                        LOG.debug("Screenshot moved to: {}", (Object)to);
                    }
                    catch (IOException ioe) {
                        LOG.debug("Failed to move screenshot from {} to {}", new Object[]{from, to, ioe});
                    }
                }
                catch (Exception sse) {
                    LOG.debug("Failed to take screenshot.", (Throwable)sse);
                }
            } else {
                LOG.debug("Driver can't take screenshots.");
            }
            LOG.debug("Current URL: {}", (Object)OpenNMSSeleniumTestCase.this.m_driver.getCurrentUrl());
            OpenNMSSeleniumTestCase.this.m_driver.navigate().back();
            LOG.debug("Previous URL: {}", (Object)OpenNMSSeleniumTestCase.this.m_driver.getCurrentUrl());
            LogEntries logs = OpenNMSSeleniumTestCase.this.m_driver.manage().logs().get("browser");
            for (LogEntry entry : logs.getAll()) {
                int level = entry.getLevel().intValue();
                String msg = "BROWSER: " + entry.getMessage();
                if (level > Level.SEVERE.intValue()) {
                    LOG.error(msg);
                    continue;
                }
                if (level >= Level.WARNING.intValue()) {
                    LOG.warn(msg);
                    continue;
                }
                if (level >= Level.INFO.intValue()) {
                    LOG.info(msg);
                    continue;
                }
                if (level >= Level.FINE.intValue()) {
                    LOG.debug(msg);
                    continue;
                }
                LOG.trace(msg);
            }
        }

        protected void finished(Description description) {
            this.cleanUp();
            LOG.debug("Shutting down Selenium.");
            if (OpenNMSSeleniumTestCase.this.m_driver != null) {
                try {
                    OpenNMSSeleniumTestCase.this.m_driver.get(OpenNMSSeleniumTestCase.this.getBaseUrl() + "opennms/j_spring_security_logout");
                }
                catch (SeleniumException seleniumException) {
                    // empty catch block
                }
                try {
                    OpenNMSSeleniumTestCase.this.m_driver.quit();
                }
                catch (Exception e) {
                    LOG.error("Failed while shutting down WebDriver for test {}.", (Object)description.getMethodName(), (Object)e);
                }
                OpenNMSSeleniumTestCase.this.m_driver = null;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        protected void cleanUp() {
            try {
                OpenNMSSeleniumTestCase.this.deleteTestRequisition();
                OpenNMSSeleniumTestCase.this.deleteTestUser();
                OpenNMSSeleniumTestCase.this.deleteTestGroup();
            }
            catch (Exception e) {
                LOG.error("Cleaning up failed. Future tests will be in an unhandled state.", (Throwable)e);
            }
        }
    };

    @ClassRule
    public static final TestEnvironment getTestEnvironment() {
        if (m_useDocker) {
            LOG.warn("Setting up Docker test environment.");
            try {
                TestEnvironmentBuilder builder = TestEnvironment.builder().opennms();
                OpenNMSSeleniumTestCase.configureTestEnvironment(builder);
                m_testEnvironment = builder.build();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (m_testEnvironment == null) {
            LOG.warn("Setting up local test environment.");
            m_testEnvironment = new LocalTestEnvironment();
        }
        return m_testEnvironment;
    }

    public static void configureTestEnvironment(TestEnvironmentBuilder builder) {
        builder.skipTearDown(Boolean.getBoolean("org.opennms.smoketest.docker.skipTearDown"));
        builder.useExisting(Boolean.getBoolean("org.opennms.smoketest.docker.useExisting"));
        builder.withOpenNMSEnvironment().optIn(false).addFile(OpenNMSSeleniumTestCase.class.getResource("etc/monitoring-locations.xml"), "etc/monitoring-locations.xml");
    }

    public static void assumeDockerEnabled() {
        Assume.assumeTrue((String)"Docker is required for this test!  Enable it by setting -Dorg.opennms.smoketest.docker=true when running.", (boolean)m_useDocker);
    }

    public static boolean isDockerEnabled() {
        return m_useDocker;
    }

    private static final boolean setLevel(String pack, String level) {
        org.slf4j.Logger logger = LoggerFactory.getLogger((String)pack);
        if (logger instanceof Logger) {
            ((Logger)logger).setLevel(ch.qos.logback.classic.Level.valueOf((String)level));
            return true;
        }
        return false;
    }

    public String getServerAddress() {
        return m_testEnvironment.getServiceAddress(NewTestEnvironment.ContainerAlias.OPENNMS, 8980).getAddress().getHostAddress();
    }

    public int getServerHttpPort() {
        return m_testEnvironment.getServiceAddress(NewTestEnvironment.ContainerAlias.OPENNMS, 8980).getPort();
    }

    public int getServerEventPort() {
        return m_testEnvironment.getServiceAddress(NewTestEnvironment.ContainerAlias.OPENNMS, 5817).getPort();
    }

    public String getBaseUrl() {
        return "http://" + this.getServerAddress() + ":" + this.getServerHttpPort() + "/";
    }

    public String createBasicAuthHeader() {
        String authString = String.format("%s:%s", "admin", "admin");
        return "Basic " + new String(Base64.getEncoder().encode(authString.getBytes()));
    }

    protected JavascriptExecutor getExecutor() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (JavascriptExecutor)this.getDriver();
    }

    protected WebDriver getDriver() {
        WebDriver driver = null;
        String driverClass = System.getProperty("org.opennms.smoketest.webdriver.class", System.getProperty("webdriver.class"));
        if (driverClass != null) {
            try {
                driver = (WebDriver)Class.forName(driverClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new OpenNMSTestException(e);
            }
        }
        if (driver == null) {
            File chrome;
            DesiredCapabilities caps;
            if (usePhantomJS) {
                File phantomJS = OpenNMSSeleniumTestCase.findPhantomJS();
                if (phantomJS != null) {
                    caps = DesiredCapabilities.phantomjs();
                    this.customizeCapabilities(caps);
                    caps.setCapability("phantomjs.binary.path", phantomJS.toString());
                    driver = new PhantomJSDriver((Capabilities)caps);
                }
            } else if (useChrome && (chrome = OpenNMSSeleniumTestCase.findChrome()) != null) {
                ChromeOptions options = new ChromeOptions();
                options.setBinary(chrome);
                DesiredCapabilities caps2 = DesiredCapabilities.chrome();
                this.customizeCapabilities(caps2);
                caps2.setCapability("chromeOptions", (Object)options);
                driver = new ChromeDriver((Capabilities)caps2);
            }
            if (driver == null) {
                FirefoxProfile fp = new FirefoxProfile();
                fp.setEnableNativeEvents(false);
                fp.setPreference("app.update.auto", false);
                fp.setPreference("app.update.enabled", false);
                fp.setPreference("app.update.silent", false);
                fp.setPreference("browser.startup.homepage", "about:blank");
                fp.setPreference("startup.homepage_welcome_url", "about:blank");
                fp.setPreference("startup.homepage_welcome_url.additional", "about:blank");
                caps = DesiredCapabilities.firefox();
                this.customizeCapabilities(caps);
                driver = new FirefoxDriver(new FirefoxBinary(), fp, (Capabilities)caps);
            }
        }
        return driver;
    }

    protected void customizeCapabilities(DesiredCapabilities caps) {
    }

    private static File findChrome() {
        File chromeFile;
        String chromePath = System.getProperty("chrome.path");
        if (chromePath != null && !"".equals(chromePath) && OpenNMSSeleniumTestCase.isExectuable(chromeFile = new File(chromePath))) {
            return chromeFile;
        }
        String os = System.getProperty("os.name").toLowerCase();
        String extension = os.indexOf("win") >= 0 ? ".exe" : "";
        String path = System.getenv("PATH");
        if (path == null) {
            LOG.debug("findChrome(): Unable to get PATH.");
            File chromeFile2 = new File("/usr/bin/chromium-browser" + extension);
            LOG.debug("findChrome(): trying {}", (Object)chromeFile2);
            if (OpenNMSSeleniumTestCase.isExectuable(chromeFile2)) {
                return chromeFile2;
            }
        } else {
            ArrayList<String> paths = new ArrayList<String>(Arrays.asList(path.split(File.pathSeparator)));
            paths.add("/usr/local/bin");
            paths.add("/usr/local/sbin");
            LOG.debug("findChrome(): paths = {}", paths);
            for (String directory : paths) {
                for (String exeName : new String[]{"chromium-browser", "chrome", "google-chrome"}) {
                    File chromeFile3 = new File(directory + File.separator + exeName + extension);
                    LOG.debug("findChrome(): trying {}", (Object)chromeFile3);
                    if (!OpenNMSSeleniumTestCase.isExectuable(chromeFile3)) continue;
                    return chromeFile3;
                }
            }
        }
        return null;
    }

    private static boolean isExectuable(File file) {
        return file != null && file.exists() && file.canExecute();
    }

    private static File findChromeDriver() {
        String os = System.getProperty("os.name").toLowerCase();
        String extension = os.indexOf("win") >= 0 ? ".exe" : "";
        String path = System.getenv("PATH");
        if (path == null) {
            LOG.debug("findChromeDriver(): Unable to get PATH.");
            for (String searchPath : new String[]{"/usr/lib/chromium-browser/", "/usr/local/bin/", "/usr/bin/"}) {
                File chromeDriverFile = new File(searchPath + "chromedriver" + extension);
                LOG.debug("findChromeDriver(): trying {}", (Object)chromeDriverFile);
                if (!chromeDriverFile.exists() || !chromeDriverFile.canExecute()) continue;
                return chromeDriverFile;
            }
        } else {
            ArrayList<String> paths = new ArrayList<String>(Arrays.asList(path.split(File.pathSeparator)));
            paths.add("/usr/local/bin");
            paths.add("/usr/local/sbin");
            paths.add("/usr/lib/chromium-browser");
            LOG.debug("findChromeDriver(): paths = {}", paths);
            for (String directory : paths) {
                File chromeDriverFile = new File(directory + File.separator + "chromedriver" + extension);
                LOG.debug("findChromeDriver(): trying {}", (Object)chromeDriverFile);
                if (!chromeDriverFile.exists() || !chromeDriverFile.canExecute()) continue;
                return chromeDriverFile;
            }
        }
        return null;
    }

    private static File findPhantomJS() {
        String os = System.getProperty("os.name").toLowerCase();
        String extension = os.indexOf("win") >= 0 ? ".exe" : "";
        String path = System.getenv("PATH");
        if (path == null) {
            LOG.debug("findPhantomJS(): Unable to get PATH.");
            File phantomFile = new File("/usr/local/bin/phantomjs" + extension);
            LOG.debug("findPhantomJS(): trying {}", (Object)phantomFile);
            if (phantomFile.exists() && phantomFile.canExecute()) {
                return phantomFile;
            }
        } else {
            ArrayList<String> paths = new ArrayList<String>(Arrays.asList(path.split(File.pathSeparator)));
            paths.add("/usr/local/bin");
            paths.add("/usr/local/sbin");
            LOG.debug("findPhantomJS(): paths = {}", paths);
            for (String directory : paths) {
                File phantomFile = new File(directory + File.separator + "phantomjs" + extension);
                LOG.debug("findPhantomJS(): trying {}", (Object)phantomFile);
                if (!phantomFile.exists() || !phantomFile.canExecute()) continue;
                return phantomFile;
            }
        }
        return null;
    }

    protected WebDriver.Timeouts setImplicitWait() {
        return this.setImplicitWait(LOAD_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    protected WebDriver.Timeouts setImplicitWait(long time, TimeUnit unit) {
        LOG.debug("Setting implicit wait to {} milliseconds.", (Object)unit.toMillis(time));
        return this.m_driver.manage().timeouts().implicitlyWait(time, unit);
    }

    protected WebDriverWait waitFor(long seconds) {
        return new WebDriverWait(this.m_driver, seconds);
    }

    protected void waitForClose(final By selector) {
        LOG.debug("waitForClose: {}", (Object)selector);
        try {
            this.setImplicitWait(1L, TimeUnit.SECONDS);
            this.wait.until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver input) {
                    try {
                        Thread.sleep(200L);
                        List elements = input.findElements(selector);
                        if (elements.size() == 0) {
                            return true;
                        }
                        LOG.debug("waitForClose: matching elements: {}", (Object)elements);
                        WebElement element = input.findElement(selector);
                        Point location = element.getLocation();
                        element = input.findElement(selector);
                        Dimension size = element.getSize();
                        if (new Point(0, 0).equals((Object)location) && new Dimension(0, 0).equals((Object)size)) {
                            LOG.debug("waitForClose: {} element technically exists, but is sized 0,0", (Object)element);
                            return true;
                        }
                        LOG.debug("waitForClose: {} element still exists at location {} with size {}: {}", new Object[]{selector, location, size, element.getText()});
                        return false;
                    }
                    catch (NoSuchElementException | StaleElementReferenceException e) {
                        return true;
                    }
                    catch (Exception e) {
                        LOG.debug("waitForClose: unknown exception", (Throwable)e);
                        throw new OpenNMSTestException(e);
                    }
                }
            });
        }
        finally {
            this.setImplicitWait();
        }
    }

    protected ExpectedCondition<Boolean> pageContainsText(String text) {
        LOG.debug("pageContainsText: {}", (Object)text);
        final String escapedText = text.replace("'", "\\'");
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String xpathExpression = "//*[contains(., '" + escapedText + "')]";
                LOG.debug("XPath expression: {}", (Object)xpathExpression);
                try {
                    WebElement element = driver.findElement(By.xpath((String)xpathExpression));
                    return element != null;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
        };
    }

    public void focusElement(By by) {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.waitForElement(by).click();
    }

    public void clearElement(By by) {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.waitForElement(by).clear();
    }

    protected void assertElementDoesNotExist(By by) {
        LOG.debug("assertElementDoesNotExist: {}", (Object)by);
        WebElement element = this.getElementWithoutWaiting(by);
        if (element == null) {
            LOG.debug("Success: element does not exist: {}", (Object)by);
            return;
        }
        throw new OpenNMSTestException("Element should not exist, but was found: " + element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement getElementWithoutWaiting(By by) {
        WebElement element = null;
        try {
            this.setImplicitWait(2L, TimeUnit.SECONDS);
            element = this.getDriver().findElement(by);
        }
        catch (NoSuchElementException e) {
            WebElement webElement = null;
            return webElement;
        }
        finally {
            this.setImplicitWait();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertElementDoesNotHaveText(By by, String text) {
        LOG.debug("assertElementDoesNotHaveText: locator={}, text={}", (Object)by, (Object)text);
        WebElement element = null;
        try {
            this.setImplicitWait(2L, TimeUnit.SECONDS);
            element = this.getDriver().findElement(by);
            Assert.assertTrue((!element.getText().contains(text) ? 1 : 0) != 0);
        }
        catch (NoSuchElementException e) {
            LOG.debug("Success: element does not exist: {}", (Object)by);
            return;
        }
        finally {
            this.setImplicitWait();
        }
    }

    protected void assertElementHasText(By by, String text) {
        LOG.debug("assertElementHasText: locator={}, text={}", (Object)by, (Object)text);
        WebElement element = this.waitForElement(by);
        Assert.assertTrue((boolean)element.getText().contains(text));
    }

    protected String handleAlert() {
        return this.handleAlert(null);
    }

    protected String handleAlert(String expectedText) {
        LOG.debug("handleAlerm: expectedText={}", (Object)expectedText);
        try {
            Alert alert = this.m_driver.switchTo().alert();
            String alertText = alert.getText();
            if (expectedText != null) {
                Assert.assertEquals((Object)expectedText, (Object)alertText);
            }
            alert.dismiss();
            return alertText;
        }
        catch (NoAlertPresentException e) {
            LOG.debug("handleAlert: no alert is active");
        }
        catch (TimeoutException e) {
            LOG.debug("handleAlert: no alert was found");
        }
        return null;
    }

    protected void setChecked(By by) {
        LOG.debug("setChecked: locator=", (Object)by);
        WebElement element = this.m_driver.findElement(by);
        if (element.isSelected()) {
            return;
        }
        element.click();
    }

    protected void setUnchecked(By by) {
        LOG.debug("setUnchecked: locator=", (Object)by);
        WebElement element = this.m_driver.findElement(by);
        if (!element.isSelected()) {
            return;
        }
        element.click();
    }

    protected void clickMenuItem(String menuItemText, String submenuItemText, String submenuItemHref) {
        WebElement menuElement;
        LOG.debug("clickMenuItem: itemText={}, submenuItemText={}, submenuHref={}", new Object[]{menuItemText, submenuItemText, submenuItemHref});
        Actions action = new Actions(this.m_driver);
        if (menuItemText.startsWith("name=")) {
            String menuItemName = menuItemText.replaceFirst("name=", "");
            menuElement = this.findElementByName(menuItemName);
        } else {
            menuElement = this.findElementByXpath("//a[contains(text(), '" + menuItemText + "')]");
        }
        action.moveToElement(menuElement, 2, 2).perform();
        WebElement submenuElement = submenuItemText != null ? (submenuItemHref == null ? this.findElementByXpath("//a[contains(text(), '" + submenuItemText + "')]") : this.findElementByXpath("//a[contains(@href, '" + submenuItemHref + "') and contains(text(), '" + submenuItemText + "')]")) : null;
        if (submenuElement == null) {
            this.wait.until((Function)ExpectedConditions.visibilityOf((WebElement)menuElement));
            menuElement.click();
        } else {
            this.wait.until((Function)ExpectedConditions.visibilityOf(submenuElement));
            submenuElement.click();
        }
    }

    protected void frontPage() {
        LOG.debug("navigating to the front page");
        this.m_driver.get(this.getBaseUrl() + "opennms/");
        this.m_driver.findElement(By.id((String)"index-contentleft"));
    }

    public void adminPage() {
        LOG.debug("navigating to the admin page");
        this.m_driver.get(this.getBaseUrl() + "opennms/admin/index.jsp");
    }

    protected void nodePage() {
        LOG.debug("navigating to the node page");
        this.m_driver.get(this.getBaseUrl() + "opennms/element/nodeList.htm");
    }

    protected void notificationsPage() {
        LOG.debug("navigating to the notifications page");
        this.m_driver.get(this.getBaseUrl() + "opennms/notification/index.jsp");
    }

    protected void outagePage() {
        LOG.debug("navigating to the outage page");
        this.m_driver.get(this.getBaseUrl() + "opennms/outage/index.jsp");
    }

    protected void provisioningPage() {
        LOG.debug("navigating to the provisioning page");
        this.m_driver.get(this.getBaseUrl() + "opennms/admin/index.jsp");
        this.m_driver.findElement(By.linkText((String)"Manage Provisioning Requisitions")).click();
    }

    protected void remotingPage() {
        LOG.debug("navigating to the remoting page");
        this.m_driver.get(this.getBaseUrl() + "opennms-remoting/index.html");
    }

    protected void reportsPage() {
        LOG.debug("navigating to the reports page");
        this.m_driver.get(this.getBaseUrl() + "opennms/report/index.jsp");
    }

    protected void searchPage() {
        LOG.debug("navigating to the search page");
        this.m_driver.get(this.getBaseUrl() + "opennms/element/index.jsp");
    }

    protected void supportPage() {
        LOG.debug("navigating to the support page");
        this.m_driver.get(this.getBaseUrl() + "opennms/support/index.htm");
    }

    protected void goBack() {
        LOG.warn("hitting the 'back' button");
        this.m_driver.navigate().back();
    }

    public WebElement waitForElement(By by) {
        return this.waitForElement(this.wait, by);
    }

    public WebElement waitForElement(WebDriverWait w, final By by) {
        return (WebElement)w.until((Function)new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                try {
                    return driver.findElement(by);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }
        });
    }

    public WebElement findElementById(String id) {
        LOG.debug("findElementById: id={}", (Object)id);
        return this.m_driver.findElement(By.id((String)id));
    }

    public WebElement findElementByLink(String link) {
        LOG.debug("findElementByLink: link={}", (Object)link);
        return this.m_driver.findElement(By.linkText((String)link));
    }

    public WebElement findElementByName(String name) {
        LOG.debug("findElementByName: name={}", (Object)name);
        return this.m_driver.findElement(By.name((String)name));
    }

    public WebElement findElementByCss(String css) {
        LOG.debug("findElementByCss: selector={}", (Object)css);
        return this.m_driver.findElement(By.cssSelector((String)css));
    }

    public WebElement findElementByXpath(String xpath) {
        LOG.debug("findElementByXpath: selector={}", (Object)xpath);
        return this.m_driver.findElement(By.xpath((String)xpath));
    }

    public int countElementsMatchingCss(String css) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LOG.debug("countElementsMatchingCss: selector={}", (Object)css);
        Document doc = Jsoup.parse((String)this.m_driver.getPageSource());
        Elements matching = doc.select(css);
        return matching.size();
    }

    protected WebElement enterText(By selector, CharSequence ... text) {
        String textString = Joiner.on((String)"").join((Object[])text);
        LOG.debug("Enter text: '{}' into selector: '{}'", (Object)text, (Object)selector);
        this.scrollToElement(selector);
        this.waitForElement(selector).click();
        this.sleep(500);
        long end = System.currentTimeMillis() + LOAD_TIMEOUT;
        boolean found = false;
        int count = 0;
        WebDriverWait shortWait = new WebDriverWait(this.m_driver, 10L);
        do {
            LOG.debug("enterText({},{}): {}", new Object[]{selector, text, ++count});
            this.waitForElement(selector).clear();
            this.waitForValue(selector, "");
            this.waitForElement(selector).click();
            this.sleep(500);
            this.waitForElement(selector).sendKeys(text);
            this.waitForElement(selector).click();
            this.sleep(500);
            if (text.length == 1 && text[0] != Keys.ENTER) {
                try {
                    String elementText = this.waitForElement(shortWait, selector).getText();
                    String elementValue = this.waitForElement(shortWait, selector).getAttribute("value");
                    found = elementText.contains(textString) || elementValue.contains(textString);
                }
                catch (Exception e) {
                    LOG.warn("Failed when checking for {} to equal '{}'.", new Object[]{selector, textString, e});
                }
                continue;
            }
            LOG.info("Skipped waiting for {} to equal {}", (Object)selector, (Object)textString);
            found = true;
        } while (!found && System.currentTimeMillis() < end);
        return this.m_driver.findElement(selector);
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new OpenNMSTestException(e);
        }
    }

    protected void waitForValue(final By selector, final String value) {
        this.wait.until((Predicate)new Predicate<WebDriver>(){

            public boolean apply(WebDriver driver) {
                return value.equals(driver.findElement(selector).getAttribute("value"));
            }
        });
    }

    protected WebElement scrollToElement(WebElement element) {
        return OpenNMSSeleniumTestCase.scrollToElement(this.getDriver(), element);
    }

    protected static WebElement scrollToElement(WebDriver driver, WebElement element) {
        LOG.debug("scrollToElement: element={}", (Object)element);
        List<Integer> bounds = OpenNMSSeleniumTestCase.getBoundedRectangleOfElement(driver, element);
        int windowHeight = driver.manage().window().getSize().getHeight();
        JavascriptExecutor je = (JavascriptExecutor)driver;
        je.executeScript("window.scrollTo(0, " + (bounds.get(1) - windowHeight / 2) + ");", new Object[0]);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement scrollToElement(final By by) {
        LOG.debug("scrollToElement: by={}", (Object)by);
        try {
            this.setImplicitWait(200L, TimeUnit.MILLISECONDS);
            WebElement element = (WebElement)this.wait.until((Function)new ExpectedCondition<WebElement>(){

                public WebElement apply(WebDriver driver) {
                    try {
                        WebElement el = OpenNMSSeleniumTestCase.this.waitForElement(by);
                        List<Integer> bounds = OpenNMSSeleniumTestCase.getBoundedRectangleOfElement(driver, el);
                        int windowHeight = driver.manage().window().getSize().getHeight();
                        JavascriptExecutor je = (JavascriptExecutor)driver;
                        je.executeScript("window.scrollTo(0, " + (bounds.get(1) - windowHeight / 2) + ");", new Object[0]);
                        return el;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            if (element == null) {
                throw new OpenNMSTestException("Failed to scroll to element: " + by);
            }
            WebElement webElement = element;
            return webElement;
        }
        finally {
            this.setImplicitWait();
        }
    }

    protected static List<Integer> getBoundedRectangleOfElement(WebDriver driver, WebElement we) {
        LOG.debug("getBoundedRectangleOfElement: element={}", (Object)we);
        JavascriptExecutor je = (JavascriptExecutor)driver;
        ArrayList bounds = (ArrayList)je.executeScript("var rect = arguments[0].getBoundingClientRect();return [ '' + parseInt(rect.left), '' + parseInt(rect.top), '' + parseInt(rect.width), '' + parseInt(rect.height) ]", new Object[]{we});
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (String entry : bounds) {
            ret.add(Integer.valueOf(entry));
        }
        return ret;
    }

    protected void clickId(String id) throws InterruptedException {
        this.clickId(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clickId(String id, boolean refresh) throws InterruptedException {
        LOG.debug("clickElement: id={}, refresh={}", (Object)id, (Object)refresh);
        WebElement element = null;
        try {
            this.setImplicitWait(10L, TimeUnit.MILLISECONDS);
            try {
                element = this.findElementById(id);
            }
            catch (Throwable t) {
                LOG.warn("Failed to locate id=" + id, t);
            }
            long waitUntil = System.currentTimeMillis() + 60000L;
            while (!(element != null && element.getAttribute("disabled") == null && element.isDisplayed() && element.isEnabled() || System.currentTimeMillis() >= waitUntil)) {
                try {
                    if (refresh) {
                        this.m_driver.navigate().refresh();
                    }
                    this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)id)));
                    this.wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.id((String)id)));
                    element = this.findElementById(id);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to locate id=" + id, t);
                }
            }
            Thread.sleep(1000L);
            element.click();
        }
        finally {
            this.setImplicitWait();
        }
    }

    protected Integer doRequest(HttpRequestBase request) throws ClientProtocolException, IOException, InterruptedException {
        return this.getRequest(request).getStatus();
    }

    protected ResponseData getRequest(HttpRequestBase request) throws ClientProtocolException, IOException, InterruptedException {
        final CountDownLatch waitForCompletion = new CountDownLatch(1);
        URI uri = request.getURI();
        HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        CloseableHttpClient client = HttpClients.createDefault();
        ResponseHandler<ResponseData> responseHandler = new ResponseHandler<ResponseData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ResponseData handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                try {
                    int status = response.getStatusLine().getStatusCode();
                    String responseText = null;
                    if (status >= 200 && status < 300 || status == 400 || status == 404) {
                        ResponseData r;
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            responseText = EntityUtils.toString((HttpEntity)entity);
                            EntityUtils.consume((HttpEntity)entity);
                        }
                        ResponseData responseData = r = new ResponseData(status, responseText);
                        return responseData;
                    }
                    try {
                        throw new ClientProtocolException("Unexpected response status: " + status);
                    }
                    catch (Exception e) {
                        LOG.warn("Unhandled exception", (Throwable)e);
                        ResponseData responseData = new ResponseData(-1, null);
                        return responseData;
                    }
                }
                finally {
                    waitForCompletion.countDown();
                }
            }
        };
        ResponseData result = (ResponseData)client.execute(targetHost, (HttpRequest)request, (ResponseHandler)responseHandler, (HttpContext)context);
        waitForCompletion.await();
        client.close();
        return result;
    }

    public long getNodesInDatabase(String foreignSource) {
        try {
            HttpGet request = new HttpGet(this.getBaseUrl() + "opennms/rest/nodes?foreignSource=" + URLEncoder.encode(foreignSource, "UTF-8"));
            ResponseData rd = this.getRequest((HttpRequestBase)request);
            LOG.debug("getNodesInDatabase: response={}", (Object)rd);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(new InputSource(new StringReader(rd.getResponseText())));
            Element rootElement = document.getDocumentElement();
            return Long.valueOf(rootElement.getAttribute("totalCount"), 10);
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    public boolean requisitionExists(String foreignSource) {
        LOG.debug("requisitionExists: foreignSource={}", (Object)foreignSource);
        try {
            String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
            Integer status = this.doRequest((HttpRequestBase)new HttpGet(this.getBaseUrl() + "opennms/rest/requisitions/" + foreignSourceUrlFragment));
            return status == 200;
        }
        catch (IOException | InterruptedException e) {
            throw new OpenNMSTestException(e);
        }
    }

    public void deleteExistingRequisition(String foreignSource) {
        LOG.debug("deleteExistingRequisition: Deleting Requisition: {}", (Object)foreignSource);
        long waitUntil = System.currentTimeMillis() + 300000L;
        do {
            long nodesInRequisition = -1L;
            long nodesInDatabase = -1L;
            try {
                nodesInRequisition = this.getNodesInRequisition(foreignSource);
                nodesInDatabase = this.getNodesInDatabase(foreignSource);
                LOG.debug("deleteExistingRequisition: nodesInRequisition={}, nodesInDatabase={}", (Object)nodesInRequisition, (Object)nodesInDatabase);
                String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
                if (nodesInDatabase > 0L) {
                    this.createRequisition(foreignSource);
                }
                if (this.requisitionExists(foreignSource)) {
                    this.sendDelete("/rest/requisitions/" + foreignSourceUrlFragment);
                    this.sendDelete("/rest/requisitions/deployed/" + foreignSourceUrlFragment);
                    this.sendDelete("/rest/foreignSources/" + foreignSourceUrlFragment);
                    this.sendDelete("/rest/foreignSources/deployed/" + foreignSourceUrlFragment);
                }
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                throw new OpenNMSTestException(e);
            }
            if (System.currentTimeMillis() <= waitUntil) continue;
            throw new OpenNMSTestException("Gave up waiting to delete requisition '" + foreignSource + "'.  This should totally not happen.");
        } while (this.requisitionExists(foreignSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected WebElement getForeignSourceElement(String requisitionName) {
        LOG.debug("getForeignSourceElement: requisition={}", (Object)requisitionName);
        String selector = "//span[@data-foreignSource='" + requisitionName + "']";
        WebElement foreignSourceElement = null;
        try {
            this.setImplicitWait(2L, TimeUnit.SECONDS);
            foreignSourceElement = this.m_driver.findElement(By.xpath((String)selector));
        }
        catch (NoSuchElementException e) {
            LOG.debug("Could not find: {}", (Object)selector);
            WebElement webElement = null;
            return webElement;
        }
        finally {
            this.setImplicitWait();
        }
        return foreignSourceElement;
    }

    protected void createTestRequisition() {
        this.createRequisition(REQUISITION_NAME);
    }

    protected void createRequisition(String foreignSource) {
        LOG.debug("Creating empty requisition: " + foreignSource);
        String emptyRequisition = "<model-import xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" date-stamp=\"2013-03-29T11:36:55.901-04:00\" foreign-source=\"" + foreignSource + "\" last-import=\"2016-03-29T10:40:23.947-04:00\"></model-import>";
        this.createRequisition(foreignSource, emptyRequisition, 0);
    }

    protected void createRequisition(String foreignSource, String xml, int expectedNodes) {
        LOG.debug("Creating requisition from XML: " + foreignSource);
        try {
            String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
            this.sendPost("/rest/requisitions", xml);
            this.requisitionWait.until((Function)new WaitForNodesInRequisition(expectedNodes));
            HttpPut request = new HttpPut(this.getBaseUrl() + "opennms/rest/requisitions/" + foreignSourceUrlFragment + "/import");
            Integer status = this.doRequest((HttpRequestBase)request);
            if (status == null || status < 200 || status >= 400) {
                throw new OpenNMSTestException("Unknown status: " + status);
            }
            this.requisitionWait.until((Function)new WaitForNodesInDatabase(expectedNodes));
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    protected void deleteTestRequisition() throws Exception {
        this.deleteExistingRequisition(REQUISITION_NAME);
    }

    protected void createTestForeignSource(String xml) {
        this.createForeignSource(REQUISITION_NAME, xml);
    }

    protected void createForeignSource(String foreignSource, String xml) {
        LOG.debug("Creating foreign source definition: {}", (Object)foreignSource);
        try {
            this.sendPost("/rest/foreignSources", xml);
            this.doRequest((HttpRequestBase)new HttpGet(this.getBaseUrl() + "/rest/foreignSources"));
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    protected void deleteTestForeignSource() {
        this.deleteExistingForeignSource(REQUISITION_NAME);
    }

    protected void deleteExistingForeignSource(String foreignSource) {
        LOG.debug("Deleting foreign source definition: {}", (Object)foreignSource);
        try {
            String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
            this.sendDelete("/rest/foreignSources/" + foreignSourceUrlFragment);
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    protected void deleteTestUser() throws Exception {
        LOG.debug("deleteTestUser()");
        this.doRequest((HttpRequestBase)new HttpDelete(this.getBaseUrl() + "opennms/rest/users/" + USER_NAME));
    }

    protected void deleteTestGroup() throws Exception {
        LOG.debug("deleteTestGroup()");
        this.doRequest((HttpRequestBase)new HttpDelete(this.getBaseUrl() + "opennms/rest/groups/" + GROUP_NAME));
    }

    protected long getNodesInRequisition(String foreignSource) {
        try {
            HttpGet request = new HttpGet(this.getBaseUrl() + "opennms/rest/requisitions/" + URLEncoder.encode(foreignSource, "UTF-8"));
            ResponseData rd = this.getRequest((HttpRequestBase)request);
            LOG.debug("getNodesInRequisition: response={}", (Object)rd);
            if (rd.getStatus() == 404 || rd.getStatus() == -1 || rd.getResponseText() == null) {
                return 0L;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(new InputSource(new StringReader(rd.getResponseText())));
            Element rootElement = document.getDocumentElement();
            long count = 0L;
            NodeList children = rootElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!"node".equals(child.getNodeName())) continue;
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    @Deprecated
    protected long getNodesInRequisition(WebElement element) {
        LOG.debug("getNodesInRequisition: element={}", (Object)element);
        try {
            WebElement match = element.findElement(By.xpath((String)"//span[@data-requisitionedNodes]"));
            String nodes = match.getAttribute("data-requisitionedNodes");
            if (nodes != null) {
                Long nodeCount = Long.valueOf(nodes);
                LOG.debug("{} requisitioned nodes found.", (Object)nodeCount);
                return nodeCount;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LOG.debug("0 requisitioned nodes found.");
        return 0L;
    }

    @Deprecated
    protected long getNodesInDatabase(WebElement element) {
        LOG.debug("getNodesInDatabase: element={}", (Object)element);
        try {
            WebElement match = element.findElement(By.xpath((String)"//span[@data-databaseNodes]"));
            String nodes = match.getAttribute("data-databaseNodes");
            if (nodes != null) {
                Long nodeCount = Long.valueOf(nodes);
                LOG.debug("{} database nodes found.", (Object)nodeCount);
                return nodeCount;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LOG.debug("0 database nodes found.");
        return 0L;
    }

    protected void sendPost(String urlFragment, String body) throws ClientProtocolException, IOException, InterruptedException {
        this.sendPost(urlFragment, body, null);
    }

    protected void sendPost(String urlFragment, String body, Integer expectedResponse) throws ClientProtocolException, IOException, InterruptedException {
        LOG.debug("sendPost: url={}, expectedResponse={}, body={}", new Object[]{urlFragment, expectedResponse, body});
        HttpPost post = new HttpPost(this.getBaseUrl() + "opennms" + (urlFragment.startsWith("/") ? urlFragment : "/" + urlFragment));
        post.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_XML));
        Integer response = this.doRequest((HttpRequestBase)post);
        if (expectedResponse == null) {
            if (response == null || response != 303 && response != 200 && response != 201 && response != 202) {
                throw new RuntimeException("Bad response code! (" + response + "; expected 200, 201, 202, or 303)");
            }
        } else if (!expectedResponse.equals(response)) {
            throw new RuntimeException("Bad response code! (" + response + "; expected " + expectedResponse + ")");
        }
    }

    protected void sendPut(String urlFragment, String body) throws ClientProtocolException, IOException, InterruptedException {
        this.sendPut(urlFragment, body, null);
    }

    protected void sendPut(String urlFragment, String body, Integer expectedResponse) throws ClientProtocolException, IOException, InterruptedException {
        LOG.debug("sendPut: url={}, expectedResponse={}, body={}", new Object[]{urlFragment, expectedResponse, body});
        HttpPut put = new HttpPut(this.getBaseUrl() + "opennms" + (urlFragment.startsWith("/") ? urlFragment : "/" + urlFragment));
        put.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_FORM_URLENCODED));
        Integer response = this.doRequest((HttpRequestBase)put);
        if (expectedResponse == null) {
            if (response == null || response != 303 && response != 200 && response != 201 && response != 202) {
                throw new RuntimeException("Bad response code! (" + response + "; expected 200, 201, 202, or 303)");
            }
        } else if (!expectedResponse.equals(response)) {
            throw new RuntimeException("Bad response code! (" + response + "; expected " + expectedResponse + ")");
        }
    }

    protected void sendDelete(String urlFragment) throws ClientProtocolException, IOException, InterruptedException {
        this.sendDelete(urlFragment, null);
    }

    protected void sendDelete(String urlFragment, Integer expectedResponse) throws ClientProtocolException, IOException, InterruptedException {
        LOG.debug("sendDelete: url={}, expectedResponse={}", (Object)urlFragment, (Object)expectedResponse);
        HttpDelete del = new HttpDelete(this.getBaseUrl() + "opennms" + (urlFragment.startsWith("/") ? urlFragment : "/" + urlFragment));
        Integer response = this.doRequest((HttpRequestBase)del);
        if (expectedResponse == null) {
            if (response == null || response != 303 && response != 200 && response != 202 && response != 204) {
                throw new RuntimeException("Bad response code! (" + response + "; expected 200, 202, 204, or 303)");
            }
        } else if (!expectedResponse.equals(response)) {
            throw new RuntimeException("Bad response code! (" + response + "; expected " + expectedResponse + ")");
        }
    }

    static {
        String logLevel = System.getProperty("org.opennms.smoketest.logLevel", "DEBUG");
        Properties props = new Properties();
        props.put("log4j.logger.org.apache.cxf", APACHE_LOG_LEVEL);
        props.put("log4j.logger.org.apache.cxf.phase.PhaseInterceptorChain", "ERROR");
        props.put("log4j.logger.org.apache.http", APACHE_LOG_LEVEL);
        try {
            Method m;
            Class<?> mockLogAppender = Class.forName("org.opennms.core.test.MockLogAppender");
            if (mockLogAppender != null && (m = mockLogAppender.getMethod("setupLogging", Boolean.TYPE, String.class, Properties.class)) != null) {
                m.invoke(null, true, logLevel, props);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.cxf", APACHE_LOG_LEVEL);
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.cxf.phase.PhaseInterceptorChain", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", APACHE_LOG_LEVEL);
        OpenNMSSeleniumTestCase.setLevel("ROOT", logLevel);
        OpenNMSSeleniumTestCase.setLevel("org.apache.cxf", APACHE_LOG_LEVEL);
        OpenNMSSeleniumTestCase.setLevel("org.apache.cxf.phase.PhaseInterceptorChain", "ERROR");
        OpenNMSSeleniumTestCase.setLevel("org.apache.http", APACHE_LOG_LEVEL);
        File chromeDriver = OpenNMSSeleniumTestCase.findChromeDriver();
        if (chromeDriver != null) {
            LOG.debug("Found chrome driver: " + chromeDriver.getAbsolutePath());
            System.setProperty("webdriver.chrome.driver", chromeDriver.getAbsolutePath());
        } else {
            LOG.debug("Did not find chrome driver.");
        }
        LOAD_TIMEOUT = Long.getLong("org.opennms.smoketest.web-timeout", 120000L);
        REQ_TIMEOUT = Long.getLong("org.opennms.smoketest.requisition-timeout", 240000L);
        usePhantomJS = Boolean.getBoolean("org.opennms.smoketest.webdriver.use-phantomjs") || Boolean.getBoolean("smoketest.usePhantomJS");
        useChrome = Boolean.getBoolean("org.opennms.smoketest.webdriver.use-chrome");
    }

    protected final class WaitForNodesInRequisition
    implements ExpectedCondition<Boolean> {
        private final String m_foreignSource;
        private final int m_numberToMatch;

        public WaitForNodesInRequisition(String foreignSource, int numberOfNodes) {
            this.m_foreignSource = foreignSource;
            this.m_numberToMatch = numberOfNodes;
            LOG.debug("WaitForNodesInRequisition: foreignSource={}, expectedNodes={}", (Object)foreignSource, (Object)numberOfNodes);
        }

        public WaitForNodesInRequisition(int numberOfNodes) {
            this.m_foreignSource = OpenNMSSeleniumTestCase.REQUISITION_NAME;
            this.m_numberToMatch = numberOfNodes;
            LOG.debug("WaitForNodesInRequisition: foreignSource={}, expectedNodes={}", (Object)this.m_foreignSource, (Object)numberOfNodes);
        }

        public Boolean apply(WebDriver input) {
            try {
                long nodes = OpenNMSSeleniumTestCase.this.getNodesInRequisition(this.m_foreignSource);
                LOG.debug("WaitForNodesInRequisition: foreignSource={}, count={}", (Object)this.m_foreignSource, (Object)nodes);
                if (nodes == (long)this.m_numberToMatch) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("WaitForNodesInRequisition: foreignSource={}, expectedNodes={}: Failed to get nodes in requisition {}.", new Object[]{this.m_foreignSource, this.m_numberToMatch, e});
            }
            return null;
        }
    }

    protected final class WaitForNodesInDatabase
    implements ExpectedCondition<Boolean> {
        private final String m_foreignSource;
        private final int m_numberToMatch;

        public WaitForNodesInDatabase(int numberOfNodes) {
            this(OpenNMSSeleniumTestCase.REQUISITION_NAME, numberOfNodes);
        }

        public WaitForNodesInDatabase(String foreignSource, int numberOfNodes) {
            this.m_foreignSource = foreignSource;
            this.m_numberToMatch = numberOfNodes;
            LOG.debug("WaitForNodesInDatabase: foreignSource={}, expectedNodes={}", (Object)foreignSource, (Object)numberOfNodes);
        }

        public Boolean apply(WebDriver input) {
            try {
                long nodes = OpenNMSSeleniumTestCase.this.getNodesInDatabase(this.m_foreignSource);
                LOG.debug("WaitForNodesInDatabase: foreignSource={}, count={}", (Object)this.m_foreignSource, (Object)nodes);
                if (nodes == (long)this.m_numberToMatch) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("WaitForNodesInDatabase: foreignSource={}, count={}: Failed while attempting to validate.", new Object[]{this.m_foreignSource, this.m_numberToMatch, e});
            }
            return null;
        }
    }
}

