/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.expectations;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.opennms.smoketest.OpenNMSSeleniumTestCase;
import org.opennms.smoketest.expectations.ExpectationFailed;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expectation {
    private static final Logger LOG = LoggerFactory.getLogger(Expectation.class);
    final ExecutorService m_executor = Executors.newFixedThreadPool(5);
    private final String m_target;
    private Type m_matchType = Type.OR;
    private List<String> m_textPresent = new ArrayList<String>();
    private Long m_waitTime;
    private TimeUnit m_waitUnits;

    public Expectation(String target) {
        this.m_target = target;
    }

    public void setMatchType(Type type) {
        this.m_matchType = type;
    }

    public void setTextPresent(List<String> textPresent) {
        if (textPresent != this.m_textPresent) {
            this.m_textPresent.clear();
            this.m_textPresent.addAll(textPresent);
        }
    }

    public void addTextPresent(String text) {
        this.m_textPresent.add(text);
    }

    public void setWaitTime(Long time, TimeUnit units) {
        this.m_waitTime = time;
        this.m_waitUnits = units;
    }

    public void check(WebDriver webdriver) throws Exception {
        Future future;
        WebElement element;
        String target;
        WebDriverWait wait = new WebDriverWait(webdriver, TimeUnit.SECONDS.convert(OpenNMSSeleniumTestCase.LOAD_TIMEOUT, TimeUnit.MILLISECONDS));
        if (this.m_target.startsWith("link=")) {
            target = this.m_target.replaceFirst("link=", "");
            element = (WebElement)wait.until(this.visibilityOfElementLocated(By.linkText((String)target)));
        } else if (this.m_target.startsWith("css=")) {
            target = this.m_target.replaceFirst("css=", "");
            element = (WebElement)wait.until(this.visibilityOfElementLocated(By.cssSelector((String)target)));
        } else {
            element = (WebElement)wait.until(this.visibilityOfElementLocated(By.xpath((String)this.m_target)));
        }
        LOG.debug("found element: {}", (Object)element);
        element.click();
        if (this.m_textPresent.size() == 0) {
            return;
        }
        if (this.m_waitTime != null) {
            Thread.sleep(this.m_waitUnits.toMillis(this.m_waitTime));
        }
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(this.m_executor);
        List<Future<Boolean>> futures = Collections.synchronizedList(new ArrayList());
        for (String tp : this.m_textPresent) {
            futures.add(completionService.submit(new Callable<Boolean>((Wait)wait, tp){
                final /* synthetic */ Wait val$wait;
                final /* synthetic */ String val$tp;
                {
                    this.val$wait = wait;
                    this.val$tp = string;
                }

                @Override
                public Boolean call() throws Exception {
                    return (Boolean)this.val$wait.until((Function)Expectation.this.pageContainsText(this.val$tp));
                }
            }));
        }
        if (this.m_matchType == Type.OR) {
            while (futures.size() > 0) {
                future = completionService.take();
                futures.remove(future);
                if (!((Boolean)future.get()).booleanValue()) continue;
                for (Future future2 : futures) {
                    future2.cancel(true);
                }
                return;
            }
            throw new ExpectationFailed(this);
        }
        if (this.m_matchType == Type.AND) {
            while (futures.size() > 0) {
                future = completionService.take();
                futures.remove(future);
                if (((Boolean)future.get()).booleanValue()) continue;
                for (Future future3 : futures) {
                    future3.cancel(true);
                }
                throw new ExpectationFailed(this, "isTextPresent &= " + this.m_textPresent);
            }
        }
    }

    private ExpectedCondition<WebElement> visibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement toReturn = driver.findElement(locator);
                if (toReturn.isDisplayed()) {
                    return toReturn;
                }
                return null;
            }
        };
    }

    private ExpectedCondition<Boolean> pageContainsText(String text) {
        final String escapedText = text.replace("'", "\\'");
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String xpathExpression = "//*[contains(., '" + escapedText + "')]";
                LOG.debug("XPath expression: {}", (Object)xpathExpression);
                WebElement element = driver.findElement(By.xpath((String)xpathExpression));
                return element != null;
            }
        };
    }

    public String toString() {
        return "Expectation [target=" + this.m_target + ", matchType=" + (Object)((Object)this.m_matchType) + ", textPresent=" + this.m_textPresent + "]";
    }

    public static enum Type {
        OR,
        AND;

    }
}

