/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest;

import com.spotify.docker.client.messages.ContainerInfo;
import java.net.InetSocketAddress;
import java.util.Set;
import org.opennms.test.system.api.NewTestEnvironment;
import org.opennms.test.system.api.TestEnvironment;
import org.opennms.test.system.api.junit.ExternalResourceRule;

public class LocalTestEnvironment
extends ExternalResourceRule
implements TestEnvironment {
    public InetSocketAddress getServiceAddress(NewTestEnvironment.ContainerAlias alias, int port) {
        return this.getServiceAddress(alias, port, "tcp");
    }

    public InetSocketAddress getServiceAddress(NewTestEnvironment.ContainerAlias alias, int port, String type) {
        if (alias == NewTestEnvironment.ContainerAlias.OPENNMS) {
            Integer overriddenPort;
            String hostname;
            String opennmsWebHostname = System.getProperty("org.opennms.smoketest.web-host", "localhost");
            if (port == 5817) {
                hostname = System.getProperty("org.opennms.smoketest.event-host", opennmsWebHostname);
                overriddenPort = Integer.getInteger("org.opennms.smoketest.event-port", port);
            } else {
                hostname = opennmsWebHostname;
                overriddenPort = Integer.getInteger("org.opennms.smoketest.web-port", port);
            }
            return new InetSocketAddress(hostname, (int)overriddenPort);
        }
        throw new UnsupportedOperationException("Unsure how to answer for non-OpenNMS local requests!");
    }

    public ContainerInfo getContainerInfo(NewTestEnvironment.ContainerAlias alias) {
        throw new UnsupportedOperationException("Unsure how to answer for local requests!");
    }

    public Set<NewTestEnvironment.ContainerAlias> getContainerAliases() {
        throw new UnsupportedOperationException("Unsure how to answer for local requests!");
    }
}

