/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import simple.http.Request;
import simple.http.Response;
import simple.http.serve.ContentComponent;
import simple.http.serve.Context;

final class FileComponent
extends ContentComponent {
    public FileComponent(Context context, String target) {
        super(context, target);
    }

    protected void process(Request req, Response resp) throws Exception {
        if (req.getDate("If-Modified-Since") < this.getLastModified()) {
            resp.setDate("Date", System.currentTimeMillis());
            resp.setDate("Last-Modified", this.getLastModified());
            resp.set("Content-Type", this.getContentType());
            resp.setContentLength(this.getLength());
            if (req.getMethod().equals("HEAD")) {
                resp.commit();
            } else if (req.getMethod().equals("GET")) {
                this.write(resp.getOutputStream());
                resp.getOutputStream().close();
            } else {
                this.handle(req, resp, 501);
            }
        } else {
            this.handle(req, resp, 304);
        }
    }
}

