/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import simple.http.Request;
import simple.http.Response;
import simple.http.load.LoaderEngine;
import simple.http.load.Mapper;
import simple.http.load.MapperFactory;
import simple.http.serve.CacheContext;
import simple.http.serve.Component;
import simple.http.serve.Context;
import simple.http.serve.ErrorReport;
import simple.http.serve.Report;
import simple.http.serve.Resource;
import simple.http.serve.StatusReport;

public class MapperEngine
extends LoaderEngine {
    protected Mapper mapper;
    protected Object data;

    public MapperEngine() throws IOException {
        this(new CacheContext());
    }

    public MapperEngine(Context context) throws IOException {
        this(context, context.getBasePath());
    }

    public MapperEngine(Context context, Object data) throws IOException {
        this(context, context.getBasePath(), data);
    }

    public MapperEngine(Context context, String path) throws IOException {
        this(context, path, null);
    }

    public MapperEngine(Context context, String path, Object data) throws IOException {
        this(context, new File(path), data);
    }

    public MapperEngine(Context context, File path) throws IOException {
        this(context, path, null);
    }

    public MapperEngine(Context context, File path, Object data) throws IOException {
        this(context, path.getCanonicalFile().toURL(), data);
    }

    private MapperEngine(Context context, URL codebase, Object data) throws IOException {
        super(context, new URL[]{codebase});
        this.mapper = MapperFactory.getInstance(context);
        this.data = data;
    }

    public synchronized Resource lookup(String name) {
        try {
            String type = this.mapper.getClass(name);
            if (this.registry.contains(name)) {
                return this.registry.retrieve(name);
            }
            Object[] list = new Object[]{this.mapper.getConfiguration(name), this.data};
            if (this.data == null) {
                list = new Object[]{list[0]};
            }
            this.load(name, type, list);
        }
        catch (Throwable cause) {
            return new Delegate(this.context, cause);
        }
        return this.registry.retrieve(name);
    }

    public synchronized Resource resolve(String target) {
        String path = this.context.getRequestPath(target);
        String name = this.mapper.getName(path);
        if (name == null) {
            name = this.resolver.resolve(path);
        }
        if (name != null) {
            return this.lookup(name);
        }
        return new Delegate(this.context, 404);
    }

    private class Delegate
    extends Component {
        private Report report;

        public Delegate(Context context, int code) {
            this(context, new StatusReport(code));
        }

        public Delegate(Context context, Throwable cause) {
            this(context, new ErrorReport(cause, 500));
        }

        public Delegate(Context context, Report report) {
            this.context = context;
            this.report = report;
        }

        protected void process(Request req, Response resp) {
            this.handle(req, resp, this.report);
        }
    }
}

