/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class LogMatchTableMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(LogMatchTableMonitor.class);
    private static final String m_serviceName = "LogMatch-Table";
    private static final String lmTableErrorFlag = "1.3.6.1.4.1.2021.16.2.1.100";
    private static final String lmTableFileName = "1.3.6.1.4.1.2021.16.2.1.3";
    private static final String lmTableRegEx = "1.3.6.1.4.1.2021.16.2.1.4";
    private static final String lmTableCount = "1.3.6.1.4.1.2021.16.2.1.10";

    public String serviceName() {
        return m_serviceName;
    }

    @Override
    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            LOG.error("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        ArrayList<String> errorStringReturn = new ArrayList<String>();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        try {
            LOG.debug("PrTableMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId lmTableErrorSnmpObject = SnmpObjId.get((String)lmTableErrorFlag);
            Map flagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"LogMatchTableMonitor", (SnmpObjId)lmTableErrorSnmpObject);
            if (flagResults.size() == 0) {
                LOG.debug("SNMP poll failed: no results, addr={} oid={}", (Object)hostAddress, (Object)lmTableErrorSnmpObject);
                return PollStatus.unavailable();
            }
            for (Map.Entry e : flagResults.entrySet()) {
                LOG.debug("poll: SNMPwalk poll succeeded, addr={} oid={} instance={} value={}", new Object[]{hostAddress, lmTableErrorSnmpObject, e.getKey(), e.getValue()});
                if (!((SnmpValue)e.getValue()).toString().equals("1")) continue;
                LOG.debug("LogMatchTableMonitor.poll: found errorFlag=1");
                SnmpObjId lmTableFilenameSnmpObject = SnmpObjId.get((String)("1.3.6.1.4.1.2021.16.2.1.3." + ((SnmpInstId)e.getKey()).toString()));
                SnmpObjId lmTableRegExSnmpObject = SnmpObjId.get((String)("1.3.6.1.4.1.2021.16.2.1.4." + ((SnmpInstId)e.getKey()).toString()));
                SnmpObjId lmTableCountSnmpObject = SnmpObjId.get((String)("1.3.6.1.4.1.2021.16.2.1.10." + ((SnmpInstId)e.getKey()).toString()));
                String lmErrorMsg = "Rexeg " + SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)lmTableRegExSnmpObject).toDisplayString() + ", for log file " + SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)lmTableFilenameSnmpObject).toDisplayString() + " has matched " + SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)lmTableCountSnmpObject).toDisplayString() + "time(s).";
                errorStringReturn.add(lmErrorMsg);
            }
            if (errorStringReturn.size() > 0) {
                return PollStatus.unavailable((String)errorStringReturn.toString());
            }
            return status;
        }
        catch (NumberFormatException e) {
            String reason1 = "Number operator used on a non-number " + e.getMessage();
            LOG.error(reason1, (Throwable)e);
            return PollStatus.unavailable((String)reason1);
        }
        catch (IllegalArgumentException e) {
            String reason1 = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.error(reason1, (Throwable)e);
            return PollStatus.unavailable((String)reason1);
        }
        catch (Throwable t) {
            String reason1 = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.warn(reason1, t);
            return PollStatus.unavailable((String)reason1);
        }
    }
}

