/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class LaTableMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(LaTableMonitor.class);
    private static final String m_serviceName = "La-Table";
    private static final String laTableErrorFlag = "1.3.6.1.4.1.2021.10.1.100";
    private static final String laTableErrorMsg = "1.3.6.1.4.1.2021.10.1.101";

    public String serviceName() {
        return m_serviceName;
    }

    @Override
    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            LOG.error("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        ArrayList<String> errorStringReturn = new ArrayList<String>();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        try {
            LOG.debug("PrTableMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId laTableErrorSnmpObject = SnmpObjId.get((String)laTableErrorFlag);
            Map flagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"LaTableMonitor", (SnmpObjId)laTableErrorSnmpObject);
            if (flagResults.size() == 0) {
                LOG.debug("SNMP poll failed: no results, addr={} oid={}", (Object)hostAddress, (Object)laTableErrorSnmpObject);
                return PollStatus.unavailable();
            }
            for (Map.Entry e : flagResults.entrySet()) {
                LOG.debug("poll: SNMPwalk poll succeeded, addr={} oid={} instance={} value={}", new Object[]{hostAddress, laTableErrorSnmpObject, e.getKey(), e.getValue()});
                if (!((SnmpValue)e.getValue()).toString().equals("1")) continue;
                LOG.debug("LaTableMonitor.poll: found errorFlag=1");
                SnmpObjId laTableErrorMsgSnmpObject = SnmpObjId.get((String)("1.3.6.1.4.1.2021.10.1.101." + ((SnmpInstId)e.getKey()).toString()));
                String LaErrorMsg = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)laTableErrorMsgSnmpObject).toDisplayString();
                errorStringReturn.add(LaErrorMsg);
            }
            if (errorStringReturn.size() > 0) {
                return PollStatus.unavailable((String)errorStringReturn.toString());
            }
            return status;
        }
        catch (NumberFormatException e) {
            String reason1 = "Number operator used on a non-number " + e.getMessage();
            LOG.error(reason1, (Throwable)e);
            return PollStatus.unavailable((String)reason1);
        }
        catch (IllegalArgumentException e) {
            String reason1 = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.error(reason1, (Throwable)e);
            return PollStatus.unavailable((String)reason1);
        }
        catch (Throwable t) {
            String reason1 = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.warn(reason1);
            return PollStatus.unavailable((String)reason1);
        }
    }
}

