/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.DBTools;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class JDBCMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(JDBCMonitor.class);
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RETRY = 0;

    public JDBCMonitor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LOG.info("JDBCmonitor class loaded");
    }

    @Override
    public void initialize(Map<String, Object> parameters) {
        super.initialize(parameters);
        LOG.debug("Calling init");
    }

    @Override
    public void release() {
        LOG.debug("Shuting down plugin");
    }

    @Override
    public void initialize(MonitoredService svc) {
        super.initialize(svc);
        LOG.debug("initialize");
    }

    @Override
    public void release(MonitoredService svc) {
        LOG.debug("Shuting down plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        Driver driver = null;
        Connection con = null;
        Statement statement = null;
        ResultSet resultset = null;
        if (iface.getType() != 1) {
            LOG.error("Unsupported interface type, only TYPE_INET currently supported");
            throw new NetworkInterfaceNotSupportedException(this.getClass().getName() + ": Unsupported interface type, only TYPE_INET currently supported");
        }
        if (parameters == null) {
            throw new NullPointerException("parameter cannot be null");
        }
        try {
            String driverClass = ParameterMap.getKeyedString(parameters, (String)"driver", (String)"com.sybase.jdbc2.jdbc.SybDriver");
            driver = (Driver)Class.forName(driverClass).newInstance();
            LOG.debug("Loaded JDBC driver: {}", (Object)driverClass);
        }
        catch (Throwable exp) {
            throw new RuntimeException("Unable to load driver class: " + exp.toString(), exp);
        }
        LOG.info("Loaded JDBC driver");
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        String url = null;
        url = DBTools.constructUrl((String)ParameterMap.getKeyedString(parameters, (String)"url", (String)"jdbc:sybase:Tds:OPENNMS_JDBC_HOSTNAME/tempdb"), (String)ipv4Addr.getCanonicalHostName());
        LOG.debug("JDBC url: {}", (Object)url);
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String db_user = ParameterMap.getKeyedString(parameters, (String)"user", (String)"sa");
        String db_pass = ParameterMap.getKeyedString(parameters, (String)"password", (String)"");
        Properties props = new Properties();
        props.setProperty("user", db_user);
        props.setProperty("password", db_pass);
        props.setProperty("timeout", String.valueOf(tracker.getTimeoutInSeconds()));
        tracker.reset();
        while (tracker.shouldRetry()) {
            try {
                con = driver.connect(url, props);
                status = PollStatus.unresponsive();
                if (con != null) {
                    LOG.debug("JDBC Connection Established");
                    tracker.startAttempt();
                    status = this.checkDatabaseStatus(con, parameters);
                    if (status.isAvailable()) {
                        double responseTime = tracker.elapsedTimeInMillis();
                        status = PollStatus.available((Double)responseTime);
                        LOG.debug("JDBC service is AVAILABLE on: {}", (Object)ipv4Addr.getCanonicalHostName());
                        LOG.debug("poll: responseTime= {}ms", (Object)responseTime);
                        break;
                    }
                }
            }
            catch (SQLException sqlEx) {
                String reason = "JDBC service is not responding on: " + ipv4Addr.getCanonicalHostName() + ", " + sqlEx.getSQLState() + ", " + sqlEx.toString();
                LOG.debug(reason, (Throwable)sqlEx);
                status = PollStatus.unavailable((String)reason);
            }
            finally {
                this.closeResultSet(resultset);
                this.closeStmt(statement);
                this.closeConnection(con);
            }
            tracker.nextAttempt();
        }
        return status;
    }

    private void closeConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeResultSet(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus checkDatabaseStatus(Connection con, Map<String, Object> parameters) {
        PollStatus status = PollStatus.unavailable((String)"Unable to retrieve database catalogs");
        ResultSet resultset = null;
        try {
            status = PollStatus.unresponsive();
            DatabaseMetaData metadata = con.getMetaData();
            resultset = metadata.getCatalogs();
            while (resultset.next()) {
                resultset.getString(1);
            }
            if (resultset != null) {
                status = PollStatus.available();
            }
            this.closeResultSet(resultset);
        }
        catch (SQLException sqlEx) {
            try {
                String reason = "JDBC service failed to retrieve metadata: " + sqlEx.getSQLState() + ", " + sqlEx.toString();
                LOG.debug(reason, (Throwable)sqlEx);
                status = PollStatus.unavailable((String)reason);
                this.closeResultSet(resultset);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultset);
                throw throwable;
            }
        }
        return status;
    }
}

